/**/
OPTIONS SINGLE_INTERPRETER
Call RxFuncAdd 'DW_LoadFuncs', 'rexxdw', 'DW_LoadFuncs'
Call dw_loadfuncs

Trace o
/*
 * Depending on platform, set up various constants
 */
Parse Version ver
Parse Source os . prog
lp = Lastpos( !REXXDW.!DIRSEP, prog )
icondir = Substr( prog, 1, lp )
Select
   When os = 'OS2' Then /* Regina */
      Do
         !global.!fixedfont = "10.System VIO"
         !global.!icondir = icondir'os2\'
         rexxutil = 'regutil'
         !global.!root = 'c:\rexxdw'
         enable_explorer = 0
         enable_rendering = 0
         !global.!widgetheight = 20
      End
   When os = 'OS/2' Then
      Do
         !global.!fixedfont = "10.System VIO"
         !global.!icondir = icondir'os2\'
         rexxutil = 'REXXUTIL'
         !global.!root = 'c:\rexxdw'
         enable_explorer = 1
         enable_rendering = 0
         !global.!widgetheight = 20
      End
   When os = 'WIN32' Then /* Regina */
      Do
         !global.!fixedfont = "20.Terminal"
         !global.!icondir = icondir'win\'
         rexxutil = 'rexxutil'
         !global.!root = 'd:\rexxdw'
         enable_explorer = 0
         enable_rendering = 1
         !global.!widgetheight = 20
      End
   When os = 'WindowsNT' Then /* object rexx */
      Do
         !global.!fixedfont = "20.Terminal"
         !global.!icondir = icondir'win\'
         rexxutil = 'rexxutil'
         !global.!root = 'd:\rexxdw'
         enable_explorer = 1
         enable_rendering = 1
         !global.!widgetheight = 20
      End
   When Uname( 'S' ) = 'Darwin' Then -- MacOS X
      Do
         !global.!fixedfont = "12.Monaco"
         !global.!icondir = icondir'win\'
         rexxutil = 'rexxutil'
         !global.!root = '/home/mark/RexxDW'
         enable_explorer = 1
         enable_rendering = 1
         !global.!widgetheight = 20
      End
   When !REXXDW.!GTK_MAJOR_VERSION > 1 Then
      Do
         !global.!fixedfont = "monospace 20"
         !global.!icondir = icondir'gtk/'
         rexxutil = 'rexxutil'
         !global.!root = '/home/mark/RexxDW'
         enable_explorer = 1
         enable_rendering = 1
         !global.!widgetheight = 25
      End
   Otherwise
      Do
         !global.!fixedfont = "fixed"
         !global.!icondir = icondir'gtk/'
         rexxutil = 'rexxutil'
         !global.!root = '/home/mark/RexxDW'
         enable_explorer = 1
         enable_rendering = 1
         !global.!widgetheight = 25
      End
End

/*
 * Check if rexxutil already loaded...
 */
If RxFuncQuery( 'sysfiletree' ) \= 0 Then
   Do
      If RxFuncAdd( 'sysloadfuncs', rexxutil, 'sysloadfuncs' ) \= 0 Then
         Do
            If RxFuncAdd( 'SysLoadFuncs', rexxutil, 'SysLoadFuncs' ) \= 0 Then
               Do
                  enable_explorer = 0
               End
            Else enable_explorer = 1
         End
      Else enable_explorer = 1
   End
Else
   enable_explorer = 1

If enable_explorer Then Call SysLoadFuncs

!globalv = '!REXXDW. !global. ind. items. !dialog.'

font_width = 8
font_height=12
rows=100
width1=6
cols=80
num_lines=0
max_linewidth=0
current_row=0
current_col=0
scrollbarwidth = 14
current_file = ''

numeric digits 12

!global.!days.1 = 'Monday:'
!global.!days.2 = 'Tuesday:'
!global.!days.3 = 'Wednesday:'
!global.!days.4 = 'Thursday:'
!global.!days.0 = 4

!global.!langs.1 = 'Rexx:'
!global.!langs.2 = 'COBOL:'
!global.!langs.3 = 'PL/1:'
!global.!langs.0 = 3

!global.!folder_icon_data = x2c(Getfolder_ico())

Call dw_init

!global.!allowcallbacks = 0

!global.!screen_width = dw_screen_width()
!global.!screen_height = dw_screen_height()

!global.!foldericon = dw_icon_load_from_file( !global.!icondir'folder' );
!global.!fileicon = dw_icon_load_from_file( !global.!icondir'file'  );

!global.!style = dw_or( !REXXDW.!DW_FCF_SYSMENU, !REXXDW.!DW_FCF_TITLEBAR, !REXXDW.!DW_FCF_SHELLPOSITION, !REXXDW.!DW_FCF_TASKLIST, !REXXDW.!DW_FCF_DLGBORDER )
/* create our toplevel window */
!global.!mainwindow = dw_window_new( !REXXDW.!DW_DESKTOP, 'Rexx/DW Test', dw_or( !global.!style, !REXXDW.!DW_FCF_SIZEBORDER, !REXXDW.!DW_FCF_MINMAX ) )
notebookbox = dw_box_new( !REXXDW.!DW_VERT )
Call dw_box_pack_start !global.!mainwindow, notebookbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0

notebook = dw_notebook_new( 0, !REXXDW.!DW_TAB_TO_BOTTOM )
Call dw_box_pack_start notebookbox, notebook, 100, 100, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 5

Call dw_signal_connect !global.!mainwindow, !REXXDW.!DW_EXPOSE_EVENT, 'MainExposeCallback'
Call dw_signal_connect !global.!mainwindow, !REXXDW.!DW_CONFIGURE_EVENT, 'MainConfigureCallback'
/*
 * Insert taskbar icon
 */
tb = dw_taskbar_insert( !global.!mainwindow, !global.!foldericon, 'Rexx/DW Demo', 'TaskbarMenuCallback', 'arg1', 'arg2' )

/*
 * Various:
 *   box, groupbox, button, bitmapbutton, slider/percent, radiobutton/checkbutton
 * Container: (explorer)
 *   container, tree, popup menu, splitbar, mle
 * Render: (display file selected in Container)
 *   render, pixmap
pages = 'Various Explorer Rendering MDI Dialog Utility Box'
 */
pages = 'Various Explorer Rendering MDI Utility Box HTML'
If \enable_rendering Then pages = Delword( pages, 3, 1 )
If \enable_explorer Then pages = Delword( pages, 2, 1 )
Do i = 1 To Words( pages )
   Call CreatePage notebook, Word( pages, i ), i
End

Call dw_signal_connect notebook, !REXXDW.!DW_SWITCH_PAGE_EVENT, 'SwitchPageCallback'
Call dw_notebook_page_set notebook, !global.!notebookpage.1
Call dw_signal_connect !global.!mainwindow, !REXXDW.!DW_DELETE_EVENT, 'QuitCallback', !global.!mainwindow

/* add a menubar to the toplevel window */
mainmenubar = dw_menubar_new( !global.!mainwindow )
/* add menus to the menubar */
menu = dw_menu_new( 0 )
menuitem = dw_menu_append_item( menu, 'Browse ~Directory', 1011, 0, !REXXDW.!DW_MENU_END, !REXXDW.!DW_MENU_NOT_CHECKABLE, 0 )
Call dw_signal_connect menuitem, !REXXDW.!DW_CLICKED_EVENT, 'BrowseCallback', 'dir'
menuitem = dw_menu_append_item( menu, 'Browse ~File', 1012, 0, !REXXDW.!DW_MENU_END, !REXXDW.!DW_MENU_NOT_CHECKABLE, 0 )
Call dw_signal_connect menuitem, !REXXDW.!DW_CLICKED_EVENT, 'BrowseCallback', 'file'
menuitem = dw_menu_append_item( menu, 'Choose ~Colour', 1021, 0, !REXXDW.!DW_MENU_END, !REXXDW.!DW_MENU_NOT_CHECKABLE, 0 )
Call dw_signal_connect menuitem, !REXXDW.!DW_CLICKED_EVENT, 'ChooseColourCallback'
menuitem = dw_menu_append_item( menu, 'Choose ~Font', 1022, 0, !REXXDW.!DW_MENU_END, !REXXDW.!DW_MENU_NOT_CHECKABLE, 0 )
Call dw_signal_connect menuitem, !REXXDW.!DW_CLICKED_EVENT, 'ChooseFontCallback'
menuitem = dw_menu_append_item( menu, '~About', 1013, 0, !REXXDW.!DW_MENU_END, !REXXDW.!DW_MENU_NOT_CHECKABLE, 0 )
Call dw_signal_connect menuitem, !REXXDW.!DW_CLICKED_EVENT, 'HelpAboutCallback'
menuitem = dw_menu_append_item( menu, '~Quit', 1090, 0, !REXXDW.!DW_MENU_END, !REXXDW.!DW_MENU_NOT_CHECKABLE, 0 )
Call dw_signal_connect menuitem, !REXXDW.!DW_CLICKED_EVENT, 'QuitCallback', !global.!mainwindow
/*
 * Add the 'File' menu to the menubar...
 */
Call dw_menu_append_item mainmenubar, '~File', 1010, 0, !REXXDW.!DW_MENU_END, !REXXDW.!DW_MENU_NOT_CHECKABLE, menu
menu = dw_menu_new( 0 )
menuitem = dw_menu_append_item( menu, '~Non-Modal Dialog Test', 1021, 0, !REXXDW.!DW_MENU_END, !REXXDW.!DW_MENU_NOT_CHECKABLE, 0 )
Call dw_signal_connect menuitem, !REXXDW.!DW_CLICKED_EVENT, 'Dialog'
menuitem = dw_menu_append_item( menu, '~Modal Dialog Test', 1021, 0, !REXXDW.!DW_MENU_END, !REXXDW.!DW_MENU_NOT_CHECKABLE, 0 )
Call dw_signal_connect menuitem, !REXXDW.!DW_CLICKED_EVENT, 'Dialog', 'modal'
/*
 * Add the 'Dialog' menu to the menubar...
 */
Call dw_menu_append_item mainmenubar, '~Dialog', 1020, 0, !REXXDW.!DW_MENU_END, !REXXDW.!DW_MENU_NOT_CHECKABLE, menu
/*
timerid = dw_timer_connect( 1000, 'timer_callback' )
*/
Call dw_window_set_pos_size !global.!mainwindow, 0, 0, 750, 800
Call dw_window_show !global.!mainwindow
/*
 * The following is the main event loop for this program. We check the
 * variable !REXXDW.!HAVE_REXXCALLBACK to determine which mechanism
 * can be used for callbacks. It is far better to use the mechanism
 * offered by an interpreter that offers RexxCallBack() in its API.
 */

!global.!allowcallbacks = 1

If !REXXDW.!HAVE_REXXCALLBACK Then
   Do
      Call dw_main
   End
Else
   Do Forever
      cmd = dw_main_iteration()
      If cmd \= '' Then
         Do
            Interpret 'Call' cmd
         End
   End
Call dw_taskbar_delete tb, !global.!foldericon
Call dw_window_destroy !global.!mainwindow
Call dw_shutdown
Exit 0

Return 0

CreatePage: Procedure Expose (!globalv)
Parse Arg notebook, page, idx
func = Translate( page, '', '/' )
!global.!notebookbox.idx = dw_box_new( !REXXDW.!DW_VERT )
!global.!notebookpage.idx = dw_notebook_page_new( notebook, 0, !REXXDW.!DW_PAGE_TO_BACK )
Call dw_notebook_pack notebook, !global.!notebookpage.idx, !global.!notebookbox.idx
Call dw_notebook_page_set_text notebook, !global.!notebookpage.idx, page
Interpret 'Call' func idx
Return

MainExposeCallback: Procedure Expose (!globalv)
--Say 'Got an Expose event on main window'
Return 0

MainConfigureCallback: Procedure Expose (!globalv)
--Say 'Got a Configure event on main window'
Return 0

EnableWidgetsCallback: Procedure Expose (!globalv)
If !global.!allowcallbacks = 0 Then Return 1
Parse Value dw_window_get_pos_size( !global.!mainwindow ) With x y width height
Call dw_messagebox 'Enable', !REXXDW.!DW_MB_OK, 'Some widgets will now be enabled...'
Call dw_window_enable !global.!ls
Return 0

DisableWidgetsCallback: Procedure Expose (!globalv)
If !global.!allowcallbacks = 0 Then Return 1
Parse Value dw_window_get_pos_size( !global.!mainwindow ) With x y width height
Call dw_messagebox 'Disable', !REXXDW.!DW_MB_OK, 'Some widgets will now be disabled...'
Call dw_window_disable !global.!ls
Return 0

GenericClickCallback: Procedure Expose (!globalv)
If !global.!allowcallbacks = 0 Then Return 1
Parse Arg ., text
Parse Value dw_window_get_pos_size( !global.!mainwindow ) With x y width height
Call dw_messagebox 'Rexx/DW Test', !REXXDW.!DW_MB_OK, text x y width height
Return 0

EntryClickCallback: Procedure Expose (!globalv)
If !global.!allowcallbacks = 0 Then Return 1
Parse Arg ., slider, spinbutton, entry, password, combo, listbox
text = dw_slider_get_pos( slider )
Call dw_window_set_text !global.!slider_text, 'Slider:' text
text = dw_spinbutton_get_pos( spinbutton )
Call dw_window_set_text !global.!spinbutton_text, 'Spinbutton:' text
text = dw_window_get_text( entry )
Call dw_window_set_text !global.!entry_text, 'EntryField:' text
text = dw_window_get_text( password )
Call dw_window_set_text !global.!password_text, 'Password:' text
text = dw_window_get_text( combo )
Call dw_window_set_text !global.!combo_text, 'Combobox:' text
idx = dw_listbox_selected( listbox )
If idx = -1 Then Call dw_window_set_text !global.!listbox_text, 'Listbox: *none selected*'
Else
   Do
      text = dw_listbox_get_text( listbox, idx )
      Call dw_window_set_text !global.!listbox_text, 'Listbox:' text
   End
Return 0

CheckClickCallback: Procedure Expose (!globalv)
If !global.!allowcallbacks = 0 Then Return 1
Do i = 1 To !global.!days.0
   If dw_radiobutton_get( !global.!days_cb.i ) Then text = !global.!days.i 'Yes'
   Else text = !global.!days.i 'No'
   Call dw_window_set_text !global.!days_text.i, text
End
Do i = 1 To !global.!langs.0
   If dw_checkbox_get( !global.!langs_cb.i ) Then text = !global.!langs.i 'Yes'
   Else text = !global.!langs.i 'No'
   Call dw_window_set_text !global.!langs_text.i, text
End
text = dw_calendar_get_date( !global.!date )
Call dw_window_set_text !global.!date_text, 'Date:' text
Return 0

SliderCallback: Procedure Expose (!globalv)
If !global.!allowcallbacks = 0 Then Return 1
Parse Arg win, value, percent, spinbutton
Call dw_percent_set_pos percent, value
Call dw_spinbutton_set_pos spinbutton, value
Return 0

SpinbuttonCallback: Procedure Expose (!globalv)
If !global.!allowcallbacks = 0 Then Return 1
Parse Arg win, value, percent, slider
Call dw_percent_set_pos percent, value
Call dw_slider_set_pos slider, value
Return 0

BrowseCallback: Procedure Expose (!globalv)
If !global.!allowcallbacks = 0 Then Return 1
Parse Upper Arg ., type
title.DIR = 'Directory'
title.FILE = 'File'
flag.DIR = !REXXDW.!DW_DIRECTORY_OPEN
flag.FILE = !REXXDW.!DW_FILE_OPEN
/* dw_file_browse() on at least Windows changes directory! */
here = Directory()
ret = Strip( dw_file_browse( 'Select' title.type, '', , flag.type ) )
If ret \= '' Then Call dw_messagebox title.type 'selected', !REXXDW.!DW_MB_OK, 'The' title.type 'selected was' ret
Else Call dw_messagebox title.type 'Selected', !REXXDW.!DW_MB_OK, 'The' title.type 'selection was cancelled'
Call Directory here
Return 0

ChooseColourCallback: Procedure Expose (!globalv)
If !global.!allowcallbacks = 0 Then Return 1
ret = Strip( dw_color_choose( 0 ) )
If ret \= '' Then Call dw_messagebox 'Colour selected', !REXXDW.!DW_MB_OK, 'The colour selected was' ret
Else Call dw_messagebox 'Colour Selected', !REXXDW.!DW_MB_OK, 'The colour selection was cancelled'
Return 0

ChooseFontCallback: Procedure Expose (!globalv)
If !global.!allowcallbacks = 0 Then Return 1
ret = Strip( dw_font_choose( ) )
If ret \= '' Then Call dw_messagebox 'Font selected', !REXXDW.!DW_MB_OK, 'The font selected was' ret
Else Call dw_messagebox 'Font Selected', !REXXDW.!DW_MB_OK, 'The font selection was cancelled'
Return 0

/* sets the window data entry for 'myvalue' */
SetWindowDataCallback: Procedure Expose (!globalv)
If !global.!allowcallbacks = 0 Then Return 1
Parse Arg ., entry
Call dw_window_set_data entry, 'myvalue', dw_window_get_text( entry )
Return 0

/* gets the window data entry for 'myvalue' */
GetWindowDataCallback: Procedure Expose (!globalv)
If !global.!allowcallbacks = 0 Then Return 1
Parse Arg ., entry, text
Call dw_window_set_text text, 'Window Data:' dw_window_get_data( entry, 'myvalue' )
Return 0

SwitchPageCallback: Procedure Expose (!globalv)
--If !global.!allowcallbacks = 0 Then Return 1
Parse Arg ., page, userdata
If page = 0 Then
   Do
      -- set a timer to start the progress meters
      !global.!progress_timer = dw_timer_connect( 1000, 'ProgressTimerCallback' )
      !global.!progress_countdown = 0
      Call dw_percent_set_pos !global.!progress_fixed, 0
      Call dw_percent_set_pos !global.!progress_indeterminant, !REXXDW.!DW_PERCENT_INDETERMINATE
   End
Else
   Do
      -- kill the timer if not dead already
      If !global.!progress_timer = '' Then
         Do
            Call dw_timer_disconnect !global.!progress_timer
            !global.!progress_timer = ''
         End
   End
Return 0

ProgressTimerCallback: Procedure Expose (!globalv)
!global.!progress_countdown = !global.!progress_countdown + 1
perc = !global.!progress_countdown * 20
Call dw_percent_set_pos !global.!progress_fixed, perc
rcode = 1
If perc = 100 Then
   Do
      Call dw_percent_set_pos !global.!progress_indeterminant, 100
      -- kill the timer
      Call dw_timer_disconnect !global.!progress_timer
      !global.!progress_timer = ''
      rcode = 0
   End
Return rcode

/* the help about callback */
HelpAboutCallback: Procedure Expose (!globalv)
If !global.!allowcallbacks = 0 Then Return 1
window_x = 500
window_y = 180
splashwindow = dw_window_new( !REXXDW.!DW_DESKTOP, 'Rexx/DW Details', !global.!style )
textbox = dw_box_new( !REXXDW.!DW_VERT )
Call dw_box_pack_start splashwindow, textbox, window_x-64, window_y-45, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0
Call dw_window_set_color textbox, !REXXDW.!DW_CLR_BLACK, !REXXDW.!DW_CLR_WHITE
/*
 * Display version details
 */
Parse Version ver
t1  = dw_text_new( 'Rexx Version:' ver, 0 )
Call dw_box_pack_start textbox, t1, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0
Call dw_window_set_style t1, dw_or( !REXXDW.!DW_DT_CENTER, !REXXDW.!DW_DT_VCENTER) , dw_or( !REXXDW.!DW_DT_CENTER, !REXXDW.!DW_DT_VCENTER )
Call dw_window_set_color t1, !REXXDW.!DW_CLR_BLACK, !REXXDW.!DW_CLR_WHITE

t1  = dw_text_new( 'RexxDW Version:' dw_variable( 'VERSION' ), 0 )
Call dw_box_pack_start textbox, t1, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0
Call dw_window_set_style t1, dw_or( !REXXDW.!DW_DT_CENTER, !REXXDW.!DW_DT_VCENTER) , dw_or( !REXXDW.!DW_DT_CENTER, !REXXDW.!DW_DT_VCENTER )
Call dw_window_set_color t1, !REXXDW.!DW_CLR_BLACK, !REXXDW.!DW_CLR_WHITE

Call dw_environment_query 'ver.'

t1 = dw_text_new( 'dwindows Version:' ver.8'.'ver.9'.'ver.10 'Built:' ver.2 ver.3, 0 )
Call dw_box_pack_start textbox, t1, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0
Call dw_window_set_style t1, dw_or( !REXXDW.!DW_DT_CENTER, !REXXDW.!DW_DT_VCENTER) , dw_or( !REXXDW.!DW_DT_CENTER, !REXXDW.!DW_DT_VCENTER )
Call dw_window_set_color t1, !REXXDW.!DW_CLR_BLACK, !REXXDW.!DW_CLR_WHITE

t1 = dw_text_new( 'Operating System:' ver.1 '('ver.4'.'ver.5')', 0 )
Call dw_box_pack_start textbox, t1, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0
Call dw_window_set_style t1, dw_or( !REXXDW.!DW_DT_CENTER, !REXXDW.!DW_DT_VCENTER) , dw_or( !REXXDW.!DW_DT_CENTER, !REXXDW.!DW_DT_VCENTER )
Call dw_window_set_color t1, !REXXDW.!DW_CLR_BLACK, !REXXDW.!DW_CLR_WHITE
/*
 * Our OK button
 */
abutton = dw_button_new( 'OK', 0 )
Call dw_box_pack_start textbox, abutton, window_x, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 1
Call dw_signal_connect abutton, !REXXDW.!DW_CLICKED_EVENT, 'GenericCloseCallback', splashwindow
Call dw_signal_connect splashwindow, !REXXDW.!DW_DELETE_EVENT, 'GenericCloseCallback', splashwindow
/*
 * Display the splash window
 */
Call dw_window_set_pos_size splashwindow, (!global.!screen_width % 2) - (window_x % 2), (!global.!screen_height % 2) - (window_y % 2), window_x, window_y
Call dw_window_show splashwindow
Return 0

/* called when a key is pressed */
KeyPressCallback: Procedure Expose (!globalv)
If !global.!allowcallbacks = 0 Then Return 1
Parse Arg window, key, virtual_key, state, where, textwin
Select
   When where = 'pointer_pos' Then
      Do
         Select
            When virtual_key = !REXXDW.!DW_VK_F1 Then
               Do
                  Parse Value dw_pointer_get_pos() With x y
                  Call dw_window_set_text textwin, 'Pointer at:' x'/'y
               End
            When virtual_key = !REXXDW.!DW_VK_F2 Then
               Do
                  Parse Value dw_pointer_get_pos() With x y
                  Call dw_pointer_set_pos 0, 0
                  Call dw_window_set_text textwin, 'Pointer moved from:' x'/'y 'to: 0/0'
               End
            When virtual_key = !REXXDW.!DW_VK_F3 Then
               Do
                  Parse Value dw_window_get_pos_size( window ) With wx wy .
                  Parse Value dw_pointer_get_pos() With x y
                  Call dw_pointer_set_pos x-wx, y-wy
                  Call dw_window_set_text textwin, 'Pointer moved from:' x'/'y 'to window: 0/0'
               End
            Otherwise Nop
         End
      End
   Otherwise Nop
End
Return 0

/* called when a mouse button is pressed */
ButtonPressCallback: Procedure Expose (!globalv)
If !global.!allowcallbacks = 0 Then Return 1
Parse Arg window, x, y, button, where, textwin, action
Select
   When where = 'pointer_pos' Then
      Do
         Select
            When button = 1 Then
               Do
                  Parse Value dw_pointer_get_pos() With x y
                  Call dw_window_set_text textwin, 'Pointer at:' x'/'y '('action')'
               End
            When button = 2 Then
               Do
                  Parse Value dw_pointer_get_pos() With x y
                  Call dw_pointer_set_pos 0, 0
                  Call dw_window_set_text textwin, 'Pointer moved from:' x'/'y 'to: 0/0' '('action')'
               End
            When button = 3 Then
               Do
                  Parse Value dw_window_get_pos_size( window ) With wx wy .
                  Parse Value dw_pointer_get_pos() With x y
                  Call dw_pointer_set_pos x-wx, y-wy
                  Call dw_window_set_text textwin, 'Pointer moved from:' x'/'y 'to window: 0/0' '('action')'
               End
            Otherwise Nop
         End
      End
   Otherwise Nop
End
Return 0

TaskbarMenuCallback: Procedure Expose (!globalv)
Parse Arg win, x, y, button, arg1, arg2
menu = dw_menu_new( 0 )
menuitem = dw_menu_append_item( menu, '~Quit', !REXXDW.!DW_MENU_POPUP, 0, !REXXDW.!DW_MENU_END, !REXXDW.!DW_MENU_NOT_CHECKABLE, !REXXDW.!DW_MENU_NOMENU )
Call dw_signal_connect menuitem, !REXXDW.!DW_CLICKED_EVENT, 'QuitCallback'
Call dw_menu_append_item menu, !REXXDW.!DW_MENU_SEPARATOR, !REXXDW.!DW_MENU_POPUP, 0, !REXXDW.!DW_MENU_END, !REXXDW.!DW_MENU_NOT_CHECKABLE, !REXXDW.!DW_MENU_NOMENU
menuitem = dw_menu_append_item( menu, '~Show Window', !REXXDW.!DW_MENU_POPUP, 0, !REXXDW.!DW_MENU_END, !REXXDW.!DW_MENU_NOT_CHECKABLE, !REXXDW.!DW_MENU_NOMENU )
Call dw_signal_connect menuitem, !REXXDW.!DW_CLICKED_EVENT, 'ShowWindowCallback'
Parse Value dw_pointer_get_pos( ) With x y
/* Use the toplevel window handle here.... because on the Mac..
 * using the control itself, when a different tab is active
 * the control is removed from the window and can no longer
 * handle the messages.
 */
Call dw_menu_popup menu, !global.!mainwindow, x, y
Return 1

GenericCloseCallback: Procedure Expose (!globalv)
If !global.!allowcallbacks = 0 Then Return 1
Parse Arg ., window, dialog
Call dw_window_destroy window
If dialog \= '' Then Call dw_dialog_dismiss dialog, 'close'
Return 0

QuitCallback:
If !global.!allowcallbacks = 0 Then Return 1
Call dw_main_quit
Return 0

/*
 * Each page showing different widgets...
 */
Various: Procedure Expose (!globalv)
Parse Arg idx
mainbox = dw_box_new( !REXXDW.!DW_HORZ )
Call dw_box_pack_start !global.!notebookbox.idx, mainbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 5

/* first col - buttons */
buttonbox = dw_groupbox_new( !REXXDW.!DW_VERT, 'Buttons', !REXXDW.!DW_FONT_BOLD )
Call dw_box_pack_start mainbox, buttonbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 2
tmpbox = dw_box_new( !REXXDW.!DW_HORZ )
Call dw_box_pack_start buttonbox, tmpbox, 150, 200, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0
abutton = dw_button_new( 'A really big text button!', 0 )
Call dw_box_pack_start tmpbox, abutton, 150, 200, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 2
--Call dw_signal_connect abutton, !REXXDW.!DW_CLICKED_EVENT, 'GenericClickCallback', 'A really big text button!'
Call dw_signal_connect abutton, !REXXDW.!DW_CLICKED_EVENT, 'ThreadTest'

/* enabled buttons */
tmpbox = dw_groupbox_new( !REXXDW.!DW_HORZ, 'Enabled Buttons', !REXXDW.!DW_FONT_ITALIC )
Call dw_box_pack_start buttonbox, tmpbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 2
abutton = dw_bitmapbutton_new_from_file( 'Enable Widgets', 0, !global.!icondir||'file' )
Call dw_box_pack_start tmpbox, abutton, 32, 32, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 2
Call dw_signal_connect abutton, !REXXDW.!DW_CLICKED_EVENT, 'EnableWidgetsCallback'
abutton = dw_bitmapbutton_new_from_data( 'Disable Widgets', 0, !global.!folder_icon_data )
Call dw_box_pack_start tmpbox, abutton, 32, 32, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 2
Call dw_signal_connect abutton, !REXXDW.!DW_CLICKED_EVENT, 'DisableWidgetsCallback'

/* disabled buttons */
tmpbox = dw_groupbox_new( !REXXDW.!DW_HORZ, 'Disabled Buttons', dw_or( !REXXDW.!DW_FONT_BOLD, !REXXDW.!DW_FONT_ITALIC ) )
Call dw_box_pack_start buttonbox, tmpbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 2
abutton = dw_bitmapbutton_new_from_file('A file button', 0, !global.!icondir||'file' )
Call dw_box_pack_start tmpbox, abutton, 32, 32, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 2
Call dw_signal_connect abutton, !REXXDW.!DW_CLICKED_EVENT, 'GenericClickCallback', 'A file button'
Call dw_window_disable abutton
abutton = dw_bitmapbutton_new_from_data( 'A dir button', 0, !global.!folder_icon_data )
Call dw_box_pack_start tmpbox, abutton, 32, 32, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 2
Call dw_signal_connect abutton, !REXXDW.!DW_CLICKED_EVENT, 'GenericClickCallback', 'A directory button'
Call dw_window_disable abutton

sliderbox = dw_groupbox_new( !REXXDW.!DW_VERT, 'Slider/Spin' )
Call dw_box_pack_start buttonbox, sliderbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 2

/* slider */
tmpbox = dw_box_new( !REXXDW.!DW_HORZ )
Call dw_box_pack_start sliderbox, tmpbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0
tmp = dw_text_new( 'Slider:', 0 )
Call dw_box_pack_start tmpbox, tmp, 100, !global.!widgetheight, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
slider = dw_slider_new( !REXXDW.!DW_HORZ, 100, 0 )
Call dw_box_pack_start tmpbox, slider, 0, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0

/* slider percent */
tmpbox = dw_box_new( !REXXDW.!DW_HORZ )
Call dw_box_pack_start sliderbox, tmpbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0
slider_percent = dw_percent_new( 0 )
Call dw_box_pack_start tmpbox, slider_percent, 0, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0

Call dw_percent_set_pos slider_percent, 0

Call dw_box_pack_start sliderbox, 0, 200, 5, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0

/* spinbutton */
tmp = dw_text_new( 'Spinbutton:', 0 )
Call dw_box_pack_start sliderbox, tmp, 200, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
spinbutton = dw_spinbutton_new( '', 0 )
Call dw_box_pack_start sliderbox, spinbutton, 200, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
Call dw_spinbutton_set_limits spinbutton, 100, 0
Call dw_spinbutton_set_pos spinbutton, 0
/*
 * As our slider and spinbutton are tied together, we need the widget id for each callback
 */
Call dw_signal_connect spinbutton, !REXXDW.!DW_VALUE_CHANGED_EVENT, 'SpinbuttonCallback', slider_percent, slider
Call dw_signal_connect slider, !REXXDW.!DW_VALUE_CHANGED_EVENT, 'SliderCallback', slider_percent, spinbutton
-- percents
percentbox = dw_groupbox_new( !REXXDW.!DW_VERT, 'Percent' )
Call dw_box_pack_start buttonbox, percentbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 2

tmpbox = dw_box_new( !REXXDW.!DW_HORZ )
Call dw_box_pack_start percentbox, tmpbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0
!global.!progress_fixed = dw_percent_new( 0 )
Call dw_box_pack_start tmpbox, !global.!progress_fixed, 0, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
Call dw_percent_set_pos !global.!progress_fixed, 0

tmpbox = dw_box_new( !REXXDW.!DW_HORZ )
Call dw_box_pack_start percentbox, tmpbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0
!global.!progress_indeterminant = dw_percent_new( 0 )
Call dw_box_pack_start tmpbox, !global.!progress_indeterminant, 0, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
Call dw_percent_set_pos !global.!progress_indeterminant, !REXXDW.!DW_PERCENT_INDETERMINATE

/* second col - entry */
secondbox = dw_box_new( !REXXDW.!DW_VERT )
Call dw_box_pack_start mainbox, secondbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0

entrybox = dw_groupbox_new( !REXXDW.!DW_VERT, 'Entry' )
Call dw_box_pack_start secondbox, entrybox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 2

tmp = dw_text_new( 'EntryField:', 0 )
Call dw_box_pack_start entrybox, tmp, 200, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
entry = dw_entryfield_new( '', 0 )
Call dw_box_pack_start entrybox, entry, 200, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0

tmp = dw_text_new( 'Password:', 0 )
Call dw_box_pack_start entrybox, tmp, 200, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
password = dw_entryfield_password_new( '', 0 )
Call dw_box_pack_start entrybox, password, 200, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0

tmp = dw_text_new( 'Combobox:', 0 )
Call dw_box_pack_start entrybox, tmp, 200, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
combo = dw_combobox_new( '', 0 )
Call dw_box_pack_start entrybox, combo, 200, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
Call dw_window_set_text combo, 'item 1'
Call dw_listbox_append combo, 'item 1'
Call dw_listbox_append combo, 'item 2'
Call dw_listbox_append combo, 'item 3'

tmp = dw_text_new( 'Listbox:', 0 )
Call dw_box_pack_start entrybox, tmp, 200, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
listbox = dw_listbox_new( 673, !REXXDW.!DW_LB_SINGLE_SELECTION )
Call dw_box_pack_start entrybox, listbox, 200, 40, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
Call dw_listbox_append listbox, 'item 1'
Call dw_listbox_append listbox, 'item 2'
Call dw_listbox_append listbox, 'item 3'

selectorbox = dw_groupbox_new( !REXXDW.!DW_VERT, 'Listbox Selector' )
Call dw_box_pack_start secondbox, selectorbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 2

!global.!ls = dw_listbox_selector_new( 'Selected', 'Not Selected', 100, 200 )
Call dw_box_pack_start selectorbox, !global.!ls, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0
items.0 = 5
items.1 = 'one'
items.2 = 'two'
items.3 = 'three'
items.4 = 'four'
items.5 = 'five'
ind. = 0
ind.0 = 5
ind.2 = 1
ind.4 = 1
Call dw_listbox_selector_setup !global.!ls, 'items.', 'ind.'

tmpbox = dw_box_new( !REXXDW.!DW_HORZ )
Call dw_box_pack_start secondbox, tmpbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0

Call dw_box_pack_start tmpbox, 0, 0, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0
abutton = dw_button_new( 'Show Values', 0 )
Call dw_box_pack_start tmpbox, abutton, 100, !global.!widgetheight, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
Call dw_signal_connect abutton, !REXXDW.!DW_CLICKED_EVENT, 'EntryClickCallback', slider, spinbutton, entry, password, combo, listbox
Call dw_box_pack_start tmpbox, 0, 0, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0

/* display the current values */
!global.!slider_text = dw_text_new( 'Slider:', 0 )
Call dw_box_pack_start secondbox, !global.!slider_text, 200, 15, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
!global.!spinbutton_text = dw_text_new( 'Spinbutton:', 0 )
Call dw_box_pack_start secondbox, !global.!spinbutton_text, 200, 15, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
!global.!entry_text = dw_text_new( 'EntryField:', 0 )
Call dw_box_pack_start secondbox, !global.!entry_text, 200, 15, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
!global.!password_text = dw_text_new( 'Password:', 0 )
Call dw_box_pack_start secondbox, !global.!password_text, 200, 15, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
!global.!combo_text = dw_text_new( 'Combobox:', 0 )
Call dw_box_pack_start secondbox, !global.!combo_text, 200, 15, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
!global.!listbox_text = dw_text_new( 'Listbox:', 0 )
Call dw_box_pack_start secondbox, !global.!listbox_text, 200, 15, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0

/* third col - radio/checkbox */
thirdbox = dw_box_new( !REXXDW.!DW_VERT )
Call dw_box_pack_start mainbox, thirdbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0

radiocheckbox = dw_groupbox_new( !REXXDW.!DW_VERT, 'Radio/Check Boxes' )
Call dw_box_pack_start thirdbox, radiocheckbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 2

radiobox = dw_groupbox_new( !REXXDW.!DW_VERT, 'Favourite Language' )
Call dw_window_set_color radiobox, !REXXDW.!DW_CLR_BLACK, !REXXDW.!DW_CLR_CYAN
Call dw_box_pack_start radiocheckbox, radiobox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 2
Do i = 1 To !global.!langs.0
   !global.!langs_cb.i = dw_radiobutton_new( !global.!langs.i, 100+i )
   Call dw_box_pack_start radiobox, !global.!langs_cb.i, 200, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
   Call dw_window_set_color !global.!langs_cb.i, !REXXDW.!DW_CLR_BLACK, !REXXDW.!DW_CLR_CYAN
End
Call dw_radiobutton_set !global.!langs_cb.1, !REXXDW.!DW_CHECKED

checkbox = dw_groupbox_new( !REXXDW.!DW_VERT, 'Staying Awake Days' )
Call dw_box_pack_start radiocheckbox, checkbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 2
Call dw_window_set_color checkbox, !REXXDW.!DW_CLR_BLACK, !REXXDW.!DW_CLR_YELLOW
Do i = 1 To !global.!days.0
   !global.!days_cb.i = dw_checkbox_new( !global.!days.i, 0 )
   Call dw_box_pack_start checkbox, !global.!days_cb.i, 200, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
   Call dw_window_set_color !global.!days_cb.i, !REXXDW.!DW_CLR_BLACK, !REXXDW.!DW_CLR_YELLOW
End

Call dw_box_pack_start radiocheckbox, 0, 0, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0

tmpbox = dw_box_new( !REXXDW.!DW_VERT )
Call dw_box_pack_start radiocheckbox, tmpbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0

Call dw_box_pack_start tmpbox, 0, 0, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0

tmp = dw_box_new( !REXXDW.!DW_HORZ )
Call dw_box_pack_start tmpbox, tmp, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0

Call dw_box_pack_start tmp, 0, 0, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0
!global.!date = dw_calendar_new( 110 )
Call dw_box_pack_start tmp, !global.!date, 180, 160, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
Call dw_box_pack_start tmp, 0, 0, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
Call dw_calendar_set_date !global.!date, Date('S')

Call dw_box_pack_start thirdbox, 0, 200, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0

abutton = dw_button_new( 'Show Values', 0 )
Call dw_box_pack_start tmpbox, abutton, 100, !global.!widgetheight, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
Call dw_signal_connect abutton, !REXXDW.!DW_CLICKED_EVENT, 'CheckClickCallback', entry, password, combo, listbox
Call dw_box_pack_start tmpbox, 0, 0, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0

/* display the current values */

tmpbox = dw_box_new( !REXXDW.!DW_HORZ )
Call dw_box_pack_start radiocheckbox, tmpbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0

langbox = dw_box_new( !REXXDW.!DW_VERT )
Call dw_box_pack_start tmpbox, langbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 5

Call dw_window_set_color langbox, !REXXDW.!DW_CLR_BLACK, !REXXDW.!DW_CLR_CYAN
Do i = 1 To !global.!langs.0
   !global.!langs_text.i = dw_text_new( '', 0 )
   Call dw_box_pack_start langbox, !global.!langs_text.i, 0, 15, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
   Call dw_window_set_color !global.!langs_text.i, !REXXDW.!DW_CLR_BLACK, !REXXDW.!DW_CLR_CYAN
End

daysbox = dw_box_new( !REXXDW.!DW_VERT )
Call dw_box_pack_start tmpbox, daysbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 5
Call dw_window_set_color daysbox, !REXXDW.!DW_CLR_BLACK, !REXXDW.!DW_CLR_YELLOW
Do i = 1 To !global.!days.0
   !global.!days_text.i = dw_text_new( '', 0 )
   Call dw_box_pack_start daysbox, !global.!days_text.i, 0, 15, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
   Call dw_window_set_color !global.!days_text.i, !REXXDW.!DW_CLR_BLACK, !REXXDW.!DW_CLR_YELLOW
End

!global.!date_text = dw_text_new( 'Date:', 0 )
Call dw_box_pack_start thirdbox, !global.!date_text, 200, 15, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0

Call CheckClickCallback
Return

Explorer: Procedure Expose (!globalv)
Parse Arg idx

flags.0 = 3
flags.1 = dw_or( !REXXDW.!DW_CFA_STRING, !REXXDW.!DW_CFA_CENTER, !REXXDW.!DW_CFA_SEPARATOR, !REXXDW.!DW_CFA_HORZSEPARATOR )
flags.2 = dw_or( !REXXDW.!DW_CFA_ULONG, !REXXDW.!DW_CFA_RIGHT, !REXXDW.!DW_CFA_SEPARATOR, !REXXDW.!DW_CFA_HORZSEPARATOR )
flags.3 = dw_or( !REXXDW.!DW_CFA_STRING, !REXXDW.!DW_CFA_LEFT, !REXXDW.!DW_CFA_SEPARATOR, !REXXDW.!DW_CFA_HORZSEPARATOR )
titles.0 = 3
titles.1 = 'File Date'
titles.2 = 'Size'
titles.3 = 'Permissions'
mainbox = dw_box_new( !REXXDW.!DW_VERT )
Call dw_box_pack_start !global.!notebookbox.idx, mainbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 5

treecontainerbox = dw_box_new( !REXXDW.!DW_HORZ ) /* don't pack */
treebox = dw_box_new( !REXXDW.!DW_HORZ ) /* don't pack */
containerbox = dw_box_new( !REXXDW.!DW_HORZ ) /* don't pack */
mlebox = dw_box_new( !REXXDW.!DW_HORZ ) /* don't pack */

hsplitbar = dw_splitbar_new( !REXXDW.!DW_HORZ, treebox, containerbox, 0 )
Call dw_box_pack_start treecontainerbox, hsplitbar, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0
Call dw_splitbar_set hsplitbar, 30.0

vsplitbar = dw_splitbar_new( !REXXDW.!DW_VERT, treecontainerbox, mlebox, 0 )
Call dw_box_pack_start mainbox, vsplitbar, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0
Call dw_splitbar_set vsplitbar, 50.0

!global.!tree = dw_tree_new( 101 )
Call dw_box_pack_start treebox, !global.!tree, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0

Call dw_signal_connect !global.!tree, !REXXDW.!DW_ITEM_CONTEXT_EVENT, 'TreeContextCallback'

!global.!container = dw_container_new( 100, !REXXDW.!DW_SINGLE_SELECTION )
Call dw_box_pack_start containerbox, !global.!container, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0

Call dw_filesystem_setup !global.!container, 'flags.', 'titles.'

Call PopulateTree !global.!root
/*
Call dw_tree_item_select !global.!tree, !global.!toptreeitem
*/

!global.!mle = dw_mle_new( 0 )
Call dw_box_pack_start mlebox, !global.!mle, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0
Call dw_mle_set_word_wrap !global.!mle, !REXXDW.!DW_DONT_WORD_WRAP
Call dw_window_set_color !global.!mle, !REXXDW.!DW_CLR_BLACK, !REXXDW.!DW_CLR_WHITE

Return

PopulateTree: Procedure Expose (!globalv)
Parse Arg dir
/*
thisdir = Stream( Strip( dir, 'T', '/' ), 'C', 'QUERY EXISTS' ) || !REXXDW.!DIRSEP
*/
olddir = Directory( )
Call Directory  dir
thisdir = Directory() || !REXXDW.!DIRSEP
Call Directory olddir
!global.!allowcallbacks = 0
Call dw_signal_connect !global.!tree, !REXXDW.!DW_ITEM_SELECT_EVENT, 'TreeSelectCallback'
/*
 * Populate our tree with files from specified directory
 * Need rexxutil
 */
Call SysFileTree thisdir'*', 'DIR.', 'ODS' /**/
Call SysStemSort 'DIR.', 'Ascending', , , , 1, 100
!global.!toptreeitem = dw_tree_insert( !global.!tree, '['thisdir']', !global.!foldericon, 0, '.' )
Do i = 1 To dir.0
   mydir = dir.i
   pos = Lastpos( !REXXDW.!DIRSEP, mydir )
   currentdir = Substr( mydir, pos+1 )
   parent = Substr( mydir, 1, pos-1 )
   parentidx = FindTreeItem( parent )
   If parentidx = 0 Then parentitem = !global.!toptreeitem
   Else parentitem = !global.!treeitem.parentidx
   !global.!treeitem.i = dw_tree_insert( !global.!tree, currentdir, !global.!foldericon, parentitem, dir.i )
End
!global.!allowcallbacks = 1
Return

PopulateContainer: Procedure Expose (!globalv)
Parse Arg dir
/*
thisdir = Stream( Strip( dir, 'T', '/' ), 'C', 'QUERY EXISTS' ) || !REXXDW.!DIRSEP
*/
thisdir = dir
!global.!allowcallbacks = 0
/*
 * If this is NOT the first time we call this, we need to clear the contents
 * of the container
 */
If Left( !global.!container, 1 ) \= '!' Then
   Do
      /*
       * Clear our signals for container
       */
      Call dw_signal_disconnect !global.!container, !REXXDW.!DW_ITEM_SELECT_EVENT
      Call dw_signal_disconnect !global.!container, !REXXDW.!DW_ITEM_CONTEXT_EVENT
      Call dw_container_clear !global.!container, !REXXDW.!DW_DONT_REDRAW
   End
/*
 * Get the files and directories for the specified directory
 */
Call SysFileTree thisdir||!REXXDW.!DIRSEP'*', '!GLOBAL.!FILE.', 'LF' /**/
Call SysStemSort '!GLOBAL.!FILE.', 'Ascending', , , , 40, 100
/*
 * We know how many items to go into our container; allocate memory for it
 */
containermemory = dw_container_alloc( !global.!container, !global.!file.0 )
Do i = 1 To !global.!file.0
   fn = SubWord( !global.!file.i, 5 )
   pos = Lastpos( !REXXDW.!DIRSEP, fn )
   fn = Substr( fn, pos+1 )
   Call dw_filesystem_set_file !global.!container, containermemory, i-1, fn, !global.!fileicon
   Call dw_filesystem_set_item !global.!container, containermemory, 0, i-1, Subword( !global.!file.i, 1, 2 )
   Call dw_filesystem_set_item !global.!container, containermemory, 1, i-1, Word( !global.!file.i, 3 )
   Call dw_filesystem_set_item !global.!container, containermemory, 2, i-1, Word( !global.!file.i, 4 )
   Call dw_container_set_row_title containermemory, i-1, i
End
Call dw_container_insert !global.!container, containermemory, !global.!file.0
Call dw_container_optimize !global.!container
/*
 * Connect our signals for the container AFTER populating it
 */
Call dw_signal_connect !global.!container, !REXXDW.!DW_ITEM_SELECT_EVENT, 'ContainerSelectCallback'
Call dw_signal_connect !global.!container, !REXXDW.!DW_ITEM_CONTEXT_EVENT, 'ContainerContextCallback'
!global.!allowcallbacks = 1
Return

/*
 * Determine the index of the supplied directory in the list of directories
 * in the repository
 */
FindTreeItem: Procedure Expose (!globalv) dir.
Parse Arg item
Do i = 1 To dir.0
   If dir.i = item Then Return i
End
Return 0

/*
 * The callback for left mouse button click on Tree item
 */
TreeSelectCallback: Procedure Expose (!globalv)
If !global.!allowcallbacks = 0 Then Return 1
Parse Arg win, item, text, itemdata, userdata
If !global.!allowcallbacks = 1 Then Call PopulateContainer itemdata

Return 1

/*
 * The callback for left mouse button click on Container item
 */
ContainerSelectCallback: Procedure Expose (!globalv)
If !global.!allowcallbacks = 0 Then Return 1
Parse Arg win, item, text, itemdata, userdata
Call dw_mle_delete !global.!mle
/*
 * Get the file name from the file array...
 */
fn = SubWord( !global.!file.text, 5 )
/*
 * ...and check if it is a binary file...
 */
If IsBinaryFile( fn ) Then
   Do
      Call dw_messagebox 'Binary file!', dw_or( !REXXDW.!DW_MB_OK, !REXXDW.!DW_MB_WARNING ), fn 'is a binary file. Not displayed.'
      Return 1
   End
/*
 * ... and read it into the MLE
 */
Call dw_mle_freeze !global.!mle
crlf = d2c(13)||d2c(10)
Call Stream fn, 'C', 'OPEN READ'
pos = -1
Do While Lines( fn ) > 0
   line = Linein( fn )
   pos = dw_mle_import( !global.!mle, line||crlf, pos )
End
Call Stream fn, 'C', 'CLOSE'
Call dw_mle_thaw !global.!mle
Return 1

/*
 * The callback for right mouse button click on Container item
 */
ContainerContextCallback: Procedure Expose (!globalv)
If !global.!allowcallbacks = 0 Then Return 1
Parse Arg win, text, x, y
/*
 * Get the file name from the file array...
 */
fn = SubWord( !global.!file.text, 5 )
Call dw_messagebox 'Context Event!', !REXXDW.!DW_MB_OK, 'Right mouse clicked on' fn
Return 1

/*
 * The callback for right mouse button click on Tree item
 */
TreeContextCallback: Procedure Expose (!globalv)
If !global.!allowcallbacks = 0 Then Return 1
Parse Arg win, text, x, y
Call dw_messagebox 'Context Event!', !REXXDW.!DW_MB_OK, 'Right mouse clicked on dir' text 'at' x','y
Return 1

Rendering: Procedure Expose (!globalv) pixmap renderbox
Parse Arg idx
depth = dw_color_depth_get()
pagebox = dw_box_new( !REXXDW.!DW_VERT )
Call dw_box_pack_start !global.!notebookbox.idx, pagebox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 2
t1  = dw_text_new( 'Mouse:', 0 )
Call dw_box_pack_start pagebox, t1, 0, 20, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 2
/* create render box for our pixmap */
renderbox = dw_render_new( 0 )
Call dw_box_pack_start pagebox, renderbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0
Call dw_window_set_font renderbox, !global.!fixedfont

Call dw_signal_connect renderbox, !REXXDW.!DW_EXPOSE_EVENT, 'ExposeCallback'
Call dw_signal_connect renderbox, !REXXDW.!DW_CONFIGURE_EVENT, 'ConfigureCallback'
Call dw_signal_connect renderbox, !REXXDW.!DW_MOTION_NOTIFY_EVENT, 'MotionNotifyCallback', t1
Return

ExposeCallback:
If !global.!allowcallbacks = 0 Then Return 1
Parse Arg renderbox, x, y, width, height
If renderbox \= '' Left( !global.!pixmap, 1 ) \= '!' Then
   Do
      pixmap = !global.!pixmap
      width = dw_pixmap_width( pixmap )
      height = dw_pixmap_height( pixmap )
      Call dw_pixmap_bitblt renderbox, , 0, 0, width, height, , pixmap, 0, 0
      Call dw_flush
   End
Return 1

ConfigureCallback: Procedure Expose (!globalv)
If !global.!allowcallbacks = 0 Then Return 1
Parse Arg renderbox, width, height
pixmap = !global.!pixmap
/* Destroy the old pixmap */
If Left( pixmap, 1 ) \= '!' Then Call dw_pixmap_destroy pixmap
depth = dw_color_depth_get()

/* Create new pixmap with the current size */
!global.!pixmap = dw_pixmap_new( renderbox, width, height, depth )

/* Redraw the window */
Call DrawPixmap renderbox, !global.!pixmap
Return 1

MotionNotifyCallback: Procedure Expose (!globalv)
If !global.!allowcallbacks = 0 Then Return 1
Parse Arg win, x, y, button, t1
Call dw_window_set_text t1, 'Mouse:' x'x'y
Return 0

DrawPixmap: Procedure Expose (!globalv)
Parse Arg renderbox, pixmap
width = dw_pixmap_width( pixmap )
height = dw_pixmap_height( pixmap )
Call dw_color_foreground_set !REXXDW.!DW_CLR_RED
Call dw_draw_rect , pixmap, !REXXDW.!DW_FILL, 10, 10, width - 20, height - 20
Call dw_color_foreground_set !REXXDW.!DW_CLR_BLUE
Call dw_color_background_set !REXXDW.!DW_CLR_RED
Call dw_draw_line , pixmap, 50, 50, width - 50, height - 50
Call dw_draw_line , pixmap, width - 50, 50, 50, height - 50
Call dw_draw_line , pixmap, width % 2, 50, width % 2, height - 50
Call dw_draw_line , pixmap, 50, height % 2, width - 50, height % 2
x.0 = 3; x.1 = 50; x.2 = 130; x.3 = 130
y.0 = 3; y.1 = 50; y.2 = 10; y.3 = 120
Call dw_draw_polygon , pixmap, !REXXDW.!DW_FILL, 'x.', 'y.'
x.0 = 3; x.1 = 20; x.2 = 135; x.3 = 150
y.0 = 3; y.1 = 20; y.2 = 23; y.3 = 134
Call dw_color_foreground_set !REXXDW.!DW_CLR_WHITE
Call dw_draw_polygon , pixmap, !REXXDW.!DW_DONT_FILL, 'x.', 'y.'
Parse Value dw_font_text_extents_get( renderbox, , "(g" ) With font_width font_height
font_width = font_width % 2
str = ' Some rendered text '
len = Length( str )
str_width = len * font_width
x = (width % 2) - (str_width % 2)
y = (height % 2) - (font_height % 2)
Call dw_draw_text , pixmap, x, y, str
Call ExposeCallback renderbox
Return

MDI: Procedure Expose (!globalv)
Parse Arg idx
/* create a box to pack into the notebook page */
mdibox = dw_box_new( !REXXDW.!DW_HORZ )
Call dw_box_pack_start !global.!notebookbox.idx, mdibox, 500, 200, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 1

/* now a mdi under this box */
mdi = dw_mdi_new(333)
Call dw_box_pack_start  mdibox, mdi, 500, 200, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 2

mdi1w = dw_window_new( mdi, 'MDI1', dw_or( !global.!style, !REXXDW.!DW_FCF_SIZEBORDER, !REXXDW.!DW_FCF_MINMAX ) )
mdi1box = dw_box_new( !REXXDW.!DW_HORZ )
Call dw_box_pack_start  mdi1w, mdi1box, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0
ef = dw_entryfield_new( "", 0)
Call dw_box_pack_start mdi1box, ef, 100, 15, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 4
Call dw_window_set_pos_size mdi1w, 10, 10, 200, 100
Call dw_window_show mdi1w

mdi2w = dw_window_new( mdi, 'MDI2', dw_or( !global.!style, !REXXDW.!DW_FCF_SIZEBORDER, !REXXDW.!DW_FCF_MINMAX ) )
mdi2box = dw_box_new( !REXXDW.!DW_HORZ )
Call dw_box_pack_start  mdi2w, mdi2box, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0
ef = dw_entryfield_new( "", 0)
Call dw_box_pack_start mdi2box, ef, 150, 30, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 4
bb = dw_button_new( "Browse", 0 )
Call dw_box_pack_start mdi2box, bb, 60, 30, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 4
Call dw_window_set_pos_size mdi2w, 150, 10, 300, 100
Call dw_window_show mdi2w
Return 0

Dialog: Procedure Expose (!globalv)
Parse Arg ., type
Parse Version ver
If Countstr( 'Regina', ver ) = 0 Then
   Do
      Call dw_messagebox 'Dialog Warning', dw_or( !REXXDW.!DW_MB_OK, !REXXDW.!DW_MB_WARNING ), 'Callbacks from a dialog only work with Regina. Dialog disabled.'
      Return 1
   End
/*
 * Make pseudo modal
 */
If type = 'modal' Then Call dw_window_disable !global.!mainwindow

win = dw_window_new( !REXXDW.!DW_DESKTOP, 'Job Details', !global.!style )
topbox = dw_box_new( !REXXDW.!DW_VERT )
Call dw_box_pack_start win, topbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0

ls = dw_listbox_selector_new( 'Selected', 'Not Selected', 100, 200 )
Call dw_box_pack_start topbox, ls, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0
items.0 = 5
items.1 = 'one'
items.2 = 'two'
items.3 = 'three'
items.4 = 'four'
items.5 = 'five'
ind. = 0
ind.0 = 5
ind.2 = 1
ind.4 = 1
Call dw_listbox_selector_setup ls, 'items.', 'ind.'
/*
 * Create View and Delete buttons...
 */
buttonbox = dw_box_new( !REXXDW.!DW_HORZ )
Call dw_box_pack_start topbox, buttonbox, 0, 20+10, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
Call dw_box_pack_start buttonbox, 0, 0, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
b0 = dw_button_new( 'View', 0 )
Call dw_box_pack_start buttonbox, b0, 50, !global.!widgetheight, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 5
Call dw_box_pack_start buttonbox, 0, 50, !global.!widgetheight, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
b1 = dw_button_new( 'Delete', 0 )
Call dw_box_pack_start buttonbox, b1, 50, !global.!widgetheight, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 5
Call dw_box_pack_start buttonbox, 0, 0, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0

/*
 * Create OK button
 */
b2 = dw_button_new( 'OK', 0 )
Call dw_box_pack_start topbox, b2, 0, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
/*
 * Display the window
 */
width = 200
height = 80  /* text_height + cb_height + 80 */
Call dw_window_set_pos_size win, (!global.!screen_width % 2) - (width % 2), (!global.!screen_height % 2) - (height % 2), width, height
Call dw_window_show win
Call dw_main_sleep 10
Do Forever
   /*
    * Create a dialog for the window
    */
   dialog_wait = dw_dialog_new( )
   /*
    * We now have everything setup, we can connect the destroying of the top-level window
    * to the 'close' callback
    */
   Call dw_signal_connect b0, !REXXDW.!DW_CLICKED_EVENT, 'DialogCallback', 'view'
   Call dw_signal_connect b1, !REXXDW.!DW_CLICKED_EVENT, 'DialogCallback', 'delete'
   Call dw_signal_connect b2, !REXXDW.!DW_CLICKED_EVENT, 'GenericCloseCallback', win, dialog_wait
   Call dw_signal_connect win, !REXXDW.!DW_DELETE_EVENT, 'GenericCloseCallback', win, dialog_wait
   /*
    * Wait for the dialog to come back
    */
   result = dw_dialog_wait( dialog_wait )
   /*
    * All successful processing done in the 'applycallback', so simply get
    * out of the loop if we don't have any validation issues
    */
   If result \= 'retry' Then Leave
End
/*
 * Make pseudo modal
 */
If type = 'modal' Then
   Do
      Call dw_window_enable !global.!mainwindow
      Call dw_window_raise !global.!mainwindow
   End
Return 1

DialogCallback: Procedure Expose (!globalv)
Parse Arg ., action
Call dw_messagebox 'Dialog Result', !REXXDW.!DW_MB_OK, 'Button pressed:' action
Return 1

/*
 * dw_screen_height(), dw_screen_width()
 * dw_window_set_data(), dw_window_get_data()
 * dw_pointer_get_pos(), dw_pointer_set_pos() (keyboard)
 */
Utility: Procedure Expose (!globalv)
Parse Arg idx
mainbox = dw_box_new( !REXXDW.!DW_HORZ )
Call dw_box_pack_start !global.!notebookbox.idx, mainbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 5

/* first col - pointer position stuff */
firstbox = dw_box_new( !REXXDW.!DW_VERT )
Call dw_box_pack_start mainbox, firstbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0
posbox = dw_groupbox_new( !REXXDW.!DW_VERT, 'Position Info' )
Call dw_box_pack_start firstbox, posbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 2
tmp = dw_text_new( 'Screen Width:' dw_screen_width(), 0 )
Call dw_box_pack_start posbox, tmp, 200, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
tmp = dw_text_new( 'Screen Height:' dw_screen_height(), 0 )
Call dw_box_pack_start posbox, tmp, 200, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
tmp = dw_text_new( 'Press F1 or button 1 to display pointer position.', 0 )
Call dw_box_pack_start posbox, tmp, 200, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
tmp = dw_text_new( 'Press F2 or button 2 to move pointer to screen 0/0.', 0 )
Call dw_box_pack_start posbox, tmp, 200, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
tmp = dw_text_new( 'Press F3 or button 3 to move pointer to window 0/0.', 0 )
Call dw_box_pack_start posbox, tmp, 200, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0

/*
whitebox = dw_box_new( !REXXDW.!DW_HORZ )
Call dw_box_pack_start posbox, whitebox, 200, 200, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
Call dw_window_set_color whitebox, !REXXDW.!DW_CLR_BLACK, !REXXDW.!DW_CLR_WHITE
*/
whitebox = dw_render_new( 0 )
Call dw_box_pack_start posbox, whitebox, 200, 200, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
Call dw_color_background_set !REXXDW.!DW_CLR_WHITE
Call dw_draw_rect whitebox, , !REXXDW.!DW_FILL, 0, 0, 200, 200
Call dw_color_foreground_set !REXXDW.!DW_CLR_BLACK
Call dw_draw_rect whitebox, , !REXXDW.!DW_DONT_FILL, 0, 0, 200, 200

Parse Value dw_pointer_get_pos() With x y
mousepostext = dw_text_new( 'Mouse Position:' x'/'y, 0 )
Call dw_box_pack_start posbox, mousepostext, 200, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
/*
Call dw_signal_connect whitebox, !REXXDW.!DW_KEY_PRESS_EVENT, 'KeyPressCallback', 'pointer_pos', mousepostext
*/
Call dw_signal_connect whitebox, !REXXDW.!DW_BUTTON_PRESS_EVENT, 'ButtonPressCallback', 'pointer_pos', mousepostext, 'press'
Call dw_signal_connect whitebox, !REXXDW.!DW_BUTTON_RELEASE_EVENT, 'ButtonPressCallback', 'pointer_pos', mousepostext, 'release'
Call dw_signal_connect !global.!mainwindow, !REXXDW.!DW_KEY_PRESS_EVENT, 'KeyPressCallback', 'pointer_pos', mousepostext
Call dw_signal_connect !global.!mainwindow, !REXXDW.!DW_BUTTON_PRESS_EVENT, 'ButtonPressCallback', 'pointer_pos', mousepostext, 'press'


/* second col - dw_window_get/set_data() test */
secondbox = dw_box_new( !REXXDW.!DW_VERT )
Call dw_box_pack_start mainbox, secondbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0
entrybox = dw_groupbox_new( !REXXDW.!DW_VERT, 'Window Data Test' )
Call dw_box_pack_start secondbox, entrybox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 2

tmp = dw_text_new( 'Enter Window Data:', 0 )
Call dw_box_pack_start entrybox, tmp, 200, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
entry = dw_entryfield_new( '', 0 )
Call dw_box_pack_start entrybox, entry, 200, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0

abutton = dw_button_new( "Set Value", 0 )
Call dw_box_pack_start entrybox, abutton, 30, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
Call dw_signal_connect abutton, !REXXDW.!DW_CLICKED_EVENT, 'SetWindowDataCallback', entry

text = dw_text_new( 'Window Data:', 0 )
Call dw_box_pack_start entrybox, text, 200, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0

abutton = dw_button_new( "Get Value", 0 )
Call dw_box_pack_start entrybox, abutton, 30, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
Call dw_signal_connect abutton, !REXXDW.!DW_CLICKED_EVENT, 'GetWindowDataCallback', entry, text

-- another group box containing various utility information
infobox = dw_groupbox_new( !REXXDW.!DW_VERT, 'Information' )
Call dw_box_pack_start secondbox, infobox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 2

tmp = dw_text_new( 'dw_screen_width():' dw_screen_width(), 0 )
Call dw_box_pack_start infobox, tmp, 200, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
Call dw_window_set_font tmp, dw_window_get_font( tmp ) 'italic'

tmp = dw_text_new( 'dw_screen_height():' dw_screen_height(), 0 )
Call dw_box_pack_start infobox, tmp, 200, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
Call dw_window_set_font tmp, dw_window_get_font( tmp ) 'italic'

tmp = dw_text_new( 'dw_user_dir():', 0 )
Call dw_box_pack_start infobox, tmp, 200, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
Call dw_window_set_font tmp, dw_window_get_font( tmp ) 'italic'
tmp = dw_text_new( dw_user_dir(), 0 )
Call dw_box_pack_start infobox, tmp, 200, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0

tmp = dw_text_new( 'dw_app_dir():', 0 )
Call dw_box_pack_start infobox, tmp, 200, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
Call dw_window_set_font tmp, dw_window_get_font( tmp ) 'italic'
tmp = dw_text_new( dw_app_dir(), 0 )
Call dw_box_pack_start infobox, tmp, 200, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0

Call dw_environment_query 'env.'
tmp = dw_text_new( 'dw_environment_query() Operating System:', 0 )
Call dw_box_pack_start infobox, tmp, 200, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
Call dw_window_set_font tmp, dw_window_get_font( tmp ) 'italic'
str = ''
Do i = 1 To 7
   str = str env.i
End
tmp = dw_text_new( str, 0 )
Call dw_box_pack_start infobox, tmp, 200, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
tmp = dw_text_new( 'dw_environment_query() dwindows version:', 0 )
Call dw_box_pack_start infobox, tmp, 200, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
Call dw_window_set_font tmp, dw_window_get_font( tmp ) 'italic'
str = ''
Do i = 8 To 10
   str = str env.i
End
tmp = dw_text_new( str, 0 )
Call dw_box_pack_start infobox, tmp, 200, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0

Return

Box: Procedure Expose (!globalv)
Parse Arg idx
topbox = dw_box_new( !REXXDW.!DW_HORZ )
Call dw_box_pack_start !global.!notebookbox.idx, topbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 5

/* create our RED HORZ box and pack it into the top box */
box1 = dw_box_new( !REXXDW.!DW_HORZ )
Call dw_box_pack_start topbox, box1, 500, 200, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 5
Call dw_window_set_color box1, !REXXDW.!DW_CLR_BLACK, !REXXDW.!DW_CLR_RED

/* create a legend VERT box and pack it into the top box */
box2 = dw_box_new( !REXXDW.!DW_VERT )
Call dw_box_pack_start topbox, box2, 250, 200, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 5

/* create our BLUE VERT box on the left and pack it into the RED box */
leftbox = dw_box_new( !REXXDW.!DW_VERT )
Call dw_box_pack_start box1, leftbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 10
Call dw_window_set_color leftbox, !REXXDW.!DW_CLR_BLACK, !REXXDW.!DW_CLR_BLUE
/* add 4 entryfields */
Do i = 1 To 4
   entry = dw_entryfield_new( '', 0 )
   Call dw_box_pack_start leftbox, entry, 200, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 5
End

/* create our BLUE VERT box on the right and pack it into the RED box */
rightbox = dw_box_new( !REXXDW.!DW_VERT )
Call dw_box_pack_start box1, rightbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 10
Call dw_window_set_color rightbox, !REXXDW.!DW_CLR_BLACK, !REXXDW.!DW_CLR_BLUE
/* add 2 entryfields */
Do i = 1 To 2
   entry = dw_entryfield_new( '', 0 )
   Call dw_box_pack_start rightbox, entry, 200, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 5
End
/* now another RED HORZ box for a couple of buttons */
smallbox = dw_box_new( !REXXDW.!DW_HORZ )
Call dw_box_pack_start rightbox, smallbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 5
Call dw_window_set_color smallbox, !REXXDW.!DW_CLR_BLACK, !REXXDW.!DW_CLR_RED
abutton = dw_button_new( 'OK', 0 )
Call dw_box_pack_start smallbox, abutton, !global.!widgetheight, 20, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 5
abutton = dw_button_new( 'OK', 0 )
Call dw_box_pack_start smallbox, abutton, !global.!widgetheight, 20, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 5

/* now the legend boxes */
vertbox = dw_box_new( !REXXDW.!DW_HORZ )
Call dw_box_pack_start box2, vertbox, 200, 0, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 5
vertbox1 = dw_box_new( !REXXDW.!DW_VERT )
Call dw_box_pack_start vertbox, vertbox1, 50, 0, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 10
Call dw_window_set_color vertbox1, !REXXDW.!DW_CLR_BLACK, !REXXDW.!DW_CLR_BLUE
stext = dw_text_new( "Vert Box", 0 )
Call dw_window_set_style stext, !REXXDW.!DW_DT_VCENTER, !REXXDW.!DW_DT_VCENTER
Call dw_box_pack_start vertbox1, stext, 50, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 2

vertbox = dw_box_new( !REXXDW.!DW_HORZ )
Call dw_box_pack_start box2, vertbox, 200, 0, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 5
vertbox2 = dw_box_new( !REXXDW.!DW_VERT )
Call dw_box_pack_start vertbox, vertbox2, 50, 0, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 10
Call dw_window_set_color vertbox2, !REXXDW.!DW_CLR_BLACK, !REXXDW.!DW_CLR_RED
stext = dw_text_new( "Horz Box", 0 )
Call dw_window_set_style stext, !REXXDW.!DW_DT_VCENTER, !REXXDW.!DW_DT_VCENTER
Call dw_box_pack_start vertbox2, stext, 50, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 2

vertbox = dw_box_new( !REXXDW.!DW_HORZ )
Call dw_box_pack_start box2, vertbox, 200, 0, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 5
vertbox3 = dw_box_new( !REXXDW.!DW_VERT )
Call dw_box_pack_start vertbox, vertbox3, 50, 0, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 10
Call dw_window_set_color vertbox3, !REXXDW.!DW_CLR_BLACK, !REXXDW.!DW_CLR_WHITE
stext = dw_text_new( "Widget", 0 )
Call dw_window_set_style stext, !REXXDW.!DW_DT_VCENTER, !REXXDW.!DW_DT_VCENTER
Call dw_box_pack_start vertbox3, stext, 50, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 2
Return

/*
 * HTML embedded widget
 */
HTML: Procedure Expose (!globalv)
Parse Arg idx
mainbox = dw_box_new( !REXXDW.!DW_HORZ )
Call dw_box_pack_start !global.!notebookbox.idx, mainbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 5

/* first col - pointer position stuff */
firstbox = dw_box_new( !REXXDW.!DW_VERT )
Call dw_box_pack_start mainbox, firstbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0

entrybox = dw_box_new( !REXXDW.!DW_HORZ )
Call dw_box_pack_start firstbox, entrybox, 0, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
tmp = dw_text_new( 'URL:', 0 )
Call dw_box_pack_start entrybox, tmp, 100, !global.!widgetheight, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
entry = dw_entryfield_new( '', 0 )
Call dw_box_pack_start entrybox, entry, 0, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
ebutton = dw_button_new( "Go", 0 )
Call dw_box_pack_start entrybox, ebutton, 30, !global.!widgetheight, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0

buttonbox = dw_box_new( !REXXDW.!DW_HORZ )
Call dw_box_pack_start firstbox, buttonbox, 0, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0

sbutton = dw_button_new( "Stop", 0 )
Call dw_box_pack_start buttonbox, sbutton, 30, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0

bbutton = dw_button_new( "Back", 0 )
Call dw_box_pack_start buttonbox, bbutton, 30, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0

fbutton = dw_button_new( "Forward", 0 )
Call dw_box_pack_start buttonbox, fbutton, 30, !global.!widgetheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0

htmlbox = dw_box_new( !REXXDW.!DW_VERT )
Call dw_box_pack_start firstbox, htmlbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0
html = dw_html_new( 11011 )
Call dw_box_pack_start htmlbox, html, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0
Call dw_html_url html, 'http://www.rexx.org'

Call dw_signal_connect sbutton, !REXXDW.!DW_CLICKED_EVENT, 'HTMLButtonCallback', !REXXDW.!DW_HTML_STOP, html
Call dw_signal_connect bbutton, !REXXDW.!DW_CLICKED_EVENT, 'HTMLButtonCallback', !REXXDW.!DW_HTML_GOBACK, html
Call dw_signal_connect fbutton, !REXXDW.!DW_CLICKED_EVENT, 'HTMLButtonCallback', !REXXDW.!DW_HTML_GOFORWARD, html
Call dw_signal_connect ebutton, !REXXDW.!DW_CLICKED_EVENT, 'HTMLButtonCallback', 'load', html, entry

raw = dw_html_new( 102 )
Call dw_box_pack_start firstbox, raw, 0, 80, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
Call dw_html_raw raw, '<html><body><center><h1>Rexx/DW</h1></center></body></html>'


Return

HTMLButtonCallback:
trace i
Parse Arg ., action, html, entry
If !global.!allowcallbacks = 0 Then Return 1
If Datatype( action ) = 'NUM' Then Call dw_html_action html, action
Else
   Do
      If action = 'load' Then
         Do
            text = dw_window_get_text( entry )
            Call dw_html_url html, text
         End
   End
Call dw_main_sleep 10
Return 0

timer_callback:
If !global.!allowcallbacks = 0 Then Return 1
Call dw_beep 200, 200
If \!REXXDW.!HAVE_REXXCALLBACK Then timerid = dw_timer_connect( 1000, 'timer_callback' )
/* return 1 here to ensure that timer is re-armed */
Return 1

beep_callback:
If !global.!allowcallbacks = 0 Then Return 1
Call dw_timer_disconnect timerid
Return 1

text_expose_callback:
If !global.!allowcallbacks = 0 Then Return 1
Parse Arg win, x, y, width, height, data
If win = textbox1 Then hpm = text1pm
Else hpm = text2pm
width = dw_pixmap_width(hpm)
height = dw_pixmap_height(hpm)

Call dw_pixmap_bitblt win, , 0, 0, width, height, , hpm, 0, 0
Call dw_flush
return 1

scrollbar_valuechanged_callback:
If !global.!allowcallbacks = 0 Then Return 1
Parse Arg hwnd, value, stext
If stext \= '' Then
   Do
      If hwnd = vscrollbar Then current_row = value
      Else current_col = value
      Call dw_window_set_text stext, 'Row:'current_row 'Col:'current_col 'Lines:'num_lines 'Cols:'max_linewidth
      Call draw_file  current_row, current_col
   End
Return 1

keypress_callback:
If !global.!allowcallbacks = 0 Then Return 1
Parse Arg win, char, virtualkey, state, data
return 1

/*
 * Tests if the given filename is binary; ie there is at least one
 * nul character in the first 1024 characters.
 */
IsBinaryFile: Procedure
Parse Arg fn
size = Stream( fn, 'C', 'QUERY SIZE' )
numchars = Min( size, 1024 )
Call Stream fn, 'C', 'OPEN READ'
file_block = Charin( fn, 1, numchars )
test_block = Translate( file_block, '#', '00'x )
If file_block \== test_block Then
   binary = 1
Else
   binary = 0
Call Stream fn, 'C', 'CLOSE'
Return binary

Getfolder_ico: Procedure
start = .LINE + 2
/*
000001000200101010000000000028010000260000001010000000000000680500004E010000280000001000000020000000
0100040000000000C00000000000000000000000000000000000000000000000000080000080000000808000800000008000
800080800000C0C0C000808080000000FF0000FF000000FFFF00FF000000FF00FF00FFFF0000FFFFFF000000000000000000
0000000000000000003333333333333003333333333333333B3777777777B7333B3777777777B7333B3777777777B7333B37
77777777B733373777777777B733373FFFFFFFFF7F3337733333333333303777777FFFFF30003F7777F33333300003FFFF30
0000000000333300000000000000000000000000FFFF0000FFFF0000C0010000800000000000000000000000000000000000
0000000000000000000000010000000700000007000081FF0000C3FF0000FFFF000028000000100000002000000001000800
0000000040010000000000000000000000000000000000000000000000008000008000000080800080000000800080008080
0000C0C0C000C0DCC000F0CAA60004040400080808000C0C0C0011111100161616001C1C1C00222222002929290055555500
4D4D4D004242420039393900807CFF005050FF009300D600FFECCC00C6D6EF00D6E7E70090A9AD0000003300000066000000
99000000CC00003300000033330000336600003399000033CC000033FF00006600000066330000666600006699000066CC00
0066FF00009900000099330000996600009999000099CC000099FF0000CC000000CC330000CC660000CC990000CCCC0000CC
FF0000FF660000FF990000FFCC00330000003300330033006600330099003300CC003300FF00333300003333330033336600
333399003333CC003333FF00336600003366330033666600336699003366CC003366FF003399000033993300339966003399
99003399CC003399FF0033CC000033CC330033CC660033CC990033CCCC0033CCFF0033FF330033FF660033FF990033FFCC00
33FFFF00660000006600330066006600660099006600CC006600FF00663300006633330066336600663399006633CC006633
FF00666600006666330066666600666699006666CC00669900006699330066996600669999006699CC006699FF0066CC0000
66CC330066CC990066CCCC0066CCFF0066FF000066FF330066FF990066FFCC00CC00FF00FF00CC0099990000993399009900
99009900CC009900000099333300990066009933CC009900FF00996600009966330099336600996699009966CC009933FF00
9999330099996600999999009999CC009999FF0099CC000099CC330066CC660099CC990099CCCC0099CCFF0099FF000099FF
330099CC660099FF990099FFCC0099FFFF00CC00000099003300CC006600CC009900CC00CC0099330000CC333300CC336600
CC339900CC33CC00CC33FF00CC660000CC66330099666600CC669900CC66CC009966FF00CC990000CC993300CC996600CC99
9900CC99CC00CC99FF00CCCC0000CCCC3300CCCC6600CCCC9900CCCCCC00CCCCFF00CCFF0000CCFF330099FF6600CCFF9900
CCFFCC00CCFFFF00CC003300FF006600FF009900CC330000FF333300FF336600FF339900FF33CC00FF33FF00FF660000FF66
3300CC666600FF669900FF66CC00CC66FF00FF990000FF993300FF996600FF999900FF99CC00FF99FF00FFCC0000FFCC3300
FFCC6600FFCC9900FFCCCC00FFCCFF00FFFF3300CCFF6600FFFF9900FFFFCC006666FF0066FF660066FFFF00FF666600FF66
FF00FFFF66002100A5005F5F5F00777777008686860096969600CBCBCB00B2B2B200D7D7D700DDDDDD00E3E3E300EAEAEA00
F1F1F100F8F8F800F0FBFF00A4A0A000808080000000FF0000FF000000FFFF00FF000000FF00FF00FFFF0000FFFFFF000A0A
0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A4B4B4B4B4B4B4B4B4B4B4B4B4B0A0A525252
52525252525252525252524B527A52A07A7A7A7A7A7A7A7A58A0524B527A52A07A7A7A7A7A7A7A7A58A0524B527A52A09A9A
9A9A9A9A9AA058A0524B527A52A0A0A0A0A0A0A0A0A079A0524B527A52A0A0A0A0A0A0A0A0A07AA0524B527A52FFF6F6F6F6
F6FFFFFF9AF6524B52A09A5252525252525252525252520A52A0A0A0A0A0A0FFFFFFFFFF2A0A0A0A52FFA0A0A0A0FF525252
52522A0A0A0A0A52FFFFFFF6520A0A0A0A0A0A0A0A0A0A0A525252520A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A
0A0A0A0AFFFF0000FFFF0000C001000080000000000000000000000000000000000000000000000000000000000100000007
00000007000081FF0000C3FF0000FFFF0000
*/
end = .LINE - 2
image = ""
Do i = start To end
   image = image||Sourceline(i)
End
Return image

my_thread: Procedure Expose (!globalv)
say gettid() dw_thread_id()
Say Time() 'in my_thread...sleeping for 3 seconds'
Call Sleep 3
Call dw_messagebox 'Thread', !REXXDW.!DW_MB_OK, 'In another thread...at' Time()
call dw_thread_end
Return 0

Threadtest:
say Time() 'in threadtest'
say gettid() dw_thread_id()
rc = dw_thread_new( 'my_thread', 'data' )
say Time() 'return from dw_thread_id' rc
Return 0
