//
//                     TxWin, Textmode Windowing Library
//
//   Original code Copyright (c) 1995-2021 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   TxLib, released under MIT License
//
//   Copyright (c) 1995-2021  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on TxWin licensing can be directed to: info@dfsee.com
//
// ==========================================================================
//
// TxLib filesystem functions, filename manipulations, file extension
//
// JvW  28-02-2021 LICENSING: Changed from LGPL to the more liberal MIT license

#include <txlib.h>                              // TxLib interface


/*****************************************************************************/
// Append file-extension to path+filename, if no (max 3 chars) one present yet
// Allows DOT in path component, and in filename if fragment > 3 characters
// Can NOT have any internal tracing! Used in TxPrint to scrollbuffer stream!
/*****************************************************************************/
char *TxFnameExtension                          // RET   ptr to filename
(
   char               *fname,                   // INOUT filename string
   char               *ext                      // IN    default extension
)
{
   char               *dot = strrchr( fname, '.');         //- including DOT!
   char               *sep = strrchr( fname, FS_PATH_SEP);

   if ((dot == NULL) || (dot < sep) || (strlen( dot) > 4)) // no extension present
   {
      strcat( fname, ".");
      strcat( fname, ext);
   }
   return( fname);
}                                               // end 'TxFnameExtension'
/*---------------------------------------------------------------------------*/

/*****************************************************************************/
// Remove filename extension (max 3 chars) from path+filename, if present
// Allows DOT in path component, and in filename if fragment > 3 characters
// Can NOT have any internal tracing! Used in TxPrint to scrollbuffer stream!
/*****************************************************************************/
char *TxStripExtension                          // RET   ptr to filename
(
   char               *fname                    // INOUT filename string
)
{
   char               *dot = strrchr( fname, '.');         //- including DOT!
   char               *sep = strrchr( fname, FS_PATH_SEP);

   if ((dot > sep) && (strlen( dot) <= 4))
   {
      *dot = 0;                                 // terminate string at dot
   }
   return( fname);
}                                               // end 'TxStripExtension'
/*---------------------------------------------------------------------------*/

