/* lange.h */
#ifndef  LANGE_H_INCLUDED

#define  LANGE_H_INCLUDED

#include <os2.h>

#ifdef __cplusplus
extern "C" {
#endif

#define LNGHANDLE LHANDLE
typedef LNGHANDLE * PLNGHANDLE;
#define LANGE LHANDLE
typedef LANGE * PLANGE;

#define ERR_LNG_NO_ERROR 0
#define ERR_LNG_NO_KEY 1
#define ERR_LNG_NO_TARGET_BUFFER 2
#define ERR_LNG_NO_SEARCH_KEY 3

/* LngOpenDialect - ᮧ , 室  祭 ᮮ饭
 * 㪠   䠩,  頥  .
 * 頥 १ DosAllocMem, DosFreeMem, DosScanEnv, DosSearchPath,
 * DosOpen, DosRead, DosSetFilePtr, DosQueryCp, UniMapCpToUcsCp, UniCreateUconvObject,
 *  ⠪:
 * ERROR_BAD_FORMAT - ᫨ 䠩 ࠢ,
 * ERROR_INVALID_NAME - ᫨   ࠢ쭮,
 * ERROR_NO_ITEMS - ᫨   
 */
APIRET APIENTRY LngOpenDialect(PCHAR MsgFile, PLNGHANDLE Handle);

/* LngLoadDialect -   ,   LngOpenDialect,  㦠  
 *  ᮮ饭 㪠   ᨬ쭮 ண 㯠  .
 * ࠬ  १   LngOpenDialect.
 */
APIRET APIENTRY LngLoadDialect(PCHAR nlsfile, PLNGHANDLE phandle);

/* LngCloseDialect - 㭨⮦ ਯ  (  ᮮ饭ﬨ,
 * ᫨  뫨 㦥).
 * 祭 ६ Handle  .
 * 頥 १ DosFreeMem, DosClose, UniFreeUconvObject
 * ஬ ⮣: ERROR_INVALID_HANDLE
 */
APIRET APIENTRY LngCloseDialect(LNGHANDLE Handle);

/* LngGetString - 砥 ᮮ饭  ⠭ ࠬ஠.
 *
 */
APIRET APIENTRY LngGetString(LNGHANDLE handle, PCHAR searchkey, PCHAR target, ULONG target_maxlength);

/****************************************************************************/
/*                                                                          */
/* All following functions are obsoled and not documented. Use at your risk */
/*                                                                          */
/****************************************************************************/

// Obsoled. Don't use.
APIRET APIENTRY LngLoadLanguage(PCHAR nlsfile, PCHAR dialect, PLNGHANDLE phandle);
APIRET APIENTRY LngUnLoadLanguage(LNGHANDLE handle);

// Backward compatability with old version
#define LangeLoadLanguage LngLoadLanguage
#define LangeGetString LngGetString
#define LangeUnLoadLanguage LngUnLoadLanguage


#ifdef __cplusplus
        }
#endif


#endif
/* LANGE_H_INCLUDED */
