/****************************************************************************/
/* RWS - beta version 0.80                                                  */
/****************************************************************************/

// RWSCLS.C
// Remote Workplace Server - Server WPS class "RWSxx" implementation

/****************************************************************************/

/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Remote Workplace Server - Server component.
 *
 * The Initial Developer of the Original Code is Richard L. Walsh.
 * 
 * Portions created by the Initial Developer are Copyright (C) 2004-2007
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * ***** END LICENSE BLOCK ***** */

/****************************************************************************/
/*

"RWSxx" is a subclass of WPTransient whose only purpose is to anchor
the RWS server thread in the WPS process.  It is not loaded automatically
by the WPS;  rather, the client (RWSCLIxx.DLL) forces this to happen by
creating an instance of the class.  Once loaded, RWS starts the server
thread.  When the last instance of the class is destroyed, the server
thread terminates and SOM unloads this dll.

*/
/****************************************************************************/

/*
 *  This file was generated by the SOM Compiler and Emitter Framework.
 *  Generated using: 
 *      SOM Emitter emitctm: 2.41
 *
 *  Note:  this was created with the version of the SOM compiler that
 *  came with Warp v3 Toolkit.  Later versions are incompatible with
 *  Warp v3 prior to FP16 - they send pre-FP16 versions of the WPS
 *  into a continuous crash/restart cycle.
 */

#ifndef SOM_Module_rwscls_Source
#define SOM_Module_rwscls_Source
#endif
#define RWS08_Class_Source
#define M_RWS08_Class_Source

#include "RWSCLS.IH"
#include <wpclsmgr.h>

/****************************************************************************/

// rwscls.h contains this macro:
//    #define somresolve_(obj,mToken) ((somMethodProc*)((void)obj, mToken))
// redefining it to eliminate the reference to "obj" keeps VAC++3.65
// from generating an informational message for every method call

#undef somresolve_
#define somresolve_(obj,mToken) ((somMethodProc*)(mToken))

// these nonexistent functions are referenced by "#pragma linkage"
// statements in somltypes.h;  declaring them here keeps VAC happy
void somGenericApply(void);
void somResolveDLocator(void);
void somResolveMLocator(void);

// suppress an "unreferenced static variable" warning
void *          ClsDummy( void) { return (void*)__somtmp_SOMObject; }

/****************************************************************************/

// from RWSINIT.C  (avoid dragging RWSSRV.H's baggage into this module)
void    _System ServerThreadProc( ULONG ul);

// in this module
void            ReloadModule( void);

extern BOOL     fFalse;
extern HMODULE  hmodRWS;            // this dll's module handle
extern HMQ      hmqServer;          // the server thread's HMQ
extern HWND     hThread1;           // the server's object window on thread1
extern char     szRwsCls[];         // the WPS class' name
extern char     szRwsSrv[];         // the module's name
extern char     szRwsFQPath[260];   // the f/q name of this dll

// copied from RWS.H
#define ERRNBR(x)   {rc = (x); break;}

// also defined in rwssrv.rc (but not in rwssrv.h)
#define IDI_RWSSRV          101

/****************************************************************************/

SOM_Scope void SOMLINK somDefaultInit( RWS08* somSelf, somInitCtrl* ctrl)

{
    somInitCtrl globalCtrl;
    somBooleanVector myMask;

    RWS08_BeginInitializer_somDefaultInit;
    RWS08_Init_WPTransient_somDefaultInit(somSelf, ctrl);
}

/****************************************************************************/

SOM_Scope void SOMLINK somDestruct( RWS08* somSelf, octet doFree, 
                                    somDestructCtrl* ctrl)

{
    somDestructCtrl globalCtrl;
    somBooleanVector myMask;

    RWS08_BeginDestructor;
    RWS08_EndDestructor;
}

/****************************************************************************/

// ensure the class is registered with a f/q filename,
// then start the thread that does all of the work

SOM_Scope void  SOMLINK wpclsInitData( M_RWS08* somSelf)

{
    TID         tid = 0;

    M_RWS08_parent_M_WPTransient_wpclsInitData(somSelf);

    ReloadModule();

    if (DosCreateThread( &tid, &ServerThreadProc, 0, CREATE_READY, 0xf000))
    {
        somPrintf( "%s - unable to start server thread\n", szRwsSrv);
        DosBeep( 660, 120);
    }

    return;
}

/****************************************************************************/

// close our window on thread 1 and terminate the server thread;
// wait up to a second for this to happen, then exit

SOM_Scope void  SOMLINK wpclsUnInitData( M_RWS08* somSelf)

{
    ULONG   ctr;

    if (hThread1)
        WinPostMsg( hThread1, WM_CLOSE, (MPARAM)hThread1, 0);

    if (hmqServer)
        WinPostQueueMsg( hmqServer, WM_QUIT, 0, 0);

    for (ctr = 30; ctr; ctr--)
    {
        if (hmqServer == 0 && hThread1 == 0)
            break;
        DosSleep( 30);
    }

    if (hmqServer || hThread1)
        somPrintf( "%s - clean shutdown failed - hmq= %x  hT1= %x\n",
                   szRwsSrv, hmqServer, hThread1);

    M_RWS08_parent_M_WPTransient_wpclsUnInitData(somSelf);

    return;
}

/****************************************************************************/

SOM_Scope ULONG  SOMLINK wpclsQueryIconData( M_RWS08 *somSelf, 
                                             PICONINFO pIconInfo)

{
    if (pIconInfo)
    {
        pIconInfo->fFormat = ICON_RESOURCE;
        pIconInfo->hmod = hmodRWS;
        pIconInfo->resid = IDI_RWSSRV;
    }

    return (sizeof(ICONINFO));
}

/****************************************************************************/

SOM_Scope PSZ   SOMLINK wpclsQueryTitle( M_RWS08* somSelf)

{
    return ("RWS08");
}

/****************************************************************************/

// This fixes two problems:
// 1)  If an app registers the class using the dll's module name, the
// WPS might not be able to locate it when another app tries to load it.
// If needed, this will reregister the class using its f/q name.
// 2)  Under Warp 4.5, a dll loaded by its f/q name cannot be reloaded
// using only its module name unless the dll happens to be on the LIBPATH.
// This function works around the problem by temporarily changing
// BEGINLIBPATH, then reloading the dll by module name.  Thereafter, the
// dll can be reloaded by module name, regardless of LIBPATH settings.
// This is critical when setting a hook.

void        ReloadModule( void)
{
    ULONG       rc = 0;
    ULONG       ul;
    ULONG       ul2;
    char *      ptr;
    char *      pDst;
    char *      pMem = 0;
    char    	szBuf[16];

do
{
    // in Warp 4.5, this is the only reliable way to get the hmod
    if (DosQueryModFromEIP( &hmodRWS, &ul, sizeof(szBuf), szBuf,
                            &ul2, (ULONG)ReloadModule))
        ERRNBR( 1)

    // get the module's f/q name
    if (DosQueryModuleName( hmodRWS, sizeof(szRwsFQPath), szRwsFQPath))
        ERRNBR( 2)

    // this returns whatever was used for registration: mod name or f/q name
    ptr = _wpModuleForClass( SOMClassMgrObject, szRwsCls);
    if (ptr == 0)
        ERRNBR( 3)

    // if this appears to be a mod name, reregister with the f/q name
    if (strchr( ptr, '\\') == 0)
        if (WinRegisterObjectClass( szRwsCls, szRwsFQPath) == FALSE)
            ERRNBR( 4)

    // get the current Warp version;  if less than 4.5, exit
    DosQuerySysInfo( QSV_VERSION_MINOR, QSV_VERSION_MINOR,
                     &ul, sizeof(ul));
    if (ul < 45)
        break;

    // alloc plenty of space
    pMem = SOMMalloc( 2048);
    if (pMem == 0)
        ERRNBR( 5)

    // put the current BEGINLIBPATH in the 1st half of the buffer
    if (DosQueryExtLIBPATH( pMem, BEGIN_LIBPATH))
        ERRNBR( 6)

    // copy the directory containing RwsSrv to the 2nd half of the buffer
    pDst = &pMem[1024];
    strcpy( pDst, szRwsFQPath);
    ptr = strrchr( pDst, '\\');
    if (ptr == 0)
        ERRNBR( 7)

    // append the existing BEGINLIBPATH
    *ptr++ = ';';
    strcpy( ptr, pMem);

    // temporarily change BEGINLIBPATH
    if (DosSetExtLIBPATH( pDst, BEGIN_LIBPATH))
        ERRNBR( 8)

    // reload  this dll using its module name only, then unload it
    if (DosLoadModule( szBuf, sizeof(szBuf), szRwsSrv, &ul) == 0)
        DosFreeModule( ul);
    else
        somPrintf( "%s: ReloadModule - DosLoadModule failed\n", szRwsSrv);

    // restore the original BEGINLIBPATH
    if (DosSetExtLIBPATH( pMem, BEGIN_LIBPATH))
        ERRNBR( 9)

} while (fFalse);

    // if we allocated memory, free it
    if (pMem)
        SOMFree( pMem);

    // report errors
    if (rc)
        somPrintf( "%s: ReloadModule failed - rc= %d\n", szRwsSrv, rc);

    return;
}

/****************************************************************************/

