#if !defined(WPSPTRS) && !defined(WPSREFS)
   #define WPSPTRS
#endif

#ifndef WPProgram_Source
#define WPProgram_Source

#include <wpabs.hh>
#pragma off(dts_class);
#pragma on(somobject_assignment_operators);
#pragma on(somobject_constructors);
#pragma on(somobject_destructor);
#pragma off(case_insensitive_class_names);

#pragma on(som_bindings);
class WPProgram : public WPAbstract {

     #pragma SOMMap (WPProgram, "WPProgram", "M_WPProgram")

     #pragma SOMClassVersion (WPProgram, 1, 2)

     #pragma SOMCallstyle (WPProgram, oidl)

     #pragma off(som_bindings);
     #pragma pop(som_bindings);
  public :

#pragma off(use_override_signature)
     virtual ULONG wpAddProgramAssociationPage(HWND hwndNotebook);
     virtual BOOL wpQueryProgDetails(PPROGDETAILS pProgDetails,
                                     PULONG pulSize);
     virtual BOOL wpSetProgDetails(PPROGDETAILS pProgDetails);
     virtual ULONG wpAddProgramPage(HWND hwndNotebook);
     virtual ULONG wpAddProgramSessionPage(HWND hwndNotebook);
     virtual PSZ wpQueryAssociationFilter();
     virtual PSZ wpQueryAssociationType();
     virtual BOOL wpSetAssociationFilter(PSZ pszFilter);
     virtual BOOL wpSetAssociationType(PSZ pszType);
     virtual BOOL wpQueryDefaultHelp(PULONG pHelpPanelId, PSZ HelpLibrary);
     virtual void wpInitData();
     virtual BOOL wpSetup(PSZ pszSetupString);
     virtual void wpUnInitData();
     virtual BOOL wpSaveState();
     virtual BOOL wpRestoreState(ULONG ulReserved);
     virtual BOOL wpAddSettingsPages(HWND hwndNotebook);
     virtual HWND wpOpen(HWND hwndCnr, ULONG ulView, ULONG param);
     virtual BOOL wpModifyPopupMenu(HWND hwndMenu, HWND hwndCnr,
                                    ULONG iPosition);
     virtual BOOL wpMenuItemSelected(HWND hwndFrame, ULONG ulMenuId);
     virtual BOOL wpMenuItemHelpSelected(ULONG MenuId);
#if defined(WPSREFS)
     virtual WPObject* wpCreateFromTemplate(WPFolder& folder,
#else
     virtual WPObject* wpCreateFromTemplate(WPFolder* folder,
#endif
                                            BOOL fLock);
     virtual WPObject* wpCreateAnother(PSZ pszTitle, PSZ pszSetupEnv,
#if defined(WPSREFS)
                                       WPFolder& Folder);
#else
                                       WPFolder* Folder);
#endif
     virtual ULONG wpQueryIconData(PICONINFO pIconInfo);
     virtual BOOL wpSetIconData(PICONINFO pIconInfo);
     virtual HPOINTER wpQueryIcon();
#if defined(WPSREFS)
     virtual BOOL wpMoveObject(WPFolder& Folder);
#else
     virtual BOOL wpMoveObject(WPFolder* Folder);
#endif
#if defined(WPSREFS)
     virtual WPObject* wpCopyObject(WPFolder& Folder, BOOL fLock);
#else
     virtual WPObject* wpCopyObject(WPFolder* Folder, BOOL fLock);
#endif
     virtual MRESULT wpDragOver(HWND hwndCnr, PDRAGINFO pdrgInfo);
     virtual MRESULT wpDrop(HWND hwndCnr, PDRAGINFO pdrgInfo,
                            PDRAGITEM pdrgItem);
     virtual BOOL wpSetTitle(PSZ pszNewTitle);
#pragma pop(use_override_signature)

     #pragma SOMReleaseOrder ( \
                              wpAddProgramPage, \
                              wpAddProgramSessionPage, \
                              wpQueryProgDetails, \
                              wpSetProgDetails, \
                              *, \
                              *, \
                              wpAddProgramAssociationPage, \
                              *, \
                              wpQueryAssociationFilter, \
                              wpQueryAssociationType, \
                              wpSetAssociationFilter, \
                              wpSetAssociationType)
};
#pragma pop(som_bindings);

#pragma pop(dts_class);
#pragma pop(somobject_assignment_operators);
#pragma pop(somobject_constructors);
#pragma pop(somobject_destructor);
#pragma pop(case_insensitive_class_names);
#endif /* WPProgram_Source */

#ifndef M_WPProgram_Source
#define M_WPProgram_Source

#include <wpabs.hh>
#include <somcls.hh>
#pragma off(dts_class);
#pragma on(somobject_assignment_operators);
#pragma on(somobject_constructors);
#pragma on(somobject_destructor);
#pragma off(case_insensitive_class_names);

#pragma on(som_bindings);
class M_WPProgram : public M_WPAbstract {

     #pragma SOMClassVersion (M_WPProgram, 1, 2)

     #pragma SOMCallstyle (M_WPProgram, oidl)

     #pragma off(som_bindings);
     #pragma pop(som_bindings);
  public :

#pragma off(use_override_signature)
     virtual PSZ wpclsQueryTitle();
     virtual ULONG wpclsQueryIconData(PICONINFO pIconInfo);
     virtual ULONG wpclsQueryStyle();
     virtual BOOL wpclsQueryDefaultHelp(PULONG pHelpPanelId,
                                        PSZ pszHelpLibrary);
     virtual ULONG wpclsQueryDefaultView();
#pragma pop(use_override_signature)

     #pragma SOMReleaseOrder ()

};
#pragma pop(som_bindings);

#pragma pop(dts_class);
#pragma pop(somobject_assignment_operators);
#pragma pop(somobject_constructors);
#pragma pop(somobject_destructor);
#pragma pop(case_insensitive_class_names);
#endif /* M_WPProgram_Source */

