#! /bin/sh -e

#
# usage: util/checkasm.sh [directory]
#
# This script runs lzo_test with all assembler decompressors
# on a complete directory tree.
# It is not suitable for accurate timings.
#
# Copyright (C) 1996, 1997 Markus Franz Xaver Johannes Oberhumer
#

dir=${1-"."}

LZO_FLAGS="-q"

TMPFILE="./lzo_chk2.tmp"
rm -f $TMPFILE
find $dir -type f -print > $TMPFILE

for i in 11; do
	cat $TMPFILE | ./lzo_test -m${i} -@ $LZO_FLAGS -A
	cat $TMPFILE | ./lzo_test -m${i} -@ $LZO_FLAGS -A -S
done

for i in 61; do
	cat $TMPFILE | ./lzo_test -m${i} -@ $LZO_FLAGS -F
	cat $TMPFILE | ./lzo_test -m${i} -@ $LZO_FLAGS -F -S
done

for i in 71 81; do
	cat $TMPFILE | ./lzo_test -m${i} -@ $LZO_FLAGS -A
	cat $TMPFILE | ./lzo_test -m${i} -@ $LZO_FLAGS -A -S
	cat $TMPFILE | ./lzo_test -m${i} -@ $LZO_FLAGS -F
	cat $TMPFILE | ./lzo_test -m${i} -@ $LZO_FLAGS -F -S
done

rm -f $TMPFILE
echo Done.
exit 0

