/*
 * (Free|Open|Net)BSD USB support
 *
 * Derived from Linux version by Richard Tobin.
 *
 * $Id: bsd.c,v 1.30 2004/02/18 06:34:52 jerdfelt Exp $
 * $Name: V0_1_10 $
 *
 * This library is covered by the LGPL, read LICENSE for details.
 */

/*
 * Note: I don't have a clue what I'm doing.  I just looked at the
 * man pages and source to try and find things that did the same as
 * the Linux version. -- Richard
 *
 * johnjen@reynoldsnet.org - minor fixes with debug mode output. Consistent brace
 * use as well as indenting. More error messages put in to test for failure
 * modes with /dev/ permissions (when it happens). Note: I, like Richard, have
 * no clue what I'm doing. Patches to increase/fix functionality happily
 * accepted!
 */

/* dirkx@webweaving.org - minor changes to make things actually work
 * 	for both read and write.
 */

#define INCL_DOS
#include <os2.h>
#include <usbcalls.h>

#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <assert.h>
#include <sys/time.h>
#include <sys/ioctl.h>


#include "usbi.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#define MAX_RW 64000


int usb_os_open(usb_dev_handle *dev)
{
	APIRET	rc;
	USBHANDLE	usbHandle;
	
	usbHandle = 0;
	rc = UsbOpen( (PUSBHANDLE) &usbHandle, (SHORT) dev->device->descriptor.idVendor, 
				(SHORT) dev->device->descriptor.idProduct,
				(SHORT) USB_ANY_PRODUCTVERSION, //dev->device->descriptor.bcdDevice,
				(SHORT) USB_OPEN_FIRST_UNUSED);
    if (rc) {
		errno = rc;
		USB_ERROR_STR(-errno, "failed to open %x,%x,%x, rc=%x(%d)", dev->device->descriptor.idVendor, 
				dev->device->descriptor.idProduct, dev->device->descriptor.bcdDevice, rc, rc);
    }

	dev->fd = usbHandle;
	if (usb_debug >= 3)
		fprintf(stderr, "usb_os_open (fd %x)\n", dev->fd);

	return 0;
}

int usb_os_close(usb_dev_handle *dev)
{
	APIRET	rc;

	if (usb_debug >= 3)
		fprintf(stderr, "usb_os_close (fd %x)\n", dev->fd);
	rc = UsbClose( dev->fd);
    if (rc) {
		errno = rc;
		USB_ERROR_STR(-errno, "failed to close %x,%x,%x, rc=%x(%d)", dev->device->descriptor.idVendor, 
				dev->device->descriptor.idProduct, dev->device->descriptor.bcdDevice, rc, rc);
    }
	dev->fd = 0;

	return 0;
}

int usb_set_configuration(usb_dev_handle *dev, int configuration)
{
	APIRET	rc;
	
	if (usb_debug >= 3)
		fprintf(stderr, "usb_set_configuration (fd %x) configuration %d\n", dev->fd, configuration);
	rc = UsbDeviceSetConfiguration( dev->fd, configuration);
    if (rc) {
		errno = rc;
		USB_ERROR_STR(-errno, "could not set config %d: erc=%x", configuration, rc);
    }
	return 0;
}

int usb_claim_interface(usb_dev_handle *dev, int interface)
{
	if (usb_debug >= 3)
		fprintf(stderr, "usb_claim_interface (fd %x) interface %d\n", dev->fd, interface);
  /* BSD doesn't have the corresponding ioctl.  It seems to
     be sufficient to open the relevant endpoints as needed. */

  dev->interface = interface;

  return 0;
}

int usb_release_interface(usb_dev_handle *dev, int interface)
{
	if (usb_debug >= 3)
		fprintf(stderr, "usb_release_interface (fd %x) interface %d\n", dev->fd, interface);
  /* See above */
  return 0;
}

int usb_set_altinterface(usb_dev_handle *dev, int alternate)
{
	fprintf( stderr, "usb_set_altinterface not implemented\n");
	return -1;
#if 0
  int ret;
  struct usb_alt_interface intf;

  if (dev->interface < 0)
    USB_ERROR(-EINVAL);

  intf.uai_interface_index = dev->interface;
  intf.uai_alt_no = alternate;

  ret = ioctl(dev->fd, USB_SET_ALTINTERFACE, &intf);
  if (ret < 0)
    USB_ERROR_STR(-errno, "could not set alt intf %d/%d: %s",
                  dev->interface, alternate, strerror(errno));

  dev->altsetting = alternate;
#endif // 0

  return 0;
}


int usb_bulk_write(usb_dev_handle *dev, int ep, char *bytes, int size,
                   int timeout)
{
	APIRET	rc;
	ssize_t write_size = 0;

	if (usb_debug >= 3)
		fprintf(stderr, "usb_bulk_write (fd %x) ep %d, interface %d, size %d, timeout %d\n", 
			dev->fd, ep, dev->interface, size, timeout);

	while (size)
    {
		ULONG ulToWrite = (size>MAX_RW) ? MAX_RW : size;
		
		if (usb_debug >= 3)
			fprintf(stderr, "size requested to write = %lu, ulToWrite = %lu\n",(unsigned long) size,ulToWrite);

		rc = UsbBulkWrite( dev->fd, ep, dev->interface, ulToWrite, bytes, timeout);
		if (rc) {
			errno = EINVAL;
			USB_ERROR_STR(-errno, "error writing to bulk endpoint rc=%x", rc);
		}
		size -= ulToWrite;
		bytes += ulToWrite;
		write_size += ulToWrite;
		if (usb_debug >= 3)
			fprintf(stderr, "size = %d, write_size = %d\n", size, write_size);
    }

	return write_size;
}

int usb_bulk_read(usb_dev_handle *dev, int ep, char *bytes, int size,
                  int timeout)
{
	ssize_t read_size = 0;
    APIRET	rc;

	if (usb_debug >= 3)
		fprintf(stderr, "usb_bulk_read (fd %x) ep %d, interface %d, size %d, timeout %d\n", 
			dev->fd, ep, dev->interface, size, timeout);
	
    while( size) {
		ULONG ulToRead = (size > MAX_RW) ? MAX_RW : size;
		ULONG ulNum = ulToRead;

		if (usb_debug >= 3)
			fprintf(stderr, "size requested to read = %lu, ulToRead = %lu\n",(unsigned long) size, ulToRead);
		
		rc = UsbBulkRead( dev->fd, ep, dev->interface, &ulToRead, bytes, timeout);
		if (rc>0 && rc!=USB_ERROR_LESSTRANSFERED) {
			errno = EINVAL;
			USB_ERROR_STR(-errno, "error reading from bulk endpoint rc=%x, ulToRead=%d", rc, ulToRead);
		}
		//if (rc || (ulNum!=ulToRead)) return SANE_STATUS_INVAL;
		size -= ulToRead;
		bytes += ulToRead;
		read_size += ulToRead;
		if (rc==USB_ERROR_LESSTRANSFERED) {
			break; // less bytes transferred from bulk read, return now
		}
    }

	if (usb_debug >= 3)
		fprintf(stderr, "usb_bulk_read (fd %x) read_size %d\n", read_size);

	return read_size;
}

int usb_interrupt_write(usb_dev_handle *dev, int ep, char *bytes, int size,
                        int timeout)
{
	fprintf( stderr, "usb_interrupt_write not implemented\n");
	return -1;
#if 0
  int fd, ret, sent = 0;

  /* Ensure the endpoint address is correct */
  ep &= ~USB_ENDPOINT_IN;

  fd = ensure_ep_open(dev, ep, O_WRONLY);
  if (fd < 0) {
    if (usb_debug >= 2) {
#if __FreeBSD__
      fprintf (stderr, "usb_interrupt_write: got negative open file descriptor for endpoint %d\n", UE_GET_ADDR(ep));
#else
      fprintf (stderr, "usb_interrupt_write: got negative open file descriptor for endpoint %02d\n", UE_GET_ADDR(ep));
#endif
    }
    return fd;
  }

  ret = ioctl(fd, USB_SET_TIMEOUT, &timeout);
  if (ret < 0)
    USB_ERROR_STR(-errno, "error setting timeout: %s",
                  strerror(errno));

  do {
    ret = write(fd, bytes+sent, size-sent);
    if (ret < 0)
#if __FreeBSD__
      USB_ERROR_STR(-errno, "error writing to interrupt endpoint %s.%d: %s",
                    dev->device->filename, UE_GET_ADDR(ep), strerror(errno));
#else
      USB_ERROR_STR(-errno, "error writing to interrupt endpoint %s.%02d: %s",
                  dev->device->filename, UE_GET_ADDR(ep), strerror(errno));
#endif

    sent += ret;
  } while (ret > 0 && sent < size);

  return sent;
#endif // 0
}

int usb_interrupt_read(usb_dev_handle *dev, int ep, char *bytes, int size,
                       int timeout)
{
	fprintf( stderr, "usb_interrupt_read not implemented\n");
	return -1;
#if 0
  int fd, ret, retrieved = 0, one = 1;

  /* Ensure the endpoint address is correct */
  ep |= USB_ENDPOINT_IN;

  fd = ensure_ep_open(dev, ep, O_RDONLY);
  if (fd < 0) {
    if (usb_debug >= 2) {
#if __FreeBSD__
      fprintf (stderr, "usb_interrupt_read: got negative open file descriptor for endpoint %d\n", UE_GET_ADDR(ep));
#else
      fprintf (stderr, "usb_interrupt_read: got negative open file descriptor for endpoint %02d\n", UE_GET_ADDR(ep));
#endif
    }
    return fd;
  }

  ret = ioctl(fd, USB_SET_TIMEOUT, &timeout);
  if (ret < 0)
    USB_ERROR_STR(-errno, "error setting timeout: %s", strerror(errno));

  ret = ioctl(fd, USB_SET_SHORT_XFER, &one);
  if (ret < 0)
    USB_ERROR_STR(-errno, "error setting short xfer: %s", strerror(errno));

  do {
    ret = read(fd, bytes+retrieved, size-retrieved);
    if (ret < 0)
#if __FreeBSD__
      USB_ERROR_STR(-errno, "error reading from interrupt endpoint %s.%d: %s",
                    dev->device->filename, UE_GET_ADDR(ep), strerror(errno));
#else
      USB_ERROR_STR(-errno, "error reading from interrupt endpoint %s.%02d: %s",
                  dev->device->filename, UE_GET_ADDR(ep), strerror(errno));
#endif
    retrieved += ret;
  } while (ret > 0 && retrieved < size);

  return retrieved;
#endif // 0
}

int usb_control_msg(usb_dev_handle *dev, int requesttype, int request,
                     int value, int index, char *bytes, int size, int timeout)
{
	APIRET	rc;
	
	if (usb_debug >= 3)
		fprintf(stderr, "usb_control_msg (fd %x): %d %d %d %d %p %d %d\n",
        	    dev->fd, requesttype, request, value, index, bytes, size, timeout);
	rc = UsbCtrlMessage( dev->fd, requesttype, request, value, index, size, bytes, timeout);
	if (rc)
		USB_ERROR_STR(-errno, "error sending control message: rc=%x(%d)", rc,rc);

	return size;
}

int usb_os_find_busses(struct usb_bus **busses)
{
  struct usb_bus *fbus = NULL;
  char buf[20];

    struct usb_bus *bus;

    bus = malloc(sizeof(*bus));
    if (!bus)
      USB_ERROR(-ENOMEM);

    memset((void *)bus, 0, sizeof(*bus));

    strcpy(bus->dirname, "usbcallsbus0");

    LIST_ADD(fbus, bus);

  *busses = fbus;

  return 0;
}

int usb_os_find_devices(struct usb_bus *bus, struct usb_device **devices)
{
	APIRET	rc;
	ULONG 	ulNumDev;
	struct usb_device *fdev = NULL;
	int cfd, dfd;
	int device;
	
	rc = UsbQueryNumberDevices( &ulNumDev);
	if (rc)
		USB_ERROR_STR( -rc, "couldn't query number of devices");
	
    if (usb_debug >= 2)
		fprintf(stderr, "usb_os_find_devices: Found %d devices\n", ulNumDev);

	for (device = 1; device <= ulNumDev; device++) {
    //struct usb_device_info di;
    struct usb_device *dev;
    char buf[4096];
	ULONG	ulBufLen;

    dev = malloc(sizeof(*dev));
    if (!dev)
      USB_ERROR(-ENOMEM);

    memset((void *)dev, 0, sizeof(*dev));

	ulBufLen = sizeof( buf);
  	rc = UsbQueryDeviceReport( device, &ulBufLen, buf); 
	if (rc)
		USB_ERROR_STR( -rc, "couldn't query device#%d report error#%d", device, rc);

    dev->bus = bus;
	memcpy( &dev->descriptor, buf, sizeof( dev->descriptor));
    USB_LE16_TO_CPU(dev->descriptor.bcdUSB);
    USB_LE16_TO_CPU(dev->descriptor.idVendor);
    USB_LE16_TO_CPU(dev->descriptor.idProduct);
    USB_LE16_TO_CPU(dev->descriptor.bcdDevice);

    snprintf(buf, sizeof(buf) - 1, "usbcalls:%d", device);
    strncpy(dev->filename, buf, sizeof(dev->filename) - 1);
    dev->filename[sizeof(dev->filename) - 1] = 0;
	dev->devnum = device;

    LIST_ADD(fdev, dev);

    if (usb_debug >= 2)
      fprintf(stderr, "usb_os_find_devices: Found %s on %s\n",
              dev->filename, bus->dirname);
	}

  *devices = fdev;

  return 0;
}

int usb_os_determine_children(struct usb_bus *bus)
{
  /* Nothing yet */
  return 0;
}

void usb_os_init(void)
{
  /* nothing */
}

int usb_resetep(usb_dev_handle *dev, unsigned int ep)
{
  /* Not yet done, because I haven't needed it. */

  USB_ERROR_STR(-ENOSYS, "usb_resetep called, unimplemented on BSD");
}

int usb_clear_halt(usb_dev_handle *dev, unsigned int ep)
{
  /* Not yet done, because I haven't needed it. */

  USB_ERROR_STR(-ENOSYS, "usb_clear_halt called, unimplemented on BSD");
}

int usb_reset(usb_dev_handle *dev)
{
  /* Not yet done, because I haven't needed it. */

  USB_ERROR_STR(-ENOSYS, "usb_reset called, unimplemented on BSD");
}

