/* -*-C-*-

$Id$

Copyright (c) 1995 Massachusetts Institute of Technology

This material was developed by the Scheme project at the Massachusetts
Institute of Technology, Department of Electrical Engineering and
Computer Science.  Permission to copy this software, to redistribute
it, and to use it for any purpose is granted, subject to the following
restrictions and understandings.

1. Any copy made of this software must include this copyright notice
in full.

2. Users of this software agree to make their best efforts (a) to
return to the MIT Scheme project any improvements or extensions that
they make, so that these may be included in future releases; and (b)
to inform MIT of noteworthy uses of this software.

3. All materials developed as a consequence of the use of this
software shall duly acknowledge such use, in accordance with the usual
standards of acknowledging credit in academic research.

4. MIT has made no warrantee or representation that the operation of
this software will be error-free, and MIT is under no obligation to
provide any services, by way of maintenance, update, or otherwise.

5. In conjunction with products arising from the use of this material,
there shall be no use of the name of the Massachusetts Institute of
Technology nor of any adaptation thereof in any advertising,
promotional, or sales literature without prior written consent from
MIT in each case. */

#ifndef EALIB_H
#define EALIB_H

typedef struct
{
  BYTE flags;
  BYTE name_length;
  USHORT value_length;
  PSZ name;
  PSZ value;
} ea_binding;
#define EA_BINDING_FLAGS(binding) ((binding) -> flags)
#define EA_BINDING_NAME_LENGTH(binding) ((binding) -> name_length)
#define EA_BINDING_VALUE_LENGTH(binding) ((binding) -> value_length)
#define EA_BINDING_NAME(binding) ((binding) -> name)
#define EA_BINDING_VALUE(binding) ((binding) -> value)

typedef struct _ea_list
{
  ea_binding * binding;
  struct _ea_list * next;
} ea_list;
#define EA_LIST_BINDING(list) ((list) -> binding)
#define EA_LIST_NEXT(list) ((list) -> next)

/* Set this to handle errors signalled by the Dos... API.
   It will be called with the return code as the first argument.
   The second argument will be the string name of the procedure
   that signalled the error.  If set to 0 (the default), errors will
   be handled by printing a simple error message to `stderr', and
   terminating the program with `exit'.  */
extern void (* ea_error_hook) (APIRET, const char *);

/* Each of the following procedures comes in two flavors.  One flavor
   operates on previously-opened file handles, and the other operates
   on file pathnames.  */

/* Read all of the extended attributes, and return them as a list.
   Returns 0 if there are no attributes.  The returned list of
   attributes should be freed by calling `free_ea_list'.  */
extern ea_list * read_file_eas (HFILE);
extern ea_list * read_path_eas (PSZ);

/* Return the extended attribute specified by a given index.  The
   index of the first attribute is 1.  Returns 0 if the index is
   larger than the number of attributes attached to the file; in
   particular, returns 0 for index 1 if there are no attributes.  The
   returned binding should be freed by calling `free_ea_binding'.  */
extern ea_binding * read_file_ea_by_index (HFILE, ULONG);
extern ea_binding * read_path_ea_by_index (PSZ, ULONG);

/* Return the extended attribute specified by the given name.  If
   there is no such attribute, returns 0.  The returned binding should
   be freed by calling `free_ea_binding'.  */
extern ea_binding * read_file_ea_by_name (HFILE, PSZ);
extern ea_binding * read_path_ea_by_name (PSZ, PSZ);

/* The following procedures write extended attributes to a given file.
   A given attribute is deleted if its `value_length' is 0; in that
   case the `value' field is also permitted to be 0.  */

/* Write a list of extended attributes to a given file.  These
   attributes add to any attributes already stored on the file.  */
extern void write_file_eas (HFILE, ea_list *);
extern void write_path_eas (PSZ, ea_list *);

/* Write a single extended attribute to a given file.  This attribute
   is added to any attributes already stored on the file.  */
extern void write_file_ea (HFILE, ea_binding *);
extern void write_path_ea (PSZ, ea_binding *);

/* The following procedures deallocate the EA binding memory
   structures that are generated by the `read_...' procedures
   described above.  These procedures assume that `malloc' is used for
   allocation of all storage, and that the `name' and `value' fields
   of each binding are also allocated with `malloc'.  The `value'
   field may also be 0.  */

/* Free the storage associated with a list of EA bindings.  */
extern void free_ea_list (ea_list *);

/* Free the storage associated with a single EA binding.  */
extern void free_ea_binding (ea_binding *);

#endif /* not EALIB_H */
