#define Uses_TEvent
#define Uses_TRect
#define Uses_TListViewer
#define Uses_TWindow
#define Uses_TKeys
#define Uses_TScrollBar
#include <tv.h>

#define TPoint TT_Point
#include "freetype.h"
#include "tttypes.h"
#include "tttables.h"
#include "ttdebug.h"
#include "ttins.h"
#undef TPoint

#include "statetv.h"
#include "debugger.h"

#include <stdio.h>

/*
 * TStateViewer
 */

TStateViewer::TStateViewer( TRect &bounds, PExecution_Context ainstance ) :
  TView( bounds ),
  instance( ainstance )
{
  options   |= ofSelectable;
  eventMask |= evWave;
}

void TStateViewer::draw()
{
  TDrawBuffer  B;
  char         S[256];
  int          Color, n;

  Color = 0x1E;
  n     = 0;
  B.moveChar( 0, ' ', Color, size.x );

  sprintf( S, " Loop                 %04lx", instance->GS.loop );
  B.moveStr( 0, S, Color );
  writeLine( 0, n, size.x, 1, B );
  ++n;

  sprintf( S, " Auto_flip            %s",
	   instance->GS.auto_flip ? " Yes" : "  No" );
  B.moveStr( 0, S, Color );
  writeLine( 0, n, size.x, 1, B );
  ++n;

  sprintf( S, " Dual          (%04x,%04x)",
	   instance->GS.dualVector.x, instance->GS.dualVector.y );
  B.moveStr( 0, S, Color );
  writeLine( 0, n, size.x, 1, B );
  ++n;

  sprintf( S, " Projection    (%04x,%04x)",
	   instance->GS.projVector.x, instance->GS.projVector.y );
  B.moveStr( 0, S, Color );
  writeLine( 0, n, size.x, 1, B );
  ++n;

  sprintf( S, " Freedom       (%04x,%04x)",
	   instance->GS.freeVector.x, instance->GS.freeVector.y );
  B.moveStr( 0, S, Color );
  writeLine( 0, n, size.x, 1, B );
  ++n;

  sprintf( S, " Gep0                   %02x", instance->GS.gep0 );
  B.moveStr( 0, S, Color );
  writeLine( 0, n, size.x, 1, B );
  ++n;

  sprintf( S, " Gep1                   %02x", instance->GS.gep1 );
  B.moveStr( 0, S, Color );
  writeLine( 0, n, size.x, 1, B );
  ++n;

  sprintf( S, " Gep2                   %02x", instance->GS.gep2 );
  B.moveStr( 0, S, Color );
  writeLine( 0, n, size.x, 1, B );
  ++n;

  sprintf( S, " Ins_Control            %02x", instance->GS.instruct_control );
  B.moveStr( 0, S, Color );
  writeLine( 0, n, size.x, 1, B );
  ++n;

  sprintf( S, " Rounding               %02x", instance->GS.round_state );
  B.moveStr( 0, S, Color );
  writeLine( 0, n, size.x, 1, B );
  ++n;

  sprintf( S, " Min_Distance     %08lx", instance->GS.minimum_distance );
  B.moveStr( 0, S, Color );
  writeLine( 0, n, size.x, 1, B );
  ++n;

  sprintf( S, " Rp0                    %02x", instance->GS.rp0 );
  B.moveStr( 0, S, Color );
  writeLine( 0, n, size.x, 1, B );
  ++n;

  sprintf( S, " Rp1                    %02x", instance->GS.rp1 );
  B.moveStr( 0, S, Color );
  writeLine( 0, n, size.x, 1, B );
  ++n;

  sprintf( S, " Rp2                    %02x", instance->GS.rp2 );
  B.moveStr( 0, S, Color );
  writeLine( 0, n, size.x, 1, B );
  ++n;

  sprintf( S, " Ctrl_Val_Cutin   %08lx", instance->GS.control_value_cutin );
  B.moveStr( 0, S, Color );
  writeLine( 0, n, size.x, 1, B );
  ++n;

  sprintf( S, " Sngl_Width_Cutin %08lx", instance->GS.single_width_cutin );
  B.moveStr( 0, S, Color );
  writeLine( 0, n, size.x, 1, B );
  ++n;

  sprintf( S, " Sngl_Widht_Value %08lx", instance->GS.single_width_value );
  B.moveStr( 0, S, Color );
  writeLine( 0, n, size.x, 1, B );
  ++n;

#if 0
  // FIXME!!
  sprintf( S, " Scan_type              %02x", instance->GS.scan_type );
  B.moveStr( 0, S, Color );
  writeLine( 0, n, size.x, 1, B );
  ++n;
#endif

  B.moveChar( 0, ' ', Color, size.x );
  writeLine( 0, n, size.x, size.y-n, B );

}

void TStateViewer::handleEvent( TEvent &event )
{
#if 0
  TRect  Limits;
  TPoint Mini, Maxi;
#endif

  TView::handleEvent( event );

  if ( event.what == evWave )
  {
    switch ( event.message.command )
    {
    case cmReFocus:
      drawView();
      break;
#if 0
                  cmResize: begin
                              Owner^.GetExtent(Limits);
                              SizeLimits( Mini, Maxi );
                              DragView(Event, DragMode, Limits, Mini, Maxi );
                              ClearEvent(Event);
                            end;
#endif
    }
  }
}


/*
 * TStateWindow
 */

TStateWindow::TStateWindow( TRect &bounds, PExecution_Context instance ) :
  TWindow( bounds, "State", wnNoNumber ),
  TWindowInit( &TStateWindow::initFrame )
{
  // XXX GetClipRect( Bounds );
  TRect Bounds = getExtent();
  Bounds.grow(-1,-1);
  stateView = new TStateViewer( Bounds, instance );
  insert( stateView );
}
