{***************************************************************************}
{*                                                                         *}
{*  FreeType Glyph Viewer.                                                 *}
{*                                                                         *}
{*                                                                         *}
{*    This small program will load a TrueType font file and allow          *}
{*    you to view/scale/rotate its glyphs. Glyphs are in the order         *}
{*    found within the 'glyf' table.                                       *}
{*                                                                         *}
{*  NOTE : This version displays a magnified view of the glyph             *}
{*         along with the pixel grid.                                      *}
{*                                                                         *}
{*  This source code has been compiled and run under both Virtual Pascal   *}
{*  on OS/2 and Borland's BP7.                                             *}
{*                                                                         *}
{***************************************************************************}

program Abc;

uses Crt,

{$IFDEF OS2}
     Use32,
{$ENDIF}

     FreeType,
     TTTypes,
     TTMemory,
     TTFile,
     TTCalc,
     TTTables,
     TTRaster,
     TTIns,
     TTDebug,
     TTError;

{$DEFINE DEBUG}

const
  Precis  = 64;
  Precis2 = Precis div 2;

  PrecisAux = 1024;

  Screen_Width  = 640;
  Screen_Height = 480;
  Screen_Cols   = Screen_Width div 8;
  Screen_Size   = Screen_Cols * Screen_Height;

  Grid_Width  = Screen_Width div 8;
  Grid_Height = Screen_Height div 8;
  Grid_Cols   = Grid_Width div 8;
  Grid_Size   = Grid_Cols * Grid_Height;

  Screen_Center_X = Screen_Width div 2;
  Screen_Center_Y = Screen_Height div 2;

  Grid_Center_X = Grid_Width div 2;
  Grid_Center_Y = Grid_Height div 2;

  Profile_Buff_Size = 64000;

var

  Font_Buffer : PStorage;

  num_pts : word;
  num_ctr : word;

  glyfArray : word;

  epts_ctr : PShort;

  xCoord : TT_PCoordinates;
  yCoord : TT_PCoordinates;
  Flag   : TT_PTouchTable;

  ymin, ymax, xmax, xmin, xsize : longint;
  res, old_res                  : int;

  numPoints, numContours : int;

  Bitmap_small : TRasterBlock;
  Bitmap_big   : TRasterBlock;

  Rotation : int;  (* Angle modulo 1024 *)

  num_glyphs : int;

  stream    : TT_Stream;
  resident  : PResidentLeading;
  instance  : PInstanceRecord;

  display_outline : boolean;
  hint_glyph      : boolean;
  scan_type       : Byte;

  old_glyph : int;
  glyph     : int;

  FOut : Text;

(*******************************************************************
 *
 *  Function    :  Dump_CVT
 *
 *  Description :  Dumps a CVT to a standardized form
 *
 *****************************************************************)

 procedure Dump_CVT( cvt : PShort; num : Int );
 var
   i : Int;
 begin
   for i := 0 to num-1 do
   begin
     Write( FOut, Hex16( cvt^[i] ),':' );
   end;
   Writeln( FOut );
 end;

 procedure Dump_CVT2( cvt : PLong; num : Int );
 var
   i : Int;
 begin
   for i := 0 to num-1 do
   begin
     Write( FOut, Hex16( cvt^[i] ),':' );
   end;
   Writeln( FOut );
 end;

(*******************************************************************
 *
 *  Function    :  LoadTrueTypeChar
 *
 *  Description :  Loads a single glyph into the xcoord, ycoord and
 *                 flag arrays, from the instance data.
 *
 *****************************************************************)

Function LoadTrueTypeChar( index : integer ) : Boolean;

var
  off    : longint;
  x, y   : Longint;
  i      : integer;
  j      : word;
  EM     : Word;

  ResR   : Real;
  CR, SR : Real;

begin
  LoadtrueTypeChar := TRUE;

  (* TT_Reset_Glyph( instance ); *)

  if not TT_Load_Glyph( instance, index ) then exit;
  (* composite glyphs are not hinted *)

  LoadTrueTypeChar := False;

  numPoints   := instance^.pts.n;
  numContours := instance^.numContours;

  if (numPoints <= 0) or (numContours <= 0) then exit;

  for j := 0 to numPoints-1 do with instance^, pts do
  begin
    x := MulDiv_Round( org_x^[j], Scale1, Scale2 );
    y := MulDiv_Round( org_y^[j], Scale1, Scale2 );


    org_x^[j] := x;
    org_y^[j] := y;
    cur_x^[j] := x;
    cur_y^[j] := y;
    touch^[j] := touch^[j] and 1;
  end;

  if hint_glyph then
  begin

    Set_CodeRange( instance, 3, instance^.glyphIns, instance^.glyphSize );

    if not Goto_CodeRange( instance, TT_CodeRange_Glyph, 0 )
    then exit;

    TT_Glyph_Defaults( instance );

    with instance^, pts do
    begin
      cur_x^[n-2] := (org_x^[n-2]   ) and -64;
      cur_x^[n-1] := (org_x^[n-1]+32) and -64;
(*
      org_x^[n-2] := cur_x^[n-2];
      org_x^[n-1] := cur_x^[n-1];
*)
    (* Particularit de la fonte Georgia : si les deux lignes prcdentes *)
    (* sont commentes, le 'B' s'affiche correctement  10 pts, tandis    *)
    (* que le 'g' est trop troit d'un pixel. Si ces deux lignes ne sont  *)
    (* pas commentes, le 'g' est OK, le 'B' est trop troit !!           *)

    end;

    instance^.top := 0;

    if not RunIns( instance ) then exit;

  end
  else
    for j := 0 to numPoints-1 do with instance^, pts do
    begin
      cur_x^[j] := (org_x^[j]+32) and -64;
      cur_y^[j] := (org_y^[j]+32) and -64;
    end;

  LoadTrueTypeChar := TRUE;
end;



procedure Usage;
begin
    Writeln('Simple TrueType Glyphs viewer - part of the FreeType project' );
    Writeln;
    Writeln('Usage : ',paramStr(0),' FontName[.TTF]');
    Halt(1);
end;



var i: integer;
    heure,
    min1,
    min2,
    sec1,
    sec2,
    cent1,
    cent2  :
{$IFDEF OS2}
    longint;
{$ELSE}
    word;
{$ENDIF}

    C : Char;

    Filename : String;

label Fin;

var
  Fail     : Int;
  glyphStr : String[4];


begin
  TextMode( co80+Font8x8 );

  GetMem       ( Font_Buffer, 64000 );
  Init_FontPool( Font_Buffer^, 64000 );

  num_pts   := 0;
  num_ctr   := 0;

  xCoord  := NIL;
  yCoord  := NIL;
  Flag    := NIL;

  if ParamCount = 0 then Usage;

  Filename := ParamStr(1);

  if Pos('.',FileName) = 0 then FileName:=FileName+'.TTF';

  if not TT_Open_File( FileName, stream ) then
    begin
      Writeln('ERROR: Could not open ', FileName );
      halt(1);
    end;

  if not TT_Load_Resident_Table( stream, resident ) then
   begin
    Writeln('ERROR: Could not load data from ', FileName );
    Halt(1);
   end;

  i := length(FileName);
  while (i > 1) and (FileName[i] <> '\') do dec(i);

  FileName := Copy( FileName, i+1, length(FileName) );

  if not TT_Load_Instance_Data( resident, instance ) then
   begin
    Writeln('ERROR: Could not open instance from ', FileName );
    Halt(1);
   end;

  Rotation  := 0;
  Fail      := 0;
  res       := 21;
  scan_type := 2;

  num_glyphs := resident^.numGlyphs;

  TT_Reset_Instance( instance, res, 96 );

  if resident^.fontPgmSize > 0 then
  begin

    if not Goto_CodeRange( instance, TT_CodeRange_Font, 0 ) then
    begin
      Writeln('Could not go to font program' );
      halt(1);
    end;

    if not RunIns( instance ) then
    begin
      Writeln('Error while running font program' );
      halt(1);
    end;

  end;

  if resident^.cvtPgmSize > 0 then
  begin

    if not Goto_CodeRange( instance, TT_CodeRange_Cvt, 0 ) then
    begin
      Writeln('Could not go to CVT program' );
      halt(1);
    end;

    if not RunIns( instance ) then
    begin
      Writeln('Error while running CVT program' );
      Writeln('> ', TT_ErrorStr, ' <' );
      halt(1);
    end;

  end;

  TT_Set_Glyph_Defaults( instance );

  hint_glyph := True;

  Fail := 0;

  for i := 0 to num_glyphs-1 do
  begin
    if not LoadTrueTypeChar( i ) then
    begin
      Writeln('Glyph ',i:4,' : error ', Error );
      inc( Fail );
    end
  end;

  TT_Close_File(stream);

  Writeln('Glyphs instructed' );
  Writeln('total glyphs = ', num_glyphs );
  Writeln('failures     = ', Fail );

end.

