{***************************************************************************}
{*                                                                         *}
{*  FreeType Performance Timer                                             *}
{*                                                                         *}
{*                                                                         *}
{*  This source code has been compiled and run under both Virtual Pascal   *}
{*  on OS/2 and Borland's BP7.                                             *}
{*                                                                         *}
{***************************************************************************}

program Timer;

uses Crt,
     Dos,

{$IFDEF OS2}
     Use32,
{$ENDIF}

     FullScr,
     FreeType,
     TTTypes,
     TTMemory,
     TTFile,
     TTTables,
     TTRaster;

{ $DEFINE VISUAL}

{ $DEFINE DEBUG}

{$IFDEF VISUAL}
{&PMTYPE NOVIO}
{$ENDIF}

const
  Precis  = 64;
  Precis2 = Precis div 2;

  PrecisAux = 1024;

  Centre_X : int = 320;
  Centre_Y : int = 225;

  Profile_Buff_Size = 64000;

  Max_Glyphs =26000;

type
  TGlyphData = record
                 numPoints   : Int;
                 numContours : Int;

                 xCoord    : TT_PCoordinates;
                 yCoord    : TT_PCoordinates;
                 Flag      : TT_PTouchTable;
                 endPoints : PUShort;

                 xMin,
                 xMax,
                 yMin,
                 yMax  : Short;
               end;

var
  Font_Buffer : PStorage;

  xC : TT_PCoordinates;
  yC : TT_PCoordinates;
  Fl : TT_PTouchTable;

  total_glyphs : integer;

  glyph_table : array[1..Max_Glyphs] of TGlyphData;

  ymin, ymax, xmax, xmin, xsize : longint;
  res,  resB                    : int;

  resR : real;

  numPoints, numContours : int;

  Bit : TRasterBlock;

  Rotation : int;  (* Angle modulo 1024 *)

  num_glyphs : int;

  gray_level : Boolean;

  stream    : TT_Stream;
  resident  : PResidentLeading;
  instance  : PInstanceRecord;

  old_glyph : int;
  glyph     : int;

  grayLines : array[0..2048] of Byte;

Procedure InitRows;
var
  i: integer;
  P: Pointer;
begin

  if gray_level then
  begin
    Bit.rows  := 200;
    Bit.cols  := 320;
    Bit.width := 320*2;
    Bit.flow  := TTFlowDown;
    Bit.size  := 320*200;
  end
  else
  begin
    Bit.rows  := 450;
    Bit.cols  := 80;
    Bit.width := 640;
    Bit.flow  := TTFlowDown;
    Bit.size  := 80*450;
  end;

  GetMem( Bit.buffer, Bit.size );
  if Bit.buffer = NIL then
   begin
    Writeln('ERREUR:InitRows:Not enough memory to allocate BitMap');
    halt(1);
   end;

  GetMem( P, Profile_Buff_Size );
  if P=nil then
   begin
    writeln('ERREUR:InitRows:Not enough memory to allocate render pool');
    Halt(2);
   end;

  if gray_level then

    Init_Rasterizer( P,
                     Profile_Buff_Size,
                     @grayLines,
                     2048 )
  else
    Init_Rasterizer( P,
                     Profile_Buff_Size,
                     nil,
                     0 );

  FillChar( Bit.Buffer^, Bit.Size, 0 );
end;


Procedure ClearData;
var i: integer;
begin
  FillChar( Bit.Buffer^, Bit.Size, 0 );
end;

procedure Preload_Glyphs;
var
  i, np, nc :integer;

begin
  total_glyphs := 0;

  for i := 0 to resident^.numGlyphs do

    if TT_Load_Glyph( instance, i ) then
    begin

      np := instance^.pts.n;
      nc := instance^.numContours;

      if (np > 0) and (nc > 0) then
      begin

        inc( total_glyphs );
        with glyph_table[total_glyphs] do
        begin

          numPoints   := np;
          numContours := nc;

          GetMem( flag, np );
          move ( instance^.pts.touch^, Flag^, np );

          nc := nc * sizeof(UShort);
          np := np * sizeof(ULong);

          GetMem( endPoints, nc );
          GetMem( xCoord, np );
          GetMem( yCoord, np );

          move ( instance^.endContours^, endPoints^, nc );
          move ( instance^.pts.cur_x^, xCoord^, np );
          move ( instance^.pts.cur_y^, yCoord^, np );
          xMin := instance^.xMin;
          xMax := instance^.xMax;
          yMin := instance^.yMin;
          yMax := instance^.yMax;

          if (i and 63 = 0) then Write('.');

        end;
      end;
  end;
end;


procedure Set_Glyph( index    : integer;
                     center_x : integer;
                     center_y : integer;
                     rotation : integer );
var
  off    : longint;
  xm, ym : integer;
  x, y   : Real;
  EM, j  : Word;
  CR, SR : Real;

begin
  EM := resident^.fontHeader.Units_Per_EM;

  with glyph_table[index] do
  begin

    xm := xMax-xMin;
    ym := yMax-yMin;

    dec ( res );
    resR := res/EM/2;

    xm := trunc( xm * resR + 0.5 );
    ym := trunc( ym * resR + 0.5 );

    CR := Cos( Rotation*Pi/512 );
    SR := Sin( Rotation*Pi/512 );

    for j := 0 to numPoints-1 do
     begin

      x := xCoord^[j] * ( res / EM );
      y := yCoord^[j] * ( res / EM );

      off := Trunc( Precis*( CR*(x-xm) + SR*(y-ym) ) );

      xC^[j] := Precis*Centre_X + off;
      (*
      xCoord^[j] := Precis*( Centre_X + off div Precis ) + Precis2;
      *)

      off := Trunc( Precis*( - SR*(x-xm) + CR*(y-ym) ) );

      yC^[j] := Precis*Centre_Y + off;
      (*
      yCoord^[j] := Precis*( Centre_Y + off div Precis ) + Precis2;
      *)

      Fl^[j] := Flag^[j];
     end;

    inc ( res );
  end;

end;


function ConvertRaster : boolean;
var
  B : Array[0..128] of Integer;
  i : integer;
  G : TGlyphRecord;
begin

  Set_Glyph( glyph, Centre_X, Centre_Y, rotation );

  with glyph_table[glyph] do
  begin
    G.numConts  := numContours;
    G.endPoints := endPoints;
    G.Points    := numPoints - 2;  (* remove phantom points *)
  end;

  G.XCoord    := xC;
  G.YCoord    := yC;
  G.Flag      := Fl;

  if gray_level then
    ConvertRaster := Render_Gray_Glyph( G, @Bit, 2, nil )
  else
    ConvertRaster := Render_Glyph ( G, @Bit, 2 );
end;

procedure Usage;
begin
    Writeln('Simple TrueType Glyphs viewer - part of the FreeType project' );
    Writeln;
    Writeln('Usage : ',paramStr(0),' FontName[.TTF]');
    Halt(1);
end;

function Get_Time : LongInt;
var
  heure,
  min,
  sec,
  cent :
{$IFDEF OS2}
  longint;
{$ELSE}
  word;
{$ENDIF}

begin
  GetTime( heure, min, sec, cent );
  Get_Time := 6000*longint(min) + 100*longint(sec) + cent;
end;

var i        : integer;
    Filename : String;
    Fail     : Int;
    T        : Long;

begin
  GetMem       ( Font_Buffer, 512000 );
  Init_FontPool( Font_Buffer^, 512000 );

  xC := NIL;
  yC := NIL;
  Fl := NIL;

  if ParamCount = 0 then Usage;

  gray_level := ParamStr(1)='-g';

  if gray_level then
    if ParamCount <> 2 then Usage else
  else
    if ParamCount <> 1 then Usage;

  if gray_level then Filename := ParamStr(2)
                else Filename := ParamStr(1);

  if Pos('.',FileName) = 0 then FileName:=FileName+'.TTF';

  if not TT_Open_File( FileName, stream ) then
    begin
      Writeln('ERROR: Could not open ', FileName );
      halt(1);
    end;

  if not TT_Load_Resident_Table( stream, resident ) then
   begin
    Writeln('ERROR: Could not load data from ', FileName );
    Halt(1);
   end;

  if not TT_Load_Instance_Data( resident, instance ) then
   begin
    Writeln('ERROR: Could not open instance from ', FileName );
    Halt(1);
   end;

  i := resident^.MaxProfile.maxPoints;

  GetMem( fl, i );
  i := i * sizeof(Long);

  GetMem( xC, i );
  GetMem( yC, i );

  res := 800;
  TT_Reset_Instance( instance, res, 96 );

  Rotation := 0;

  Fail := 0;

  InitRows;

  num_glyphs := instance^.fontres^.numGlyphs;

  Preload_Glyphs;

  num_glyphs := total_glyphs;

  {$IFDEF VISUAL}
  if gray_level then
    SetGraphScreen( FS_Graphics_Gray )
  else
    SetGraphScreen( FS_Graphics_Mono );
  {$ENDIF}

  T := Get_Time;

  old_glyph := -1;
  glyph     :=  1;

  for glyph := 0 to num_glyphs do
  begin

    if ConvertRaster then
    {$IFDEF VISUAL}
    begin
      if gray_level then
        Display( Bit.Buffer^, 200, 320 )
      else
        Display( Bit.Buffer^, 450, 80  );

      ClearData;
    end
    {$ELSE}
      ClearData

    {$ENDIF}
    else
      inc( Fail );

  end;

  T := Get_Time - T;
  if T < 0 then T := T + 100*60*60;

  {$IFDEF VISUAL}
  RestoreScreen;
  {$ENDIF}
  TT_Close_File(stream);

  writeln;
  writeln('Time elapsed  : ', T/100:0:2,' s');
  writeln('Fails         : ',Fail );
end.

