{**********************************************************}
{*                                                        *}
{* The following routines are inline assembly, they are   *}
{* thus processor and bitness specific. Replace them      *}
{* with your own if you want to port the TrueType Engine  *}


{**********************************************************}
{* Calc A*B/C with Intermediate 64 bit precision          *}

function MulDiv( A, B, C : Int32 ): Int32; assembler;
  {$USES ebx, ecx }
asm
  mov eax,[A]
  mov ecx,[B]
  mov ebx,[C]
  imul ecx
  idiv ebx
end;

function MulDiv_Round( A, B, C : Int32 ): Int32; assembler;
  {$USES ebx, ecx, edx, esi}
asm
  mov eax,[A]
  mov ecx,[B]
  mov ebx,[C]
  imul ecx

  mov ecx, ebx
  sar ecx, 1
  add eax, ecx
  adc edx, 0
  sar ecx, 31
  add edx, ecx

  idiv ebx
end;



{**********************************************************}
{* 64 Bit Addition                                        *}

procedure Add64( var X, Y, Z : Int64 ); assembler; {$USES ebx, edx}
asm
  mov ebx,[X].dword
  mov eax,[ebx]
  mov edx,[ebx+4]

  mov ebx,[Y].dword
  add eax,[ebx]
  adc edx,[ebx+4]

  mov ebx,[Z].dword
  mov [ebx],eax
  mov [ebx+4],edx
end;


{**********************************************************}
{* 64 Bit Substraction                                    *}

procedure Sub64( var X, Y, Z : Int64 ); assembler; {$USES eax, ebx, edx}
asm
  mov ebx,[X].dword
  mov eax,[ebx]
  mov edx,[ebx+4]

  mov ebx,[Y].dword
  sub eax,[ebx]
  sbb edx,[ebx+4]

  mov ebx,[Z].dword
  mov [ebx],eax
  mov [ebx+4],edx
end;


{**********************************************************}
{* Multiply two Int32 to an Int64                         *}

procedure MulTo64( X, Y : Int32; var Z : Int64 ); assembler; {$USES ebx, eax, edx }
asm
  mov ebx,[Z].dword
  mov eax,[X]
  imul [Y]
  mov [ebx],eax
  mov [ebx+4],edx
end;


{**********************************************************}
{* Divide an Int64 by an Int32                            *}

function Div64by32( var X : Int64; Y : Int32 ) : Int32; assembler; {$USES ebx}
         {$USES ebx, edx}
asm
  mov ebx,[X].dword
  mov eax,[ebx]
  mov edx,[ebx+4]
  idiv [Y]
end;

procedure DivMod64by32( var X : Int64; Y : Int32; var Q, R : Int32 );
          assembler; {$USES ebx, edx}
asm
  mov ebx, [X].dword
  mov eax, [ebx]
  mov edx, [ebx+4]
  idiv [Y]
  mov ebx, [Q].dword
  mov [ebx], eax
  mov ebx, [R].dword
  mov [ebx], edx
end;



{**********************************************************}
{* MSB index ( return -1 for 0 )                          *}

function Order64( var Z : Int64 ) : integer; assembler; {$USES ebx, ecx}
asm
  mov ebx, [Z].dword
  mov eax, [ ebx ]
  mov edx, [ebx+4]

  test edx, edx
  jz @1

  bsr eax, edx
  add eax, 32
  jmp @2

 @1:
  bsr eax, eax

 @2:
end;


{**********************************************************}
{* MSB index ( return -1 for 0 )                          *}

function Order32( Z : Int32 ) : integer; assembler;
asm
  bsr eax,[Z]
end;

