{***************************************************************************}
{*                                                                         *}
{* The Portable TrueType Engine - Copyright 1995, 1996 David TURNER        *}
{*_________________________________________________________________________*}
{*                                                                         *}
{*                                                                         *}
{*   TTError : A very simple unit to define the engine's error messages    *}
{*             a the global 'Error' variable                               *}
{*                                                                         *}
{*                                                                         *}
{***************************************************************************}

unit TTError;

interface

uses TTTypes;

const
  TT_ErrMsg_Ok                   =  0;
  TT_ErrMsg_Invalid_Opcode       = -1;
  TT_ErrMsg_Too_Few_Arguments    = -2;
  TT_ErrMsg_Stack_Overflow       = -3;
  TT_ErrMsg_Code_Overflow        = -4;
  TT_ErrMsg_Bad_Argument         = -5;
  TT_ErrMsg_Divide_by_Zero       = -6;
  TT_ErrMsg_Storage_Overflow     = -7;
  TT_ErrMsg_Cvt_OverFlow         = -8;
  TT_ErrMsg_Invalid_Reference    = -9;
  TT_ErrMsg_Invalid_Distance     = -10;
  TT_ErrMsg_Interpolate_Twilight = -11;
  TT_ErrMsg_Debug_OpCode         = -12;
  TT_ErrMsg_ENDF_In_Exec_Stream  = -13;
  TT_ErrMsg_Invalid_Coderange    = -14;
  TT_ErrMsg_Nested_DEFs          = -15;
  TT_ErrMsg_File_Error           = -16;

  TT_ErrMsg_Invalid_Font_Handle  = -17;
  TT_ErrMsg_Invalid_Glyph_Index  = -18;
  TT_ErrMsg_Invalid_Contours     = -19;
  TT_ErrMsg_Too_Many_Ins         = -20;

var
  Error : Int;

  function TT_ErrorStr : String;

implementation

const
  Err_Str : array [ 0..20 ] of String[30]
          = (
              'No error',
              'Invalid opcode',
              'Too few arguments',
              'Stack overflow',
              'Code overflow',
              'Bad argument',
              'Divide by zero',
              'Storage overflow',
              'Cvt overflow',
              'Invalid reference',
              'Invalid distance',
              'Interpolate twilight',
              'Debug opcode',
              'ENDF in exec. stream',
              'Invalid coderange',
              'Nested DEFs',
              'File Error',
              'Invalid font handle',
              'Invalid glyph index',
              'Invalid contour',
              'Too many instructions'
            );

  function TT_ErrorStr : String;
  begin
    TT_ErrorStr := Err_Str[ -Error ];
  end;

end.
