/*******************************************************************
 *
 *  ttextend.h                                                   1.0
 *
 *    Extensions Interface    
 *
 *  Copyright 1996, 1997 by
 *  David Turner, Robert Wilhelm, and Werner Lemberg.
 *
 *  This file is part of the FreeType project, and may only be used
 *  modified and distributed under the terms of the FreeType project
 *  license, LICENSE.TXT. By continuing to use, modify or distribute
 *  this file you indicate that you have read the license and
 *  understand and accept it fully.
 *
 *  It is now possible to 'extend' the FreeType engine, in order
 *  to be able to access additionnal tables, without having to
 *  to change the core library's code.
 *
 *  Only extensions of the face object class are supported.
 *  Each face object has now a typeless pointer called 'extension'
 *  that can be used as an anchor to the data specific to a given
 *  library extension.
 *
 *  The extension component can also allocate memory on engine
 *  initialisation, which calls the TTExtension_Init function.
 *
 *  NOTE :
 *
 *  The ttextend.h and ttextend.c are used to extend the core           
 *  library. They do not affect the high-level API.  
 *
 *  It is possible to extend the high-level API by modifying the
 *  file 'extend/api.h' found in this same directory
 *  read its source for more information on how to do that.
 *
 ******************************************************************/

#ifndef TTEXTEND_H
#define TTEXTEND_H

#include "ttcommon.h"
#include "tttypes.h"
#include "ttobjs.h"

  #ifdef __cplusplus
  extern "C" {
  #endif

  /* You must list there the header files off all the extension */
  /* components you want to add to the core engine.             */

  /* ------ kerning support in 'ttkern.h/c' ---- */

  #include "ttkern.h"

  /* ------- other optional extensions ------------------ */

  /* ---------------------------------------------------- */

  /* THE extensions structure, root of all extensions        */
  /* You must place a root field for each of your extensions */

  struct _TExtension
  {
     TT_Kerning  kerning;    /* optional kerning support */
  };
  
  typedef struct _TExtension  TExtension;
  typedef TExtension*         PExtension;

  /* Here comes the minimal API that must be provided by this */
  /* component.                                               */

  /* Init the extension component */
  TT_Error  TTExtension_Init();

  /* Finalize the extension component */
  TT_Error  TTExtension_Done();

  /* Create a new extension for a newly created face.         */
  /* This is called by the face constructor/loader            */

  /* Note that you should _never_ change anything in the      */
  /* face object, with the exception of the 'face->extension'.*/
  /* It will be used as an anchor to all the supplemental     */
  /* data that you want to allocate with a face object.       */
  TT_Error  Extension_Create( PFace  face );

  /* Destroy an extension. This is called by the face       */
  /* destructor                                             */
  /*                                                        */
  /* Note that this is the last function to be called by    */
  /* the destructor, so all values in the 'face' object     */
  /* should be considered as invalid !                      */
  /*                                                        */
  /* You should only destroy the data that you created      */
  /* from the 'face->extension' anchor.                     */
  /*                                                        */
  TT_Error  Extension_Destroy( PFace  face );

  #ifdef __cplusplus
  }
  #endif


#endif /* TTEXTEND_H */

