{HALDISK provides REXX with access to OS/2's disk access functions.}

LIBRARY HALDISK;

{$CDecl+,OrgName+,I-,S-,Delphi+,Use32+}

USES DOS,OS2DEF,REXX,STRINGS,OS2BASE;

{$LINKER
  DESCRIPTION      "HALDISK - Access to OS/2's disk access functions for REXX"
  DATA MULTIPLE NONSHARED

  EXPORTS
    HALDISKOPEN=HALDISKOPEN
    HALDISKCLOSE=HALDISKCLOSE
    HALDISKREAD=HALDISKREAD
    HALDISKWRITE=HALDISKWRITE
    HALDISKCHGFILEPTR=HALDISKCHGFILEPTR
    HALDISKLOADFUNCS=HALDISKLOADFUNCS
}

CONST FUNCTIONTABLE : ARRAY[ 0..4 ] OF PCHAR =
(
    'HALDISKOPEN',
    'HALDISKCLOSE',
    'HALDISKCHGFILEPTR',
    'HALDISKWRITE',
    'HALDISKREAD'
);

FUNCTION HALDISKLOADFUNCS(FUNCNAME:PCHAR;ARGC:ULONG;ARGS:PRXSTRING;QUEUENAME:PCHAR;VAR RET:RXSTRING):ULONG;EXPORT;
VAR
    I:INTEGER;
BEGIN
    RET.STRLENGTH:=0;
    IF ARGC>0 THEN RESULT:=40
    ELSE BEGIN
        FOR I:=LOW(FUNCTIONTABLE) TO HIGH(FUNCTIONTABLE) DO
            REXXREGISTERFUNCTIONDLL(FUNCTIONTABLE[I],'HALDISK',FUNCTIONTABLE[I]);
        RESULT:=0;
    END;
END;

FUNCTION STR2INT(S:STRING):INTEGER;
VAR
    INT,I:INTEGER;
BEGIN
    INT:=0;
    FOR I:=1 TO LENGTH(S) DO INT:=INT*10+ORD(S[I])-ORD('0');
    RESULT:=INT;
END;

PROCEDURE INT2RXSTR(VAR RX:RXSTRING;NUM:INTEGER);
VAR
    S:STRING;
BEGIN
    STR(NUM,S);
    RX.STRLENGTH:=LENGTH(S);
    STRPCOPY(RX.STRPTR,S);
END;

FUNCTION HALDISKOPEN(FUNCNAME:PCHAR;ARGC:ULONG;ARGS:PRXSTRING;QUEUENAME:PCHAR;VAR RET:RXSTRING):ULONG;EXPORT;
VAR
    FILENAME:STRING;
    FILEHANDLE:LONGINT;
    ACTION:ULONG;
    FLAGS,MODE:ULONG;
    TMP,S:STRING;
BEGIN
    FILENAME:=STRPAS(ARGS^.STRPTR)+#0;
    INC(ARGS);
    FLAGS:=STR2INT(STRPAS(ARGS^.STRPTR));
    INC(ARGS);
    MODE:=STR2INT(STRPAS(ARGS^.STRPTR));
    DOSOPEN(@FILENAME[1],FILEHANDLE,ACTION,0,0,FLAGS,MODE,NIL);
    STR(ACTION,S);
    TMP:=S+' ';
    STR(FILEHANDLE,S);
    TMP:=TMP+S;
    STRPCOPY(RET.STRPTR,TMP);
    RET.STRLENGTH:=LENGTH(TMP);
    RESULT:=0;
END;

FUNCTION HALDISKREAD(FUNCNAME:PCHAR;ARGC:ULONG;ARGS:PRXSTRING;QUEUENAME:PCHAR;VAR RET:RXSTRING):ULONG;EXPORT;
VAR
    HANDLE:LONGINT;
    BUFFER:ARRAY [0..255] OF CHAR;
    LEN:ULONG;
    NREAD:ULONG;
    I:INTEGER;
    TMP:STRING;
    OK:LONGINT;
BEGIN
    HANDLE:=STR2INT(STRPAS(ARGS^.STRPTR));
    INC(ARGS);
    LEN:=STR2INT(STRPAS(ARGS^.STRPTR));
    IF LEN>256 THEN BEGIN RESULT:=40; EXIT; END;
    OK:=DOSREAD(HANDLE,BUFFER,LEN,NREAD);
    TMP:=STRPAS(BUFFER);
    STRPCOPY(RET.STRPTR,TMP);
    RET.STRLENGTH:=NREAD;
    RESULT:=0;
END;

FUNCTION HALDISKWRITE(FUNCNAME:PCHAR;ARGC:ULONG;ARGS:PRXSTRING;QUEUENAME:PCHAR;VAR RET:RXSTRING):ULONG;EXPORT;
VAR
    HANDLE:LONGINT;
    LEN:ULONG;
    NWRITTEN:ULONG;
    I:INTEGER;
    TMP:STRING;
    OK:LONGINT;
BEGIN
    HANDLE:=STR2INT(STRPAS(ARGS^.STRPTR));
    INC(ARGS);
    LEN:=STRLEN(ARGS^.STRPTR);
    {IF LEN>256 THEN BEGIN RESULT:=40; EXIT; END;}
    OK:=DOSWRITE(HANDLE,ARGS^.STRPTR,LEN,NWRITTEN);
    INT2RXSTR(RET,OK);
    RESULT:=0;
END;

FUNCTION HALDISKCHGFILEPTR(FUNCNAME:PCHAR;ARGC:ULONG;ARGS:PRXSTRING;QUEUENAME:PCHAR;VAR RET:RXSTRING):ULONG;EXPORT;
VAR
    HANDLE:LONGINT;
    MOVETYPE:INTEGER;
    DIST:LONGINT;
    NEWLOC:LONGINT;
BEGIN
    HANDLE:=STR2INT(STRPAS(ARGS^.STRPTR));
    INC(ARGS);
    MOVETYPE:=STR2INT(STRPAS(ARGS^.STRPTR));
    INC(ARGS);
    DIST:=STR2INT(STRPAS(ARGS^.STRPTR));
    DOSSETFILEPTR(HANDLE,DIST,MOVETYPE,NEWLOC);
    INT2RXSTR(RET,NEWLOC);
    RESULT:=0;
END;

FUNCTION HALDISKCLOSE(FUNCNAME:PCHAR;ARGC:ULONG;ARGS:PRXSTRING;QUEUENAME:PCHAR;VAR RET:RXSTRING):ULONG;EXPORT;
VAR
    HANDLE:LONGINT;
BEGIN
    INT2RXSTR(RET,DOSCLOSE(STR2INT(STRPAS(ARGS^.STRPTR))));
    RESULT:=0;
END;

INITIALIZATION
END.

