{
HALMOU provides REXX with access to OS/2's Mou... functions.
}

Library halmou;

{$CDecl+,OrgName+,I-,S-,Delphi+,Use32+}

Uses
  Dos, Os2Def, Rexx, Strings, Os2Base;

{$LINKER
  DESCRIPTION      "HALMOU - Access to OS/2's Mou... functions for REXX"
  DATA MULTIPLE NONSHARED

  EXPORTS
    HALMOUCLOSE         = HALMouClose
    HALMOUDRAWPTR       = HALMouDrawPtr
    HALMOUFLUSHQUE      = HALMouFlushQue
    HALMOUGETDEVSTATUS  = HALMouGetDevStatus
    HALMOUGETEVENTMASK  = HALMouGetEventMask
    HALMOUGETNUMBUTTONS = HALMouGetNumButtons
    HALMOUGETNUMMICKEYS = HALMouGetNumMickeys
    HALMOUGETNUMQUEEL   = HALMouGetNumQueEl
    HALMOUGETPTRPOS     = HALMouGetPtrPos
    HALMOUGETSCALEFACT  = HALMouGetScaleFact
    HALMOUOPEN          = HALMouOpen
    HALMOUREADEVENTQUE  = HALMouReadEventQue
    HALMOUREMOVEPTR     = HALMouRemovePtr
    HALMOUSETDEVSTATUS  = HALMouSetDevStatus
    HALMOUSETPTRPOS     = HALMouSetPtrPos
    HALMOUSETSCALEFACT  = HALMouSetScaleFact
    HALMOULOADFUNCS     = HALMouLoadFuncs
}

Const FunctionTable : Array[ 0..15 ] of pChar =
(
  'HALMouClose',
  'HALMouDrawPtr',
  'HALMouFlushQue',
  'HALMouGetDevStatus',
  'HALMouGetEventMask',
  'HALMouGetNumButtons',
  'HALMouGetNumMickeys',
  'HALMouGetNumQueEl',
  'HALMouGetPtrPos',
  'HALMouGetScaleFact',
  'HALMouOpen',
  'HALMouReadEventQue',
  'HALMouRemovePtr',
  'HALMouSetDevStatus',
  'HALMouSetPtrPos',
  'HALMouSetScaleFact'
);

Function HALMouLoadFuncs( FuncName  : PChar;
                         ArgC      : ULong;
                         Args      : pRxString;
                         QueueName : pChar;
                         Var Ret   : RxString ) : ULong; export;
Var
  j       : Integer;

begin
  Ret.strLength := 0;
  For j := Low( FunctionTable ) to High( FunctionTable ) do
    RexxRegisterFunctionDLL( FunctionTable[j],'HALMOU',FunctionTable[j] );
  HALMouLoadFuncs := 0;
end;

Function Str2Int( s : String) : Integer;
var
  int,i : Integer;
begin
  int:=0;
  for i := 1 to length(s) do
    int:=int*10+ord(s[i])-ord('0');
  Str2Int:=int;
end;

procedure int2rxstr(var Ret : RXString; num : Integer);
var
  s : String;
begin
  str( num, s );
  Ret.strLength := Length(s);
  strpcopy( Ret.strptr, s );
end;

Function HALMouOpen( FuncName : PChar; ArgC : ULong; Args : pRxString; QueueName : pChar; Var Ret : RxString ) : ULong; export;
var
  hndl : SmallWord;
  s : String;
begin
  HALMouOpen := 40;
  IF MouOpen(nil,hndl)=0 THEN HALMOUOPEN:=0;
  int2rxstr(Ret,hndl);
end;

Function HALMouDrawPtr( FuncName : PChar; ArgC : ULong; Args : pRxString; QueueName : pChar; Var Ret : RxString ) : ULong; export;
var
  hndl : Integer;
begin
  If ArgC < 1 then begin
    HALMouDrawPtr := 40;
    Exit;
  end;
  hndl := Str2Int(StrPas( Args^.strptr ));
  MouDrawPtr(hndl);
  Ret.strLength := 0;
  HALMouDrawPtr := 0;
end;

Function HALMouGetNumButtons( FuncName : PChar; ArgC : ULong; Args : pRxString; QueueName : pChar; Var Ret : RxString ) : ULong; export;
var
  hndl : Integer;
  but : SmallWord;
begin
  If ArgC < 1 then begin
    HALMouGetNumButtons := 40;
    Exit;
  end;
  hndl := Str2Int(StrPas( Args^.strptr ));
  MouGetNumButtons(but,hndl);
  int2rxstr(Ret,but);
  HALMouGetNumButtons := 0;
end;

Function HALMouGetPtrPos( FuncName : PChar; ArgC : ULong; Args : pRxString; QueueName : pChar; Var Ret : RxString ) : ULong; export;
var
  hndl : Integer;
  pos : ptrloc;
  s : String;
  tmp : String;
begin
  If ArgC < 1 then begin
    HALMouGetPtrPos := 40;
    Exit;
  end;
  hndl := Str2Int(StrPas( Args^.strptr ));
  MouGetPtrPos(pos,hndl);
  str( pos.row, s );
  tmp:=s;
  str( pos.col, s );
  tmp:=tmp+' '+s;
  strpcopy( Ret.strptr, tmp );
  Ret.strLength := strlen(Ret.strptr);
  HALMouGetPtrPos := 0;
end;

Function HALMouSetPtrPos( FuncName : PChar; ArgC : ULong; Args : pRxString; QueueName : pChar; Var Ret : RxString ) : ULong; export;
var
  hndl : Integer;
  pos : ptrloc;
  s : String;
  tmp : String;
begin
  If ArgC < 3 then begin
    HALMouSetPtrPos := 40;
    Exit;
  end;
  hndl := Str2Int(StrPas( Args^.strptr ));
  inc(args);
  pos.row:= Str2Int(StrPas( Args^.strptr ));
  inc(args);
  pos.col:= Str2Int(StrPas( Args^.strptr ));
  MouSetPtrPos(pos,hndl);
  Ret.strLength := 0;
  HALMouSetPtrPos := 0;
end;

Function HALMouClose( FuncName : PChar; ArgC : ULong; Args : pRxString; QueueName : pChar; Var Ret : RxString ) : ULong; export;
var
  hndl : Integer;
begin
  If ArgC < 1 then
    begin
      HALMouClose := 40;
      Exit;
    end;
  hndl := Str2Int(StrPas( Args^.strptr ));
  MouClose(hndl);
  Ret.strLength := 0;
  HALMouClose := 0;
end;

Function HALMouFlushQue( FuncName : PChar; ArgC : ULong; Args : pRxString; QueueName : pChar; Var Ret : RxString ) : ULong; export;
var
  hndl : Integer;
begin
  If ArgC < 1 then
    begin
      HALMouFlushQue := 40;
      Exit;
    end;
  hndl := Str2Int(StrPas( Args^.strptr ));
  MouFlushQue(hndl);
  Ret.strLength := 0;
  HALMouFlushQue := 0;
end;

Function HALMouGetDevStatus( FuncName : PChar; ArgC : ULong; Args : pRxString; QueueName : pChar; Var Ret : RxString ) : ULong; export;
var
  hndl : Integer;
  status : SmallWord;
begin
  If ArgC < 1 then
    begin
      HALMouGetDevStatus := 40;
      Exit;
    end;
  hndl := Str2Int(StrPas( Args^.strptr ));
  MouGetDevStatus(status,hndl);
  int2rxstr(Ret,status);
  HALMouGetDevStatus := 0;
end;

Function HALMouGetEventMask( FuncName : PChar; ArgC : ULong; Args : pRxString; QueueName : pChar; Var Ret : RxString ) : ULong; export;
var
  hndl : Integer;
  status : SmallWord;
begin
  If ArgC < 1 then
    begin
      result := 40;
      Exit;
    end;
  hndl := Str2Int(StrPas( Args^.strptr ));
  MouGetEventMask(status,hndl);
  int2rxstr(Ret,status);
  result := 0;
end;

Function HALMouGetNumMickeys( FuncName : PChar; ArgC : ULong; Args : pRxString; QueueName : pChar; Var Ret : RxString ) : ULong; export;
var
  hndl : Integer;
  status : SmallWord;
begin
  If ArgC < 1 then
    begin
      result := 40;
      Exit;
    end;
  hndl := Str2Int(StrPas( Args^.strptr ));
  MouGetNumMickeys(status,hndl);
  int2rxstr(Ret,status);
  result := 0;
end;

Function HALMouGetNumQueEl( FuncName : PChar; ArgC : ULong; Args : pRxString; QueueName : pChar; Var Ret : RxString ) : ULong; export;
var
  hndl : Integer;
  QueEl : MouQueInfo;
  tmp,s : String;
begin
  If ArgC < 1 then
    begin
      result := 40;
      Exit;
    end;
  hndl := Str2Int(StrPas( Args^.strptr ));
  MouGetNumQueEl(queEl,hndl);
  str( queEl.cevents, s );
  tmp:=s;
  str( queEl.cmaxevents, s );
  tmp:=tmp+' '+s;
  strpcopy( Ret.strptr, tmp );
  Ret.strLength := strlen(Ret.strptr);
  result := 0;
end;

Function HALMouGetScaleFact( FuncName : PChar; ArgC : ULong; Args : pRxString; QueueName : pChar; Var Ret : RxString ) : ULong; export;
var
  hndl : Integer;
  sf : ScaleFact;
  tmp,s : String;
begin
  If ArgC < 1 then
    begin
      result := 40;
      Exit;
    end;
  hndl := Str2Int(StrPas( Args^.strptr ));
  MouGetScaleFact(sf,hndl);
  str( sf.rowscale, s );
  tmp:=s;
  str( sf.colscale, s );
  tmp:=tmp+' '+s;
  strpcopy( Ret.strptr, tmp );
  Ret.strLength := strlen(Ret.strptr);
  result := 0;
end;

Function HALMouReadEventQue( FuncName : PChar; ArgC : ULong; Args : pRxString; QueueName : pChar; Var Ret : RxString ) : ULong; export;
var
  hndl : Integer;
  wait : smallword;
  evt : MouEventInfo;
  tmp,s : String;
begin
  If ArgC < 1 then begin
    result := 40;
    Exit;
  end;
  hndl := Str2Int(StrPas( Args^.strptr ));
  inc(args);
  wait:= Str2Int(StrPas( Args^.strptr ));
  MouReadEventQue(evt,wait,hndl);
  str( evt.fs, s );
  tmp:=s;
  str( evt.row, s );
  tmp:=tmp+' '+s;
  str( evt.col, s );
  tmp:=tmp+' '+s;
  str( evt.time, s );
  tmp:=tmp+' '+s;
  strpcopy( Ret.strptr, tmp );
  Ret.strLength := strlen(Ret.strptr);
  result := 0;
end;

Function HALMouRemovePtr( FuncName : PChar; ArgC : ULong; Args : pRxString; QueueName : pChar; Var Ret : RxString ) : ULong; export;
var
  hndl : Integer;
  area : NoPtrRect;
begin
  If ArgC < 1 then begin
    result := 40;
    Exit;
  end;
  hndl := Str2Int(StrPas( Args^.strptr ));
  inc(args);
  area.row:= Str2Int(StrPas( Args^.strptr ));
  inc(args);
  area.col:= Str2Int(StrPas( Args^.strptr ));
  inc(args);
  area.crow:= Str2Int(StrPas( Args^.strptr ));
  inc(args);
  area.ccol:= Str2Int(StrPas( Args^.strptr ));
  MouRemovePtr(area,hndl);
  Ret.strLength:=0;
  result:=0;
end;

Function HALMouSetDevStatus( FuncName : PChar; ArgC : ULong; Args : pRxString; QueueName : pChar; Var Ret : RxString ) : ULong; export;
var
  hndl : Integer;
  status : smallword;
begin
  If ArgC < 1 then begin
    result:=40;
    Exit;
  end;
  hndl := Str2Int(StrPas( Args^.strptr ));
  inc(args);
  status:= Str2Int(StrPas( Args^.strptr ));
  MouSetDevStatus(status,hndl);
  Ret.strLength:=0;
  result:=0;
end;

Function HALMouSetScaleFact( FuncName : PChar; ArgC : ULong; Args : pRxString; QueueName : pChar; Var Ret : RxString ) : ULong; export;
var
  hndl : Integer;
  sf : scalefact;
begin
  If ArgC < 1 then begin
    result:=40;
    Exit;
  end;
  hndl := Str2Int(StrPas( Args^.strptr ));
  inc(args);
  sf.rowscale:=Str2Int(StrPas( Args^.strptr ));
  inc(args);
  sf.colscale:=Str2Int(StrPas( Args^.strptr ));
  MouSetScaleFact(sf,hndl);
  Ret.strLength:=0;
  result:=0;
end;

initialization
end.


