/************************************************************************
*  Project     : PRTGRAPH                                               *
*  Module      : REXX Library                                           *
*  Filename    : install.cmd              Author  : Peter Kanis         *
*************************************************************************
*                                                                       *
*  (c) ADD Consulting  All Rights Reserved                              *
*                                                                       *
*************************************************************************/

'@echo off'
address cmd

/***** Find out where we are ********************************************/

parse source s1 s2 s3

s1 = filespec( 'D', s3)
s2 = filespec( 'P', s3)

p = pos( '\', s2)
lp = lastpos( '\', s2)

if lp <> p then
    instpath =  s1 || substr( s2, 1, lp)
else
    instpath =  s1 || s2

/***** Find the boot drive for installation *****************************/

set_path = VALUE( 'PATH', , 'OS2ENVIRONMENT');
bootdrive = substr( set_path, pos( '\OS2\SYSTEM', set_path ) -2, 2);

dllpath = bootdrive || '\OS2\APPS\DLL'
bkpath = bootdrive || '\OS2\BOOK'
exepath = bootdrive || '\OS2\APPS'
bmppath = bootdrive || '\OS2\BITMAP'

'cls'

say 'Installation for PRTGRAPH REXX library'
say '(c)1995, 1996 ADD Consulting (CH)'
say ''

say 'The DLL will be installed in' dllpath 'OK (Y/N)'
pull ans
ans = translate( ans);
if ans <> 'Y' then do
    say 'Enter the path to install the DLL'
    pull dllpath
end
say 'The programming guide book will be installed in' bkpath 'OK (Y/N)'
pull ans
ans = translate( ans);
if ans <> 'Y' then do
    say 'Enter the path to install the book'
    pull bkpath
end
say 'The Demo will be installed in' exepath 'OK (Y/N)'
pull ans
ans = translate( ans);
if ans <> 'Y' then do
    say 'Enter the path to install the Demo'
    pull exepath
end

'copy' instpath || 'prtgraph.dll' dllpath
'copy' instpath || 'prtgraph.inf' bkpath
'copy' instpath || 'prtrdemo.exe' exepath
'copy' instpath || 'addlogo.bmp' bmppath

say 'PRTGRAPH wass successfully installed'
say ''
say 'You will need to copy the VX-REXX project files'
say 'to the path of your choice'

exit

/************************************************************************/
/*                                                                      */
/*                         (c) ADD Consulting 1996                      */
/*                                                                      */
/*                               END OF FILE.                           */
/*                                                                      */
/************************************************************************/
