/* definitions and prototypes for w32utils
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is w32funcs.
 *
 * The Initial Developer of the Original Code is Patrick TJ McPhee.
 * Portions created by Patrick McPhee are Copyright 1998, 2001
 * Patrick TJ McPhee. All Rights Reserved.
 *
 * $Header: C:/ptjm/rexx/w32funcs/RCS/w32funcs.h 1.18 2003/12/19 15:23:07 ptjm Rel $
 */

#include "rxproto.h"


/* prototypes for all the functions: */
rxfunc(w32backupeventlog);
rxfunc(w32callfunc);
rxfunc(w32callproc);
rxfunc(w32cleareventlog);
rxfunc(w32closeeventlog);
rxfunc(w32createobject);
rxfunc(w32findeventlogentry);
rxfunc(w32geteventcategory);
rxfunc(w32geteventdata);
rxfunc(w32geteventid);
rxfunc(w32geteventnumstrings);
rxfunc(w32geteventstring);
rxfunc(w32geteventtimegenerated);
rxfunc(w32geteventtimewritten);
rxfunc(w32geteventtype);
rxfunc(w32getnumberofeventlogrecords);
rxfunc(w32getobject);
rxfunc(w32getproperty);
rxfunc(w32getsubobj);
rxfunc(w32olegeterror);
rxfunc(w32olenext);
rxfunc(w32olecleanup);
rxfunc(w32olegetid);
rxfunc(w32olegetarray);
rxfunc(w32oleputarray);
rxfunc(w32openbackupeventlog);
rxfunc(w32openeventlog);
rxfunc(w32putproperty);
rxfunc(w32regclosekey);
rxfunc(w32regconnectregistry);
rxfunc(w32regcreatekey);
rxfunc(w32regdeletekey);
rxfunc(w32regdeletevalue);
rxfunc(w32regenumkey);
rxfunc(w32regenumvalue);
rxfunc(w32regflushkey);
rxfunc(w32reggetkeysecdesc);
rxfunc(w32regloadkey);
rxfunc(w32regopenkey);
rxfunc(w32regqueryinfokey);
rxfunc(w32regqueryvalue);
rxfunc(w32regqueryvaluetype);
rxfunc(w32regrestorekey);
rxfunc(w32regsavekey);
rxfunc(w32regsetkeysecdesc);
rxfunc(w32regsetvalue);
rxfunc(w32regunloadkey);
rxfunc(w32releaseobject);
rxfunc(w32writeeventlog);
rxfunc(w32cleareventlog);
rxfunc(w32geterror);
rxfunc(w32debug);

/* service control manager interface */
rxfunc(w32svcstart);
rxfunc(w32svcstop);
rxfunc(w32svcremove);
rxfunc(w32svcinstall);

/* shell interface */
rxfunc(w32menuadditem);
rxfunc(w32menuedititem);
rxfunc(w32menumoveitem);
rxfunc(w32menumove);
rxfunc(w32menuremoveitem);

/* program execution */
rxfunc(w32execute);
rxfunc(w32executestem);
rxfunc(w32funcadd);
rxfunc(w32funcdrop);
rxfunc(w32funcquery);

/* system information & control */
rxfunc(w32sysgetusername);
rxfunc(w32sysgetcomputername);
rxfunc(w32syssetcomputername);
rxfunc(w32sysgethardwareprofilename);
rxfunc(w32sysshutdown);
rxfunc(w32syssetpowerstate);
rxfunc(w32sysgetpowerstatus);
rxfunc(w32sysgetosversion);
rxfunc(w32sysgetcolours);
rxfunc(w32syssetcolours);
rxfunc(w32sysgetparameter);
rxfunc(w32syssetparameter);
rxfunc(w32sysshortfilename);
rxfunc(w32syslongfilename);
rxfunc(w32sysfullfilename);

/* common dialogs */
rxfunc(w32dlgopenfile);
rxfunc(w32dlgsavefile);
rxfunc(w32dlgchoosecolor);
rxfunc(w32dlgchoosecolour);


/* clipboard */
rxfunc(w32clipgetstem);
rxfunc(w32clipget);
rxfunc(w32clipsetstem);
rxfunc(w32clipset);
rxfunc(w32clipopen);
rxfunc(w32clipclose);
rxfunc(w32clipregisterformat);
rxfunc(w32clipenumformat);
rxfunc(w32clipformatname);
rxfunc(w32clipempty);
rxfunc(w32cliptestformat);

rxfunc(w32dropfuncs);
rxfunc(w32loadfuncs);

#ifndef EVENTLOG_SUCCESS
# define EVENTLOG_SUCCESS 0
#endif
