/* rexx */
signal on error
signal on syntax  name error
signal on halt    name error
signal on failure name error
'@echo off'

'cls'
say
say 'G2BLOB --- Testing REXXGDB2.DLL BLOB function(s)'
say 'Simon Husin (husin@ibm.net)'
say 'Kent, Washington, U.S.A., November 1996'
say

sq5 = "SELECT picture from emp_photo where empno = '000130' and translate(photo_format) = 'GIF'"

if rxfuncquery('g2LoadFuncs') then do
   say
   say 'Loading REXXGDB2 Functions...'
   call rxfuncadd 'g2LoadFuncs', 'REXXGDB2', 'g2LoadFuncs'
   say 'Result =' g2LoadFuncs()
   end

say
say 'Connecting to SAMPLE database...'
call g2connectshare 'SAMPLE'

say
say  'SQ5='sq5
say

call time 'R'
say  'G2SELECTBLOB RESULT 1 (SQ5 Value)='g2selectblob(sq5,   'PHOTO1.GIF')
say  '---elapse   ='time('R')
say
say  'G2SELECTBLOB RESULT 2 (SQ5)......='g2selectblob('sq5', 'PHOTO2.GIF')
say  '---elapse   ='time('R')
say
say  'G2SELECTBLOB RESULT 3 (value)....='g2selectblob("SELECT picture from emp_photo where empno = '000130' and translate(photo_format) = 'GIF'", 'PHOTO3.GIF')
say  '---elapse   ='time('R')
say
say  'Retrieving (using SQ5 Value) 100 times...'
do 100
   call g2selectblob sq5, 'PHOTO4.GIF'
   end
elapse = time('R')
say  '---elapse   ='elapse '(total),  'elapse / 100 '(per call on average)'

say
say 'Commiting...'
call g2commit
return 0



error:
say 'Error detected at line' SIGL
return 10

syntax:
say 'Syntax error detected at line' SIGL
return 20
