/* rexx */
parse arg argument

signal on error
signal on syntax  name error
signal on halt    name error
signal on failure name error
'@echo off'

if pos('"', argument) = 0 then
   sql = strip(argument)
else
   parse var argument '"' sql '"' .
sql = strip(sql)
if sql = '' then
   sql = 'select name from staff where length(name) = ' ||,
                 '(select max(length(name)) from staff)'
'cls'
say
say 'G2One --- Testing REXXGDB2.DLL function: G2SelectOne'
say 'Simon Husin (husin@ibm.net)'
say 'Kent, Washington, U.S.A., December 1995'
say
say 'SQL:' sql

if rxfuncquery('g2LoadFuncs') then do
   say
   say 'Loading REXXGDB2 Functions...'
   call rxfuncadd 'g2LoadFuncs', 'REXXGDB2', 'g2LoadFuncs'
   say 'Result =' g2LoadFuncs()
   end

say
call time 'R'
say 'Connecting to SAMPLE database...'
call g2connectshare 'SAMPLE'
say 'Execution time    ' time('E') / 1

say
call time 'R'
returned = g2selectone(sql)
elapse = time('E')
say 'SelectOne returns ' returned
say '           length ' length(returned)
say ' G2SQLCODE        ' g2sqlcode
say 'Execution time    ' elapse / 1

if g2sqlcode \= 0 |,
   returned \= '' then do
   say
   call time 'R'
   say 'Commiting...'
   call g2commit
   say 'Execution time    ' time('E') / 1
   return /* returned value is not NULL */
   end

say
say 'Enter any character(s) to do the same query to replace NULL char.'
parse pull nullchar

say
call time 'R'
returned = g2selectone(sql, nullchar)
elapse = time('E')
say 'SelectOne returns ' returned
say '           length ' length(returned)
say ' G2SQLCODE        ' g2sqlcode
say 'Execution time    ' elapse / 1

say
call time 'R'
say 'Commiting...'
call g2commit
say 'Execution time    ' time('E') / 1
return 0



error:
say 'Error detected...'
return 10

syntax:
say 'Syntax error detected...'
return 20
