/* DOS program to "slurp" the entire exetnded attrbibutes structure   */
/* file from within an OS/2 VDM session.                              */
/* Author: David W. Noon, October 1997                                */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include <malloc.h>
#include <dos.h>

#include "vdmutils.h"

/* This is a hack among hacks */
static void far *PtrAdd(void far *p, short o)
{
   return MK_FP(FP_SEG(p),FP_OFF(p)+o);
}

int main(int argc, char *argv[])
{
   if (_osmajor < 20)
      fputs("This does not look like an OS/2 VDM session.",stderr);
   else if (argc != 2)
      fputs("You must supply a path/filename.",stderr);
   else
   {
      FILESTATUS Base_attrs;
      USHORT rc;

      /* Obtain size of EA structure required */
      rc = DwnQPathInfo(argv[1],FIL_QUERYEASIZE,&Base_attrs,sizeof(FILESTATUS));
      if (rc == 0)
      {
         if (Base_attrs.cbList >= 4)
         {
            PEAOP EA_struct_ptr;
            PFEA  EA_ptr;
            USHORT Bytes_done;
            char *EA_name, *EA_value;
            int i;
            unsigned short *EA_short;

            /* We will allocate the EA_name area on the near heap, since the
               Watcom run-time library has a bug in which, if the first heap
               allocation call is _fmalloc(), the memory area abutting the
               current DGROUP is consumed, thus preventing creation of a near
               heap. Allocating some near storage first prevents this theft. */

            EA_name = malloc(32);  /* Name length max of 32 bytes */
            if (EA_name != NULL)
            {
               /* Allocate both FEAList and GEAList as full size */
               EA_struct_ptr = (PEAOP) _fmalloc(Base_attrs.cbList*2+sizeof(EAOP));
               if (EA_struct_ptr != NULL)
               {
                  /* Prime the pointers and lengths that anchor the 2 lists */
                  EA_struct_ptr->fpFEAList = (PFEALIST) PtrAdd(EA_struct_ptr,sizeof(EAOP));
                  EA_struct_ptr->fpFEAList->cbList = Base_attrs.cbList;
                  EA_struct_ptr->fpGEAList = (PGEALIST) PtrAdd(EA_struct_ptr->fpFEAList,Base_attrs.cbList);
                  EA_struct_ptr->fpGEAList->cbList = Base_attrs.cbList;

                  /* Read all the EA's in a single request to the file system */
                  rc = DwnQPathInfo(argv[1],FIL_QUERYALLEAS,EA_struct_ptr,Base_attrs.cbList+sizeof(EAOP));
                  if (rc == 0)
                  {
                     printf("EA structure for %s\n\nName\tHexadecimal Value\n",argv[1]);

                     /* We will now "run" the FEAList structure array */
                     Bytes_done = 4U;
                     EA_ptr = &(EA_struct_ptr->fpFEAList->list[0]);
                     do
                     {
                        /* Copy EA name to near storage for printing */
                        _fstrcpy(EA_name,EA_ptr->szName);

                        /* Copy EA value to near storage for printing */
                        EA_value = malloc(EA_ptr->cbValue);
                        /* Alias the bytes with unsigned short integers */
                        EA_short = (unsigned short *) EA_value;
                        if (EA_value != NULL)
                        {
                           _fmemcpy(EA_value,PtrAdd(EA_ptr,EA_ptr->cbName+5),EA_ptr->cbValue);

                           fputs(EA_name,stdout);
                           putchar('\t');
                           for (i = 0; i < EA_ptr->cbValue/sizeof(short); i++)
                              printf("%04X ",EA_short[i]);
                           if (EA_ptr->cbValue > i*sizeof(short))
                              printf("%0*X",(EA_ptr->cbValue-i*sizeof(short))*2,EA_short[i]);
                           putchar('\n');

                           /* Release near memory */
                           free(EA_value);
                        }
                        else
                           fprintf(stderr,"Unable to allocate %u bytes for EA %s.\n",
                                 EA_ptr->cbValue,EA_name);

                        Bytes_done += (EA_ptr->cbName + EA_ptr->cbValue + 7U) & 0xFFFCU;

                        EA_ptr = (PFEA) PtrAdd(EA_ptr,(EA_ptr->cbName+EA_ptr->cbValue+7U)&0xFFFCU);
                     } while (Bytes_done < EA_struct_ptr->fpFEAList->cbList);
                  }
                  else
                     fprintf(stderr,"Return code %u when slurping EA structure of %s",rc,argv[1]);

                  _ffree(EA_struct_ptr);
               }
               else
                  fprintf(stderr,"Unable to allocate %u bytes for EA structure.\n",Base_attrs.cbList);

               free(EA_name);
            }
            else
               fputs("No near heap storage available at all!",stderr);
         }
         else
            printf("Path %s has no extended attributes.",argv[1]);

      }
      else
         fprintf(stderr,"Return code %u when querying EA size of %s",rc,argv[1]);
   }
   return 0;
}
