unit IBMSO32;

{$OrgName+ }

interface

uses OS2Def;

{$CDECL+}
  (****************************************************************************)
  function IBM_accept(SFamily:  ULong;
                      SAddr:    pointer;
                      SAddrL:   pointer): APIRET;
  (****************************************************************************)
  function IBM_bind(SSocket:    ULong;
                    SAddr:      pointer;
                    SAddrLen:   ULong):   APIRET;
  (****************************************************************************)
  function IBM_connect(SSocket: ULong;
                       SAddr:   pointer;
                       SAddrLen:ULong):   APIRET;
  (****************************************************************************)
  function IBM_gethostid: APIRET;
  (****************************************************************************)
  function IBM_getsockname(SSocket: ULong;
                           SName:   pointer;
                           SLength: pointer): APIRET;
  (****************************************************************************)
  function IBM_ioctl(SSocket:  ULong;
                     SRequest: longint;
                     SArgP:    pointer): APIRET;
  (****************************************************************************)
  function IBM_listen(SSocket: ULong;
                      SQueue:  ULong): APIRET;
  (****************************************************************************)
  function IBM_recv(SSocket:   ULong;
                    SBuffer:   pointer;
                    SLength:   ULong;
                    SFlags:    ULong): APIRET;
  (****************************************************************************)
  function IBM_send(SSocket:   ULong;
                    SBuffer:   pointer;
                    SLength:   ULong;
                    SFlags:    ULong): APIRET;
  (****************************************************************************)
  function IBM_socket(SDomain:    ULong;
                     SType:      ULong;
                     SProtocol:  ULong): APIRET;
  (****************************************************************************)
  function IBM_soclose(SProtocol: ULong): APIRET;
  (****************************************************************************)
  function IBM_sock_errno: APIRET;
  (****************************************************************************)
  function IBM_shutdown(SSocket: ULong;
                        SFlags:  ULong): APIRET;
  (****************************************************************************)
  function IBM_sock_init: APIRET;
  (****************************************************************************)
{$CDECL-}

implementation

const
  Version    = '00.90';
  UseString:  string = '@(#)import interface unit for IBM TCP/IP so32dll.dll'+#0;
  CopyRight1: string = '@(#)ibmso32dll Version '+Version+' - 10.10.96'+#0;
  CopyRight2: string = '@(#)(C) Chr.Hohmann BfS ST2.2 1996'+#0;


{$CDECL+}
  function IBM_accept;                      external;
  function IBM_bind;                        external;
  function IBM_connect;                     external;
  function IBM_gethostid;                   external;
  function IBM_getsockname;                 external;
  function IBM_ioctl;                       external;
  function IBM_listen;                      external;
  function IBM_recv;                        external;
  function IBM_send;                        external;
  function IBM_socket;                      external;
  function IBM_soclose;                     external;
  function IBM_sock_errno;                  external;
  function IBM_shutdown;                    external;
  function IBM_sock_init;                   external;
{$CDECL-}

end.
