unit SOCKET;

interface

uses OS2Def,
     IBMSO32,IBMTCP32;



  const
    InAddr_Any     =  0;
    SockAddr_Len   = 16;
    In_Addr_Len    =  4;

    AF_UNSPEC      =  0;
    AF_UNIX        =  1;
    AF_INET        =  2;
    AF_IMPLINK     =  3;
    AF_PUP         =  4;
    AF_CHAOS       =  5;
    AF_NS          =  6;
    AF_NBS         =  7;
    AF_ECMA        =  8;
    AF_DATAKIT     =  9;
    AF_CCITT       = 10;
    AF_SNA         = 11;
    AF_MAX         = 17;

    SOCK_NULL      =  0;
    SOCK_STREAM    =  1;
    SOCK_DGRAM     =  2;
    SOCK_RAW       =  3;
    SOCK_RDM       =  4;
    SOCK_SEQPACKET =  5;

    IPPROTO_NULL   =  0;
    IPPROTO_UP     =  1;
    IPPROTO_TCP    =  2;

    FIONBIO        =  1;

  type
    In_Addr_Ptr    = ^In_Addr;
    In_Addr        = record
                       case integer of
                         0: (IPAddr:   ULong);
                         1: (ClassA:   byte;
                             ClassB:   byte;
                             ClassC:   byte;
                             ClassD:   byte)
                     end;
    SockAddr_In_Ptr= ^SockAddr_In;
    SockAddr_In    = record
                       case integer of
                         0: (Sa_Family:  word;
                             Sa_Addr:    array[1..14] of byte);
                         1: (Sin_Family: word;
                             Sin_Port:   word;
                             Sin_Addr:   In_Addr;
                             Sin_Zero:   array[1.. 8] of byte);
                     end;
    HostEnt_Ptr   = ^HostEnt;
    HostEnt       = record
                      H_Name:      ^string;
                      H_Alias:     pointer;
                      H_AddrType:  longint;
                      H_Length:    longint;
                      H_Addr_List: ^In_Addr_Ptr;
                    end;

  (****************************************************************************)
   function SockAccept(SockHandle:  ULong;
                       SockAddr:    SockAddr_In_Ptr;
                       SockAddrLen: ULong): ApiRet;
  (****************************************************************************)
   function SockBind(SockHandle:  ULong;
                     SockAddr:    SockAddr_In_Ptr;
                     SockAddrLen: ULong): ApiRet;
  (****************************************************************************)
   function SockConnect(SockHandle:  ULong;
                        SockAddr:    SockAddr_In_Ptr;
                        SockAddrLen: ULong): ApiRet;
  (****************************************************************************)
   function SockShutdown(SockHandle:  ULong;
                        SockFlags:   ULong): ApiRet;
  (****************************************************************************)
   function SockGetHostID: ULong;
  (****************************************************************************)
   function SockGetSockname(SockHandle: ULong): string;
  (****************************************************************************)
   function SockSetBlockingIO(SockHandle: ULong;
                              BlockingIO: boolean): ApiRet;
  (****************************************************************************)
   function SockListen(SockHandle: ULong;
                       SockQueue:  ULong): ApiRet;
  (****************************************************************************)
   function SockRecv(SockHandle: ULong;
                     SockBuffer: pointer;
                     SockBufLen: ULong;
                     SockFlags:  ULong): ApiRet;
  (****************************************************************************)
   function SockSend(SockHandle: ULong;
                     SockBuffer: pointer;
                     SockBufLen: ULong;
                     SockFlags:  ULong): ApiRet;
  (****************************************************************************)
   function SockSocket(SockFamily:   word;
                       SockType:     word;
                       SockProtocol: word): ApiRet;
  (****************************************************************************)
   function SockClose(SockHandle: ULong): ApiRet;
  (****************************************************************************)
   function SockErrNo: ApiRet;
  (****************************************************************************)
   function SockInit: ApiRet;
  (****************************************************************************)
   function SockGetHostAddrByName(HostName: string): ULong;
  (****************************************************************************)
   function SockGetHostNameByAddr(HostAddr: In_Addr_Ptr): string;
  (****************************************************************************)
   function SockGetHostname: string;
  (****************************************************************************)
   function htonl(Input: longint): longint;
  (****************************************************************************)
   function htons(Input: word): word;
  (****************************************************************************)

implementation

  const
    Version    = '0.90';
    UseString:  string = '@(#)socket interface unit for IBM TCP/IP'+#0;
    CopyRight1: string = '@(#)socket Version '+Version+' - 10.10.96'+#0;
    CopyRight2: string = '@(#)(C) Chr.Hohmann BfS ST2.2 1996'+#0;

  (****************************************************************************)
  function htonl(Input: longint): longint;
  type
    SwapLong = record
                 case integer of
                   0: (SLong:  longint);
                   1: (SArray: array[1..4] of byte);
               end;
  var
    Inp,Tmp: SwapLong;
  begin
    Inp.SLong     := Input;
    Tmp.SArray[1] := Inp.SArray[4];
    Tmp.SArray[2] := Inp.SArray[3];
    Tmp.SArray[3] := Inp.SArray[2];
    Tmp.SArray[4] := Inp.SArray[1];
    htonl         := Tmp.SLong;
  end;
  (****************************************************************************)
  function htons(Input: word): word;
  type
    SwapWord = record
                 case integer of
                   0: (SWord:  word);
                   1: (SArray: array[1..2] of byte);
               end;
  var
    Inp,Tmp: SwapWord;
  begin
    Inp.SWord     := Input;
    Tmp.SArray[1] := Inp.SArray[2];
    Tmp.SArray[2] := Inp.SArray[1];
    htons         := Tmp.SWord;
  end;
  (****************************************************************************)
  function SockAccept(SockHandle:  ULong;
                      SockAddr:    SockAddr_In_Ptr;
                      SockAddrLen: ULong): ApiRet;
  begin
    SockAccept := IBM_accept(SockHandle,
                             SockAddr,
                             @SockAddrLen);
  end;
  (****************************************************************************)
  function SockBind(SockHandle:  ULong;
                    SockAddr:    SockAddr_In_Ptr;
                    SockAddrLen: ULong): ApiRet;
  begin
    SockBind := IBM_bind(SockHandle,
                         SockAddr,
                         SockAddrLen);
  end;
  (****************************************************************************)
  function SockConnect(SockHandle:  ULong;
                       SockAddr:    SockAddr_In_Ptr;
                       SockAddrLen: ULong): ApiRet;
  begin
    SockConnect := IBM_connect(SockHandle,
                               SockAddr,
                               SockAddrLen);
  end;
  (****************************************************************************)
  function SockShutdown(SockHandle:  ULong;
                        SockFlags:   ULong): ApiRet;
  begin
    SockShutdown := IBM_shutdown(SockHandle,
                                 SockFlags);
  end;

  (****************************************************************************)
  function SockGetHostID: ULong;
  begin
    SockGetHostID := htonl(IBM_gethostid);
  end;
  (****************************************************************************)
  function SockGetSockname(SockHandle: ULong): string;
  var
    rc,
    SLength: longint;
    SName:   string;
  begin
    fillchar(SName,sizeof(SName),#0);
    SLength := 254;
    rc := IBM_getsockname(SockHandle,@SName[1],@SLength);
    if (rc <> -1) then
      SName[0] := char(SLength)
    else
      SName := '';
    SockGetSockname := SName;
  end;
  (****************************************************************************)
  function SockSetBlockingIO(SockHandle: ULong;
                             BlockingIO: boolean): ApiRet;
  var
    Arg: ULong;
  begin
    if BlockingIO then
      Arg := 0
    else
      Arg := 1;
    SockSetBlockingIO := IBM_ioctl(SockHandle,FIONBIO,@Arg);
  end;
  (****************************************************************************)
  function SockListen(SockHandle: ULong;
                      SockQueue:  ULong): ApiRet;
  begin
    SockListen := IBM_listen(SockHandle,SockQueue);
  end;
  (****************************************************************************)
  function SockRecv(SockHandle: ULong;
                    SockBuffer: pointer;
                    SockBufLen: ULong;
                    SockFlags:  ULong): ApiRet;
  begin
    SockRecv := IBM_recv(SockHandle,
                         SockBuffer,
                         SockBufLen,
                         SockFlags);
  end;
  (****************************************************************************)
  function SockSend(SockHandle: ULong;
                    SockBuffer: pointer;
                    SockBufLen: ULong;
                    SockFlags:  ULong): ApiRet;
  begin
    SockSend := IBM_send(SockHandle,
                         SockBuffer,
                         SockBufLen,
                         SockFlags);
  end;
  (****************************************************************************)
  function SockSocket(SockFamily:   word;
                      SockType:     word;
                      SockProtocol: word): ApiRet;
  begin
    SockSocket := IBM_socket(SockFamily,
                             SockType,
                             SockProtocol);
  end;
  (****************************************************************************)
  function SockClose(SockHandle: ULong): ApiRet;
  begin
    SockClose := IBM_soclose(SockHandle);
  end;
  (****************************************************************************)
  function SockErrNo: ApiRet;
  begin
    SockErrNo := IBM_Sock_ErrNo;
  end;
  (****************************************************************************)
  function SockInit: ApiRet;
  begin
    SockInit := IBM_Sock_Init;
  end;
  (****************************************************************************)
  function SockGetHostByName(Hostname: string): pointer;
  begin
    HostName          := HostName+#0;
    SockGetHostByName := IBM_gethostbyname(@HostName[1]);
  end;
  (****************************************************************************)
  function SockGetHostAddrByName(HostName: string): ULong;
  var
    rc:     Hostent_Ptr;
    InAddr: In_Addr;
  begin
    rc := SockGetHostByName(Hostname);
    if (ULong(rc) <> 0) then begin
      InAddr := rc^.H_Addr_List^^;
    end else InAddr.IPAddr := 0;
    SockGetHostAddrByName := InAddr.IPAddr;
  end;
  (****************************************************************************)
  function SockGetHostByAddr(HostAddr:     In_Addr_Ptr;
                             HostAddrLen:  ULong;
                             HostAddrType: ULong): pointer;
  begin
    SockGetHostByAddr := IBM_gethostbyaddr(HostAddr,
                                           HostAddrLen,
                                           HostAddrType);
  end;
  (****************************************************************************)
  function SockGetHostNameByAddr(HostAddr: In_Addr_Ptr): string;
  var
    I:     integer;
    rc:    Hostent_Ptr;
    HName: string;
  begin
    rc := SockGetHostByAddr(HostAddr,
                            In_Addr_Len,
                            AF_INET);
    if (ULong(rc) <> 0) then begin
      HName := '';
      I     := 0;
      while rc^.H_Name^[I] <> #0 do begin
        HName := HName+rc^.H_Name^[I];
        inc(I);
      end;
    end else HName := 'hostname not found';
    SockGetHostNameByAddr := HName;
  end;
  (****************************************************************************)
  function SockGetHostname: string;
  var
    I,
    SResult:  longint;
    HostName: string;
  begin
    fillchar(HostName,sizeof(HostName),#0);
    SResult := IBM_gethostname(@HostName[1],sizeof(HostName));
    I := 1;
    while (I < sizeof(HostName)) and (Hostname[I] <> #0) do inc(I);
    if (I > 1) then
      HostName[0] := char(I)
    else
      HostName    := 'amnesiac';
    SockGetHostname := HostName;
  end;
  (****************************************************************************)

end.
