.*------------------------------------------------------------------------*
.* Yet Another GetKey for REXX                                            *
.*========================================================================*
.* Copyright (c) 2015 VicTor Smirnoff                   iamvic@rambler.ru *
.*                                                                        *
.* Permission is hereby granted, free  of charge, to any person obtaining *
.* a  copy  of  this  software   and   associated   documentation   files *
.* (the  "Software"),  to  deal  in  the  Software  without  restriction, *
.* including without limitation  the rights  to use, copy, modify, merge, *
.* publish, distribute, sublicense,  and/or  sell copies of the Software, *
.* and  to permit persons  to whom  the Software  is furnished  to do so, *
.* subject to the following conditions:                                   *
.*                                                                        *
.* The above  copyright  notice  and  this  permission  notice  shall  be *
.* included in all copies or substantial portions of the Software.        *
.*                                                                        *
.* THE SOFTWARE  IS PROVIDED  "AS IS",  WITHOUT  WARRANTY  OF  ANY  KIND, *
.* EXPRESS OR IMPLIED,  INCLUDING  BUT  NOT LIMITED  TO THE WARRANTIES OF *
.* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. *
.* IN NO EVENT SHALL  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE  FOR ANY *
.* CLAIM, DAMAGES OR OTHER LIABILITY,  WHETHER IN AN ACTION  OF CONTRACT, *
.* TORT  OR  OTHERWISE,  ARISING  FROM,  OUT  OF  OR  IN  CONNECTION WITH *
.* THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.             *
.*------------------------------------------------------------------------*
:h3 id='ru_example'.ਬ
:font facename='Courier' size=14x8 codepage=866.
:p.
:hp2.3.5. ਬ.:ehp2.
:p.
 ⢥ ਬ ਢ ⮢ ਫ, 饥
ࠡ 㭪権 ,   ᮮ饭, 뢮  ࠭  
ࠡ ਫ,  ﬨ.
:p.
:hp2.ਬ 1:ehp2.
:lm margin=5.
:xmp.:color bc=palegray.
Ŀ
 /* The Sample of Yet Another GetKey using */                       
 parse version verrexx                                              
 say verrexx                                                        
                                                                    
 if RxFuncQuery('yaGetKeyLoad') then do                             
    _rc = RxFuncAdd('yaGetKeyLoad', 'yaGetKey', 'yaGetKeyLoad');    
    _rc = :color fc=darkgreen.yaGetKeyLoad():color fc=default.;                                           
 end                                                                
 signal on halt                                                     
                                                                    
 say ''                                                             
 say '1. display version&colon. yaGetKeyVer()'                            
 say ''                                                             
 say 'Version '||:color fc=darkgreen.yaGetKeyVer():color fc=default.                                      
                                                                    
 say ''                                                             
 say '2. display version and about info&colon. yaGetKeyVer(v)'            
 say ''                                                             
 say 'Version '||:color fc=darkgreen.yaGetKeyVer('v.'):color fc=default.                                  
 say v.0about                                                       
 say 'Implemented Function List&colon.'                                   
 do i=1 to v.0                                                      
    say '   '||v.i                                                  
 end;                                                               
                                                                    
 say ''                                                             
 say '3. unlimited key waitig&colon. yaGetKey() or yaGetKey(0)'           
 say 'Press Esc to next test'                                       
 say ''                                                             
 key = '';                                                          
 do while (key \== '1B'x)                                           
    key = :color fc=darkgreen.yaGetKey():color fc=default.;                                               
    if (key == '') then                                             
       say 'key="'||key||'"    '||'KBDERRNO="'||KBDERRNO||'"'       
    else                                                            
       say 'key="'||c2x(key)||'"x   '||'KBDERRNO="'||KBDERRNO||'"'  
 end                                                                
                                                                    
 say ''                                                             
 say '4. restricted key waitig - 5 sec&colon. yaGetKey(5)'                
 say 'Press Esc to next test'                                       
 say ''                                                             
 key = '';                                                          
 do while (key \== '1B'x)                                           
    key = :color fc=darkgreen.yaGetKey(5):color fc=default.;                                              
    if (key == '') then                                             
       say 'key="'||key||'"    '||'KBDERRNO="'||KBDERRNO||'"'       
    else                                                            
       say 'key="'||c2x(key)||'"x   '||'KBDERRNO="'||KBDERRNO||'"'  
 end                                                                
                                                                    
 say ''                                                             
 say '5. unlimited key waitig and state displaying&colon. yaGetKey(0, x)' 
 say 'Press Esc to quit'                                            
 key = '';                                                          
 do while (key \== '1B'x)                                           
    key = :color fc=darkgreen.yaGetKey(0, 'x.'):color fc=default.;                                        
    say ''                                                          
    if (key == '') then                                             
       say 'key="'||key||'"    '||'KBDERRNO="'||KBDERRNO||'"'       
    else                                                            
       say 'key="'||c2x(key)||'"x   '||'KBDERRNO="'||KBDERRNO||'"'  
    say 'x.0scancode="'||c2x(x.0scancode)||'"x'                     
    say 'x.0sysreq_down='||x.0sysreq_down                           
    say 'x.0caps_lock_down='||x.0caps_lock_down                     
    say 'x.0num_lock_down='||x.0num_lock_down                       
    say 'x.0scroll_lock_down='||x.0scroll_lock_down                 
    say 'x.0right_alt_down='||x.0right_alt_down                     
    say 'x.0right_ctrl_down='||x.0right_ctrl_down                   
    say 'x.0left_alt_down='||x.0left_alt_down                       
    say 'x.0left_ctrl_down='||x.0left_ctrl_down                     
    say 'x.0insert_on='||x.0insert_on                               
    say 'x.0caps_lock_on='||x.0caps_lock_on                         
    say 'x.0num_lock_on='||x.0num_lock_on                           
    say 'x.0scroll_lock_on='||x.0scroll_lock_on                     
    say 'x.0either_alt_down='||x.0either_alt_down                   
    say 'x.0either_ctrl_down='||x.0either_ctrl_down                 
    say 'x.0left_shift_down='||x.0left_shift_down                   
    say 'x.0right_shift_down='||x.0right_shift_down                 
 end;                                                               
                                                                    
 say ''                                                             
 say '6. restricted key waitig and state displaying&colon. yaGetKey(5, x)'
 say 'Press Esc to quit'                                            
 key = '';                                                          
 do while (key \== '1B'x)                                           
    key = :color fc=darkgreen.yaGetKey(5, 'x.'):color fc=default.;                                        
    say ''                                                          
    if (key == '') then                                             
       say 'key="'||key||'"    '||'KBDERRNO="'||KBDERRNO||'"'       
    else                                                            
       say 'key="'||c2x(key)||'"x   '||'KBDERRNO="'||KBDERRNO||'"'  
    if (x.0scancode == '') then                                     
       say 'x.0scancode="'||x.0scancode||'"'                        
    else                                                            
       say 'x.0scancode="'||c2x(x.0scancode)||'"x'                  
    say 'x.0sysreq_down='||x.0sysreq_down                           
    say 'x.0caps_lock_down='||x.0caps_lock_down                     
    say 'x.0num_lock_down='||x.0num_lock_down                       
    say 'x.0scroll_lock_down='||x.0scroll_lock_down                 
    say 'x.0right_alt_down='||x.0right_alt_down                     
    say 'x.0right_ctrl_down='||x.0right_ctrl_down                   
    say 'x.0left_alt_down='||x.0left_alt_down                       
    say 'x.0left_ctrl_down='||x.0left_ctrl_down                     
    say 'x.0insert_on='||x.0insert_on                               
    say 'x.0caps_lock_on='||x.0caps_lock_on                         
    say 'x.0num_lock_on='||x.0num_lock_on                           
    say 'x.0scroll_lock_on='||x.0scroll_lock_on                     
    say 'x.0either_alt_down='||x.0either_alt_down                   
    say 'x.0either_ctrl_down='||x.0either_ctrl_down                 
    say 'x.0left_shift_down='||x.0left_shift_down                   
    say 'x.0right_shift_down='||x.0right_shift_down                 
 end;                                                               
                                                                    
 halt&colon.                                                              
 say 'Halted...'                                                    
 _rc = :color fc=darkgreen.yaGetKeyDrop():color fc=default.;                                              
 exit;                                                              

:color bc=default.:exmp.
:lm margin=1.
.br
᫮ 믮  ( ᪮窠 ਢ ᮮ⢥騥 ப
 䠩 CONFIG.SYS)&colon.
:ul compact.
:li.࠭ -  (COUNTRY=007,C&colon.\OS2\SYSTEM\COUNTRY.SYS)
:li. ࠭ - CP866 (CODEPAGE=866,850)
:li.᪫  - RU441 (DEVINFO=KBD,RU441,C&colon.\OS2\KEYBOARD.DCP)
:li. ४祭  
:li.० CapsLock 
:li.० NumLock 
:eul.
:p.
ᯮ짮 ᫥騥 梥&colon.
:ul compact.
:li.:color fc=default.:color fc=default.
- ᮮ饭, 뢮 ਫ  ࠭  ६ 믮
:li.:color fc=darkgreen.񬭮-:color fc=default.
- ਩
:li.:color fc=palegray.ᢥ⫮-:color fc=default.
- ᨬ, ᮮ⢥騩 ⮩  ᠬ ⮩   ⨢ 
᪫ .
.br
ਬ,  ᪫  RU441   ⮩  
ᮮ⢥  ⨭᪠ 㪢 "h" (LATIN LETTER H), ᫨ ⨢  
:link reftype=fn refid=ru_en441.:color fc=darkgreen.⨭:color fc=default.:elink.,
⠪  ᪠ 㪢 "" (CYRILLIC LETTER ER), ᫨ ⨢
:link reftype=fn refid=ru_ru441.:color fc=darkgreen.ਫ:color fc=default.:elink..
:eul.
:p.
:hp2.ਬ 뢮  ࠭:ehp2.
:lm margin=5.
:xmp.:color bc=green.
Ŀ
 C&colon.&bsl.&gt.Sample.cmd                                                                  
 OBJREXX 6.00 18 May 1999                                                        
                                                                                 
 1. display version&colon. yaGetKeyVer()                                               
                                                                                 
 Version 0.07                                                                    
                                                                                 
 2. display version and about info&colon. yaGetKeyVer(v)                               
                                                                                 
 Version 0.07                                                                    
 Yet Another GetKey v0.07; Copyright (c) 2015 VicTor Smirnoff (see MIT License)  
 Implemented Function List&colon.                                                      
    yaGetKeyLoad                                                                 
    yaGetKey                                                                     
    yaGetKeyVer                                                                  
    yaGetKeyDrop                                                                 
                                                                                 
 3. unlimited key waitig&colon. yaGetKey() or yaGetKey(0)                              
 Press Esc to next test                                                          
                                :color fc=darkgreen.&lt.--- ४祭  :color fc=default.                     
 key="68"x   KBDERRNO=""     :color fc=darkgreen.&lt.---  H:color fc=palegray./:color fc=darkgreen. (LATIN SMALL LETTER H):color fc=default.              
 key="48"x   KBDERRNO=""     :color fc=darkgreen.&lt.---  Shift+H:color fc=palegray./:color fc=darkgreen. (LATIN CAPITAL LETTER H):color fc=default.      
 key="08"x   KBDERRNO=""     :color fc=darkgreen.&lt.---  Ctrl+H:color fc=palegray./:color fc=darkgreen. (BACKSPACE):color fc=default.                    
 key="0023"x   KBDERRNO=""   :color fc=darkgreen.&lt.---  Alt+H:color fc=palegray./:color fc=default.                                 
                                :color fc=darkgreen.&lt.--- ४祭  :color fc=default.                    
 key="E0"x   KBDERRNO=""     :color fc=darkgreen.&lt.---  :color fc=palegray.H/:color fc=darkgreen. (CYRILLIC SMALL LETTER ER):color fc=default.          
 key="90"x   KBDERRNO=""     :color fc=darkgreen.&lt.---  Shift+:color fc=palegray.H/:color fc=darkgreen. (CYRILLIC CAPITAL LETTER ER):color fc=default.  
 key="08"x   KBDERRNO=""     :color fc=darkgreen.&lt.---  Ctrl+:color fc=palegray.H/:color fc=darkgreen. (BACKSPACE):color fc=default.                    
 key="0023"x   KBDERRNO=""   :color fc=darkgreen.&lt.---  Alt+:color fc=palegray.H/:color fc=darkgreen.:color fc=default.                                 
                                                                                 
 key="E048"x   KBDERRNO=""   :color fc=darkgreen.&lt.---  GrayArrowUp:color fc=default.                             
 key="E048"x   KBDERRNO=""   :color fc=darkgreen.&lt.---  Shift+GrayArrowUp:color fc=default.                       
 key="E08D"x   KBDERRNO=""   :color fc=darkgreen.&lt.---  Ctrl+GrayArrowUp:color fc=default.                        
 key="0098"x   KBDERRNO=""   :color fc=darkgreen.&lt.---  Alt+GrayArrowUp:color fc=default.                         
                                                                                 
 key="003C"x   KBDERRNO=""   :color fc=darkgreen.&lt.---  F2:color fc=default.                                      
 key="0055"x   KBDERRNO=""   :color fc=darkgreen.&lt.---  Shift+F2:color fc=default.                                
 key="005F"x   KBDERRNO=""   :color fc=darkgreen.&lt.---  Ctrl+F2:color fc=default.                                 
 key="0069"x   KBDERRNO=""   :color fc=darkgreen.&lt.---  Alt+F2:color fc=default.                                  
                                                                                 
 key="1B"x   KBDERRNO=""     :color fc=darkgreen.&lt.---  Esc:color fc=default.                                     
                                                                                 
 4. restricted key waitig - 5 sec&colon. yaGetKey(5)                                   
 Press Esc to next test                                                          
                                :color fc=darkgreen.&lt.---  2 ᥪ㭤:color fc=default.                          
 key=""    KBDERRNO=""       :color fc=darkgreen.&lt.--- ॢ襭 ⠩:color fc=default.                               
                                :color fc=darkgreen.&lt.--- ४祭  :color fc=default.                     
 key="68"x   KBDERRNO=""     :color fc=darkgreen.&lt.---  H:color fc=palegray./:color fc=darkgreen. (LATIN SMALL LETTER H):color fc=default.              
 key="48"x   KBDERRNO=""     :color fc=darkgreen.&lt.---  Shift+H:color fc=palegray./:color fc=darkgreen. (LATIN CAPITAL LETTER H):color fc=default.      
                                :color fc=darkgreen.&lt.--- ४祭  :color fc=default.                    
 key="E0"x   KBDERRNO=""     :color fc=darkgreen.&lt.---  :color fc=palegray.H/:color fc=darkgreen. (CYRILLIC SMALL LETTER ER):color fc=default.          
 key="90"x   KBDERRNO=""     :color fc=darkgreen.&lt.---  Shift+:color fc=palegray.H/:color fc=darkgreen. (CYRILLIC CAPITAL LETTER ER):color fc=default.  
                                                                                 
 key="E048"x   KBDERRNO=""   :color fc=darkgreen.&lt.---  GrayArrowUp:color fc=default.                             
 key="003C"x   KBDERRNO=""   :color fc=darkgreen.&lt.---  F2:color fc=default.                                      
                                :color fc=darkgreen.&lt.---  2 ᥪ㭤:color fc=default.                          
 key=""    KBDERRNO=""       :color fc=darkgreen.&lt.--- ॢ襭 ⠩:color fc=default.                               
                                :color fc=darkgreen.&lt.---  2 ᥪ㭤:color fc=default.                          
 key=""    KBDERRNO=""       :color fc=darkgreen.&lt.--- ॢ襭 ⠩:color fc=default.                               
                                :color fc=darkgreen.&lt.---  2 ᥪ㭤:color fc=default.                          
 key=""    KBDERRNO=""       :color fc=darkgreen.&lt.--- ॢ襭 ⠩:color fc=default.                               
 key="1B"x   KBDERRNO=""     :color fc=darkgreen.&lt.---  Esc:color fc=default.                                     
                                                                                 
 5. unlimited key waitig and state displaying&colon. yaGetKey(0, x)                    
 Press Esc to quit                                                               
                                :color fc=darkgreen.&lt.--- ४祭  :color fc=default.                     
 key="0098"x   KBDERRNO=""   :color fc=darkgreen.&lt.---  Ctrl+Alt+Shift+GrayArrowUp:color fc=default.              
 x.0scancode="98"x              :color fc=darkgreen.&lt.--- ன  ᨬ쭮 ᪠:color fc=default.        
 x.0sysreq_down=0                                                                
 x.0caps_lock_down=0                                                             
 x.0num_lock_down=0                                                              
 x.0scroll_lock_down=0                                                           
 x.0right_alt_down=0                                                             
 x.0right_ctrl_down=0                                                            
 x.0left_alt_down=1             :color fc=darkgreen.&lt.---  Alt 㤥ঠ  ⮬ ﭨ:color fc=default.       
 x.0left_ctrl_down=1            :color fc=darkgreen.&lt.---  Ctrl 㤥ঠ  ⮬ ﭨ:color fc=default.      
 x.0insert_on=0                                                                  
 x.0caps_lock_on=0                                                               
 x.0num_lock_on=1               :color fc=darkgreen.&lt.--- ० NumLock :color fc=default.                       
 x.0scroll_lock_on=0                                                             
 x.0either_alt_down=1           :color fc=darkgreen.&lt.---  Alt-, 㤥ঠ  ⮬ ﭨ:color fc=default.  
 x.0either_ctrl_down=1          :color fc=darkgreen.&lt.---  Ctrl-, 㤥ঠ  ⮬ ﭨ:color fc=default. 
 x.0left_shift_down=1           :color fc=darkgreen.&lt.---  Shift 㤥ঠ  ⮬ ﭨ:color fc=default.     
 x.0right_shift_down=0                                                           
 Halted...                   :color fc=darkgreen.&lt.---  Ctrl+Break:color fc=default.                              
                                                                                 
 C&colon.&bsl.&gt.                                                                            

:color bc=default.:exmp.
:lm margin=1.
.br
:font facename=default size=0x0.
