/* ***************************************************************** */
/*                                                                   */
/* Licensed Materials - Property of IBM                              */   
/* 5639-B92 (C) Copyright IBM Corp., 1996, 1997                      */  
/* All rights reserved                                               */  
/* US Government Users Restricted Rights - Use, duplication or       */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */             
/*                                                                   */
/* ***************************************************************** */
/*--< Start of Specifications >--------------------------------------*/
/*                                                                   */
/* Program Name: ABJBPAMD                                            */
/*                                                                   */
/* Descriptive Name: Command emulates the copylib read/stow PDS      */
/*                   functions.                                      */
/*                                                                   */
/* Function:                                                         */
/*                                                                   */
/*  Supports 'bpread' and 'bpstow' functions                         */
/*  ddname defines one or more copylib directory(s)                  */
/*  mbrname is the copybook name in the copylib directroy            */
/*  replOldMbr (Y/N) determines if an existing copybook is to        */
/*                  be replaced by 'bpstow' function.                */
/*                                                                   */
/* Input:                                                            */
/*                                                                   */
/*   Description: see Function                                       */
/*                                                                   */
/* Output:                                                           */
/*                                                                   */
/*   Description: see Function                                       */
/*                                                                   */
/* Normal Exit Conditions: rc = 0 processing successful.             */
/*                                                                   */
/* Error Exit Conditions: rc = 4, 20 for BPREAD                      */
/*                        rc = 4, 8, 44, 48 for BPSTOW               */
/*                                                                   */
/* Messages:                                                         */
/*                                                                   */
/* External References:                                              */
/*                                                                   */
/*   Routines:                                                       */
/*                                                                   */
/*   Services:                                                       */
/*                                                                   */
/* Environment Variables: NEWCPYBK, ddname, ECFWORK                  */
/*                                                                   */
/*--< End of Specifications >----------------------------------------*/
/*                                                                   */
/* Change Activity                                                   */
/*                                                                   */
/*   03/14/97 jph  Copyright statement for release 4/97.             */
/*   10/15/97 jph  Incorporate VSE, (replace GetEnv)                 */
/*                                                                   */
/*--< End of specifications >----------------------------------------*/

say "BPAM COMMAND EXECUTING"
arg function ddname mbrname replOldMbr gar
replOldMbr = substr(replOldMbr,1,1)
say function  ddname  mbrname replOldMbr gar
eof_str = "\\\\\/////\\\\\/////-----eeeeeooooofffff" 
eof_str = eof_str||eof_str  /* make it 80 column */
ecfcwork = value("ECFWORK",,"OS2ENVIRONMENT") 
/* GetEnv by calling C DLL                       */
/* envvar = "ECFWORK"
   call ECFGTENV envvar
   ecfcwork = result   */
/* end GetEnv          */
select
   when function == "BPREAD" then call bpread
   when function == "BPSTOW" then call bpstow
/*    when function == "BPWRITE" then call bpwrite    */
otherwise 
   say "oops!  Should not be here."
end  /* select */
exit result

/*--< Function: bpread >----------------------------------*/
/*  return 0 if member found else return 4 or 20          */
/*--------------------------------------------------------*/
bpread:
   /* get ddname directories */
   clibs = getDdnClibs(ddname)
           /* returns clibs = [d1:\]path1;[d2:\]path2;... */
   if clibs \= "" then
      do until clibs = ""
         parse var clibs clib ";" clibs
         /* determine mbrname status */
         if substr(clib,length(clib),1) \= "\" then
            clib = clib||"\"
         member = clib||mbrname||".cpy"
         rc = stream(member, "c", "query exists")
         /* set return code */
         if rc \== "" then do  
            /* "set copybook="||member  file found */
            call read_copybook
            return result
         end  /* Do */
      end /* do */
      return 20  /* member file not found */
   else return 20  /* matching ddname not found */

/*--< getDdnClibs >---------------------------------------*/
/*     clibs = getDdnClibs(ddname)                        */
/*  return clibs string when member found                 */
/*     clibs=[d1:\]path1;[d2:\]path2;...                  */
/*  else return clibs = "" .                              */
/*--------------------------------------------------------*/
/* USE ISPEX VGET TO OBTAIN SEPARATE DDN:DIRS PAIRS */
getDdnClibs:
   listv = ispexec(vget, ddname, clibs)
   interpret listv
   return clibs

/*--< read_copybook >-------------------------------------*/
/*  read entire member into a fixed file.                 */
/*--------------------------------------------------------*/
read_copybook:
   mark_end = "***endofcopy"   /*  mark end of copy book */
   copyline = ecfcwork|| "\copyline.abj"
   copy member copyline
   call lineout copyline, mark_end
   rc = stream(copyline, "c", "open") 
 
   /* rc = stream(member, "c", "open") */
   if rc \== "READY:" then return 52 /* open error */
   else do 
      copyf = ecfcwork || "\copybook.abj"
      call lineout copyf,,1  /* set write position to beginning */
      signal on ERROR
      do forever
      /*   inline = linein(member)  */
      /*   if inline == "" then leave */
         inline = linein(copyline)  
         if inline = "***endofcopy" then leave
         else call lineout copyf, inline
      end  /* Do */
      call lineout copyf, eof_str 
      call lineout copyf  /* closes file */
      return 0
   end  /* Do */
   ERROR: return 4
   
/*--< bpstow >--------------------------------------------*/
/*  Return 0 if normal end                                */
/*  Return 4 if replOldMbr=N but oldmbr exists in clib    */
/*  Return 8 if error during I/O from/to temp files       */
/*  Return 44 if open error (eg. invalid/non-exist path)  */
/*  Return 48 if open error for temp or new file          */
/*--------------------------------------------------------*/
bpstow:
   newcpbkf = value("NEWCPYBK",,"OS2ENVIRONMENT")
   newcpylib = value(ddname,,"OS2ENVIRONMENT")
   curdir = directory() /* save current dir */
   rc = directory(newcpylib)
   if rc = "" then return 44
   else call directory curdir
   tgtfspec = newcpylib||"\"||mbrname||".CPY"
   rc = stream(newcpbkf, "c", "open")
   if rc \=="READY:" then return 48
   rc = stream(tgtfspec, "c", "query exist")
   if rc \=="" & replOldMbr \== "Y" then return 4
   if rc \=="" then  "erase " tgtfspec
   signal on error name NOT_OK  /* I/O error */
   signal on notready name NOT_OK  /* hit EOF before eof_str */
   do forever
      aline = linein(newcpbkf)
      if aline == eof_str then return 0
      call lineout tgtfspec, aline
   end /* do */
NOT_OK:
   return 8
/*--------------------------------------------------------*/
