/*-------------------------------------------------------*/
/* ARDSAMP.CMD                                           */
/* REXX file to populate ARD database                    */
/* 2/27 S.Shafazand updated the copyright year           */
/*-------------------------------------------------------*/

/*********************************************************
* IBM Application Understanding      Version 1 Release 2 *
**********************************************************
*                                                        *
* Licensed Materials - Property of IBM                   *
* 5639-B92                                               *
* (C) Copyright IBM Corp. 1996, 1997, 1998               *
*                                                        *
**********************************************************/

'@ECHO OFF'

arg rest;

line00 = "Populating database with sample data, "
line01 = "Start DATABASE MANAGER Error: SQLCODE = "
line02 = "Error: SQLCODE = "
line03 = "The Application Understanding database does not exist."
line04 = "Create the database then try again. "
line05 = "please wait... "
line06 = "Error: SQLCODE = "
line07 = "Most common causes for this error are: "
line08 = "  - Attempting to populate the database before you "
line09 = "    have run the create step. "
line10 = "  - Exceeding the maximun number of concurrent DB2/2 "
line11 = "    applications. "
line12 = "Error: SQLCODE = "
line13 = "Most common causes for this error are: "
line14 = "  - Attempting to populate the database before you "
line15 = "    have run the create step."
line16 = "  - Exceeding the maximun number of concurrent DB2/2 "
line17 = "    applications. "
line18 = "    "
line19 = "Application Database populated with sample data. "
line20 = "  "
line21 = "Error: SQLCODE = "
line22 = "Press enter to exit Application Database population."
lineconnect   = "Connecting to database."
linecycle     = "Creating Cycle objects."
lineapp       = "Creating Inventory Group objects."
linemakeapp   = "Sample Inventory Group."
linemakecyc1  = "Sample Cycle WK."
linemakecyc2  = "Sample Cycle MO."
linemakecyc3  = "Sample Cycle YR."
linemakejob1  = "Creating Job object"
linemakejob2  = "Creating APP_CONTAINS_JOB"
linemakestep1 = "Creating job step 1..."
linemakestep2 = "Creating job step 2..."
linemakestep3 = "Creating job step 3..."
linemakedds1  = "Creating DD Statement 1..."
linemakedds2  = "Creating DD Statement 2..."
linemakeexec  = "Creating executable' exec_num '..."
linemakeproc  = "Creating procedure for job step 2..."
linemakepgm1  = "Sample Program object."
linemakepgm2  = "Sample EXE_CONTAINS_PGM."
linemakesrc1  = "Sample Source object."
linemakesrc2  = "Sample PGM_CONTAINS_SRC."
linemakelib   = "Sample Library object."

say line00
/*-------------------------------------------------------*/
/* Load DB2/2 APIs                                       */
/*-------------------------------------------------------*/

call RxFuncAdd 'SQLDBS', 'SQLAR', 'SQLDBS'
call RxFuncAdd 'SQLEXEC', 'SQLAR', 'SQLEXEC'
/*Windows uses DB2AR*/
/*call RxFuncAdd 'SQLDBS', 'DB2AR', 'SQLDBS'*/
/*call RxFuncAdd 'SQLEXEC', 'DB2AR', 'SQLEXEC'*/

/*-------------------------------------------------------*/
/* Start database manager                                */
/*-------------------------------------------------------*/

call SQLDBS 'START DATABASE MANAGER'

if SQLCA.SQLCODE \= 0  & SQLCA.SQLCODE \= -1026
then do;
  /*Start DATABASE MANAGER Error: SQLCODE =  SQLCA.SQLCODE */
  line01 = line01 || SQLCA.SQLCODE
  say line01
  rc = 12;
  exit;
end;

/*-------------------------------------------------------*/
/* Connect to database in exclusive mode                 */
/*-------------------------------------------------------*/

call SQLEXEC 'CONNECT TO ARD IN EXCLUSIVE MODE'
if SQLCA.SQLCODE = -1013
  then do;
    /*Error: SQLCODE =  SQLCA.SQLCODE*/
    /*The Application Understanding database does not exist.*/
    /*Create the database then try again. */
    line02 = line02 || SQLCA.SQLCODE
    say line02
    say line03
    say line04
    exit 12;
  end;
  else do;
    if SQLCA.SQLCODE \= 0
      then do;
         /*Error: SQLCODE =  SQLCA.SQLCODE */
         say lineconnect
         line06 = line06 || SQLCA.SQLCODE
         say line06
         exit 12;
      end;
  end;

/*-------------------------------------------------------*/
/* Create sample cycles                                  */
/*-------------------------------------------------------*/

/*Populating database with sample data. */
say line05

call makecyc
if SQLCA.SQLCODE = -1024
  then do;
    /*Error: SQLCODE =  SQLCA.SQLCODE */
    /*Most common causes for this error are: '*/
    /*  - Attempting to populate the database before you */
    /*    have run the create step.*/
    /*  - Exceeding the maximun number of concurrent DB2/2 */
    /*    applications. */

    line06 = line06 || SQLCA.SQLCODE
    say line06
    say line07
    say line08
    say line09
    say line10
    say line11
    exit 12;
  end;
  else do;
    if SQLCA.SQLCODE \= 0
      then do;
         /*Error: SQLCODE =  SQLCA.SQLCODE */
         say linecycle
         line06 = line06 || SQLCA.SQLCODE
         say line06
         exit 12;
      end;
  end;

/*-------------------------------------------------------*/
/* Create sample applications                            */
/*-------------------------------------------------------*/

do app_num = 1 to 5
   call makeapp
   if SQLCA.SQLCODE = -1024
     then do;
       /*Error: SQLCODE =  SQLCA.SQLCODE  */
       /*Most common causes for this error are: */
       /*  - Attempting to populate the database before you */
       /*    have run the create step.*/
       /*  - Exceeding the maximun number of concurrent DB2/2 */
       /*    applications. */

       line12 = line12 || SQLCA.SQLCODE
       say line12
       say line13
       say line14
       say line15
       say line16
       say line17
       exit 12;
  end;
  else do;
    if SQLCA.SQLCODE \= 0
      then do;
         /*Error: SQLCODE =  SQLCA.SQLCODE */
         say lineapp
         line06 = line06 || SQLCA.SQLCODE
         say line06
         exit 12;
      end;
  end;
end

/*-------------------------------------------------------*/
/* Disconnect from the database (automatic commit)       */
/*-------------------------------------------------------*/

call SQLEXEC 'CONNECT RESET'
/*             */
/*Application Database populated with sample data. */
/*           */
say line18
say line19
say line20
say line22
Pull first;
address cmd "exit"

exit

/*-------------------------------------------------------*/
/* Routine to add a new application                      */
/*-------------------------------------------------------*/

makeapp:
   say 'Creating application' app_num'...'

   STATEMENT = 'INSERT INTO APPLICATION VALUES (',
               '''A'||app_num||''',',
               '''Application '||app_num||''',',
               ''' '',',
               ''' '',',
               'USER,''MAKEDATA'', CURRENT DATE,',
               'NULL,NULL,NULL,',
               '0,',
               '''Sample application '||app_num||''')'

   call SQLEXEC 'EXECUTE IMMEDIATE :STATEMENT'
   if SQLCA.SQLCODE = -803 then SQLCA.SQLCODE = 0
   if SQLCA.SQLCODE \= 0 then
   do
     /*Error: SQLCODE =  SQLCA.SQLCODE */
     say linemakeapp
     line21 = line21 || SQLCA.SQLCODE
     say line21
     exit 12;
   end

   do job_num = 1 to 3
      call makejob
   end
   return

/*-------------------------------------------------------*/
/* Routine to add sample cycles                          */
/*-------------------------------------------------------*/

makecyc:
  /* say 'Creating cycles...' */

   STATEMENT = 'INSERT INTO CYCLE VALUES (',
               '''WK'',''Weekly'',',
               'USER,''MAKEDATA'', CURRENT DATE,',
               'NULL,NULL,NULL,',
               '0 )'
   call SQLEXEC 'EXECUTE IMMEDIATE :STATEMENT'
   if SQLCA.SQLCODE = -803 then SQLCA.SQLCODE = 0
   if SQLCA.SQLCODE \= 0 then
   do
     /*Error: SQLCODE =  SQLCA.SQLCODE */
     say linemakecyc1
     line21 = line21 || SQLCA.SQLCODE
     say line21
     exit 12;
   end

   STATEMENT = 'INSERT INTO CYCLE VALUES (',
               '''MO'',''Monthly'',',
               'USER,''MAKEDATA'', CURRENT DATE,',
               'NULL,NULL,NULL,',
               '0 )'
   call SQLEXEC 'EXECUTE IMMEDIATE :STATEMENT'
   if SQLCA.SQLCODE = -803 then SQLCA.SQLCODE = 0
   if SQLCA.SQLCODE \= 0 then
   do
     /*Error: SQLCODE =  SQLCA.SQLCODE */
     say linemakecyc2
     line21 = line21 || SQLCA.SQLCODE
     say line21
     exit 12;
   end

   STATEMENT = 'INSERT INTO CYCLE VALUES (',
               '''YR'',''Yearly'',',
               'USER,''MAKEDATA'', CURRENT DATE,',
               'NULL,NULL,NULL,',
               '0 )'
   call SQLEXEC 'EXECUTE IMMEDIATE :STATEMENT'
   if SQLCA.SQLCODE = -803 then SQLCA.SQLCODE = 0
   if SQLCA.SQLCODE \= 0 then
   do
     /*Error: SQLCODE =  SQLCA.SQLCODE */
     say linemakecyc3
     line21 = line21 || SQLCA.SQLCODE
     say line21
     exit 12;
   end

   return

/*-------------------------------------------------------*/
/* Routine to add a new job                              */
/*-------------------------------------------------------*/

makejob:
  /* say 'Creating job' job_num'...' */

   STATEMENT = 'INSERT INTO JCL_JOB VALUES (',
               '''A'||app_num||'.TEST.JCL'',',
               '''JOB'||job_num||''',',
               '''Job '||job_num||''',',
               '''0'',',
               '''WK'',',
               ''' '',',
               ''' '',',
               'USER,''MAKEDATA'', CURRENT DATE,',
               'NULL,NULL,NULL,',
               '0,',
               '''None'')'

   call SQLEXEC 'EXECUTE IMMEDIATE :STATEMENT'
   if SQLCA.SQLCODE = -803 then SQLCA.SQLCODE = 0
   if SQLCA.SQLCODE \= 0 then
   do
     /*Error: SQLCODE =  SQLCA.SQLCODE */
     say linemakejob1
     line21 = line21 || SQLCA.SQLCODE
     say line21
     exit 12;
   end

   STATEMENT = 'INSERT INTO APP_CONTAINS_JOB VALUES (',
               '''A'||app_num||''',',
               '''A'||app_num||'.TEST.JCL'',',
               '''JOB'||job_num||''')'

   call SQLEXEC 'EXECUTE IMMEDIATE :STATEMENT'
   if SQLCA.SQLCODE = -803 then SQLCA.SQLCODE = 0
   if SQLCA.SQLCODE \= 0 then
   do
     /*Error: SQLCODE =  SQLCA.SQLCODE */
     say linemakejob2
     line21 = line21 || SQLCA.SQLCODE
     say line21
     exit 12;
   end

   call makestep1
   call makestep2
   call makestep3
   call makelib

   return

/*-------------------------------------------------------*/
/* Routine to add a job step                             */
/*-------------------------------------------------------*/

makestep1:

   exec_num = 1
   call makeexec

 /*  say 'Creating job step 1...'  */

   STATEMENT = 'INSERT INTO JOB_STEP VALUES (',
               '''A'||app_num||'.TEST.JCL'',',
               '''JOB'||job_num||''',',
               '10,',
               '''Step 1'',',
               '''4096'',',
               '''A'||app_num||'.TEST.EXECS'||job_num||''',',
               '''EXEC'||exec_num||''',',
               '''Exec '||exec_num||''',',
               'NULL,',
               'NULL,',
               'NULL,',
               'NULL,',
               'NULL,',
               'NULL,',
               'USER,''MAKEDATA'', CURRENT DATE,',
               'NULL,NULL,NULL,',
               '0,',
               ''' '')'

   call SQLEXEC 'EXECUTE IMMEDIATE :STATEMENT'
   if SQLCA.SQLCODE = -803 then SQLCA.SQLCODE = 0
   if SQLCA.SQLCODE \= 0 then
   do
     /*Error: SQLCODE =  SQLCA.SQLCODE */
     say linemakestep1
     line21 = line21 || SQLCA.SQLCODE
     say line21
     exit 12;
   end

   call makedds1

   return

/*-------------------------------------------------------*/
/* Routine to add a second job step (procedure call)     */
/*-------------------------------------------------------*/

makestep2:

   call makeproc

 /*  say 'Creating job step 2...'  */

   STATEMENT = 'INSERT INTO JOB_STEP VALUES (',
               '''A'||app_num||'.TEST.JCL'',',
               '''JOB'||job_num||''',',
               '20,',
               '''Step 2'',',
               '''4096'',',
               'NULL,',
               'NULL,',
               'NULL,',
               '''A'||app_num||'.TEST.PROCS'||job_num||''',',
               '''PROC1'',',
               '''Proc 2'',',
               'NULL,',
               'NULL,',
               'NULL,',
               'USER,''MAKEDATA'', CURRENT DATE,',
               'NULL,NULL,NULL,',
               '0,',
               ''' '')'

   call SQLEXEC 'EXECUTE IMMEDIATE :STATEMENT'
   if SQLCA.SQLCODE = -803 then SQLCA.SQLCODE = 0
   if SQLCA.SQLCODE \= 0 then
   do
     /*Error: SQLCODE =  SQLCA.SQLCODE */
     say linemakestep2
     line21 = line21 || SQLCA.SQLCODE
     say line21
     exit 12;
   end
   return


/*-------------------------------------------------------*/
/* Routine to add a third job step (from procedure call) */
/* Note: The 100 is used here as a test to make sure of  */
/* order based on value not ASCII alphabetical order     */
/*-------------------------------------------------------*/

makestep3:

   exec_num = 2
   call makeexec

 /*  say 'Creating job step 3...'  */

   STATEMENT = 'INSERT INTO JOB_STEP VALUES (',
               '''A'||app_num||'.TEST.JCL'',',
               '''JOB'||job_num||''',',
               '100,',
               '''Step 3'',',
               '''4096'',',
               '''A'||app_num||'.TEST.EXECS'||job_num||''',',
               '''EXEC'||exec_num||''',',
               '''Exec '||exec_num||''',',
               'NULL,',
               'NULL,',
               'NULL,',
               '20,',
               '''A'||app_num||'.TEST.PROCS'||job_num||''',',
               '''PROC1'',',
               'USER,''MAKEDATA'', CURRENT DATE,',
               'NULL,NULL,NULL,',
               '0,',
               ''' '')'

   call SQLEXEC 'EXECUTE IMMEDIATE :STATEMENT'
   if SQLCA.SQLCODE = -803 then SQLCA.SQLCODE = 0
   if SQLCA.SQLCODE \= 0 then
   do
     /*Error: SQLCODE =  SQLCA.SQLCODE */
     say linemakestep3
     line21 = line21 || SQLCA.SQLCODE
     say line21
     exit 12;
   end

   call makedds2

   return

/*-------------------------------------------------------*/
/* Routine to add a DD statement                         */
/*-------------------------------------------------------*/

makedds1:
 /*  say 'Creating DD Statement 1...' */

   STATEMENT = 'INSERT INTO DD_STATEMENT VALUES (',
               '''A'||app_num||'.TEST.JCL'',',
               '''JOB'||job_num||''',',
               '10,',
               '''INFILE'',',
               '''01'',',
               '''A'||app_num||'.TEST.FILES'',',
               ''' '',',
               ''' '',',
               'USER,''MAKEDATA'', CURRENT DATE,',
               'NULL,NULL,NULL,',
               '0 )'

   call SQLEXEC 'EXECUTE IMMEDIATE :STATEMENT'
   if SQLCA.SQLCODE = -803 then SQLCA.SQLCODE = 0
   if SQLCA.SQLCODE \= 0 then
   do
     /*Error: SQLCODE =  SQLCA.SQLCODE */
     say linemakedds1
     line21 = line21 || SQLCA.SQLCODE
     say line21
     exit 12;
   end
   return

/*-------------------------------------------------------*/
/* Routine to add a second DD statement (in procedure)   */
/*-------------------------------------------------------*/

makedds2:
 /*  say 'Creating DD Statement 2...'  */

   STATEMENT = 'INSERT INTO DD_STATEMENT VALUES (',
               '''A'||app_num||'.TEST.JCL'',',
               '''JOB'||job_num||''',',
               '100,',
               '''OUTFILE'',',
               '''01'',',
               '''A'||app_num||'.TEST.FILES'',',
               ''' '',',
               ''' '',',
               'USER,''MAKEDATA'', CURRENT DATE,',
               'NULL,NULL,NULL,',
               '0 )'

   call SQLEXEC 'EXECUTE IMMEDIATE :STATEMENT'
   if SQLCA.SQLCODE = -803 then SQLCA.SQLCODE = 0
   if SQLCA.SQLCODE \= 0 then
   do
     /*Error: SQLCODE =  SQLCA.SQLCODE */
     say linemakedds2
     line21 = line21 || SQLCA.SQLCODE
     say line21
     exit 12;
   end
   return

/*-------------------------------------------------------*/
/* Routine to add an executable                          */
/*-------------------------------------------------------*/

makeexec:
 /*  say 'Creating executable' exec_num '...'  */

   STATEMENT = 'INSERT INTO EXECUTABLE VALUES (',
               '''A'||app_num||'.TEST.EXECS'||job_num||''',',
               '''EXEC'||exec_num||''',',
               '''Exec '||exec_num||''',',
               ''' '',',
               ''' '',',
               'USER,''MAKEDATA'', CURRENT DATE,',
               'NULL,NULL,NULL,',
               '0,',
               ''' '')'

   call SQLEXEC 'EXECUTE IMMEDIATE :STATEMENT'
   if SQLCA.SQLCODE = -803 then SQLCA.SQLCODE = 0
   if SQLCA.SQLCODE \= 0 then
   do
     /*Error: SQLCODE =  SQLCA.SQLCODE */
     say linemakeexec
     line21 = line21 || SQLCA.SQLCODE
     say line21
     exit 12;
   end

   call makepgm

   return

/*-------------------------------------------------------*/
/* Routine to add a procedure                            */
/*-------------------------------------------------------*/

makeproc:
 /*  say 'Creating procedure for job step 2...'  */

   STATEMENT = 'INSERT INTO JCL_PROCEDURE VALUES (',
               '''A'||app_num||'.TEST.PROCS'||job_num||''',',
               '''PROC1'',',
               '''Proc 2'',',
               ''' '',',
               'USER,''MAKEDATA'', CURRENT DATE,',
               'NULL,NULL,NULL,',
               '0 )'

   call SQLEXEC 'EXECUTE IMMEDIATE :STATEMENT'
   if SQLCA.SQLCODE = -803 then SQLCA.SQLCODE = 0
   if SQLCA.SQLCODE \= 0 then
   do
     /*Error: SQLCODE =  SQLCA.SQLCODE */
     say linemakeproc
     line21 = line21 || SQLCA.SQLCODE
     say line21
     exit 12;
   end

   return

/*-------------------------------------------------------*/
/* Routine to add a program unit                         */
/*-------------------------------------------------------*/

makepgm:

  /* say 'Creating program for executable' exec_num '...'  */

   STATEMENT = 'INSERT INTO PGM VALUES (',
               '''A'||app_num||'.TEST.PGMS'||job_num||''',',
               '''PGM'||exec_num||''',',
               '''Prog '||exec_num||''',',
               ''' '',',
               'NULL,',
               'USER,''MAKEDATA'', CURRENT DATE,',
               'NULL,NULL,NULL,',
               '0,',
               ''' '')'

   call SQLEXEC 'EXECUTE IMMEDIATE :STATEMENT'
   if SQLCA.SQLCODE = -803 then SQLCA.SQLCODE = 0
   if SQLCA.SQLCODE \= 0 then
   do
     /*Error: SQLCODE =  SQLCA.SQLCODE */
     say linemakepgm1
     line21 = line21 || SQLCA.SQLCODE
     say line21
     exit 12;
   end

   STATEMENT = 'INSERT INTO EXE_CONTAINS_PGM VALUES (',
               '''A'||app_num||'.TEST.EXECS'||job_num||''',',
               '''EXEC'||exec_num||''',',
               '''A'||app_num||'.TEST.PGMS'||job_num||''',',
               '''PGM'||exec_num||''')'

   call SQLEXEC 'EXECUTE IMMEDIATE :STATEMENT'
   if SQLCA.SQLCODE = -803 then SQLCA.SQLCODE = 0
   if SQLCA.SQLCODE \= 0 then
   do
     /*Error: SQLCODE =  SQLCA.SQLCODE */
     say linemakepgm2
     line21 = line21 || SQLCA.SQLCODE
     say line21
     exit 12;
   end

   call makesrc

   return

/*-------------------------------------------------------*/
/* Routine to add a source                               */
/*-------------------------------------------------------*/

makesrc:

 /*  say 'Creating source for program' exec_num '...'  */

   STATEMENT = 'INSERT INTO SOURCE VALUES (',
               '''A'||app_num||'.TEST.SRC'||job_num||''',',
               '''SRC'||exec_num||''',',
               '''Src '||exec_num||''',',
               ''' '',',
               ''' '',',
               'USER,''MAKEDATA'', CURRENT DATE,',
               'NULL,NULL,NULL,',
               '0 )'

   call SQLEXEC 'EXECUTE IMMEDIATE :STATEMENT'
   if SQLCA.SQLCODE = -803 then SQLCA.SQLCODE = 0
   if SQLCA.SQLCODE \= 0 then
   do
     /*Error: SQLCODE =  SQLCA.SQLCODE */
     say linemakesrc1
     line21 = line21 || SQLCA.SQLCODE
     say line21
     exit 12;
   end

   STATEMENT = 'INSERT INTO PGM_CONTAINS_SRC VALUES (',
               '''A'||app_num||'.TEST.PGMS'||job_num||''',',
               '''PGM'||exec_num||''',',
               '''A'||app_num||'.TEST.SRC'||job_num||''',',
               '''SRC'||exec_num||''')'

   call SQLEXEC 'EXECUTE IMMEDIATE :STATEMENT'
   if SQLCA.SQLCODE = -803 then SQLCA.SQLCODE = 0
   if SQLCA.SQLCODE \= 0 then
   do
     /*Error: SQLCODE =  SQLCA.SQLCODE */
     say linemakesrc2
     line21 = line21 || SQLCA.SQLCODE
     say line21
     exit 12;
   end

   return

/*-------------------------------------------------------*/
/* Routine to add a library                              */
/*-------------------------------------------------------*/

makelib:

 /*  say 'Creating source library for job' job_num '...'  */

   STATEMENT = 'INSERT INTO LIBRARY VALUES (',
               '''A'||app_num||'.TEST.SRC'||job_num||''',',
               ''' '',',
               'USER,''MAKEDATA'', CURRENT DATE,',
               'NULL,NULL,NULL,',
               '0,',
               '''Source library for job '||job_num||''' )'

   call SQLEXEC 'EXECUTE IMMEDIATE :STATEMENT'
   if SQLCA.SQLCODE = -803 then SQLCA.SQLCODE = 0
   if SQLCA.SQLCODE \= 0 then
   do
     /*Error: SQLCODE =  SQLCA.SQLCODE */
     say linemakelib
     line21 = line21 || SQLCA.SQLCODE
     say line21
     exit 12;
   end

   return

