/* ***************************************************************** */
/*                                                                   */
/* Licensed Materials - Property of IBM                              */
/* 5639-B92 (C) Copyright IBM Corp., 1996, 1997                      */
/* All rights reserved                                               */
/* US Government Users Restricted Rights - Use, duplication or       */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/*                                                                   */
/* ***************************************************************** */
/*--< Start of Specifications >--------------------------------------*/
/*                                                                   */
/* Program Name: ECFPARSE                                            */
/*                                                                   */
/* Descriptive Name:  Parser for Reengineering Report                */
/*                                                                   */
/* Licensed Materials - Property of IBM                              */
/*                                                                   */
/* 5639-B92 (C) Copyright IBM Corp. 1996, 1997                       */
/* All rights reserved.                                              */
/* US Government Users Restricted Rights - Use, duplication or       */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/*                                                                   */
/* See Copyright Instructions.                                       */
/*                                                                   */
/* Status = Version 3 Release 1 Level 0                              */
/*                                                                   */
/* Function:                                                         */
/*                                                                   */
/* Input for MVS system                                              */
/*                                                                   */
/*   Symbolic Name: dainput                                          */
/*   Description:   input data set contains reengineering report     */
/*                                                                   */
/*   Symbolic Name: daoutput                                         */
/*   Description:   output data set contains output from parser      */
/*                                                                   */
/* Input for VM system                                               */
/*                                                                   */
/*   Symbolic Name: in it im                                         */
/*   Description:   File name, file type, file mode of the file      */
/*                  contains reengineering report                    */
/*                                                                   */
/*   Symbolic Name: on ot om                                         */
/*   Description:   File name, file type, file mode of the file      */
/*                  contains output from the parser                  */
/*                                                                   */
/*                                                                   */
/* Normal Exit Conditions:                                           */
/*   RC=0                                                            */
/*            Processing completed successfully.                     */
/*                                                                   */
/* Error Exit Conditions:                                            */
/*                                                                   */
/* Messages:                                                         */
/*                                                                   */
/* External References:                                              */
/*                                                                   */
/*   Routines:                                                       */
/*                                                                   */
/*   Services:                                                       */
/*                                                                   */
/*                                                                   */
/*--< End of Specifications >----------------------------------------*/
/*                                                                   */
/*--< Pseudocode >---------------------------------------------------*/
/*                                                                   */
/*   Parse the input parameters                                      */
/*                                                                   */
/*   ALLOCATE input and output datasets if in MVS system.            */
/*   Check to see if the output already exist.  If so, erase it      */
/*                                                                   */
/*   If that is Analysis report, parse 3 sessions.                   */
/*   If that is Generation report, parse 5 sessions.                 */
/*   Any session can be terminated any time by MESSAGES or INDEX     */
/*     session.  If so, read MESSAGES or INDEX part and leave.       */
/*   Otherwise, Normal exit                                          */
/*                                                                   */
/*                                                                   */
/* Change Activity                                                   */
/*                                                                   */
/*   03/01/92 NN   Created                                           */
/*   03/12/95 psw  Modified for OS/2 engine use only                 */
/*   03/14/97 jph  Copyright statement for release 4/97.             */
/*   11/15/97 jph  Full path, (replace GetEnv)                       */
/*                                                                   */
/*--< End of specifications >----------------------------------------*/

   arg CSFPIN  CSFPOUT garb
/***** debug in PM *****************/
   /* trace ?i
   CALL set_msg_file */
/***********************************/

/* initialize error codes */
   retcd     = 0
   allocerr  = 469
   formaterr = 465
   readerr   = 466
   writeerr  = 467
   inputerr  = 384
   outputerr = 385
   modeerr   = 653

/* SAY "***** Starting Report parsing for " CSFPIN CSFPOUT */
   call check_iofiles
   If result \== 0 then do
      if pmdebug == "Y" then call lineout CSFPMSGF, ,
                 "Abnormal exit - retcd,retfile = " retcd retfile
      exit result
   end  /* Do */
   /* initialize constansts */
   true = 1
   false = 0
   delimiter = '01'X
   chart_delimiter = '02'X
   pass_intro = false
   session_num.1 = "1.0"    /* session means section here */
      lsm_begin = "Lsm:"         /* dump of LSM */
      lsm_end = "End of labels"  /* dump ends   */
   session_num.1.1 = "1.1"
   session_num.2 = "2.0"
   session_num.2.1 = "2.1"
   session_num.2.2 = "2.2"
   session_num.2.3 = "2.3"
   session_num.2.4 = "2.4"
   session_num.2.5 = "2.5"
   session_num.2.6 = "2.6"
   session_num.3 = "3.0"
   session_num.3.1 = "3.1"
   session_num.3.2 = "3.2"
   session_num.4 = "4.0"
   session_num.4.1 = "4.1"
   session_num.4.2 = "4.2"
   session_num.5 = "5.0"
   session_num.5.1 = "5.1"
   session_num.5.2 = "5.2"
   session_num.5.3 = "5.3"
   session_num.6 =  "MES"
   session_num.6.1 = "6.1"
   session_num.index =  "Re-"
   start_session_pos = 5
   start_sub_session_pos = 7
   /* read and determine either analysis or generation mode */
   first_page = true
   line = read_n_line(2)
   first_page = false
   pos_found = pos("ANALYSIS",line)
   if pos_found == 0 then  /* not ANALYSIS REPORT */
      DO
         pos_found = pos("GENERATION",line)
         if pos_found > 0 then do
            ANAL = false   /* The report is for generation mode */
            call write_line "Generation"
            end
         else do  /* the file is not reengineering report */
            retcd = modeerr
            retfile = CSFPIN
            call read_index
            exit retcd
         end
      END
   else  /* is ANALYSIS REPORT */
      DO
         ANAL = true    /*The report is for analysis mode */
         call write_line "Analysis"
      END

   /* read and ignore the first introduction part */
   if (ANAL) then line = read_n_line(37)
   else line = read_n_line(57)

   retcd = 0
   DO UNTIL (substr(line, start_session_pos, 3) = session_num.1),
           | (substr(line, start_session_pos, 3) = session_num.6),
           | (substr(line, start_sub_session_pos, 3) = session_num.index)
      line = read_line()
      if retcd \== 0 then leave
   END

   if ( (pos(session_num.index, line)\= 0) | ( retcd \== 0 ) ) then do
      retfile = "NOFILE"
      call read_index
      exit retcd
      end
   if (pos(session_num.6, line)\= 0) then do
      retfile = "NOFILE"
      call read_message(line)
      exit retcd
      end
   if (pos(session_num.1, line) = 0) then do
      retcd = formaterr
      retfile = CSFPIN
      call read_index
      exit retcd
      end
   /* read and write option session - no irregularity found */
   if pmdebug == "Y" then call lineout CSFPMSGF, "calling read_1_0..."
   call read_1_0
   /* read and write Input Program Analysis in ANALYSIS mode or
      Structured program properties in GENERATION mode */
   if pmdebug == "Y" then call lineout CSFPMSGF, "calling read_2_0..."
   call read_2_0

   /* read and write Metrics Report in ANALYSIS mode or Structure Chart
      in GENERATION mode */
   if pmdebug == "Y" then call lineout CSFPMSGF, "calling read_3_0..."
   call read_3_0

   /* read and write Messages in ANALYSIS mode or Modularization
      Analysis in GENERATION mode */
   if (\ANAL) then
   DO
   if pmdebug == "Y" then call lineout CSFPMSGF, "calling read_4_0..."
      call read_4_0
   if pmdebug == "Y" then call lineout CSFPMSGF, "calling read_5_0..."
      call read_5_0
   END
/* This exit should never be reached ! */
   exit 999

READ_INDEX:
   /* read and parse the rest of the file */
   if pmdebug == "Y" then call lineout CSFPMSGF, "  in READ_INDEX..."
   signal on NOTREADY NAME eof
   do forever
      aline = linein(CSFPIN)
      call lineout CSFPOUT, aline
   end
/* Normal exit */
eof:
      signal off NOTREADY
      if pmdebug == "Y" then call lineout CSFPMSGF, "End report parsing..."
   exit 0
   RETURN

/* Abnormal exits */
readNerr:  /* premature CSFPIN eof or read error */
   signal off NOTREADY
   retcd = readerr
   retfile = CSFPIN
   if pmdebug == "Y" then call lineout CSFPMSGF, ,
              "Abnormal exit - retcd,retfile = " retcd retfile
   exit retcd
write_err:
   signal off NOTREADY
   retcd = writeerr
   retfile = CSFPOUT
   call read_index
   if pmdebug == "Y" then call lineout CSFPMSGF, ,
              "Abnormal exit - retcd,retfile = " retcd retfile
   exit retcd

CHECK_IOFILES:
   rc = stream(CSFPIN, "c", "open read")
   if rc \== "READY:" then do     /* input file does not exist */
      retcd = inputerr
      retfile = CSFPIN
      /* SAY "***** End of report parsing " */
      return retcd
   End
   rc = stream(CSFPOUT, "c", "query exists")
   if rc \== "" then "ERASE" CSFPOUT
   rc = stream(CSFPOUT, "c", "open write")
   if rc \== "READY:" then do     /* output file can't be opened */
      retcd = outputerr
      retfile = CSFPOUT
      return retcd
   end  /* Do */
   return 0

SET_MSG_FILE: procedure expose pmdebug CSFPIN CSFPOUT CSFPMSGF
   pmdebug = "Y"
   wpath=value("ECFWORK",,"OS2ENVIRONMENT")
   /* GetEnv by calling C DLL                    */
   /* envvar = "ECFWORK"
      call ECFGTENV envvar
      wpath = result */
   /* end GetEnv     */
   CSFPMSGF = wpath || "\PARSE.MSG"
   rc = stream(CSFPMSGF, "c", "query exists")
   if rc \== "" then "ERASE" CSFPMSGF
   if pmdebug == "Y" then do
      call lineout CSFPMSGF, "I/O filenames: " || CSFPIN CSFPOUT
      call lineout CSFPMSGF, "   on "|| date() || " at " || time()
      call lineout CSFPMSGF, "  "
   end  /* Do */
   return

READ_1_0:
   parse arg line2

   line2 = session_num.1.1 || " SUMMARY OPTIONS"
   call write_sub_session_header line2
   line2 = read_n_line(2)
   call write_line line2
   line2 = read_line()

line2 = read_write(session_num.2,,
              start_session_pos,"0", 1, line2, 9)
   RETURN


READ_2_0:

   line21 = find_sub_str(session_num.2.1,start_sub_session_pos,"0",1)
   if (ANAL) then
   DO
      /* parse sub session 2.1 */
      call write_sub_session_header line21
      line2 = read_n_line(3)  /* need to read 3 lines here */
      if space(line2) \= "No PERFORM statements found." then do
         line2 = find_sub_str("I. ", 9, "I. ", 9)
      end
      line22 = read_write(session_num.2.2,,
                  start_sub_session_pos,"0", 1, line2, 9)

      /* parse sub session 2.2 */
      call write_sub_session_header line22
      line2 = read_n_line(2)  /* need to read 3 lines here */
      line23 = read_write(session_num.2.3,,
                  start_sub_session_pos,"0", 1, line2, 9)

      /* parse sub session 2.3 */
      call write_sub_session_header line23
      line2 = read_n_line(3)  /* need to read only 3 lines here */
      if space(line2) \= "No HANDLE commands found." then do
         line2 = find_sub_str("Inp", 9, "Inp", 9)
      end
      line30 = read_write(session_num.3,,
                  start_session_pos,"0", 1, line2, 9)
   END
   else    /* if in Generation mode */
   DO
      /* parse sub session 2.1 */
      call write_sub_session_header line21
      line2 = read_n_line(2)    /* need to read only 2 lines here */
      line22 = read_write(session_num.2.2,,
                  start_sub_session_pos,"0", 1, line2, 9)

      /* parse sub session 2.2 */
      call write_sub_session_header line22
      line2 = read_n_line(3)   /* need to read 3 lines here */
      if space(line2) \= "No PERFORM statements found." then do
         line2 = find_sub_str("I. ", 10, "I. ", 9)
      end
      line23 = read_write(session_num.2.3,,
                  start_sub_session_pos,"0", 1, line2, 9)
      /* parse sub session 2.3 */
      call write_sub_session_header line23
      line2 = read_n_line(2)   /* need to read only 2 lines here */
      line24 = read_write(session_num.2.4,,
                  start_sub_session_pos,"0", 1, line2, 9)

      /* parse sub session 2.4 */
      call write_sub_session_header line24
      line2 = read_n_line(3)  /* need to read 3 lines here */
      if space(line2) \= "No HANDLE commands found." then do
         line2 = find_sub_str("Inp", 9, "Inp", 9)
      end
      line25 = read_write(session_num.2.5,,
                  start_sub_session_pos,"0", 1, line2, 9)

      /* parse sub session 2.5 */
      call write_sub_session_header line25
      line2 = read_n_line(2)   /* need to read only 2 lines here */
      line26 = read_write(session_num.2.6,,
                  start_sub_session_pos,"0", 1, line2, 9)

      /* parse sub session 2.6 */
      call write_sub_session_header line26
      line2 = read_n_line(2)   /* need to read only 2 lines here */
      line30 = read_write(session_num.3,,
                  start_session_pos,"0", 1, line2, 9)

   END
   RETURN


READ_3_0:

   if (ANAL) then
   DO
      line31 = find_sub_str(session_num.3.1,start_sub_session_pos,,
                 session_num.6, start_session_pos)
      /* parse sub session 3.1 */
   if pmdebug == "Y" then call lineout CSFMSGF, "parsing section 3.1..."
      call write_sub_session_header line31
      line2 = read_n_line(2)  /* need to read only 2 lines here */
      line32 = read_write(session_num.3.2,,
                  start_sub_session_pos,"0", 1, line2, 9)

      /* parse sub session 3.2 */
   if pmdebug == "Y" then call lineout CSFMSGF, "parsing section 3.2..."
      call write_sub_session_header line32
      line2 = read_n_line(2)  /* need to read only 2 lines here */
      line6 = read_write(session_num.6, start_session_pos,,
                 session_num.index,start_sub_session_pos, line2, 9)
   END
   else    /* if in Generation mode */
   DO
      line2 = find_sub_str(session_num.3.1,start_sub_session_pos,,
                 session_num.4, start_session_pos)
      pos_found = pos(session_num.3.1, line2)
      if ( pos_found \= 0 ) then
      /*there is Cross Reference part generated*/
      DO
         /* parse sub session 3.1 */
         call write_sub_session_header line2
         line2 = read_n_line(3)    /* need to read 3 lines here */
         if space(line2) \= "Neither the Output COBOL Report nor the",
                     " Structure Charts were requested." then
         do
            line2 = find_sub_str("Pag", 13, "0", 1)
            line32=read_31(session_num.3.2,start_sub_session_pos,,
                      session_num.4,start_session_pos,line2,13)
         end
         else do
            line32 = read_write(session_num.3.2,,
                        start_sub_session_pos,"0", 1, line2, 9)
         end
         /* parse sub session 3.2 */
         call write_sub_session_header line32
         line2 = read_n_line(3)   /* need to read 3 lines here */
         if space(line2) \= "Structure Charts not requested." then
         do
            line2 = find_sub_str("LIN", 8, "0", 1)
            line2 = parse_structure_chart(session_num.4,,
                    start_session_pos, "0", 1, line2, 8)
         end
         else
            line2 = read_write(session_num.4, start_session_pos,,
                    "0", 1, line2, 8)
      END
      else /* User doesn't request to generate output prog procedure */
      DO
         space(line2) = "Output Program Procedures report not requested"
         call write_sub_session_header session_num.3.1,
             ||" OUTPUT PROGRAM PROCEDURES"
      END
   END

   RETURN


READ_4_0:

   line2 = read_n_line(2)    /* need to read only 2 lines here */
   if ( (space(line2) = "Modularization Analysis not requested."),
      | (substr(line2, 7, 37) = "Modularization Analysis not generated"),
      | (substr(line2, 7, 13) = "No candidates") ) then do
      /* there are no 4.1 and 4.2 generated */
      line2 = space(line2)
      call write_sub_session_header session_num.4.1,
           || " MODULARZATION ANALYSIS"
      call write_line line2
      line50 = find_sub_str(session_num.5,start_session_pos, "0", 1)
   end

   else
   /*there are 4.1 and 4.2 generated */
   DO
      line2 = find_sub_str(session_num.4.1,start_sub_session_pos,,
                 session_num.5, start_session_pos)
      /* parse sub session 4.1 */
      call write_sub_session_header line2
      line2 = read_n_line(11)  /* need to read 11 lines of fixed text */
      line42 = read_write(session_num.4.2,,
                  start_sub_session_pos, session_num.5,,
                  start_session_pos, line2, 9)

      /* parse sub session 4.2 */
      call write_sub_session_header line42
      line2 = read_n_line(3)    /* need to read 3 lines here */
      if space(line2) = "Modularization Table not requested."
      then do
         line50 = read_write(session_num.5, start_session_pos,,
                    "0", 1, line2, 9)
      end
      else do  /* Modularization Table is generated */
         line2 = find_sub_str("STA", 47, "0", 1)
         line50 = read_write(session_num.5, start_session_pos,,
                     "0", 1, line2, 8)
      end
   END
   RETURN


READ_5_0:

   line2 = read_n_line(2)    /* need to read only 2 lines here */
   if (space(line2) = "No PROCEDURE DIVISION found in the input program",
               " no metrics were computed.") then do
      /* There are no 5.1, 5.2, 5.3 generated */
      line2 = space(line2)
      call write_sub_session_header session_num.5.1 || " METRICS REPORT"
      call write_line line2
      line6 = find_sub_str(session_num.6,start_session_pos,,
                           session_num.index,start_sub_session_pos)
   end

   else do
      /* There are 5.1, 5.2, 5.3 generated */
      line51 = find_sub_str(session_num.5.1,start_sub_session_pos,"0",1)

      /* parse sub session 5.1 */
      call write_sub_session_header line51
      line2 = read_n_line(3)    /* need to read 3 lines here */
      if space(line2) = "Not requested." then
      do
         line52 = read_write(session_num.5.2,,
                     start_sub_session_pos,"0", 1, line2, 9)
      end
      else do
         line52 = read_statistic_metric(session_num.5.2,,
                     start_sub_session_pos,"0", 1, line2)
      end

      /* parse sub session 5.2 */
      call write_sub_session_header line52
      line2 = read_n_line(2)   /* need to read only 2 lines here */
      line53 = read_write(session_num.5.3,,
                  start_sub_session_pos,"0", 1, line2, 9)

      /* parse sub session 5.3 */
      call write_sub_session_header line53
      line2 = read_n_line(2)   /* need to read only 2 lines here */
      line6 = read_write(session_num.6, start_session_pos,,
                 session_num.index,start_sub_session_pos, line2, 9)
   end
   RETURN


READ_STATISTIC_METRIC:
   parse arg next_sub_num1,at_pos1,,
   next_sub_num2,at_pos2,,
   line2

   line2 = copies(" ", 37) || "Input Prog" || "  " || "Output Prog"
   call write_line line2
   line2 = copies(" ",  9) || "Metric Name" || copies(' ', 20) ||,
                 "Count" || copies(' ', 7) || "Count"
   retcd = 0
   call write_line line2
   line2 = read_line()
   line2 = copies("-",60)
   call write_line line2
   line2 = read_n_line(3)
   DO UNTIL (( substr(line2, at_pos1, 3) = next_sub_num1 ),
            |( substr(line2, at_pos2, 3) = next_sub_num2 ),
            |( substr(line2, start_session_pos, 3) = session_num.6),
            |( substr(line2, start_sub_session_pos,3) =session_num.index))
         /*if the line is start of page header then ignore next 3 lines*/
         /* if substr(line2,1,1) = "0C"X then */
         /*   line2 = read_n_line(3)          */
         /* else                              */
         do
            line2 = substr(line2,9)
            line = substr(line2,1,36) || substr(line2,43, 10) ||,
                   substr(line2, 59)
            call write_line line
         end
         /* refresh the line */
         line2 = read_line()
         if retcd \== 0 then leave
   END
   if pmdebug == "Y" then call lineout CSFPMSGF, ,
                 "calling CHECK_TERMINATE from READ_STAT_METRIC...retcd= " retcd
   call check_terminate line2, next_sub_num1, next_sub_num2

   RETURN line2


READ_31:
   parse arg sub_num1,pos1,,
   sub_num2,pos2,,
   line2, move_space

   i = 0
   DO UNTIL i = 2
      line2 = substr(line2, move_space)
      line = substr(line2,1,49)
      call write_line line
      line2 = read_line()
      i = i + 1
   END
   retcd = 0
   DO UNTIL (( substr(line2, pos1, 3) = sub_num1 ),
            |( substr(line2, pos2, 3) = sub_num2 ),
            |( substr(line2, start_session_pos, 3) = session_num.6),
            |( substr(line2, start_sub_session_pos,3) =session_num.index))
      line2 = substr(line2, move_space)
      line = substr(line2,1,49)
      call write_line line
      line = substr(line2,50)
      call write_line line
      /* refresh the line */
      line2 = read_line()
      if retcd \== 0 then leave
   END
   if pmdebug == "Y" then call lineout CSFPMSGF, ,
                 "calling CHECK_TERMINATE from READ_31...retcd= " retcd
   call check_terminate line2, sub_num1, sub_num2

   RETURN line2

PARSE_STRUCTURE_CHART:
   parse arg sub_num1, at_pos1,,
   sub_num2, at_pos2,,
   line2, move_space
   retcd = 0
   DO UNTIL ((substr(line2, at_pos1, 3) = sub_num1 ),
            |(substr(line2, at_pos2, 3) = sub_num2 ),
            |(substr(line2, start_session_pos, 3) = session_num.6),
            |(substr(line2, start_sub_session_pos,3) = session_num.index))
      /*if the line is start of page header then ignore next 4 lines*/
      /*if substr(line2,1,1) = "0C"X then */
      /*   line2 = read_n_line(4)         */
      /*else                              */
      if substr(line2,8,4) = "LINE" then
      do
         header2 = line2
         line2 = read_n_line(2)
      end
      else if substr(line2,7,3) = "II." then
         line2 = read_line()
      else if substr(line2,10,2) = " 1" then
         do
         /* start a new chart with chart_delimiter */
         header2 = substr(header2,move_space)
         call write_line chart_delimiter || header2
         call write_line ""
         line2 = substr(line2,move_space)
         call write_line line2
         end
      else
      do
         line = space(line2)
         if (line \= "") then
         do
            line3= substr(line2,move_space)
            call write_line line3
         end
      end
      /* refresh the line */
      line2 = read_line()
      if retcd \== 0 then leave
   END
   if pmdebug == "Y" then call lineout CSFPMSGF, ,
                 "calling CHECK_TERMINATE from PARSE_STRUC_CHART...retcd= " retcd
   call check_terminate line2, sub_num1, sub_num2

   RETURN line2

WRITE_SUB_SESSION_HEADER:
   parse arg header
      header = space(header)
      call write_line delimiter|| header
      line9 = copies("-", length(header) - 3)
      call write_line line9
   RETURN


READ_WRITE:
   parse arg sub_num1, at_pos1, sub_num2, at_pos2, line2, move_space
   if pmdebug == "Y" then call lineout CSFPMSGF, "  in READ_WRITE, args: ",
        sub_num1 at_pos1 sub_num2 at_pos2 move_space
   line2 = space(line2)
   call write_line line2
   if pmdebug == "Y" then call lineout CSFPMSGF, line2
   if pmdebug == "Y" then call lineout CSFPMSGF, ,
                          "  after first write_line, retcd,rc = " retcd rc
   line2 = read_line()
   if pmdebug == "Y" then call lineout CSFPMSGF, line2
   retcd = 0  /* setup for loop exit */
   DO UNTIL ((substr(line2, at_pos1, 3) = sub_num1 ),
            |(substr(line2, at_pos2, 3) = sub_num2 ),
            |(substr(line2, start_session_pos, 3) = session_num.6),
            |(substr(line2, start_sub_session_pos,3) = session_num.index))

      line2 = substr(line2,move_space)
      call write_line line2
      /* refresh the line */
      line2 = read_line()
      if retcd \== 0 then leave
   END
   if pmdebug == "Y" then call lineout CSFPMSGF, ,
                 "  last line read by READ_WRITE is: " line2
   if pmdebug == "Y" then call lineout CSFPMSGF, ,
                 "calling CHECK_TERMINATE from READ_WRITE...retcd= " retcd
   call check_terminate line2, sub_num1, sub_num2

   RETURN line2


FIND_SUB_STR:
   parse arg sub_num1, at_pos1, sub_num2, at_pos2
   line2 = read_line()
   retcd = 0
   DO UNTIL ((substr(line2, at_pos1, 3) = sub_num1),
            |(substr(line2, at_pos2, 3) = sub_num2),
            |(substr(line2, start_session_pos, 3) = session_num.6),
            |(substr(line2, start_sub_session_pos,3) = session_num.index))
      /* refresh the line */
      line2 = read_line()
      if retcd \== 0 then leave
   END
   if pmdebug == "Y" then call lineout CSFPMSGF, ,
                 "calling CHECK_TERMINATE from FIND_SUB_STR...retcd= " retcd
   call check_terminate line2, sub_num1, sub_num2

   RETURN line2


CHECK_TERMINATE:
   parse arg line, sub_str1, sub_str2

   if pmdebug == "Y" then call lineout CSFPMSGF, "  in CHECK_TERMINATE, args= ",
                               line  sub_str1  sub_str2

   if ( (pos(session_num.index, line)\= 0) | ( retcd \== 0 ) ) then do
      retfile = "NOFILE"
      call read_index
      end
   else if (pos(session_num.6, line)\= 0) then do
      retfile = "NOFILE"
      call read_message(line)
      end
   else if ( (pos(sub_str1, line) = 0),
           & (pos(sub_str2, line) = 0)) then do
      retcd = formaterr
      retfile = CSFPIN
      call read_index
   END
   if pmdebug == "Y" then call lineout CSFPMSGF, ,
                "  in CHECK_TERMINATE, retcd,retfile= " retcd retfile
   RETURN

READ_MESSAGE:
   if pmdebug == "Y" then call lineout CSFPMSGF, "  in READ_MESSAGE..."
   parse arg line

   /* parse session MESSAGES */
   line2 = session_num.6.1 || line
   call write_sub_session_header line2
   line2 = read_n_line(1)  /* need to read only 1 lines here */
   line2 = read_write(session_num.index,,
              start_sub_session_pos, "0", 1, line2, 7)
   call read_index
   RETURN

READ_N_LINE:  /* read the n-th line */
   arg n
   DO i = 1 to n
      aline = read_line()
   END
   RETURN  aline /* return the last line read */

READ_LINE:  /* read the next line */
   signal on NOTREADY NAME readNerr
   aline = linein(CSFPIN)
   /* if there is debug data added */
   if substr(aline, 3, 4) == lsm_begin then
   do
      do until substr(aline, 1, 13) = lsm_end
         aline = linein(CSFPIN)
      end  /* Do */
      aline = linein(CSFPIN)  /* skip to next line */
   end
   if first_page == false then do
      np_pos = pos("0C"X, aline)
      if np_pos > 0 then do
         /* skip page header on new page char */
         newline = linein(CSFPIN)
         newline = linein(CSFPIN)
         newline = linein(CSFPIN)
         if np_pos = 1 then aline = linein(CSFPIN)
         else aline = substr(aline, 1, np_pos - 1)
      end  /* Do */
   end  /* Do */
   signal off NOTREADY
   RETURN aline

WRITE_LINE:
   parse arg line
   signal on NOTREADY NAME write_error
   if line \== "" then call lineout CSFPOUT, line
   signal off NOTREADY
   return
