/******************************************************************************/
/*  Licensed Material - Property of IBM                                       */
/*  5639-B92 (C) Copyright IBM Corp., 1995, 1998                              */
/*  All rights reserved.                                                      */
/*  Use Government Users Restricted Rights - Use, duplication or disclosure   */
/*  restricted by GSA ADP Schedule Contract with IBM Corp.                    */
/******************************************************************************/

/* REXX program to create cobsenv.cmd that uses Workframe options to build
 * executable via visual builder make file */

/******OS2 VERSION*****/

/* Arguments:
 *   file_name <nmake_options> */

trace o

/* Set initial values   */

COBOLOPT  = ''
OTHEROPT  = ''
LINKOPT   = ''
MAKEOPT   = '/r /NOLOGO'
BUILDOPT  = ''
CICSOPT   = ''
DEBUGOPT  = ''
FILESIN   = ''
CICSFLAG = 0
MSGOPT = ''
RCOPT = ''
IPFOPT = ''
pa = 0
options = ''
cobsenv = 'cobsenv.cmd'
if stream(cobsenv, 'C', 'QUERY EXISTS') <> '' then
   call SysFileDelete cobsenv

n = SETLOCAL()

call RxFuncAdd 'SysFileDelete' , 'RexxUtil', 'SysFileDelete'
call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'
call RxFuncAdd 'RxMessageBox', 'RexxUtil', 'RxMessageBox'

parse arg argc
remain = strip(argc)

if (remain='' | remain='?') then
   do
      call Help
      exit 8
   end

call extractName
targetFile = fileName
MAKEOPT = MAKEOPT strip(remain)

parse value fileName with targetFileName '.' extension
if pos('.',extension) > 0 then
   do
       say 'Invalid target name' fileName
       exit 97
   end

endpos=pos('\',targetFileName)
if endpos > 0 then
   do while endpos > 0
      targetFileName = strip(substr(targetFileName,endpos+1))
      endpos = pos('\',targetFileName)
   end

optFile = targetFileName || '.opt'

/* Make sure the options file exists */
if stream( optFile, 'c', 'query exists' ) == '' then do
  say optFile " - file doesn't exist"
  exit 98
end

makeFile = targetFileName || '.mak'

/* Make sure the make file exists */
if stream( makeFile, 'c', 'query exists' ) == '' then do
  say makeFile "doesn't exist - generate from Visual Builder"
  exit 99
end

/* Read in options file */
do while lines( optFile )
       options = options ' ' linein( optFile )
end

call processOptions

call createCOBSEnv

n = ENDLOCAL()

       exit 0

/* End of main program */


/* -----Subroutines------------- */

/*-------------extractName--------------------*/
extractName:
/* Current input arguments are in remain; options are last */
/* First argument may be a quoted string */
/* First argument may be fully qulaified with embedded blanks */

do while remain <> ''                        /* Remove options, if any */
   if pos('"',remain) <> 1 then              /* no quotes  */
      do
         if pos('/',remain) = 1 then
            do
               parse value remain with opt remain
               MAKEOPT = MAKEOPT opt
            end /* do */
         else
            do
               parse value remain with fileName remain   /* Discard leading strings; GUI projects have no blanks */
            end
         remain = strip(remain)
      end
   else                                      /* filename in quotes */
      do
         /* look for closing quote  */
         endpos = pos('"',remain,2)
         if endpos = 0 then
            do
               say "Error: Missing closing quote"
               exit 8
            end
         fileName = substr(remain,2,endpos-2)
         remain   = strip(substr(remain,endpos+1))
      end
end /* do while */

return

/*----------createCOBSEnv---------------*/

createCOBSEnv:

call LINEOUT cobsenv,"@echo off"
if RESULT = 1 then call cwrite
call LINEOUT cobsenv,"REM  This command file created by:"
call LINEOUT cobsenv,"REM     IWZBBLDI.CMD"
call LINEOUT cobsenv,"REM"
if COBOLOPT <> "" then
   do
      call LINEOUT cobsenv,'SET PARTCOMPFLAGS=%PARTCOMPFLAGS% -q"' || COBOLOPT || '"'
      if RESULT = 1 then call cwrite
      call LINEOUT cobsenv,'SET APPCOMPFLAGS=%APPCOMPFLAGS% -q"' || COBOLOPT || '"'
      if RESULT = 1 then call cwrite
   end
call LINEOUT cobsenv,"SET CVBDEBUG=" || DEBUGOPT
if RESULT = 1 then call cwrite
call LINEOUT cobsenv,"SET OTHEROPT=" || OTHEROPT
if RESULT = 1 then call cwrite
call LINEOUT cobsenv,"SET PARTLINKFLAGS=%PARTLINKFLAGS% " || LINKOPT
if RESULT = 1 then call cwrite
call LINEOUT cobsenv,"SET APPLINKFLAGS=%APPLINKFLAGS% " || LINKOPT
if RESULT = 1 then call cwrite
call LINEOUT cobsenv,"SET FILESIN=" || FILESIN
if RESULT = 1 then call cwrite
if CICSFLAG = 1 then
   do
      call LINEOUT cobsenv,"SET CICSOPT=CICS(" || CICSOPT || ")"
      if RESULT = 1 then call cwrite
   end

do while buildopt <> ''
   parse var BUILDOPT opt BUILDOPT
   call LINEOUT cobsenv,"SET" opt
   if RESULT = 1 then call cwrite
end

/* check if TXT file exists  */
if stream(targetFileName||".TXM", 'C', 'QUERY EXISTS') <> '' then
call LINEOUT cobsenv,"SET IWZVMSG=YES"

call LINEOUT cobsenv,"SET IWZVMSGOPT=" || MSGOPT
if RESULT = 1 then call cwrite

call LINEOUT cobsenv,"SET IWZVRCOPT=" || RCOPT
if RESULT = 1 then call cwrite

call LINEOUT cobsenv,"SET IWZVIPFOPT=" || IPFOPT
if RESULT = 1 then call cwrite

call LINEOUT cobsenv
if RESULT = 1 then call cwrite

call LINEOUT cobsenv,"@echo Performing iwzomak1" MAKEOPT "/F" makeFile
if RESULT = 1 then call cwrite

call LINEOUT cobsenv,"CALL iwzomak1" MAKEOPT "/F" makeFile
if RESULT = 1 then call cwrite

return

/*-----------processOptions-------------------*/
processOptions:

options=strip(options)
/* parse all options  */
do while options <> ''
   /* look for COBOL options */
   /* COBOL options begin with - */
   select
      /* check for special -pp option  */
      when translate(substr(options,1,4)) == '-PP"' then
         do
               call extractPPOptions
         end  /* end select for -pp processing  */
      /* parse -q" option  */
      when translate(substr(options,1,3)) == '-Q"' then
         do
            options = substr(options,4)          /* remove -q"   */
            /* allow for   -q"... SQL("...") ..... "    */

            qpos = pos('"',options,pos('")',options)+1)    /* find ending " */
         /*   qpos = pos('"',options)  */  /* find ending " */
            if qpos == 0  then
            do
               say 'Error: Unmatched "'
               exit 8
            end  /* end do  */
            opt      = substr(options,1,qpos-1)   /* get options */
            options  = strip(substr(options,qpos+1))
            COBOLOPT = strip(COBOLOPT opt)
         end

      /* parse -b" option  */
      when translate(substr(options,1,3)) == '-B"' then
         do
            options = substr(options,4)          /* remove -B"   */
            qpos = pos('"',options)              /* find ending " */
            if qpos == 0  then
            do
               say 'Error: Unmatched "'
               exit 8
            end /* end do  */
            opt      = substr(options,1,qpos-1)   /* get options */
            options  = strip(substr(options,qpos+1))
            LINKOPT = strip(LINKOPT opt)
         end

      /* parse -g option  */
      when translate(substr(options,1,3)) == '-G ' then
         do
            parse var options opt options
            COBOLOPT = strip(COBOLOPT 'TEST')
            LINKOPT = strip(LINKOPT '/DEBUG')
            DEBUGOPT = 1
         end

      /* parse -p option  */
      when translate(substr(options,1,3)) == '-P ' then
         do
            parse var options opt options
            COBOLOPT = strip(COBOLOPT 'TEST PROFILE')
            LINKOPT = strip(LINKOPT '/DEBUG')
            PA = 1
         end

      /* parse -v option  */
      when translate(substr(options,1,3)) == '-V ' then
         do
            parse var options opt options
            OTHEROPT = strip(OTHEROPT opt)
         end

      /* parse -# option  */
      when substr(options,1,3) == '-# ' then
         do
            parse var options opt options
            OTHEROPT = strip(OTHEROPT opt)
         end

      when translate(substr(options,1,1)) == '-' then
         do
            parse var options opt options
            OTHEROPT = strip(OTHEROPT opt)
         end
      otherwise
         do
            /* check for hpfs  */
            if pos('"',options) <> 1 then                 /* no quotes  */
               do
                  parse var options opt options
                  options = strip(options)
               end
            else                                      /* filename in quotes */
               do
                 /* look for closing quote  */
                  endpos = pos('"',options,2)
                  if endpos = 0 then
                     do
                       say "Error: No closing quote found"
                        exit 8
                     end
                  opt     = substr(options,1,endpos)     /* keep quotes  */
                  options = strip(substr(options,endpos+1))
               end

            select
               when pos('.CBL',translate(opt)) <> 0  then
                  FILESIN = strip(FILESIN opt)

               when pos('.EXE',translate(opt)) <> 0  then
                  if (translate(opt) = translate(targetFile)) then
                     nop
                  ELSE
                     FILESIN = strip(FILESIN opt)

               when pos('.DLL',translate(opt)) <> 0  then
                  if (translate(opt) = translate(targetFile)) then
                     nop
                  ELSE
                     FILESIN = strip(FILESIN opt)

               when pos('.MAP',translate(opt)) <> 0  then
                  FILESIN = strip(FILESIN opt)

               when pos('.DEF',translate(opt)) <> 0  then
                  FILESIN = strip(FILESIN opt)

               when pos('.OBJ',translate(opt)) <> 0  then
                  FILESIN = strip(FILESIN opt)

               when pos('.LIB',translate(opt)) <> 0  then
                  FILESIN = strip(FILESIN opt)

               when pos('.IMP',translate(opt)) <> 0  then
                  FILESIN = strip(FILESIN opt)

               when pos('.VCB',translate(opt)) <> 0  then
                  nop

               otherwise
               do
               end /* end do  */
            end  /* end select  */
         end   /* end do  */
   end /* end select  */
   options = strip(options)
end  /* while  */

/* split buildopt into make, build, msg, and ipf  */
bopt = strip(BUILDOPT)
BUILDOPT = ''
do while bopt <> ''
   /* parse var bopt opt bopt */
   select
      when substr(bopt,1,1) = '/' then     /* all / options are for make  */
         do
            parse var bopt opt bopt
            MAKEOPT = strip(MAKEOPT opt)
         end

      when (substr(translate(bopt),1,4) = 'MSG(') then
         do
            bopt = substr(bopt,5)          /* remove msg(   */
            /* find closing pren  */
            rprenpos = pos(')',bopt)  /* first right pren  */
            if rprenpos == 0 then      /* no right pren  */
               do
                  say 'Error: Unmatched ()'
                  exit 8
               end /* end do  */

            /* find next left pren  */
            nlprenpos = pos('(',bopt,1)

            /* look for other () sets */
            do while (nlprenpos < rprenpos) & (nlprenpos <> 0)
               rprenpos = pos(')',bopt,rprenpos+1)
               if rprenpos == 0 then      /* missing right pren  */
                  do
                     say 'Error: Unmatched ()'
                     exit 8
                  end   /* end do  */
               nlprenpos = pos('(',bopt,nlprenpos+1)
            end /* do */
            MSGOPT  = substr(bopt,1,rprenpos-1)
            bopt = strip(substr(bopt,rprenpos+1))
         end  /* when MSG  */

      when (substr(translate(bopt),1,3) = 'RC(') then
         do
            bopt = substr(bopt,4)          /* remove msg(   */
            /* find closing pren  */
            rprenpos = pos(')',bopt)  /* first right pren  */
            if rprenpos == 0 then      /* no right pren  */
               do
                  say 'Error: Unmatched ()'
                  exit 8
               end /* end do  */

            /* find next left pren  */
            nlprenpos = pos('(',bopt,1)

            /* look for other () sets */
            do while (nlprenpos < rprenpos) & (nlprenpos <> 0)
               rprenpos = pos(')',bopt,rprenpos+1)
               if rprenpos == 0 then      /* missing right pren  */
                  do
                     say 'Error: Unmatched ()'
                     exit 8
                  end   /* end do  */
               nlprenpos = pos('(',bopt,nlprenpos+1)
            end /* do */
            RCOPT  = substr(bopt,1,rprenpos-1)
            bopt = strip(substr(bopt,rprenpos+1))
         end  /* when RC  */

      when (substr(translate(bopt),1,4) = 'IPF(') then
         do
            bopt = substr(bopt,5)          /* remove msg(   */
            /* find closing pren  */
            rprenpos = pos(')',bopt)  /* first right pren  */
            if rprenpos == 0 then      /* no right pren  */
               do
                  say 'Error: Unmatched ()'
                  exit 8
               end /* end do  */

            /* find next left pren  */
            nlprenpos = pos('(',bopt,1)

            /* look for other () sets */
            do while (nlprenpos < rprenpos) & (nlprenpos <> 0)
               rprenpos = pos(')',bopt,rprenpos+1)
               if rprenpos == 0 then      /* missing right pren  */
                  do
                     say 'Error: Unmatched ()'
                     exit 8
                  end   /* end do  */
               nlprenpos = pos('(',bopt,nlprenpos+1)
            end /* do */
            IPFOPT  = substr(bopt,1,rprenpos-1)
            bopt = strip(substr(bopt,rprenpos+1))
         end  /* when IPF  */

      when (substr(translate(bopt),1,7) = 'COPYDLL') then
         do
            parse var bopt opt bopt
            BUILDOPT = strip(BUILDOPT 'IWZVTEST=Y')
         end

      when (substr(translate(bopt),1,6) = 'BACKUP') then
         do
            parse var bopt opt bopt
            BUILDOPT = strip(BUILDOPT 'IWZVBACKUP=Y')
         end

      otherwise
         do
            parse var bopt opt bopt
            say 'Error: Unrecognized option ignored "' || opt || '"'
         end
   end  /* select */
end /* while */

IF (PA = 1) THEN
   BUILDOPT = strip(BUILDOPT 'IWZVPA=IWZPAN40.OBJ')

return

/*----------extractPPOptions------------------*/
extractPPOptions:

            options = substr(options,5)          /* remove -pp"   */
            qpos = pos('"',options)              /* find ending " */
            if qpos == 0  then
            do
               say 'Error: Unmatched "'
               exit 8
            end /* end do  */
            ppopt   = substr(options,1,qpos-1)   /* get pp options */
            options = strip(substr(options,qpos+1))
            do while ppopt <> ''
               lprenpos   = pos("(",ppopt)
               if lprenpos == 0 then      /* no left pren  */
                  do
                     say 'Error: Missing "(" '
                     exit 8
                  end /* end do  */

               /* find keyword */
               keyword = translate(substr(ppopt,1,lprenpos-1))

               /* find closing pren  */
               rprenpos = pos(')',ppopt)  /* first right pren  */
               if rprenpos == 0 then      /* no right pren  */
                  do
                     say 'Error: Unmatched ()'
                     exit 8
                  end /* end do  */

               /* find next left pren  */
               nlprenpos = pos('(',ppopt,lprenpos+1)

               /* look for other () sets */
               do while (nlprenpos < rprenpos) & (nlprenpos <> 0)
                  rprenpos = pos(')',ppopt,rprenpos+1)
                  if rprenpos == 0 then      /* missing right pren  */
                     do
                        say 'Error: Unmatched ()'
                        exit 8
                     end /* end do  */
                  nlprenpos = pos('(',ppopt,nlprenpos+1)
               end /* do */
               opt   = substr(ppopt,lprenpos+1,rprenpos-lprenpos-1)
               ppopt = strip(substr(ppopt,rprenpos+1))

               select
                  when keyword = 'BUILD'
                       then BUILDOPT = strip(BUILDOPT opt)

                  when keyword = 'CICS' then
                      DO
                         CICSFLAG = 1
                         CICSOPT = strip(CICSOPT opt)
                      END

                  otherwise
                       say 'Error: Unrecognized preprocessor option' keyword
                       say '      Option: ' keyword ' was discarded'
               end  /* select */
            end  /* end of -pp loop     */
return

/*-------------dumpOptions--------------------*/
dumpOptions:
say 'Options are:'
say 'COBOLOPT = ' COBOLOPT
say 'OTHEROPT = ' OTHEROPT
say 'LINKOPT  = ' LINKOPT
say 'MAKEOPT  = ' MAKEOPT
say 'BUILDOPT = ' BUILDOPT
say 'CICSOPT  = ' CICSOPT
say 'FILESIN  = ' FILESIN
say 'CICSFLAG = ' CICSFLAG
say 'MSGOPT   = ' MSGOPT
say 'RCOPT    = ' RCOPT
say 'IPFOPT   = ' IPFOPT
say 'PA       = ' PA
say ''

return

/*---------------cwrite-----------------------*/
cwrite:
      say "Error: Unsuccessful write to file: " cobsenv
      exit 8
return

/*----------------verror----------------------*/
verror:
      say "Error: Invalid .vcb list: " vcblist
      exit 8
return

/*----------------terror----------------------*/
terror:
      say "Error: Invalid targetFile: " targetFile
      exit 8
return

/*----------------Help------------------------*/
Help:
   say
   say 'This command file is called from Workframe'
   say 'It initiates the build process and should not'
   say 'be used alone.'
   say
return

