/* Reinvoking as "REXX %0 %1 %2 %3 %4 %5 %6 %7 %8 %9"  2>nul
@goto runit */
/*********************************************************************/
/* Licensed Material - Property of IBM                               */
/* 5639-B92 , 5639-D65 (C) Copyright IBM Corp., 1997, 1998           */
/* All rights reserved.                                              */
/* US Government Users Restricted Rights - Use, duplication or       */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/*********************************************************************/
trace off;
signal on novalue;
parse source opsys . whoami rest;
/* cobolroot is now set by iwzmIR.CMD */
if opsys = 'OS/2' then
  do;
  env = 'OS2ENVIRONMENT';
  callit = '@Call';
  call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs';
  call SysLoadFuncs;
  end;
else
  do;
  env = 'ENVIRONMENT';
  callit = '@Rexx';
  end;
tempdir = value('TMP',,env);
tempout = SysTempFileName(tempdir'\TM?????.OUT');
tempout2 = SysTempFileName(tempdir'\T2?????.OUT');
xx = Get_MVSINFO();
if xx <> 0 then
  exit 16;
call Set_MVSINFO_Vars;
if tracemod = '*' |,
  wordpos(translate(substr(whoami,lastpos('\',whoami)+1)),tracemod) > 0 then
  do;
  if trace > 3 then trace results;
  if trace > 4 then trace ?;
  end;
parse arg the_input_args;
call traceit 1 'Entry' '!'the_input_args'!';
clistlevel = 'V2.2'; /* required SIGYCLST level */
xx = stream(tempdir'\iwzmTRC.TRC','C','CLOSE');
xx = stream(tempdir'\iwzmTRX.TRC','C','CLOSE');
if tracekeep <> 'KEEP' then
  do;
  xx = SysFileDelete(tempdir'\iwzmTRC.TRC');
  tracefilx = tempdir'\iwzmTRX.TRC';
  xx = SysFileTree(tracefilx,'tree_stem.','F');
  if xx <> 0 then
    do;
    call sayit 'Internal error';
    call traceit 1 'Error exit';
    exit 16;
    end;
  if tree_stem.0 = 1 then
    '@rename' tracefilx 'iwzmTRC.TRC';
  end;
call traceit 1 'Trace level =' trace;
parse arg the_input_args;
call traceit 1 'Entry' '!'the_input_args'!';
parse upper arg theargs;
newargs = '';
inquote = 'no';
sepchar = '01'x;
if length(theargs) > 0 then
  do;
  do ii = 1 to length(theargs);
    thechar = substr(theargs,ii,1);
    select;
      when thechar = '"' then
        do;
        if inquote = 'yes' then
          inquote = 'no';
        else
          inquote = 'yes';
        newargs = newargs||thechar;
        end;
      when thechar == ' ' then
        do;
        if inquote = 'yes' then
          newargs = newargs||sepchar;
        else
          newargs = newargs||thechar;
        end;
      otherwise
        newargs = newargs||thechar;
      end;
    end;
  end;
do ii = 1 to 12;
  thearg.ii = word(newargs,ii);
  thearg.ii = translate(thearg.ii,' ',sepchar);
  end;
a1 = thearg.1;
a2 = thearg.2;
a3 = thearg.3;
/* parse upper arg a1 a2 a3 rest; */
if a1 = '/P' then
  do;
  project = a2;
  fasttype = a3;
  refresh = 'yes';
  end;
else
  do;
  fasttype = a1;
  refresh = 'no';
  end;
if fasttype = '' then
  fasttype = 'NOFAST';
if filesys = 'SDU' then
  configdfm = cobolroot'\MACROS\CONFIG.DFM';
datfiles = value('TMP',,env)'\CS*.DAT';
xx = SysFileTree(datfiles,'tree_stem.','F');
if tree_stem.0 > 0 then
  '@erase' value('TMP',,env)'\CS*.DAT';
if pwd = '========' then
  do;
  if opsys = 'OS/2' then
    call iwzmlxp.cmd '/NOLOGO /CM SET GLOBAL.MVSDATA NULL';
  else
    '@iwzmlxp /NOLOGO /CM SET GLOBAL.MVSDATA NULL';
  end;
call message 01;
'@pause';
call SysCls;
if mvscomm = 'YES' then
  do;
  call iwzmvsr.cmd;
  iwzmvsr_rc = result;
  if iwzmvsr_rc <> 0 then
    do;
    if refresh = 'no' then
      call iwzmstp.cmd;
    else
      call iwzmstp.cmd '/P' project;
    call traceit 1 'Error exit';
    exit 16;
    end;
  end;
if filesys = 'NFS' then
  call testlevel;
call SysCls;
if fsstartcmd = '' | fsstartcmd = '*' then
  do;
  if opsys = 'OS/2' then
    do;
    if filesys = 'NFS' then
      do;
      'nfsstart';
      nfsstart_rc = rc;
      if nfsstart_rc <> 0 then
        do;
        call message 02 'nfsstart';
        call refreshproj;
        call traceit 1 'Error exit';
        exit 16;
        end;
      end;
    else
      do;
      '@strtdfmc' configdfm;
      sdu_rc = rc;
      if sdu_rc <> 0 then
        do;
        call message 02 'strtdfmc';
        call refreshproj;
        call traceit 1 'Error exit';
        exit 16;
        end;
      '@strtdfmr' configdfm;
      sdu_rc = rc;
      if sdu_rc <> 0 then
        do;
        call message 02 'strtdfmr';
        call refreshproj;
        call traceit 1 'Error exit';
        exit 16;
        end;
      end;
    end;
  else
    nop; /* nothing needed for Windows */
  end;
else
  do;
  call iwzmfsr.cmd 'FSSTARTCMD';
  fsreq_rc = result;
  if fsreq_rc <> 0 then
    do;
    call message 03;
    call refreshproj;
    call traceit 1 'Error exit';
    exit 16;
    end;
  end;
if filesys = 'NFS' then
  do;
  if fasttype = 'FAST' then
    fast = ',fastfilesize';
  else
    fast = ',nofastfilesize';
  timeout = '';
  if readtimeout <> '' & readtimeout > 0 then
    do;
    timeout = timeout',readtimeout('readtimeout')';
    timeout = timeout',attrtimeout('readtimeout')';
    end;
  if writetimeout <> '' & writetimeout > 0 then
    timeout = timeout',writetimeout('writetimeout')';
  end;
if numdrive > 0 then
  do;
  do ii = 1 to numdrive;
    call SysCls;
    call message 04 drive.ii'\\'filesys'\\'system'\\'highqual.ii;
    if filesys = 'NFS' then
      do;
      if readtimeout <> '' & readtimeout > 0 then
        do;
        call message 05 readtimeout;
        end;
      else
        call message 06;
      if writetimeout <> '' & writetimeout > 0 then
        call message 07 writetimeout;
      else
        call message 08;
      end;
    if trans.ii = 'binary' then
      call message 09;
    else
      call message 10;
    if mapping.ii = 'LOCAL' then
      call message 11;
    else
      do;
      if sidefile.ii = '' then
        call message 12;
      else
        call message 13 sidefile.ii;
      end;
    if filesys = 'NFS' then
      do;
        if fast = ',fastfilesize' then
        do;
        call message 14;
        end;
      end;
    call sayit;
    select;
      when mapping.ii = 'LOCAL' then
        do;
        if filesys = 'NFS' then
          nfsmap = '';
        else
          sdumap = ''; /* SDU - this may have to change */
        end;
      when mapping.ii = 'FILESYS' then
        do;
        if filesys = 'NFS' then
          do;
          if sidefile.ii = '' then
            nfsmap = ',fileextmap';
          else
            nfsmap = ',fileextmap,sidefile('sidefile.ii')';
          end;
        end;
      otherwise
        nfsmap = '';
      end;
    pwdd = substr('********',1,length(pwd));
    if mountcmd = '' | mountcmd = '*' then
      do;
      if opsys = 'OS/2' then
        do;
        if filesys = 'NFS' then
          do;
          say 'mount -l'userid '-p'pwdd drive.ii' ',
            system':'highqual.ii','trans.ii||nfsmap||fast||timeout||nfs;
          '@call iwzmsnd.cmd @mount -l'userid '-p'pwd drive.ii' ',
            system':'highqual.ii','trans.ii||nfsmap||fast||timeout||nfs;
          end;
        else
          do;
          'call dfmdrive assign' drive.ii highqual.ii;
          if trans.ii = 'text,crlf' then
            'call dfmdrive setparm' drive.ii '"text'sdu'"';
          end;
        end;
      else
        do;
        say 'net use' drive.ii' ',
          '\\'system'\'highqual.ii','trans.ii||nfsmap||fast||timeout||nfs pwdd' ',
          '/USER:'userid;
        '@rexx iwzmsnd.cmd @net use' drive.ii' ',
          '\\'system'\'highqual.ii','trans.ii||nfsmap||fast||timeout||nfs pwd' ',
          '/USER:'userid;
        end;
      end;
    else
      do;
      call iwzmfsr.cmd 'MOUNTCMD' mvsinfo.DRIVE.ii;
      rc = result;
      end;
    mount_rc = rc;
    if mount_rc <> 0 then
      do;
      if opsys = 'OS/2' then
        do;
        call message 15 drive.ii;
        '@pause';
        call SysCls;
        call message 16;
        parse upper pull reply rest;
        end;
      else
        call message 17 drive.ii;
      if reply <> 'CONTINUE' then
        do;
        if refresh = 'no' then
          call iwzmstp.cmd;
        else
          call iwzmstp.cmd '/P' project;
        call traceit 1 'Error exit';
        exit 16;
        end;
      end;
    else
      xx = SysSleep(1);
    end;
  end;
if filesys = 'SDU' then
  call testlevel;
if testaccess = 'TESTACCESS' then
  do;
  call iwzmtsc.cmd;
  call SysCls;
  end;
call sayit;
call refreshproj;
call traceit 1 'Normal exit';
exit 0;
/* */
refreshproj:
if refresh = 'no' then
  do;
  call message 18;
  '@pause';
  call accessmon;
  end;
else
  do;
  call message 19;
  '@pause';
  call accessmon;
  select;
    when 'iwzm' = 'iwzm' then
      '@iwzwwkf1.exe' project '/CM REFRESH';
    when 'iwzm' = 'ibmm' then
      '@ibmwwkf1.exe' project '/CM REFRESH';
    otherwise
      '@iwzwwkf1.exe' project '/CM REFRESH';
    end;
  end;
return;
/* */
testlevel:
call traceit 2 'Before IGYFLEVL';
stackfile = tempout;
if mvscomm = 'YES' then
  call iwzmvws.cmd 'IGYFLEVL >'stackfile;
else
  call iwzmtso.cmd '!!??'stackfile'??+IGYFLEVL';
read_stem.0 = 0;
xx = linein(stackfile,1,0);
do forever;
  if lines(stackfile) = 0 then
    leave;
  read_stem.0 = read_stem.0 + 1;
  nn = read_stem.0;
  read_stem.nn = linein(stackfile);
  end;
xx = stream(stackfile,'C','CLOSE');
'@erase' stackfile;
call traceit 2 'After IGYFLEVL';
if read_stem.0 < 1 then
  do;
  call message 20;
  if refresh = 'no' then
    call iwzmstp.cmd;
  else
    call iwzmstp.cmd '/P' project;
  call traceit 1 'Error exit';
  exit 16;
  end;
if mvscomm = 'YES' then
  xx=read_stem.1
else
  xx = substr(read_stem.1,3);
parse upper var xx rcode version rest;
if rcode <> 'OK' | version <> clistlevel then
  do;
  call message 21 clistlevel;
  if refresh = 'no' then
    call iwzmstp.cmd;
  else
    call iwzmstp.cmd '/P' project;
  call traceit 1 'Error exit';
  exit 16;
  end;
return;
/* */
accessmon:
if accessmon = 'ACCESSMON' then
  call iwzmnmo.cmd 'start';
return;
/* */
message:
parse arg iwz_message_num,
          iwz_message_arg1 '\\',
          iwz_message_arg2 '\\',
          iwz_message_arg3 '\\',
          iwz_message_arg4 '\\',
          iwz_message_arg5 '\\',
          iwz_message_arg6 '\\',
          iwz_message_arg7 '\\',
          iwz_message_arg8;
select;
  when language = 'ENG' then
    call message_eng;
  when language = 'JPN' then
    call message_jpn;
  otherwise
    call message_eng;
  end;
return;
/* */
message_eng:
select;
 
when iwz_message_num = 1 then do;
call sayit;
call sayit '                 -------- Note --------';
call sayit;
call sayit 'Depending on your system you may be prompted for your TSO';
call sayit 'userID and/or password.  This prompting may occur for each';
call sayit 'drive that is accessed.  You may initially get a message';
call sayit 'that your password is invalid.  Ignore this message.';
call sayit;
end;
 
when iwz_message_num = 2 then do;
call sayit iwz_message_arg1 'failed';
end;
 
when iwz_message_num = 3 then do;
call sayit 'Start of file system failed';
end;
 
when iwz_message_num = 4 then do;
call sayit;
call sayit 'Drive' iwz_message_arg1 'being accessed';
call sayit 'File system =' iwz_message_arg2;
call sayit 'System =' iwz_message_arg3
call sayit 'High Level Qualifier =' iwz_message_arg4;
end;
 
when iwz_message_num = 5 then do;
call sayit 'Readtimeout =' iwz_message_arg1;
call sayit 'Attrtimeout =' iwz_message_arg1;
end;
 
when iwz_message_num = 6 then do;
call sayit 'Readtimeout = NFS server default';
call sayit 'Attrtimeout = NFS server default';
end;
 
when iwz_message_num = 7 then do;
call sayit 'Writetimeout =' iwz_message_arg1;
end;
 
when iwz_message_num = 8 then do;
call sayit 'Writetimeout = NFS server default';
end;
 
when iwz_message_num = 9 then do;
call sayit 'Usage = binary (no translation, do not use for editing)';
end;
 
when iwz_message_num = 10 then do;
call sayit 'Usage = text (translation between EBCDIC and ASCII)';
end;
 
when iwz_message_num = 11 then do;
call sayit 'Name mapping = local using MVSINFO.DAT file';
end;
 
when iwz_message_num = 12 then do;
call sayit 'Name mapping = file system using default mapping data set';
end;
 
when iwz_message_num = 13 then do;
call sayit 'Name mapping = file system using user mapping data set' iwz_message_arg1;
end;
 
when iwz_message_num = 14 then do;
call sayit;
call sayit 'WARNING: file sizes will not be available.  Do not';
call sayit 'use this drive for normal workstation operations such';
call sayit 'as editing.';
end;
 
when iwz_message_num = 15 then do;
call sayit;
call sayit '===> Access of drive' iwz_message_arg1 'failed';
end;
 
when iwz_message_num = 16 then do;
call sayit;
call sayit 'Do you wish to continue accessing MVS drives?';
call sayit 'If the access failure was due to an invalid';
call sayit 'password then based on the security features';
call sayit 'of your MVS system attempts to access more drives';
call sayit 'may result in your TSO userID be locked out.';
call sayit;
call sayit 'Reply CONTINUE to continue accessing MVS drives.';
call sayit 'Any other response will stop accessing MVS drives';
call sayit 'and will disconnect access to any drives already';
call sayit 'accessed.';
end;
 
when iwz_message_num = 17 then do;
reply = iwzmerr('Connection to drive' iwz_message_arg1 ' failed.//To stop connecting' ,
'the remaining drives, press Cancel.  This is recommended' ,
'if the failure was due to an invalid password or other' ,
'authorization error.')
reply = translate(reply);
end;
 
when iwz_message_num = 18 then do;
call sayit 'You should select "View->Refresh now" in order to update your'
call sayit 'project view';
call sayit;
end;
 
when iwz_message_num = 19 then do;
call sayit 'Will automatically refresh your project view';
call sayit;
end;
 
when iwz_message_num = 20 then do;
call sayit 'Cannot determine SIGYCLST level';
end;
 
when iwz_message_num = 21 then do;
call sayit 'SIGYCLST level is not' iwz_message_arg1;
end;
 
otherwise
call sayit 'Invalid message number' iwz_message_num;
end;
return;
/* */
message_jpn:
call sayit 'Japanese message';
select;
 
when iwz_message_num = 1 then do;
call sayit;
call sayit '                 -------- Note --------';
call sayit;
call sayit 'Depending on your system you may be prompted for your TSO';
call sayit 'userID and/or password.  This prompting may occur for each';
call sayit 'drive that is accessed.  You may initially get a message';
call sayit 'that your password is invalid.  Ignore this message.';
call sayit;
end;
 
when iwz_message_num = 2 then do;
call sayit iwz_message_arg1 'failed';
end;
 
when iwz_message_num = 3 then do;
call sayit 'Start of file system failed';
end;
 
when iwz_message_num = 4 then do;
call sayit;
call sayit 'Drive' iwz_message_arg1 'being accessed';
call sayit 'File system =' iwz_message_arg2;
call sayit 'System =' iwz_message_arg3
call sayit 'High Level Qualifier =' iwz_message_arg4;
end;
 
when iwz_message_num = 5 then do;
call sayit 'Readtimeout =' iwz_message_arg1;
call sayit 'Attrtimeout =' iwz_message_arg1;
end;
 
when iwz_message_num = 6 then do;
call sayit 'Readtimeout = NFS server default';
call sayit 'Attrtimeout = NFS server default';
end;
 
when iwz_message_num = 7 then do;
call sayit 'Writetimeout =' iwz_message_arg1;
end;
 
when iwz_message_num = 8 then do;
call sayit 'Writetimeout = NFS server default';
end;
 
when iwz_message_num = 9 then do;
call sayit 'Usage = binary (no translation, do not use for editing)';
end;
 
when iwz_message_num = 10 then do;
call sayit 'Usage = text (translation between EBCDIC and ASCII)';
end;
 
when iwz_message_num = 11 then do;
call sayit 'Name mapping = local using MVSINFO.DAT file';
end;
 
when iwz_message_num = 12 then do;
call sayit 'Name mapping = file system using default mapping data set';
end;
 
when iwz_message_num = 13 then do;
call sayit 'Name mapping = file system using user mapping data set' iwz_message_arg1;
end;
 
when iwz_message_num = 14 then do;
call sayit;
call sayit 'WARNING: file sizes will not be available.  Do not';
call sayit 'use this drive for normal workstation operations such';
call sayit 'as editing.';
end;
 
when iwz_message_num = 15 then do;
call sayit;
call sayit '===> Access of drive' iwz_message_arg1 'failed';
end;
 
when iwz_message_num = 16 then do;
call sayit;
call sayit 'Do you wish to continue accessing MVS drives?';
call sayit 'If the access failure was due to an invalid';
call sayit 'password then based on the security features';
call sayit 'of your MVS system attempts to access more drives';
call sayit 'may result in your TSO userID be locked out.';
call sayit;
call sayit 'Reply CONTINUE to continue accessing MVS drives.';
call sayit 'Any other response will stop accessing MVS drives';
call sayit 'and will disconnect access to any drives already';
call sayit 'accessed.';
end;
 
when iwz_message_num = 17 then do;
reply = iwzmerr('Connection to drive' iwz_message_arg1 ' failed.//To stop connecting' ,
'the remaining drives, press Cancel.  This is recommended' ,
'if the failure was due to an invalid password or other' ,
'authorization error.')
reply = translate(reply);
end;
 
when iwz_message_num = 18 then do;
call sayit 'You should select "View->Refresh now" in order to update your'
call sayit 'project view';
call sayit;
end;
 
when iwz_message_num = 19 then do;
call sayit 'Will automatically refresh your project view';
call sayit;
end;
 
when iwz_message_num = 20 then do;
call sayit 'Cannot determine SIGYCLST level';
end;
 
when iwz_message_num = 21 then do;
call sayit 'SIGYCLST level is not' iwz_message_arg1;
end;
 
otherwise
call sayit 'Invalid message number' iwz_message_num;
end;
return;
Get_MVSINFO:
Procedure expose env cobolroot mvsinfo. whoami tempdir trace
 
rtn = 0
null = '0000'x
crlf = '0D0A'x
mvsinfo. = ''
mvsinfoQ = translate('iwzm_MVSINFO.DAT_YALE');
 
oldq = rxqueue('Set',mvsinfoQ)   /* switch to mvsinfo queue */
if queued() = 0 then do                   /* if Q is missing we'll */
  qname = rxqueue('Create',mvsinfoQ)      /* create it and put a bad */
  if qname = mvsinfoQ then push 'Sven'    /* timestamp on it, else */
  else x=rxqueue('Delete',qname)          /* it was in use (we hope) */
  end                                     /* so we'll assume we can */
parse pull mvsstuff; push mvsstuff        /* get/replace Q contents */
parse value mvsstuff with ts (null) . cobolroot (null) mvsstuff /* get */
                                        /* timestamp and cobolroot */
if ts <> 'Sven' then do;
  mvsinfo = cobolroot'\MACROS\MVSINFO.DAT'
  bad_mvsinfo = '    **' whoami '****'crlf'    **error*' mvsinfo,
                'is unavailable, missing or empty **'
 
  x=SysFileTree(mvsinfo,'ts','F')       /* get MVSINFO.DAT's timestamp */
  if ts.0 <> 1 then do
    say bad_mvsinfo
    return 12;
    end
  parse var ts.1 v0 v1 v2 .
  timestamp ='mvsinfo.dat.timestamp' v0 v1 v2
  end;
else
  timestamp = 'Yale'
if timestamp <> ts then do              /* timestamps match? */
  pull mvsstuff                         /* no, remove bad contents */
  rtn = "iwzmIR.CMD"()                /* ask for new stuff */
  if rtn = 0 then do
    parse pull mvsstuff; push mvsstuff    /* get/replace Q contents */
                                        /* remove timestamp and     */
                                        /* cobolroot                */
    parse value mvsstuff with . (null) . cobolroot ( null) mvsstuff
    end
  end
qname = rxqueue('Set',oldq)      /* restore normal queue */
 
do while (mvsstuff<>'') & (rtn=0)   /* mvsinfo. structure */
  parse value mvsstuff with key val (null) mvsstuff
  if mvsinfo.key = '' then do       /* e.g. mvsinfo.TYPE='' */
    mvsinfo.KEYS = mvsinfo.KEYS key /* no substitution for KEYS */
    mvsinfo.key.1 = val             /* e.g. mvsinfo.TYPE.1=val  */
    mvsinfo.key = 1                 /* e.g. mvsinfo.TYPE=1      */
    end
  else do
    x = mvsinfo.key + 1             /* e.g. mvsinfo.TYPE+1     */
    mvsinfo.key.x = val             /* e.g. mvsinfo.TYPE.2=val */
    mvsinfo.key = x                 /* e.g. mvsinfo.TYPE=2     */
    end
  end
 
return rtn
 
Set_MVSINFO_Vars:
 
 parse var mvsinfo.CLOSECMD.1 closecmd;
 parse var mvsinfo.CLOSEFILE.1 closefile;
 parse var mvsinfo.FILESYS.1 filesys accessmon testaccess;
 parse var mvsinfo.FSSTARTCMD.1 fsstartcmd;
 parse var mvsinfo.FSSTOPCMD.1 fsstopcmd;
 parse var mvsinfo.HEADER.1 header;
 parse var mvsinfo.JOBLOG.1 joblog;
 parse var mvsinfo.MAXCMD.1 maxcmd;
 parse var mvsinfo.LANGUAGE.1 language;
 parse var mvsinfo.MOUNTCMD.1 mountcmd;
 parse var mvsinfo.MVSCOMM.1 mvscomm;
 parse var mvsinfo.iwzmEDT.1 iwzmedt;
 parse var mvsinfo.NFS.1 nfs;
 parse var mvsinfo.NULLSTDIN.1 nullstdin;
 parse var mvsinfo.OUTSHOW.1 outshow;
 parse var mvsinfo.PROTSAVE.1 protsave tempmult;
 parse var mvsinfo.PWD.1 pwd pwdasis pwdt pwde;
 parse var mvsinfo.READTIMEOUT.1 readtimeout;
 parse var mvsinfo.REXECCMD.1 rexeccmd;
 parse var mvsinfo.SDU.1 sdu;
 parse var mvsinfo.SIGYCLST.1 sigyclst;
 parse var mvsinfo.SYSPROC.1 sysproc;
 parse var mvsinfo.SYSTEM.1 system;
 parse var mvsinfo.TEMPDRIVE.1 tempdrive;
 parse var mvsinfo.TEMPDATA.1 tempdata;
 parse var mvsinfo.TESTFILE.1 testfile;
 parse var mvsinfo.TRACE.1 trace tracekeep;
 parse var mvsinfo.TRACECMD.1 tracecmd;
 parse var mvsinfo.TRACEMOD.1 tracemod;
 parse var mvsinfo.UMOUNTCMD.1 umountcmd;
 parse var mvsinfo.USERID.1 userid;
 parse var mvsinfo.WORKSYS.1 worksys;
 parse var mvsinfo.WRITETIMEOUT.1 writetimeout;
 
 parse var mvsinfo.DRIVE numdrive;
 if numdrive = '' then
   numdrive = 0;
 do ii = 1 to numdrive;
   parse var mvsinfo.DRIVE.ii,
             drive.ii highqual.ii trans.ii mapping.ii sidefile.ii;
   end;
 
 parse var mvsinfo.TYPE numtype;
 if numtype = '' then
   numtype = 0;
 do ii = 1 to numtype;
   parse var mvsinfo.TYPE.ii type.ii ext.ii;
   end;
 
return
 
/* */
Traceit:
 parse arg iwz_trc_level iwz_trc_message;
 if iwz_trc_level > trace then
   return;
 if pwd <> '********' & pwd <> '++++++++' & pwd <> '========' then
   do;
   do forever;
     if pos(pwd,iwz_trc_message) = 0 then
       leave;
     parse var iwz_trc_message iwz_trc_message1 (pwd) iwz_trc_message2;
     iwz_trc_message = iwz_trc_message1||'********'||iwz_trc_message2
     end;
   end
 iwz_trc_message = date('O') time('L') whoami':' iwz_trc_message;
 xx = lineout(tempdir'\iwzmTRC.TRC',iwz_trc_message);
 xx = stream(tempdir'\iwzmTRC.TRC','C','CLOSE');
 if tracecmd <> '' then
   interpret tracecmd;
return;
 
/* */
sayit:
 parse arg iwz_sayit_arg;
 if trace > 2 then
   call traceit 3 '--->' iwz_sayit_arg;
 say iwz_sayit_arg;
return;
/*
:runit
@rexx %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
@rem */
