/* Reinvoking as "REXX %0 %1 %2 %3 %4 %5 %6 %7 %8 %9"  2>nul
@goto runit */
/*********************************************************************/
/* Licensed Material - Property of IBM                               */
/* 5639-B92 , 5639-D65 (C) Copyright IBM Corp., 1997, 1998           */
/* All rights reserved.                                              */
/* US Government Users Restricted Rights - Use, duplication or       */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/*********************************************************************/
trace off;
signal on novalue;
parse source opsys . whoami rest;
/* cobolroot is now set by iwzmIR.CMD */
if opsys = 'OS/2' then
  do;
  env = 'OS2ENVIRONMENT';
  callit = '@Call';
  call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs';
  call SysLoadFuncs;
  end;
else
  do;
  env = 'ENVIRONMENT';
  callit = '@Rexx';
  end;
tempdir = value('TMP',,env);
tempout = SysTempFileName(tempdir'\TM?????.OUT');
tempout2 = SysTempFileName(tempdir'\T2?????.OUT');
xx = Get_MVSINFO();
if xx <> 0 then
  exit 16;
call Set_MVSINFO_Vars;
if tracemod = '*' |,
  wordpos(translate(substr(whoami,lastpos('\',whoami)+1)),tracemod) > 0 then
  do;
  if trace > 3 then trace results;
  if trace > 4 then trace ?;
  end;
parse arg the_input_args;
call traceit 1 'Entry' '!'the_input_args'!';
parse upper arg jobspec asis rest;
if asis = '' then
  asis = 'USERID';
if jobspec = '' then
  do;
  call message 01;
  call traceit 1 'Error exit';
  exit 16;
  end;
jobspec2 = jobspec;
if substr(jobspec,2,1) <> ':' | substr(jobspec,3,1) <> '\' then
  do;
  call message 02 jobspec;
  call traceit 1 'Error exit';
  exit 16;
  end;
curdrive = substr(jobspec,1,2);
curdrive = translate(curdrive);
jobspec = substr(jobspec,4);
parse var jobspec lowquals '\' dummy;
lastdot = lastpos('.',lowquals);
lowqual = substr(lowquals,lastdot+1);
lowqual = translate(lowqual);
mvslog = value('TMP',,env)'\MVSJOB.LOG';
highqm = '';
if numdrive > 0 then
  do;
  do ii = 1 to numdrive;
    if curdrive = drive.ii & trans.ii = 'text,crlf' then
      do;
      highqm = highqual.ii
      mapping = mapping.ii;
      leave;
      end;
    end;
  end;
if highqm = '' then
  do;
  call message 03 jobspec2;
  call traceit 1 'Error exit';
  exit 16;
  end;
parse var jobspec lowquals '\' member
if mapping = 'FILESYS' then
  do;
  parse upper var member fname '.' fext;
  if fext <> '' then
    useext = fext;
  else
    useext = '?';
  end;
else
  do;
  useext = '?';
  if numtype > 0 then
    do;
    do ii = 1 to numtype;
      if lowqual = type.ii then
        useext = ext.ii;
      end;
    end;
  end;
if useext <> 'JCL' then
  do;
  call message 04 jobspec2;
  call traceit 1 'Error exit';
  exit 16;
  end;
parse var jobspec lowquals '\' member
parse var member member '.' dummy;
jobspec = "'"highqm"."lowquals"("member")'";
jobspec = strip(jobspec,'B',"'");
parse var jobspec pref1 '.' pref2 '(' member ')';
lastdot = lastpos('.',pref2);
pref3 = substr(pref2,lastdot+1);
pref2 = substr('.'pref2,1,lastdot);
cntl = "'"pref1""pref2"."pref3"("member")'";
call message 05 cntl'\\'system;
if asis = 'ASIS' then
  do;
  sendcmd = 'SUBMIT' cntl;
  if mvscomm = 'YES' then
    call iwzmvws.cmd sendcmd '>'tempout;
  else
    callit 'iwzmtso.cmd !!'sendcmd '>'tempout;
  end;
else
  do;
  call traceit 2 'Before close';
  if filesys <> 'SDU' then
    do;
    if readtimeout = '' | readtimeout < 1 then
      timeout = 1;
    else
      timeout = readtimeout;
    if timeout > 10 then
      sleepamt = timeout - 10;
    else
      sleepamt = 0;
    if sleepamt > 0 then
      xx = SysSleep(sleepamt);
    end;
  call traceit 2 'After close';
  callit 'iwzmcmd.cmd -'jobspec2 'PM * IGYFSUB >'tempout;
  end;
call traceit 2 'Before call to readout';
call readout;
call traceit 2 'After call to readout';
call sayit output;
if pos('SUBMITTED',output) = 0 then
  do;
  if read_stem.0 > 1 then
    do;
    do ii = 2 to read_stem.0;
      call sayit read_stem.ii;
      end;
    end;
  call message 06;
  call traceit 1 'Error exit';
  exit 16;
  end;
parse var output dummy 'JOB ' jobname rest;
if pos('(',jobname) = 0 | pos(')',jobname) = 0 then
  do;
  call message 07;
  call traceit 1 'Error exit';
  exit 16;
  end;
call log date('U') time() 'SUB' jobname;
call traceit 1 'Normal exit';
exit 0;
/* */
readout:
read_stem.0 = 0;
xx = linein(tempout,1,0);
do forever;
  if lines(tempout) = 0 then
    leave;
  read_stem.0 = read_stem.0 + 1;
  nn = read_stem.0;
  read_stem.nn = linein(tempout);
  end;
xx = stream(tempout,'C','CLOSE');
  if read_stem.0 > 0 then
    output = read_stem.1;
  else
    output = '';
return;
/* */
log:
if joblog <> 'YES' then
  return;
parse arg logdata;
do ll = 1 to 5;
  '@echo' logdata '>>'mvslog;
  echo_rc = rc;
  if echo_rc = 0 then
    return;
  xx = SysSleep(1);
  end;
call message 08 mvslog;
return;
/* */
message:
parse arg iwz_message_num,
          iwz_message_arg1 '\\',
          iwz_message_arg2 '\\',
          iwz_message_arg3 '\\',
          iwz_message_arg4 '\\',
          iwz_message_arg5 '\\',
          iwz_message_arg6 '\\',
          iwz_message_arg7 '\\',
          iwz_message_arg8;
select;
  when language = 'ENG' then
    call message_eng;
  when language = 'JPN' then
    call message_jpn;
  otherwise
    call message_eng;
  end;
return;
/* */
message_eng:
select;
 
when iwz_message_num = 1 then do;
call sayit 'No job file specified';
end;
 
when iwz_message_num = 2 then do;
call sayit 'Unknown filename format:' iwz_message_arg1;
end;
 
when iwz_message_num = 3 then do;
call sayit 'Cannot determine MVS high level qualifier for' iwz_message_arg1;
call sayit 'You may have specified a file on a non-MVS drive.';
end;
 
when iwz_message_num = 4 then do;
call sayit 'Action not valid for this part:' iwz_message_arg1;
end;
 
when iwz_message_num = 5 then do;
call sayit 'Submitting' iwz_message_arg1 'on' iwz_message_arg2;
end;
 
when iwz_message_num = 6 then do;
call sayit 'Job submission failed';
end;
 
when iwz_message_num = 7 then do;
call sayit 'Unknown SUBMIT command output';
end;
 
when iwz_message_num = 8 then do;
call sayit 'Cannot write to log' iwz_message_arg1;
end;
 
otherwise
call sayit 'Invalid message number' iwz_message_num;
end;
return;
/* */
message_jpn:
call sayit 'Japanese message';
select;
 
when iwz_message_num = 1 then do;
call sayit 'No job file specified';
end;
 
when iwz_message_num = 2 then do;
call sayit 'Unknown filename format:' iwz_message_arg1;
end;
 
when iwz_message_num = 3 then do;
call sayit 'Cannot determine MVS high level qualifier for' iwz_message_arg1;
call sayit 'You may have specified a file on a non-MVS drive.';
end;
 
when iwz_message_num = 4 then do;
call sayit 'Action not valid for this part:' iwz_message_arg1;
end;
 
when iwz_message_num = 5 then do;
call sayit 'Submitting' iwz_message_arg1 'on' iwz_message_arg2;
end;
 
when iwz_message_num = 6 then do;
call sayit 'Job submission failed';
end;
 
when iwz_message_num = 7 then do;
call sayit 'Unknown SUBMIT command output';
end;
 
when iwz_message_num = 8 then do;
call sayit 'Cannot write to log' iwz_message_arg1;
end;
 
otherwise
call sayit 'Invalid message number' iwz_message_num;
end;
return;
Get_MVSINFO:
Procedure expose env cobolroot mvsinfo. whoami tempdir trace
 
rtn = 0
null = '0000'x
crlf = '0D0A'x
mvsinfo. = ''
mvsinfoQ = translate('iwzm_MVSINFO.DAT_YALE');
 
oldq = rxqueue('Set',mvsinfoQ)   /* switch to mvsinfo queue */
if queued() = 0 then do                   /* if Q is missing we'll */
  qname = rxqueue('Create',mvsinfoQ)      /* create it and put a bad */
  if qname = mvsinfoQ then push 'Sven'    /* timestamp on it, else */
  else x=rxqueue('Delete',qname)          /* it was in use (we hope) */
  end                                     /* so we'll assume we can */
parse pull mvsstuff; push mvsstuff        /* get/replace Q contents */
parse value mvsstuff with ts (null) . cobolroot (null) mvsstuff /* get */
                                        /* timestamp and cobolroot */
if ts <> 'Sven' then do;
  mvsinfo = cobolroot'\MACROS\MVSINFO.DAT'
  bad_mvsinfo = '    **' whoami '****'crlf'    **error*' mvsinfo,
                'is unavailable, missing or empty **'
 
  x=SysFileTree(mvsinfo,'ts','F')       /* get MVSINFO.DAT's timestamp */
  if ts.0 <> 1 then do
    say bad_mvsinfo
    return 12;
    end
  parse var ts.1 v0 v1 v2 .
  timestamp ='mvsinfo.dat.timestamp' v0 v1 v2
  end;
else
  timestamp = 'Yale'
if timestamp <> ts then do              /* timestamps match? */
  pull mvsstuff                         /* no, remove bad contents */
  rtn = "iwzmIR.CMD"()                /* ask for new stuff */
  if rtn = 0 then do
    parse pull mvsstuff; push mvsstuff    /* get/replace Q contents */
                                        /* remove timestamp and     */
                                        /* cobolroot                */
    parse value mvsstuff with . (null) . cobolroot ( null) mvsstuff
    end
  end
qname = rxqueue('Set',oldq)      /* restore normal queue */
 
do while (mvsstuff<>'') & (rtn=0)   /* mvsinfo. structure */
  parse value mvsstuff with key val (null) mvsstuff
  if mvsinfo.key = '' then do       /* e.g. mvsinfo.TYPE='' */
    mvsinfo.KEYS = mvsinfo.KEYS key /* no substitution for KEYS */
    mvsinfo.key.1 = val             /* e.g. mvsinfo.TYPE.1=val  */
    mvsinfo.key = 1                 /* e.g. mvsinfo.TYPE=1      */
    end
  else do
    x = mvsinfo.key + 1             /* e.g. mvsinfo.TYPE+1     */
    mvsinfo.key.x = val             /* e.g. mvsinfo.TYPE.2=val */
    mvsinfo.key = x                 /* e.g. mvsinfo.TYPE=2     */
    end
  end
 
return rtn
 
Set_MVSINFO_Vars:
 
 parse var mvsinfo.CLOSECMD.1 closecmd;
 parse var mvsinfo.CLOSEFILE.1 closefile;
 parse var mvsinfo.FILESYS.1 filesys accessmon testaccess;
 parse var mvsinfo.FSSTARTCMD.1 fsstartcmd;
 parse var mvsinfo.FSSTOPCMD.1 fsstopcmd;
 parse var mvsinfo.HEADER.1 header;
 parse var mvsinfo.JOBLOG.1 joblog;
 parse var mvsinfo.MAXCMD.1 maxcmd;
 parse var mvsinfo.LANGUAGE.1 language;
 parse var mvsinfo.MOUNTCMD.1 mountcmd;
 parse var mvsinfo.MVSCOMM.1 mvscomm;
 parse var mvsinfo.iwzmEDT.1 iwzmedt;
 parse var mvsinfo.NFS.1 nfs;
 parse var mvsinfo.NULLSTDIN.1 nullstdin;
 parse var mvsinfo.OUTSHOW.1 outshow;
 parse var mvsinfo.PROTSAVE.1 protsave tempmult;
 parse var mvsinfo.PWD.1 pwd pwdasis pwdt pwde;
 parse var mvsinfo.READTIMEOUT.1 readtimeout;
 parse var mvsinfo.REXECCMD.1 rexeccmd;
 parse var mvsinfo.SDU.1 sdu;
 parse var mvsinfo.SIGYCLST.1 sigyclst;
 parse var mvsinfo.SYSPROC.1 sysproc;
 parse var mvsinfo.SYSTEM.1 system;
 parse var mvsinfo.TEMPDRIVE.1 tempdrive;
 parse var mvsinfo.TEMPDATA.1 tempdata;
 parse var mvsinfo.TESTFILE.1 testfile;
 parse var mvsinfo.TRACE.1 trace tracekeep;
 parse var mvsinfo.TRACECMD.1 tracecmd;
 parse var mvsinfo.TRACEMOD.1 tracemod;
 parse var mvsinfo.UMOUNTCMD.1 umountcmd;
 parse var mvsinfo.USERID.1 userid;
 parse var mvsinfo.WORKSYS.1 worksys;
 parse var mvsinfo.WRITETIMEOUT.1 writetimeout;
 
 parse var mvsinfo.DRIVE numdrive;
 if numdrive = '' then
   numdrive = 0;
 do ii = 1 to numdrive;
   parse var mvsinfo.DRIVE.ii,
             drive.ii highqual.ii trans.ii mapping.ii sidefile.ii;
   end;
 
 parse var mvsinfo.TYPE numtype;
 if numtype = '' then
   numtype = 0;
 do ii = 1 to numtype;
   parse var mvsinfo.TYPE.ii type.ii ext.ii;
   end;
 
return
 
/* */
Traceit:
 parse arg iwz_trc_level iwz_trc_message;
 if iwz_trc_level > trace then
   return;
 if pwd <> '********' & pwd <> '++++++++' & pwd <> '========' then
   do;
   do forever;
     if pos(pwd,iwz_trc_message) = 0 then
       leave;
     parse var iwz_trc_message iwz_trc_message1 (pwd) iwz_trc_message2;
     iwz_trc_message = iwz_trc_message1||'********'||iwz_trc_message2
     end;
   end
 iwz_trc_message = date('O') time('L') whoami':' iwz_trc_message;
 xx = lineout(tempdir'\iwzmTRC.TRC',iwz_trc_message);
 xx = stream(tempdir'\iwzmTRC.TRC','C','CLOSE');
 if tracecmd <> '' then
   interpret tracecmd;
return;
 
/* */
sayit:
 parse arg iwz_sayit_arg;
 if trace > 2 then
   call traceit 3 '--->' iwz_sayit_arg;
 say iwz_sayit_arg;
return;
/*
:runit
@rexx %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
@rem */
