#*******************************************************************************
# FILE NAME: iwzbexe.mak                                              V2R2     *
#                                                                              *
# DESCRIPTION:                                                                 *
#   Make file to create OS/2 exe for class: $(CVBNAME)                         *
#                                                                              *
# COPYRIGHT:                                                                   *
#   IBM(R) VisualAge(TM) for COBOL                                             *
#   (C) Copyright International Business Machines Corporation 1998             *
#   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
#   US Government Users Restricted Rights - Use, duplication, or disclosure    *
#   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
#                                                                              *
# ---------------------------------------------------------------------------- *
# Notes: $(CVBNAME).obj $(CVBNAME).lib iwzbtemp.lib iwzbtemp.lib are temps     *
#   The environment variables CVBNAME, CVBDEBUG, PARTCOMPFLAGS, APPCOMPFLAGS,  *
#   PARTLINKFLAGS, APPLINKFLAGS can be used to override the default values     *
#*******************************************************************************
PARTCOMPFLAGS=-qNOADATA $(PARTCOMPFLAGS) 
!ifdef CVBDEBUG
PARTCOMPFLAGS=$(PARTCOMPFLAGS) -qTEST
!endif

APPCOMPFLAGS=-qNOADATA $(APPCOMPFLAGS)
!ifdef CVBDEBUG
APPCOMPFLAGS=$(APPCOMPFLAGS) -qTEST
!endif

APPLINKFLAGS=/free /pmtype:pm /nologo /exe $(APPLINKFLAGS)
!ifdef CVBDEBUG
APPLINKFLAGS=$(APPLINKFLAGS) /de
!endif

EXEDEPENDS=$(LIBLIST) $(EXEDEPENDS)
EXELIBS=$(LIBLIST) $(FILESIN) $(EXELIBS)

.SUFFIXES:

.SUFFIXES: .app .cbl .rc

$(CVBNAME).exe:   $(CVBNAME).abj $(CVBNAME).lib \
!ifdef RESREQUIRED
                  $(CVBNAME).res \
!endif
                  $(EXEDEPENDS)
  @echo ... creating $(CVBNAME).exe ...
          @copy $(CVBNAME).abj $(CVBNAME).obj > nul
          iwzolnk1 $(APPLINKFLAGS) $(CVBNAME).obj \
              iwzbcprt.lib iwzbcobs.lib iwzbapix.lib \
              iwzbodx.lib iwzblang.obj iwzbrtr1.lib \
              $(EXELIBS) $(IWZVPA)
!ifdef RESREQUIRED
          rc -n $(CVBNAME).res $(CVBNAME).exe
!endif

.app.abj: 
  @echo ... compiling %s ... 
          @if exist %|dpfF.abj erase %|dpfF.abj
          @set SYSLIB=$(SYSLIB);$(INCLUDE)
      -7  igyccob2 $(APPCOMPFLAGS) %s
          @if exist %|dpfF.obj ren %|dpfF.obj %|dpfF.abj

!ifdef RESREQUIRED
.rc.res:
  @echo ... creating %|dpfF.res ...
          rc -r %s
!endif

.cbl.lib:
  @echo ... creating object and library file for %s ...
          @if exist iwzbtemp.obj del iwzbtemp.obj
          @if exist %|dpfF.obj ren %|dpfF.obj iwzbtemp.obj
          @if exist %|dpfF.cbj del %|dpfF.cbj
          @set SYSLIB=$(SYSLIB);$(INCLUDE)
      -7  igyccob2 $(PARTCOMPFLAGS) %s
          @if exist %|dpfF.obj ren %|dpfF.obj %|dpfF.cbj
          @if exist iwzbtemp.obj ren iwzbtemp.obj %|dpfF.obj 

clean:
  @if exist $(CVBNAME).exe del $(CVBNAME).exe
  @if exist $(CVBNAME).abj del $(CVBNAME).abj
  @if exist $(CVBNAME).res del $(CVBNAME).res
  @if exist $(CVBNAME).lib del $(CVBNAME).lib
  @if exist $(CVBNAME).cbj del $(CVBNAME).cbj
  @if exist $(CVBNAME).lst del $(CVBNAME).lst
  @if exist $(CVBNAME).adt del $(CVBNAME).adt
  @if exist $(CVBNAME).obj del $(CVBNAME).obj

