      ******************************************************************
      * COBOL COPY book for ODBC API's - ODBC Version 3.0 Level        *
      *   (c) Copyright IBM CORP. 1996, 1998                           *
      ******************************************************************

      ******************************************************************
      * ODBC version dependent data-item names in this copy book       *
      * are noted with case sensitive naming conventions as follows    *
      * (note that the COBOL language is case insensitive).            *
      *                                                                *
      *    Data-names applicable only to ODBC Version 3.0 or later     *
      *    are shown in lower case letters with "sql-" prefix.         *
      *                                                                *
      *    Data-names replaced for ODBC Version 3.0 but do not have    *
      *    name conflicts are kept with "Sql-" prefix vs "SQL-" or     *
      *    "sql-" prefix.                                              *
      *                                                                *
      *    i.e.                                                        *
      *     Sql-ABC  for ODBC Ver < 3.0 (e.g. deprecated in 3.0)       *
      *     SQL-ABC: for ODBC Ver < 3.0 as well as >= 3.0              *
      *     sql-abc: for ODBC Ver >= 3.0 only                          *
      ******************************************************************

      ******************************************************************
      * ODBC CALL Return Values                                        *
      *   e.g.  CALL  "SQLAllocHandle" USING ...                       *
      *         IF RETURN-CODE = SQL-ERROR, ...                        *
      ******************************************************************
       01  SQL-INVALID-HANDLE       GLOBAL PIC S9(4) COMP-5 VALUE    -2.
       01  SQL-ERROR                GLOBAL PIC S9(4) COMP-5 VALUE    -1.
       01  SQL-SUCCESS              GLOBAL PIC S9(4) COMP-5 VALUE     0.
       01  SQL-SUCCESS-WITH-INFO    GLOBAL PIC S9(4) COMP-5 VALUE     1.
       01  SQL-STILL-EXECUTING      GLOBAL PIC S9(4) COMP-5 VALUE     2.
       01  SQL-NEED-DATA            GLOBAL PIC S9(4) COMP-5 VALUE    99.
       01  Sql-NO-DATA-FOUND        GLOBAL PIC S9(4) COMP-5 VALUE   100.
       01  sql-no-data         redefines  Sql-NO-DATA-FOUND
                                    global pic s9(4) comp-5.
      ******************************************************************
      *  The following may be used (after un-commenting them) instead  *
      *  of the above if the function return value is explicitly       *
      *  specified on the call  statement:                             *
      *   e.g.  CALL  "SQLAllocHandle" USING ... RETURNING SQL-RC      *
      *         IF SQL-ERROR, ...                                      *
      ******************************************************************
      *01  SQL-RC                   GLOBAL PIC S9(4) COMP-5.
      * 88  SQL-INVALID-HANDLE                              VALUE    -2.
      * 88  SQL-ERROR                                       VALUE    -1.
      * 88  SQL-SUCCESS                                     VALUE     0.
      * 88  SQL-SUCCESS-WITH-INFO                           VALUE     1.
      * 88  SQL-STILL-EXECUTING                             VALUE     2.
      * 88  SQL-NEED-DATA                                   VALUE    99.
      * 88  Sql-NO-DATA-FOUND                               VALUE   100.
      * 88  sql-no-data                                     VALUE   100.
      ******************************************************************


      ******************************************************************
      * SQLAllocHandle                               (ODBC Ver >= 3.0) *
      ******************************************************************
      * Handle types
       01  sql-handle-env           global pic  9(4) comp-5 value     1.
       01  sql-handle-dbc           global pic  9(4) comp-5 value     2.
       01  sql-handle-stmt          global pic  9(4) comp-5 value     3.
       01  sql-handle-desc          global pic  9(4) comp-5 value     4.

       01  sql-handle-senv          global pic  9(4) comp-5 value     5.

      * Null values for henv, hdbc and hstmt
       01  SQL-NULL-HENV            GLOBAL POINTER          VALUE  NULL.
       01  SQL-NULL-HDBC  REDEFINES SQL-NULL-HENV
                                    GLOBAL POINTER.
       01  SQL-NULL-HSTMT REDEFINES SQL-NULL-HENV
                                    GLOBAL POINTER.
       01  sql-null-hdesc redefines sql-null-henv
                                    global pointer.

      * input handle type to be used for allocating sql-handle-henv
       01  sql-null-handle          global pic  9(9) comp-5 value     0.

      ******************************************************************
      * SQLBindCol, SQLBindParam, and SQLGetData     (ODBC Ver >= 3.0) *
      ******************************************************************
      * Default conversion code
       01  sql-default               global pic  9(4) comp-5 value   99.

      ******************************************************************
      * SQLBindParameter                                               *
      ******************************************************************
      ** Information on parameter value
       01  SQL-DEFAULT-PARAM         GLOBAL PIC S9(4) COMP-5 VALUE  -5.
       01  SQL-IGNORE                GLOBAL PIC S9(4) COMP-5 VALUE  -6.
        01 sql-column-ignore  redefines  SQL-IGNORE
                                     global pic s9(4) comp-5.

       01  SQL-LEN-DATA-AT-EXEC-OFFSET
                                     GLOBAL PIC S9(4) COMP-5 VALUE -100.

      ******************************************************************
      * SQLBindParameter and SQLProcedureColumns                       *
      ******************************************************************
      * types of parameter - InputOutPutType (SQLBindParameter)
      * result set values for COLUMN-TYPE column (SQLProcedureColumn)
       01  SQL-PARAM-TYPE-UNKNOWN    GLOBAL PIC  9(4) COMP-5 VALUE  0.
       01  SQL-PARAM-INPUT           GLOBAL PIC  9(4) COMP-5 VALUE  1.
       01  SQL-PARAM-INPUT-OUTPUT    GLOBAL PIC  9(4) COMP-5 VALUE  2.
       01  SQL-RESULT-COL            GLOBAL PIC  9(4) COMP-5 VALUE  3.
       01  SQL-PARAM-OUTPUT          GLOBAL PIC  9(4) COMP-5 VALUE  4.
       01  SQL-RETURN-VALUE          GLOBAL PIC  9(4) COMP-5 VALUE  5.

      * SQL_ATTR_PARAM_BIND_TYPE statement attribute value
      * for SQLBindParameter                         (ODBC Ver >= 3.0)
       01  sql-param-bind-by-column  global pic  9(9) comp-5 value  0.
        01 sql-param-bind-type-default redefines
             sql-param-bind-by-column
                                     global pic  9(9) comp-5.

      ******************************************************************
      * SQLBulkOperations                            (ODBC Ver >= 3.0) *
      ******************************************************************
       01  sql-add                   global pic  9(4) comp-5 value  4.
        01 sql-setpos-max-option-value redefines sql-add
                                     global pic  9(4) comp-5.
       01  sql-update-by-bookmark    global pic  9(4) comp-5 value  5.
       01  sql-delete-by-bookmark    global pic  9(4) comp-5 value  6.
       01  sql-fetch-by-bookmark     global pic  9(4) comp-5 value  7.

      ******************************************************************
      * SQLColAttribute                                                *
      *                  (SQLColAttributes was deprecated and          *
      *                   replaced by SQLColAttribute in ODBC Ver 3.0) *
      ******************************************************************
      ** field identifier
       01  Sql-COLUMN-COUNT         GLOBAL PIC  9(4) COMP-5 VALUE     0.
       01  SQL-COLATT-OPT-MIN REDEFINES SQL-COLUMN-COUNT
                                    GLOBAL PIC  9(4) COMP-5.
       01  SQL-COLUMN-NAME          GLOBAL PIC  9(4) COMP-5 VALUE     1.
       01  SQL-COLUMN-TYPE          GLOBAL PIC  9(4) COMP-5 VALUE     2.
        01 sql-desc-concise-type redefines SQL-COLUMN-TYPE
                                    global pic  9(4) comp-5.
       01  Sql-COLUMN-LENGTH        GLOBAL PIC  9(4) COMP-5 VALUE     3.
       01  Sql-COLUMN-PRECISION     GLOBAL PIC  9(4) COMP-5 VALUE     4.
       01  Sql-COLUMN-SCALE         GLOBAL PIC  9(4) COMP-5 VALUE     5.
       01  SQL-COLUMN-DISPLAY-SIZE  GLOBAL PIC  9(4) COMP-5 VALUE     6.
        01 sql-desc-display-size redefines SQL-COLUMN-DISPLAY-SIZE
                                    global pic  9(4) comp-5.
       01  SQL-COLUMN-NULLABLE      GLOBAL PIC  9(4) COMP-5 VALUE     7.
       01  SQL-COLUMN-UNSIGNED      GLOBAL PIC  9(4) COMP-5 VALUE     8.
        01 sql-desc-unsigned redefines SQL-COLUMN-UNSIGNED
                                    global pic  9(4) comp-5.
       01  SQL-COLUMN-MONEY         GLOBAL PIC  9(4) COMP-5 VALUE     9.
        01 sql-desc-fixed-prec-scale redefines SQL-COLUMN-MONEY
                                    global pic  9(4) comp-5.
       01  SQL-COLUMN-UPDATABLE     GLOBAL PIC  9(4) COMP-5 VALUE    10.
        01 sql-desc-updatable redefines SQL-COLUMN-UPDATABLE
                                    global pic  9(4) comp-5.
       01  SQL-COLUMN-AUTO-INCREMENT
                                    GLOBAL PIC  9(4) COMP-5 VALUE    11.
        01 sql-desc-auto-unique-value redefines
             SQL-COLUMN-AUTO-INCREMENT
                                    global pic  9(4) comp-5.
       01  SQL-COLUMN-CASE-SENSITIVE
                                    GLOBAL PIC  9(4) COMP-5 VALUE    12.
        01 sql-desc-case-sensitive redefines SQL-COLUMN-CASE-SENSITIVE
                                    global pic  9(4) comp-5.
       01  SQL-COLUMN-SEARCHABLE    GLOBAL PIC  9(4) COMP-5 VALUE    13.
        01 sql-desc-searchable redefines SQL-COLUMN-SEARCHABLE
                                    global pic  9(4) comp-5.
       01  SQL-COLUMN-TYPE-NAME     GLOBAL PIC  9(4) COMP-5 VALUE    14.
        01 sql-desc-type-name redefines SQL-COLUMN-TYPE-NAME
                                    global pic  9(4) comp-5.
       01  SQL-COLUMN-TABLE-NAME    GLOBAL PIC  9(4) COMP-5 VALUE    15.
        01 sql-desc-table-name redefines SQL-COLUMN-TABLE-NAME
                                    global pic  9(4) comp-5.
       01  SQL-COLUMN-OWNER-NAME    GLOBAL PIC  9(4) COMP-5 VALUE    16.
        01 sql-desc-schema-name redefines SQL-COLUMN-OWNER-NAME
                                    global pic  9(4) comp-5.
       01  SQL-COLUMN-QUALIFIER-NAME
                                    GLOBAL PIC  9(4) COMP-5 VALUE    17.
        01 sql-desc-catalog-name redefines SQL-COLUMN-QUALIFIER-NAME
                                    global pic  9(4) comp-5.
       01  SQL-COLUMN-LABEL         GLOBAL PIC  9(4) COMP-5 VALUE    18.
        01 sql-desc-label redefines SQL-COLUMN-LABEL
                                    global pic  9(4) comp-5.
       01  SQL-COLATT-OPT-MAX REDEFINES SQL-COLUMN-LABEL
                                    GLOBAL PIC  9(4) COMP-5.
      * (ODBC Ver >= 3.0)
       01  sql-desc-array-size      global pic  9(4) comp-5 value    20.
       01  sql-desc-array-status-ptr
                                    global pic  9(4) comp-5 value    21.
       01  sql-desc-base-column-name
                                    global pic  9(4) comp-5 value    22.
       01  sql-desc-base-table-name
                                    global pic  9(4) comp-5 value    23.
       01  sql-desc-base-offset-ptr
                                    global pic  9(4) comp-5 value    24.
       01  sql-desc-bind-type       global pic  9(4) comp-5 value    25.
      *     (name truncated from sql-desc-datetime-interval-precision)
       01  sql-desc-datetime-interval-pre
                                    global pic  9(4) comp-5 value    26.
       01  sql-desc-literal-prefix  global pic  9(4) comp-5 value    27.
       01  sql-desc-literal-suffix  global pic  9(4) comp-5 value    28.
       01  sql-desc-local-type-name
                                    global pic  9(4) comp-5 value    29.
       01  sql-desc-maximum-scale   global pic  9(4) comp-5 value    30.
       01  sql-desc-minimum-scale   global pic  9(4) comp-5 value    31.
       01  sql-desc-num-prec-radix  global pic  9(4) comp-5 value    32.
       01  sql-desc-parameter-type  global pic  9(4) comp-5 value    33.
       01  sql-desc-rows-processed-ptr
                                    global pic  9(4) comp-5 value    34.

      * (ODBC Ver < 3.0)
       01  SQL-COLUMN-DRIVER-START  GLOBAL PIC  9(4) COMP-5 VALUE  1000.

      * (ODBC Ver >= 3.0)
       01  sql-desc-count           global pic  9(4) comp-5 value  1001.
       01  sql-desc-type            global pic  9(4) comp-5 value  1002.
       01  sql-desc-length          global pic  9(4) comp-5 value  1003.
       01  sql-desc-octet-length-ptr
                                    global pic  9(4) comp-5 value  1004.
       01  sql-desc-precision       global pic  9(4) comp-5 value  1005.
       01  sql-desc-scale           global pic  9(4) comp-5 value  1006.
       01  sql-desc-datetime-interval-cod
                                    global pic  9(4) comp-5 value  1007.
       01  sql-desc-nullable        global pic  9(4) comp-5 value  1008.
       01  sql-desc-indicator-ptr   global pic  9(4) comp-5 value  1009.
       01  sql-desc-data-ptr        global pic  9(4) comp-5 value  1010.
       01  sql-desc-name            global pic  9(4) comp-5 value  1011.
       01  sql-desc-unnamed         global pic  9(4) comp-5 value  1012.
       01  sql-desc-octet-length    global pic  9(4) comp-5 value  1013.
       01  sql-desc-alloc-type      global pic  9(4) comp-5 value  1099.


      ** NumericAttribute for sql-desc-updatable
       01  SQL-ATTR-READONLY        GLOBAL PIC  9(4) COMP-5 VALUE     0.
       01  SQL-ATTR-WRITE           GLOBAL PIC  9(4) COMP-5 VALUE     1.
       01  SQL-ATTR-READWRITE-UNKNOWN
                                    GLOBAL PIC  9(4) COMP-5 VALUE     2.

      ** NumericAttribute for sql-desc-seachable
       01  SQL-UNSEARCHABLE         GLOBAL PIC  9(4) COMP-5 VALUE     0.
       01  SQL-LIKE-ONLY            GLOBAL PIC  9(4) COMP-5 VALUE     1.
        01 sql-col-pred-char  redefines  SQL-LIKE-ONLY
                                    global pic  9(4) comp-5.
       01  SQL-ALL-EXCEPT-LIKE      GLOBAL PIC  9(4) COMP-5 VALUE     2.
        01 sql-col-pred-basic redefines  SQL-ALL-EXCEPT-LIKE
                                    global pic  9(4) comp-5.
       01  SQL-SEARCHABLE           GLOBAL PIC  9(4) COMP-5 VALUE     3.

      ** NumericAttribute for sql-desc-array-status-ptr
       01  sql-param-success        global pic  9(4) comp-5 value     0.
       01  sql-param-diag-unavailable
                                    global pic  9(4) comp-5 value     1.
       01  sql-param-error          global pic  9(4) comp-5 value     5.
       01  sql-param-success-with-info
                                    global pic  9(4) comp-5 value     6.
       01  sql-param-unused         global pic  9(4) comp-5 value     7.

       01  sql-param-proceed        global pic  9(4) comp-5 value     0.
       01  sql-param-ignore         global pic  9(4) comp-5 value     1.

      ** NumericAttributes for sql-desc-unnamed
       01  sql-named                 global pic  9(4) comp-5 value    0.
       01  sql-unnamed               global pic  9(4) comp-5 value    1.

      ******************************************************************
      * SQLDataSources and SQLFetchScroll                              *
      ******************************************************************
      * fetch direction
       01  SQL-FETCH-NEXT            GLOBAL PIC  9(4) COMP-5 VALUE  1.
       01  SQL-FETCH-FIRST           GLOBAL PIC  9(4) COMP-5 VALUE  2.
      * (ODBC Ver >= 3.0)
       01  sql-fetch-first-user      global pic  9(4) comp-5 value 31.
       01  sql-fetch-first-system    global pic  9(4) comp-5 value 32.

      ******************************************************************
      * SQLDriverConnect                                               *
      ******************************************************************
      * Prompt for connection info
       01  SQL-DRIVER-NOPROMPT       GLOBAL PIC  9(4) COMP-5 VALUE  0.
       01  SQL-DRIVER-COMPLETE       GLOBAL PIC  9(4) COMP-5 VALUE  1.
       01  SQL-DRIVER-PROMPT         GLOBAL PIC  9(4) COMP-5 VALUE  2.
       01  SQL-DRIVER-COMPLETE-REQUIRED
                                     GLOBAL PIC  9(4) COMP-5 VALUE  3.

      ******************************************************************
      * SQLEndTran                                   (ODBC Ver >= 3.0) *
      ******************************************************************
      * completion type
       01  SQL-COMMIT                GLOBAL PIC  9(4) COMP-5 VALUE    0.
       01  SQL-ROLLBACK              GLOBAL PIC  9(4) COMP-5 VALUE    1.

      ******************************************************************
      * SQLFetchScroll                               (ODBC Ver >= 3.0) *
      *                                                                *
      * SQLExtendedFetch                             (Deprecated)      *
      ******************************************************************
      ** fetch orientation                                            **
      **   SQL-FETCH-NEXT and SQL-FETCH-FIRST defined under           **
      **       SQLDataSources                                         **
       01  SQL-FETCH-LAST            GLOBAL PIC  9(4) COMP-5 VALUE    3.
       01  Sql-FETCH-PRIOR           GLOBAL PIC  9(4) COMP-5 VALUE    4.
        01 sql-fetch-previous  redefines Sql-FETCH-PRIOR
                                     global pic  9(4) comp-5.
       01  SQL-FETCH-ABSOLUTE        GLOBAL PIC  9(4) COMP-5 VALUE    5.
       01  SQL-FETCH-RELATIVE        GLOBAL PIC  9(4) COMP-5 VALUE    6.
       01  SQL-FETCH-BOOKMARK        GLOBAL PIC  9(4) COMP-5 VALUE    8.

      ** Status of each row                                           **
       01  SQL-ROW-SUCCESS           GLOBAL PIC  9(4) COMP-5 VALUE    0.
       01  SQL-ROW-DELETED           GLOBAL PIC  9(4) COMP-5 VALUE    1.
       01  SQL-ROW-UPDATED           GLOBAL PIC  9(4) COMP-5 VALUE    2.
       01  SQL-ROW-NOROW             GLOBAL PIC  9(4) COMP-5 VALUE    3.
       01  SQL-ROW-ADDED             GLOBAL PIC  9(4) COMP-5 VALUE    4.
       01  SQL-ROW-ERROR             GLOBAL PIC  9(4) COMP-5 VALUE    5.
      * (ODBC Ver >= 3.0)
       01  sql-row-success-with-info global pic  9(4) comp-5 value    6.
       01  sql-row-proceed           global pic  9(4) comp-5 value    0.
       01  sql-row-ignore            global pic  9(4) comp-5 value    1.

      ******************************************************************
      * SQLForeignKeys                                                 *
      ******************************************************************
      ** Actions to be applied to the foreign key (in result set)     **
       01  SQL-CASCADE               GLOBAL PIC  9(4) COMP-5 VALUE    0.
       01  SQL-RESTRICT              GLOBAL PIC  9(4) COMP-5 VALUE    1.
       01  SQL-SET-NULL              GLOBAL PIC  9(4) COMP-5 VALUE    2.
       01  SQL-NO-ACTION             GLOBAL PIC  9(4) COMP-5 VALUE    3.
       01  SQL-SET-DEFAULT           GLOBAL PIC  9(4) COMP-5 VALUE    4.
      * (ODBC Ver <= 3.0)
       01  sql-initially-deferred    global pic  9(4) comp-5 value    5.
       01  sql-initially-immediate   global pic  9(4) comp-5 value    6.

      ******************************************************************
      * SQLFreeStmt                                                    *
      ******************************************************************
      * Option values
       01  SQL-CLOSE                 GLOBAL PIC 9(4) COMP-5 VALUE     0.
       01  SQL-DROP                  GLOBAL PIC 9(4) COMP-5 VALUE     1.
       01  SQL-UNBIND                GLOBAL PIC 9(4) COMP-5 VALUE     2.
       01  SQL-RESET-PARAMS          GLOBAL PIC 9(4) COMP-5 VALUE     3.

      ******************************************************************
      * SQLGetConnectAttr, SQLSetConnectAttr         (ODBC Ver >= 3.0) *
      *                                                                *
      * SQLGetConnectOption, SQLSetConnectOption     (Deprecated)      *
      ******************************************************************
      ***  Option to Retrieve or Set (Attribute) -  (ODBC Ver >= 3.0)***
      ***  Option to Retrieve or Set (fOption) -    (ODBC Ver < 3.0) ***

       01  SQL-ACCESS-MODE          GLOBAL PIC  9(4) COMP-5 VALUE   101.
        01 sql-attr-access-mode redefines SQL-ACCESS-MODE
                                    global pic  9(4) comp-5.

      * (ODBCVer < 3.0)
       01  Sql-CONN-OPT-MIN REDEFINES SQL-ACCESS-MODE
                                    GLOBAL PIC  9(4) COMP-5.
      *

       01  SQL-AUTOCOMMIT           GLOBAL PIC  9(4) COMP-5 VALUE   102.
        01 sql-attr-autocommit redefines SQL-AUTOCOMMIT
                                    global pic  9(4) comp-5.
       01  SQL-LOGIN-TIMEOUT        GLOBAL PIC  9(4) COMP-5 VALUE   103.
        01 sql-attr-login-timeout redefines SQL-LOGIN-TIMEOUT
                                    global pic  9(4) comp-5.
       01  SQL-OPT-TRACE            GLOBAL PIC  9(4) COMP-5 VALUE   104.
        01 sql-attr-trace redefines SQL-OPT-TRACE
                                    global pic  9(4) comp-5.
       01  SQL-OPT-TRACEFILE        GLOBAL PIC  9(4) COMP-5 VALUE   105.
        01 sql-attr-tracefile redefines SQL-OPT-TRACEFILE
                                    global pic  9(4) comp-5.
       01  SQL-TRANSLATE-DLL        GLOBAL PIC  9(4) COMP-5 VALUE   106.
        01 sql-attr-translate-lib redefines SQL-TRANSLATE-DLL
                                    global pic  9(4) comp-5.
       01  SQL-TRANSLATE-OPTION     GLOBAL PIC  9(4) COMP-5 VALUE   107.
        01 sql-attr-translate-option redefines SQL-TRANSLATE-OPTION
                                    global pic  9(4) comp-5.
       01  SQL-TXN-ISOLATION        GLOBAL PIC  9(4) COMP-5 VALUE   108.
        01 sql-attr-txn-isolation redefines SQL-TXN-ISOLATION
                                    global pic  9(4) comp-5.
       01  SQL-CURRENT-QUALIFIER    GLOBAL PIC  9(4) COMP-5 VALUE   109.
        01 sql-attr-current-catalog redefines SQL-CURRENT-QUALIFIER
                                    global pic  9(4) comp-5.
      * ODBC < 2.0 *
      *01  SQL-CONN-OPT-MAX                SQL-CURRENT-QUALIFIER
      * ODBC = 2.0 *
       01  SQL-ODBC-CURSORS         GLOBAL PIC  9(4) COMP-5 VALUE   110.
        01 sql-attr-odbc-cursors redefines SQL-ODBC-CURSORS
                                    global pic  9(4) comp-5.
       01  SQL-QUIET-MODE           GLOBAL PIC  9(4) COMP-5 VALUE   111.
        01 sql-attr-quiet-mode redefines SQL-QUIET-MODE
                                    global pic  9(4) comp-5.
       01  SQL-PACKET-SIZE          GLOBAL PIC  9(4) COMP-5 VALUE   112.
        01 sql-attr-packet-size redefines SQL-PACKET-SIZE
                                    global pic  9(4) comp-5.

      * (ODBC Ver < 3.0)
       01  Sql-CONN-OPT-MAX REDEFINES SQL-PACKET-SIZE
                                    GLOBAL PIC  9(4) COMP-5.
      * (ODBC Ver >= 3.0)
       01  sql-attr-connection-timeout
                                    global pic  9(4) comp-5 value   113.
       01  sql-attr-disconnect-behavior
                                    global pic  9(4) comp-5 value   114.

      * (ODBC Ver < 3.0)
       01  Sql-CONNECT-OPT-DRVR-START
                                    GLOBAL PIC  9(4) COMP-5 VALUE  1000.
      * (ODBC Ver >= 3.0)
       01  sql-attr-enlist-in-dtc   global pic  9(4) comp-5 value  1207.
       01  sql-attr-enlist-in-xa    global pic  9(4) comp-5 value  1208.

       01  sql-attr-auto-ipd        global pic  9(4) comp-5 value 10001.
       01  sql-attr-metadata-id     global pic  9(4) comp-5 value 10014.

      ** ValuePtr content with Attribute = SQL-ACCESS-MODE  **
       01  SQL-MODE-READ-WRITE       GLOBAL PIC  9(9) COMP-5 VALUE  0.
       01  SQL-MODE-DEFAULT REDEFINES SQL-MODE-READ-WRITE
                                     GLOBAL PIC  9(9) COMP-5.
       01  SQL-MODE-READ-ONLY        GLOBAL PIC  9(9) COMP-5 VALUE  1.

      ** ValuePtr content with Attribute = SQL-AUTOCOMMIT **
       01  SQL-AUTOCOMMIT-OFF        GLOBAL PIC  9(9) COMP-5 VALUE  0.
       01  SQL-AUTOCOMMIT-ON         GLOBAL PIC  9(9) COMP-5 VALUE  1.
       01  SQL-AUTOCOMMIT-DEFAULT REDEFINES SQL-AUTOCOMMIT-ON
                                     GLOBAL PIC  9(9) COMP-5.

      ** ValuePtr content with Attribute = SQL-LOGIN-TIMEOUT **
       01  SQL-LOGIN-TIMEOUT-DEFAULT GLOBAL PIC  9(9) COMP-5 VALUE 15.

      ** ValuePtr content with Attribute = SQL-OPT-TRACE **
       01  SQL-OPT-TRACE-OFF         GLOBAL PIC  9(9) COMP-5 VALUE  0.
       01  SQL-OPT-TRACE-DEFAULT REDEFINES SQL-OPT-TRACE-OFF
                                     GLOBAL PIC  9(9) COMP-5.
       01  SQL-OPT-TRACE-ON          GLOBAL PIC  9(9) COMP-5 VALUE  1.
       01  SQL-OPT-TRACE-FILE-DEFAULT
                                     GLOBAL PIC  X(9)
                                                   VALUE  Z"\SQL.LOG".

      ** ValuePtr content with Attribute = SQL-ODBC-CURSOR **
       01  SQL-CUR-USE-IF-NEEDED     GLOBAL PIC  9(9) COMP-5 VALUE  0.
       01  SQL-CUR-USE-ODBC          GLOBAL PIC  9(9) COMP-5 VALUE  1.
       01  SQL-CUR-USE-DRIVER        GLOBAL PIC  9(9) COMP-5 VALUE  2.
       01  SQL-CUR-DEFAULT REDEFINES SQL-CUR-USE-DRIVER
                                     GLOBAL PIC  9(9) COMP-5.

      ** ValuePtr content with Attribute = sql-attr-disconnect-behavior
      * (ODBC Ver >= 3.0 )
       01  sql-db-return-to-pool     global pic  9(9) comp-5 value  0.
        01 sql-db-default redefines sql-db-return-to-pool
                                     global pic  9(9) comp-5.
       01  sql-db-disconnect         global pic  9(9) comp-5 value  1.

      ** ValuePtr content with Attribute = sql-attr-enlist-in-dtc
      * (ODBC Ver >= 3.0 )
       01  sql-dtc-done              global pic  9(9) comp-5 value  0.

      ******************************************************************
      * SQLGetData                                                     *
      ******************************************************************
      ** Number of bytes available cannot be determined - *pcbValue **
       01  SQL-NO-TOTAL             GLOBAL PIC S9(4) COMP-5 VALUE    -4.
       01  sql-ard-type             global pic s9(4) comp-5 value   -99.

      ******************************************************************
      * SQLGetDiagField                              (ODBC Ver >= 3.0) *
      ******************************************************************
      ** diagnostic information identifier
       01  sql-diag-cursor-row-count
                                    global pic s9(4) comp-5 value -1249.
       01  sql-diag-row-number      global pic s9(4) comp-5 value -1248.
       01  sql-diag-column-number   global pic s9(4) comp-5 value -1247.

       01  sql-diag-returncode      global pic  9(4) comp-5 value     1.
       01  sql-diag-number          global pic  9(4) comp-5 value     2.
       01  sql-diag-row-count       global pic  9(4) comp-5 value     3.
       01  sql-diag-sqlstaten       global pic  9(4) comp-5 value     4.
       01  sql-diag-native          global pic  9(4) comp-5 value     5.
       01  sql-diag-message-text    global pic  9(4) comp-5 value     6.
       01  sql-diag-dynamic-function
                                    global pic  9(4) comp-5 value     7.
       01  sql-diag-class-origin    global pic  9(4) comp-5 value     8.
       01  sql-diag-subclass-origin global pic  9(4) comp-5 value     9.
       01  sql-diag-connection-name global pic  9(4) comp-5 value    10.
       01  sql-diag-server-name     global pic  9(4) comp-5 value    11.
       01  sql-diag-dynamic-function-code
                                    global pic  9(4) comp-5 value    12.

      * sql-diag-column-number field value
       01 sql-no-column-number      global pic s9(4) comp-5 value    -1.
       01 sql-column-number-unknown global pic s9(4) comp-5 value    -2.

      * sql-diag-row-number field value
       01 sql-no-row-number         global pic s9(4) comp-5 value    -1.
       01 sql-row-number-unknown    global pic s9(4) comp-5 value    -2.


      ** dynamic function codes
       01  sql-diag-drop-index      global pic s9(4) comp-5 value    -2.
       01  sql-diag-create-index    global pic s9(4) comp-5 value    -1.
       01  sql-diag-unknown-statement
                                    global pic  9(4) comp-5 value     0.
       01  sql-diag-alter-table     global pic  9(4) comp-5 value     4.
       01  sql-diag-call            global pic  9(4) comp-5 value     7.
       01  sql-diag-delete-where    global pic  9(4) comp-5 value    19.
       01  sql-diag-drop-table      global pic  9(4) comp-5 value    32.
       01  sql-diag-drop-view       global pic  9(4) comp-5 value    36.
       01  sql-diag-dynamic-delete-cursor
                                    global pic  9(4) comp-5 value    38.
       01  sql-diag-grant           global pic  9(4) comp-5 value    48.
       01  sql-diag-insert          global pic  9(4) comp-5 value    50.
       01  sql-diag-revoke          global pic  9(4) comp-5 value    59.
       01  sql-diag-create-table    global pic  9(4) comp-5 value    77.
       01  sql-diag-dynamic-update-cursor
                                    global pic  9(4) comp-5 value    81.
       01  sql-diag-update-where    global pic  9(4) comp-5 value    82.
       01  sql-diag-create-view     global pic  9(4) comp-5 value    84.
       01  sql-diag-select-cursor   global pic  9(4) comp-5 value    85.

      ******************************************************************
      * SQLGetFunctions                                                *
      ******************************************************************
      ***  ODBC function of interest - FunctionID (input)            ***
       01  SQL-API-ALL-FUNCTIONS    GLOBAL PIC  9(4) COMP-5 VALUE     0.

       01  SQL-API-SQLALLOCCONNECT  GLOBAL PIC  9(4) COMP-5 VALUE     1.
       01  SQL-API-SQLALLOCENV      GLOBAL PIC  9(4) COMP-5 VALUE     2.
       01  SQL-API-SQLALLOCSTMT     GLOBAL PIC  9(4) COMP-5 VALUE     3.
       01  SQL-API-SQLBINDCOL       GLOBAL PIC  9(4) COMP-5 VALUE     4.
       01  SQL-API-SQLCANCEL        GLOBAL PIC  9(4) COMP-5 VALUE     5.
       01  SQL-API-SQLCOLATTRIBUTES GLOBAL PIC  9(4) COMP-5 VALUE     6.
       01  SQL-API-SQLCONNECT       GLOBAL PIC  9(4) COMP-5 VALUE     7.
       01  SQL-API-SQLDESCRIBECOL   GLOBAL PIC  9(4) COMP-5 VALUE     8.
       01  SQL-API-SQLDISCONNECT    GLOBAL PIC  9(4) COMP-5 VALUE     9.
       01  SQL-API-SQLERROR         GLOBAL PIC  9(4) COMP-5 VALUE    10.
       01  SQL-API-SQLEXECDIRECT    GLOBAL PIC  9(4) COMP-5 VALUE    11.
       01  SQL-API-SQLEXECUTE       GLOBAL PIC  9(4) COMP-5 VALUE    12.
       01  SQL-API-SQLFETCH         GLOBAL PIC  9(4) COMP-5 VALUE    13.
       01  SQL-API-SQLFREECONNECT   GLOBAL PIC  9(4) COMP-5 VALUE    14.
       01  SQL-API-SQLFREEENV       GLOBAL PIC  9(4) COMP-5 VALUE    15.
       01  SQL-API-SQLFREESTMT      GLOBAL PIC  9(4) COMP-5 VALUE    16.
       01  SQL-API-SQLGETCURSORNAME GLOBAL PIC  9(4) COMP-5 VALUE    17.
       01  SQL-API-SQLNUMRESULTCOLS GLOBAL PIC  9(4) COMP-5 VALUE    18.
       01  SQL-API-SQLPREPARE       GLOBAL PIC  9(4) COMP-5 VALUE    19.
       01  SQL-API-SQLROWCOUNT      GLOBAL PIC  9(4) COMP-5 VALUE    20.
       01  SQL-API-SQLSETCURSORNAME GLOBAL PIC  9(4) COMP-5 VALUE    21.
       01  SQL-API-SQLSETPARAM      GLOBAL PIC  9(4) COMP-5 VALUE    22.
       01  SQL-API-SQLTRANSACT      GLOBAL PIC  9(4) COMP-5 VALUE    23.
       01  sql-api-sqlbulkoperations
                                    global pic  9(4) comp-5 value    24.

       01  SQL-API-SQL-COLUMNS      GLOBAL PIC  9(4) COMP-5 VALUE    40.
       01  SQL-API-SQLDRIVERCONNECT GLOBAL PIC  9(4) COMP-5 VALUE    41.
       01  SQL-API-SQLGETCONNECTOPTION
                                    GLOBAL PIC  9(4) COMP-5 VALUE    42.
       01  SQL-API-SQLGETDATA       GLOBAL PIC  9(4) COMP-5 VALUE    43.
       01  SQL-API-SQLGETFUNCTIONS  GLOBAL PIC  9(4) COMP-5 VALUE    44.
       01  SQL-API-SQLGETINFO       GLOBAL PIC  9(4) COMP-5 VALUE    45.
       01  SQL-API-SQLGETSTMTOPTION GLOBAL PIC  9(4) COMP-5 VALUE    46.
       01  SQL-API-SQLGETTYPEINFO   GLOBAL PIC  9(4) COMP-5 VALUE    47.
       01  SQL-API-SQLPARAMDATA     GLOBAL PIC  9(4) COMP-5 VALUE    48.
       01  SQL-API-SQLPUTDATA       GLOBAL PIC  9(4) COMP-5 VALUE    49.
       01  SQL-API-SQLSETCONNECTOPTION
                                    GLOBAL PIC  9(4) COMP-5 VALUE    50.
       01  SQL-API-SQLSETSTMTOPTION GLOBAL PIC  9(4) COMP-5 VALUE    51.
       01  SQL-API-SQLSPECIALCOLUMNS
                                    GLOBAL PIC  9(4) COMP-5 VALUE    52.
       01  SQL-API-SQLSTATISTICS    GLOBAL PIC  9(4) COMP-5 VALUE    53.
       01  SQL-API-SQLTABLES        GLOBAL PIC  9(4) COMP-5 VALUE    54.
       01  SQL-API-SQLBROWSECONNECT GLOBAL PIC  9(4) COMP-5 VALUE    55.
       01  SQL-API-SQL-COLUMNPRIVILEGES
                                    GLOBAL PIC  9(4) COMP-5 VALUE    56.
       01  SQL-API-SQLDATASOURCES   GLOBAL PIC  9(4) COMP-5 VALUE    57.
       01  SQL-API-SQLDESCRIBEPARAM GLOBAL PIC  9(4) COMP-5 VALUE    58.
       01  SQL-API-SQLEXTENDEDFETCH GLOBAL PIC  9(4) COMP-5 VALUE    59.
       01  SQL-API-SQLFOREIGNKEYS   GLOBAL PIC  9(4) COMP-5 VALUE    60.
       01  SQL-API-SQLMORERESULTS   GLOBAL PIC  9(4) COMP-5 VALUE    61.
       01  SQL-API-SQLNATIVESQL     GLOBAL PIC  9(4) COMP-5 VALUE    62.
       01  SQL-API-SQLNUMPARAMS     GLOBAL PIC  9(4) COMP-5 VALUE    63.
       01  SQL-API-SQLPARAMOPTIONS  GLOBAL PIC  9(4) COMP-5 VALUE    64.
       01  SQL-API-SQLPRIMARYKEYS   GLOBAL PIC  9(4) COMP-5 VALUE    65.
       01  SQL-API-SQLPROCEDURECOLUMNS
                                    GLOBAL PIC  9(4) COMP-5 VALUE    66.
       01  SQL-API-SQLPROCEDURES    GLOBAL PIC  9(4) COMP-5 VALUE    67.
       01  SQL-API-SQLSETPOS        GLOBAL PIC  9(4) COMP-5 VALUE    68.
       01  SQL-API-SQLSETSCROLLOPTIONS
                                    GLOBAL PIC  9(4) COMP-5 VALUE    69.
       01  SQL-API-SQLTABLEPRIVILEGES
                                    GLOBAL PIC  9(4) COMP-5 VALUE    70.
       01  SQL-API-SQLDRIVERS       GLOBAL PIC  9(4) COMP-5 VALUE    71.
       01  SQL-API-SQLBINDPARAMETER GLOBAL PIC  9(4) COMP-5 VALUE    72.
       01  sql-api-sqlallochandlestd
                                    global pic  9(4) comp-5 value    73.

       01  SQL-API-LOADBYORDINAL    GLOBAL PIC  9(4) COMP-5 VALUE   199.

      * (ODBC Ver >= 3.0)
       01  sql-api-sqlallochandle   global pic  9(4) comp-5 value  1001.
       01  sql-api-sqlbindparam     global pic  9(4) comp-5 value  1002.
       01  sql-api-sqlclosecursor   global pic  9(4) comp-5 value  1003.
       01  sql-api-sqlcopydesc      global pic  9(4) comp-5 value  1004.
       01  sql-api-sqlendtran       global pic  9(4) comp-5 value  1005.
       01  sql-api-sqlfreehandle    global pic  9(4) comp-5 value  1006.
       01  sql-api-sqlgetconnectattr
                                    global pic  9(4) comp-5 value  1007.
       01  sql-api-sqlgetdescfield  global pic  9(4) comp-5 value  1008.
       01  sql-api-sqlgetdescrec    global pic  9(4) comp-5 value  1009.
       01  sql-api-sqlgetdiagfield  global pic  9(4) comp-5 value  1010.
       01  sql-api-sqlgetdiagrec    global pic  9(4) comp-5 value  1011.
       01  sql-api-sqlgetenvattr    global pic  9(4) comp-5 value  1012.

       01  sql-api-sqlgetstmtattr   global pic  9(4) comp-5 value  1014.

       01  sql-api-sqlsetconnectattr
                                    global pic  9(4) comp-5 value  1016.
       01  sql-api-sqlsetdescfield  global pic  9(4) comp-5 value  1017.
       01  sql-api-sqlsetdescrec    global pic  9(4) comp-5 value  1018.
       01  sql-api-sqlsetenvattr    global pic  9(4) comp-5 value  1019.
       01  sql-api-sqlsetstmtattr   global pic  9(4) comp-5 value  1020.
       01  sql-api-sqlfetchscroll   global pic  9(4) comp-5 value  1021.


      * (ODBC Ver < 3.0)
       01  Sql-NUM-FUNCTIONS        GLOBAL PIC  9(4) COMP-5 VALUE    23.
       01  Sql-EXT-API-START        GLOBAL PIC  9(4) COMP-5 VALUE    40.
       01  Sql-EXT-API-LAST         GLOBAL PIC  9(4) COMP-5 VALUE    72.
      *      = SQL-API-SQLBINDPARAMETER
       01  Sql-NUM-EXTENSIONS       GLOBAL PIC  9(4) COMP-5 VALUE    33.
      *      = Sql-EXT-API-LAST - Sql-API-START + 1

      ******************************************************************
      * SQLGetInfo                                                     *
      ******************************************************************
      ***  Infomation type of interest - fInfoType (input) ***
      **   ODBC driver information  **
       01  SQL-INFO-FIRST            GLOBAL PIC  9(4) COMP-5 VALUE    0.
       01  Sql-ACTIVE-CONNECTIONS    GLOBAL PIC  9(4) COMP-5 VALUE    0.
        01 sql-max-driver-connections redefines
             SQL-ACTIVE-CONNECTIONS
                                     global pic  9(4) comp-5.
        01 sql-maximum-driver-connections redefines
             sql-max-driver-connections
                                     global pic  9(4) comp-5.
       01  Sql-ACTIVE-STATEMENTS     GLOBAL PIC  9(4) COMP-5 VALUE    1.
        01 sql-max-concurrent-activities redefines
             SQL-ACTIVE-STATEMENTS
                                     global pic  9(4) comp-5.
        01 sql-maximum-concurrent-activit redefines
             sql-max-concurrent-activities
                                     global pic  9(4) comp-5.
       01  SQL-DATA-SOURCE-NAME      GLOBAL PIC  9(4) COMP-5 VALUE    2.
       01  SQL-DRIVER-HDBC           GLOBAL PIC  9(4) COMP-5 VALUE    3.
       01  SQL-DRIVER-HENV           GLOBAL PIC  9(4) COMP-5 VALUE    4.
       01  SQL-DRIVER-HSTMT          GLOBAL PIC  9(4) COMP-5 VALUE    5.
       01  SQL-DRIVER-NAME           GLOBAL PIC  9(4) COMP-5 VALUE    6.
       01  SQL-DRIVER-VER            GLOBAL PIC  9(4) COMP-5 VALUE    7.
       01  Sql-FETCH-DIRECTION       GLOBAL PIC  9(4) COMP-5 VALUE    8.
       01  Sql-ODBC-API-CONFORMANCE  GLOBAL PIC  9(4) COMP-5 VALUE    9.
       01  SQL-ODBC-VER              GLOBAL PIC  9(4) COMP-5 VALUE   10.
       01  SQL-ROW-UPDATES           GLOBAL PIC  9(4) COMP-5 VALUE   11.
       01  SQL-ODBC-SAG-CLI-CONFORMANCE
                                     GLOBAL PIC  9(4) COMP-5 VALUE   12.
       01  SQL-SERVER-NAME           GLOBAL PIC  9(4) COMP-5 VALUE   13.
       01  SQL-SEARCH-PATTERN-ESCAPE GLOBAL PIC  9(4) COMP-5 VALUE   14.

      **   DBMS product information  **
      *    (Sql-DATA-BASE-NAME deprecated in ODBC Ver 3.0)
       01  Sql-DATABASE-NAME         GLOBAL PIC  9(4) COMP-5 VALUE   16.

       01  SQL-DBMS-NAME             GLOBAL PIC  9(4) COMP-5 VALUE   17.
       01  SQL-DBMS-VER              GLOBAL PIC  9(4) COMP-5 VALUE   18.

      **   Data source information   **
       01  SQL-ACCESSIBLE-TABLES     GLOBAL PIC  9(4) COMP-5 VALUE   19.
       01  SQL-ACCESSIBLE-PROCEDURES GLOBAL PIC  9(4) COMP-5 VALUE   20.
       01  SQL-CONCAT-NULL-BEHAVIOR  GLOBAL PIC  9(4) COMP-5 VALUE   22.
       01  SQL-CURSOR-COMMIT-BEHAVIOR
                                     GLOBAL PIC  9(4) COMP-5 VALUE   23.
       01  SQL-CURSOR-ROLLBACK-BEHAVIOR
                                     GLOBAL PIC  9(4) COMP-5 VALUE   24.
       01  SQL-DATA-SOURCE-READ-ONLY GLOBAL PIC  9(4) COMP-5 VALUE   25.
       01  SQL-DEFAULT-TXN-ISOLATION GLOBAL PIC  9(4) COMP-5 VALUE   26.

       01  SQL-EXPRESSIONS-IN-ORDERBY
                                     GLOBAL PIC  9(4) COMP-5 VALUE   27.
       01  SQL-IDENTIFIER-CASE       GLOBAL PIC  9(4) COMP-5 VALUE   28.

      **   SQL limits   **
       01  SQL-MAX-COLUMN-NAME-LEN   GLOBAL PIC  9(4) COMP-5 VALUE   30.
        01 sql-maximum-column-name-length redefines
             SQL-MAX-COLUMN-NAME-LEN
                                     global pic  9(4) comp-5.
       01  SQL-MAX-CURSOR-NAME-LEN   GLOBAL PIC  9(4) COMP-5 VALUE   31.
        01 sql-maximum-cursor-name-length redefines
             SQL-MAX-CURSOR-NAME-LEN
                                     global pic  9(4) comp-5.
       01  Sql-MAX-OWNER-NAME-LEN    GLOBAL PIC  9(4) COMP-5 VALUE   32.
       01  sql-max-schema-name-len redefines
             sql-max-owner-name-len
                                     global pic  9(4) comp-5.
        01 sql-maximum-schema-name-length redefines
             SQL-MAX-SCHEMA-NAME-LEN
                                     global pic  9(4) comp-5.
       01  SQL-MAX-PROCEDURE-NAME-LEN
                                     GLOBAL PIC  9(4) COMP-5 VALUE   33.
       01  Sql-MAX-QUALIFIER-NAME-LEN
                                     GLOBAL PIC  9(4) COMP-5 VALUE   34.
       01  sql-max-catalog-name-len redefines Sql-MAX-QUALIFIER-NAME-LEN
                                     global pic  9(4) comp-5.
        01 sql-maximum-catalog-name-lengt redefines
             sql-max-catalog-name-len
                                     global pic  9(4) comp-5.
       01  SQL-MAX-TABLE-NAME-LEN    GLOBAL PIC  9(4) COMP-5 VALUE   35.
       01  SQL-MULT-RESULT-SETS      GLOBAL PIC  9(4) COMP-5 VALUE   36.
       01  SQL-MULTIPLE-ACTIVE-TXN   GLOBAL PIC  9(4) COMP-5 VALUE   37.
       01  Sql-OWNER-TERM            GLOBAL PIC  9(4) COMP-5 VALUE   39.
        01 sql-schema-term redefines Sql-OWNER-TERM
                                     global pic  9(4) comp-5.
       01  SQL-PROCEDURE-TERM        GLOBAL PIC  9(4) COMP-5 VALUE   40.
       01  Sql-QUALIFIER-TERM        GLOBAL PIC  9(4) COMP-5 VALUE   42.
        01 sql-catalog-term redefines Sql-QUALIFIER-TERM
                                     global pic  9(4) comp-5.
       01  Sql-SCROLL-CONCURRENCY    GLOBAL PIC  9(4) COMP-5 VALUE   43.
       01  SQL-SCROLL-OPTIONS        GLOBAL PIC  9(4) COMP-5 VALUE   44.
       01  SQL-TABLE-TERM            GLOBAL PIC  9(4) COMP-5 VALUE   45.
       01  SQL-TXN-CAPABLE           GLOBAL PIC  9(4) COMP-5 VALUE   46.
        01 sql-transaction-capable redefines
             SQL-TXN-CAPABLE         global pic  9(4) comp-5.
       01  SQL-USER-NAME             GLOBAL PIC  9(4) COMP-5 VALUE   47.

       01  SQL-IDENTIFIER-QUOTE-CHAR GLOBAL PIC  9(4) COMP-5 VALUE   29.
       01  Sql-ODBC-SQL-CONFORMANCE  GLOBAL PIC  9(4) COMP-5 VALUE   15.
       01  Sql-ODBC-SQL-OPT-IEF      GLOBAL PIC  9(4) COMP-5 VALUE   73.
        01 sql-integrity redefines Sql-ODBC-SQL-OPT-IEF
                                     global pic  9(4) comp-5.
       01  SQL-CORRELATION-NAME      GLOBAL PIC  9(4) COMP-5 VALUE   74.
       01  SQL-NON-NULLABLE-COLUMNS  GLOBAL PIC  9(4) COMP-5 VALUE   75.
       01  SQL-DRIVER-HLIB           GLOBAL PIC  9(4) COMP-5 VALUE   76.
       01  SQL-DRIVER-ODBC-VER       GLOBAL PIC  9(4) COMP-5 VALUE   77.
       01  Sql-LOCK-TYPES            GLOBAL PIC  9(4) COMP-5 VALUE   78.
       01  Sql-POS-OPERATIONS        GLOBAL PIC  9(4) COMP-5 VALUE   79.
       01  SQL-GETDATA-EXTENSIONS    GLOBAL PIC  9(4) COMP-5 VALUE   81.
       01  SQL-FILE-USAGE            GLOBAL PIC  9(4) COMP-5 VALUE   84.

       01  SQL-ALTER-TABLE           GLOBAL PIC  9(4) COMP-5 VALUE   86.
       01  SQL-COLUMN-ALIAS          GLOBAL PIC  9(4) COMP-5 VALUE   87.
       01  SQL-GROUP-BY              GLOBAL PIC  9(4) COMP-5 VALUE   88.
       01  SQL-KEYWORDS              GLOBAL PIC  9(4) COMP-5 VALUE   89.
       01  SQL-LIKE-ESCAPE-CLAUSE    GLOBAL PIC  9(4) COMP-5 VALUE  113.
       01  SQL-ORDER-BY-COLUMNS-IN-SELECT
                                     GLOBAL PIC  9(4) COMP-5 VALUE   90.
       01  Sql-OUTER-JOINS           GLOBAL PIC  9(4) COMP-5 VALUE   38.
       01  SQL-OWNER-USAGE           GLOBAL PIC  9(4) COMP-5 VALUE   91.
        01 sql-schema-usage redefines Sql-OWNER-USAGE
                                     global pic  9(4) comp-5.
       01  Sql-POSITIONED-STATEMENTS GLOBAL PIC  9(4) COMP-5 VALUE   80.
       01  SQL-PROCEDURES            GLOBAL PIC  9(4) COMP-5 VALUE   21.
       01  Sql-QUALIFIER-LOCATION    GLOBAL PIC  9(4) COMP-5 VALUE  114.
        01 sql-catalog-location redefines Sql-QUALIFIER-LOCATION
                                     global pic  9(4) comp-5.
       01  Sql-QUALIFIER-NAME-SEPARATOR
                                     GLOBAL PIC  9(4) COMP-5 VALUE   41.
        01 sql-catalog-name-separator redefines
             Sql-QUALIFIER-NAME-SEPARATOR
                                     global pic  9(4) comp-5.
       01  Sql-QUALIFIER-USAGE       GLOBAL PIC  9(4) COMP-5 VALUE   92.
        01 sql-catalog-usage redefines Sql-QUALIFIER-USAGE
                                     global pic  9(4) comp-5.
       01  SQL-QUOTED-IDENTIFIER-CASE
                                     GLOBAL PIC  9(4) COMP-5 VALUE   93.
       01  SQL-SPECIAL-CHARACTERS    GLOBAL PIC  9(4) COMP-5 VALUE   94.
       01  SQL-SUBQUERIES            GLOBAL PIC  9(4) COMP-5 VALUE   95.
       01  SQL-UNION                 GLOBAL PIC  9(4) COMP-5 VALUE   96.
        01 sql-union-statement  redefines SQL-UNION
                                     global pic  9(4) comp-5.

       01  SQL-MAX-BINARY-LITERAL-LEN
                                     GLOBAL PIC  9(4) COMP-5 VALUE  112.
       01  SQL-MAX-CHAR-LITERAL-LEN  GLOBAL PIC  9(4) COMP-5 VALUE  108.
       01  SQL-MAX-COLUMNS-IN-GROUP-BY
                                     GLOBAL PIC  9(4) COMP-5 VALUE   97.
        01 sql-maximum-columns-in-group-b redefines
             SQL-MAX-COLUMNS-IN-GROUP-BY
                                     global pic  9(4) comp-5.
       01  SQL-MAX-COLUMNS-IN-INDEX  GLOBAL PIC  9(4) COMP-5 VALUE   98.
        01 sql-maximum-columns-in-index   redefines
             SQL-MAX-COLUMNS-IN-INDEX
                                     global pic  9(4) comp-5.
       01  SQL-MAX-COLUMNS-IN-ORDER-BY
                                     GLOBAL PIC  9(4) COMP-5 VALUE   99.
        01 sql-maximum-columns-in-order-b redefines
             SQL-MAX-COLUMNS-IN-ORDER-BY
                                     global pic  9(4) comp-5.
       01  SQL-MAX-COLUMNS-IN-SELECT
                                     GLOBAL PIC  9(4) COMP-5 VALUE  100.
        01 sql-maximum-columns-in-select  redefines
             SQL-MAX-COLUMNS-IN-SELECT
                                     global pic  9(4) comp-5.
       01  SQL-MAX-COLUMNS-IN-TABLE  GLOBAL PIC  9(4) COMP-5 VALUE  101.
       01  SQL-MAX-INDEX-SIZE        GLOBAL PIC  9(4) COMP-5 VALUE  102.
        01 sql-maximum-index-size         redefines
             SQL-MAX-INDEX-SIZE      global pic  9(4) comp-5.
      *01  SQL-MAX-ROW-SIZE-INCLUDES-LONG
      *                              GLOBAL PIC  9(4) COMP-5 VALUE  103.
       01  SQL-MAX-ROW-SIZE          GLOBAL PIC  9(4) COMP-5 VALUE  104.
        01 sql-maximum-row-size           redefines
             SQL-MAX-ROW-SIZE        global pic  9(4) comp-5.
       01  SQL-MAX-STATEMENT-LEN     GLOBAL PIC  9(4) COMP-5 VALUE  105.
        01 sql-maximum-statement-length   redefines
             SQL-MAX-STATEMENT-LEN   global pic  9(4) comp-5.
       01  SQL-MAX-TABLES-IN-SELECT  GLOBAL PIC  9(4) COMP-5 VALUE  106.
        01 sql-maximum-tables-in-select   redefines
             SQL-MAX-TABLES-IN-SELECT
                                     global pic  9(4) comp-5.
       01  SQL-MAX-USER-NAME-LEN     GLOBAL PIC  9(4) COMP-5 VALUE  107.
        01 sql-maximum-user-name-length   redefines
             SQL-MAX-USER-NAME-LEN   global pic  9(4) comp-5.

      **   Scalar functions supported   **
       01  SQL-CONVERT-FUNCTIONS     GLOBAL PIC  9(4) COMP-5 VALUE   48.
       01  SQL-NUMERIC-FUNCTIONS     GLOBAL PIC  9(4) COMP-5 VALUE   49.
       01  SQL-STRING-FUNCTIONS      GLOBAL PIC  9(4) COMP-5 VALUE   50.
       01  SQL-SYSTEM-FUNCTIONS      GLOBAL PIC  9(4) COMP-5 VALUE   51.
       01  SQL-TIMEDATE-FUNCTIONS    GLOBAL PIC  9(4) COMP-5 VALUE   52.

       01  SQL-TIMEDATE-ADD-INTERVALS
                                     GLOBAL PIC  9(4) COMP-5 VALUE  109.
       01  SQL-TIMEDATE-DIFF-INTERVALS
                                     GLOBAL PIC  9(4) COMP-5 VALUE  110.
      ** (ODBC Ver >= 3.0)
       01  sql-oj-capabilities       global pic  9(4) comp-5 value  115.
        01 sql-outer-join-capabilities redefines
             sql-oj-capabilities     global pic  9(4) comp-5.

      * (ODBC Ver >= 2.01 and < 3.0.  Conflict with 3.0 definition)
      *01  SQL-OJ-CAPABILITIES      GLOBAL PIC  9(4) COMP-5 VALUE 65003.

      **   SQL data types supported for conversion   **
       01  SQL-CONVERT-BIGINT        GLOBAL PIC  9(4) COMP-5 VALUE   53.
       01  SQL-CONVERT-BINARY        GLOBAL PIC  9(4) COMP-5 VALUE   54.
       01  SQL-CONVERT-BIT           GLOBAL PIC  9(4) COMP-5 VALUE   55.
       01  SQL-CONVERT-CHAR          GLOBAL PIC  9(4) COMP-5 VALUE   56.
       01  SQL-CONVERT-DATE          GLOBAL PIC  9(4) COMP-5 VALUE   57.
       01  SQL-CONVERT-DECIMAL       GLOBAL PIC  9(4) COMP-5 VALUE   58.
       01  SQL-CONVERT-DOUBLE        GLOBAL PIC  9(4) COMP-5 VALUE   59.
       01  SQL-CONVERT-FLOAT         GLOBAL PIC  9(4) COMP-5 VALUE   60.
       01  SQL-CONVERT-INTEGER       GLOBAL PIC  9(4) COMP-5 VALUE   61.
       01  SQL-CONVERT-LONGVARBINARY GLOBAL PIC  9(4) COMP-5 VALUE   71.
       01  SQL-CONVERT-LONGVARCHAR   GLOBAL PIC  9(4) COMP-5 VALUE   62.
       01  SQL-CONVERT-NUMERIC       GLOBAL PIC  9(4) COMP-5 VALUE   63.
       01  SQL-CONVERT-REAL          GLOBAL PIC  9(4) COMP-5 VALUE   64.
       01  SQL-CONVERT-SMALLINT      GLOBAL PIC  9(4) COMP-5 VALUE   65.
       01  SQL-CONVERT-TIME          GLOBAL PIC  9(4) COMP-5 VALUE   66.
       01  SQL-CONVERT-TIMESTAMP     GLOBAL PIC  9(4) COMP-5 VALUE   67.
       01  SQL-CONVERT-TINYINT       GLOBAL PIC  9(4) COMP-5 VALUE   68.
       01  SQL-CONVERT-VARBINARY     GLOBAL PIC  9(4) COMP-5 VALUE   69.
       01  SQL-CONVERT-VARCHAR       GLOBAL PIC  9(4) COMP-5 VALUE   70.

       01  SQL-TXN-ISOLATION-OPTION  GLOBAL PIC  9(4) COMP-5 VALUE   72.
        01 sql-transaction-isolation-opti redefines
             SQL-TXN-ISOLATION-OPTION
                                     global pic  9(4) comp-5.

       01  SQL-BOOKMARK-PERSISTENCE  GLOBAL PIC  9(4) COMP-5 VALUE   82.
       01  Sql-STATIC-SENSITIVITY    GLOBAL PIC  9(4) COMP-5 VALUE   83.
       01  SQL-NULL-COLLATION        GLOBAL PIC  9(4) COMP-5 VALUE   85.
       01  SQL-NEED-LONG-DATA-LEN    GLOBAL PIC  9(4) COMP-5 VALUE  111.

      * (ODBC Ver >= 3.0)
       01  sql-active-environments   global pic  9(4) comp-5 value  116.
       01  sql-alter-domain          global pic  9(4) comp-5 value  117.
       01  sql-sql-conformance       global pic  9(4) comp-5 value  118.
       01  sql-datetime-literals     global pic  9(4) comp-5 value  119.
       01  sql-batch-row-count       global pic  9(4) comp-5 value  120.
       01  sql-batch-support         global pic  9(4) comp-5 value  121.
       01  sql-convert-wchar         global pic  9(4) comp-5 value  122.
       01  sql-convert-interval-day-time
                                     global pic  9(4) comp-5 value  123.
      *    (truncated from sql-convert-interval-year-month)
       01  sql-convert-interval-year-mont
                                     global pic  9(4) comp-5 value  124.
       01  sql-convert-wlongvarchar  global pic  9(4) comp-5 value  125.
       01  sql-convert-wvarchar      global pic  9(4) comp-5 value  126.
       01  sql-create-assertion      global pic  9(4) comp-5 value  127.
       01  sql-create-character-set  global pic  9(4) comp-5 value  128.
       01  sql-create-collation      global pic  9(4) comp-5 value  129.
       01  sql-create-domain         global pic  9(4) comp-5 value  130.
       01  sql-create-schema         global pic  9(4) comp-5 value  131.
       01  sql-create-table          global pic  9(4) comp-5 value  132.
       01  sql-create-translation    global pic  9(4) comp-5 value  133.
       01  sql-create-view           global pic  9(4) comp-5 value  134.
       01  sql-driver-hdesc          global pic  9(4) comp-5 value  135.
       01  sql-drop-assertion        global pic  9(4) comp-5 value  136.
       01  sql-drop-characterr-set   global pic  9(4) comp-5 value  137.
       01  sql-drop-collation        global pic  9(4) comp-5 value  138.
       01  sql-drop-domain           global pic  9(4) comp-5 value  139.
       01  sql-drop-schema           global pic  9(4) comp-5 value  140.
       01  sql-drop-table            global pic  9(4) comp-5 value  141.
       01  sql-drop-translation      global pic  9(4) comp-5 value  142.
       01  sql-drop-view             global pic  9(4) comp-5 value  143.
       01  sql-dynamic-cursor-attributes1
                                     global pic  9(4) comp-5 value  144.
       01  sql-dynamic-cursor-attributes2
                                     global pic  9(4) comp-5 value  145.
      *    (truncated from sql-forward-only-cursor-attributes1)
       01  sql-forward-only-cursor-attr1
                                     global pic  9(4) comp-5 value  146.
      *    (truncated from sql-forward-only-cursor-attributes2)
       01  sql-forward-only-cursor-attr2
                                     global pic  9(4) comp-5 value  147.
       01  sql-index-keywords        global pic  9(4) comp-5 value  148.
       01  sql-info-schema-views     global pic  9(4) comp-5 value  149.
       01  sql-keyset-cursor-attributes1
                                     global pic  9(4) comp-5 value  150.
       01  sql-keyset-cursor-attributes2
                                     global pic  9(4) comp-5 value  151.
       01  sql-odbc-interface-conformance
                                     global pic  9(4) comp-5 value  152.
       01  sql-param-array-row-counts
                                     global pic  9(4) comp-5 value  153.
       01  sql-param-array-selects   global pic  9(4) comp-5 value  154.
       01  sql-sql92-datetime-functions
                                     global pic  9(4) comp-5 value  155.
      *    (truncated from sql-sql92-foreign-key-delete-rule)
       01  sql-sql92-foreign-key-delete-r
                                     global pic  9(4) comp-5 value  156.
      *    (truncated from sql-sql92-foreign-key-update-rule)
       01  sql-sql92-foreign-key-update-r
                                     global pic  9(4) comp-5 value  157.
       01  sql-sql92-grant           global pic  9(4) comp-5 value  158.
      *    (truncated from sql-sql92-numeric-value-functions)
       01  sql-sql92-numeric-value-functi
                                     global pic  9(4) comp-5 value  159.
       01  sql-sql92-predicates      global pic  9(4) comp-5 value  160.
      *    (truncated from sql-sql92-relational-join-operations)
       01  sql-sql92-relational-join-ops
                                     global pic  9(4) comp-5 value  161.
       01  sql-sql92-revoke          global pic  9(4) comp-5 value  162.
      *    (truncated from sql-sql92-row-value-constructor)
       01  sql-sql92-row-value-constructo
                                     global pic  9(4) comp-5 value  163.
       01  sql-sql92-string-functions
                                     global pic  9(4) comp-5 value  164.
       01  sql-sql92-value-expressions
                                     global pic  9(4) comp-5 value  165.
       01  sql-standard-cli-conformance
                                     global pic  9(4) comp-5 value  166.
       01  sql-static-cursor-attributes1
                                     global pic  9(4) comp-5 value  167.
       01  sql-static-cursor-attributes2
                                     global pic  9(4) comp-5 value  168.
       01  sql-aggregate-functions   global pic  9(4) comp-5 value  169.
       01  sql-ddl-index             global pic  9(4) comp-5 value  170.
       01  sql-dm-ver                global pic  9(4) comp-5 value  171.
       01  sql-insert-statement      global pic  9(4) comp-5 value  172.

      * (ODBC Ver >= 3.0)
       01  sql-xopen-cli-year       global pic  9(4) comp-5 value 10000.
       01  sql-cursor-sensitivity   global pic  9(4) comp-5 value 10001.
       01  sql-describe-parameter   global pic  9(4) comp-5 value 10002.
       01  sql-catalog-name         global pic  9(4) comp-5 value 10003.
       01  sql-collation-seq        global pic  9(4) comp-5 value 10004.
       01  sql-max-identifier-len   global pic  9(4) comp-5 value 10005.
       01  sql-maximum-identifier-length redefines
             sql-max-identifier-len global pic  9(4) comp-5.

       01  sql-async-mode           global pic  9(4) comp-5 value 10021.
      *    (truncated from sql-max-async-concurrent-statements)
       01  sql-max-async-concurrent-stat
                                    global pic  9(4) comp-5 value 10022.

      * (ODBC Ver < 3.0)
      * ODBC >= 2.0
      *01  SQL-INFO-LAST            GLOBAL PIC  9(4) COMP-5 VALUE   114.
      * ODBC < 2.0
      *01  SQL-INFO-LAST            GLOBAL PIC  9(4) COMP-5 VALUE    75.
      *01  SQL-INFO-DRIVER-START    GLOBAL PIC  9(4) COMP-5 VALUE  1000.

      ***  Information returned                          ***
      ** return value bitmasks for SQL-CONVERT- ...                   **
      * Integer value for X'00000001'.
       01  SQL-CVT-CHAR                                  VALUE 000000001
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000002'.
       01  SQL-CVT-NUMERIC                               VALUE 000000002
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000004'.
       01  SQL-CVT-DECIMAL                               VALUE 000000004
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000008'.
       01  SQL-CVT-INTEGER                               VALUE 000000008
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000010'.
       01  SQL-CVT-SMALLINT                              VALUE 000000016
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000020'.
       01  SQL-CVT-FLOAT                                 VALUE 000000032
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000040'.
       01  SQL-CVT-REAL                                  VALUE 000000064
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000080'.
       01  SQL-CVT-DOUBLE                                VALUE 000000128
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000100'.
       01  SQL-CVT-VARCHAR                               VALUE 000000256
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000200'.
       01  SQL-CVT-LONGVARCHAR                           VALUE 000000512
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000400'.
       01  SQL-CVT-BINARY                                VALUE 000001024
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000800'.
       01  SQL-CVT-VARBINARY                             VALUE 000002048
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00001000'.
       01  SQL-CVT-BIT                                   VALUE 000004096
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00002000'.
       01  SQL-CVT-TINYINT                               VALUE 000008192
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00004000'.
       01  SQL-CVT-BIGINT                                VALUE 000016384
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00008000'.
       01  SQL-CVT-DATE                                  VALUE 000032768
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00010000'.
       01  SQL-CVT-TIME                                  VALUE 000065536
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00020000'.
       01  SQL-CVT-TIMESTAMP                             VALUE 000131072
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00040000'.
       01  SQL-CVT-LONGVARBINARY                         VALUE 000262144
                                    GLOBAL PIC  9(9) COMP-5.

      * (ODBC Ver >= 3.0)
      * Integer value for X'00080000'.
       01  sql-cvt-interval-year-month                   value 000524288
                                    global pic  9(9) comp-5.
      * Integer value for X'00100000'.
       01  sql-cvt-interval-day-time                     value 001048576
                                    global pic  9(9) comp-5.
      * Integer value for X'00200000'.
       01  sql-cvt-wchar                                 value 002097152
                                    global pic  9(9) comp-5.
      * Integer value for X'00400000'.
       01  sql-cvt-wlongvarchar                          value 004194304
                                    global pic  9(9) comp-5.
      * Integer value for X'00800000'.
       01  sql-cvt-wvarchar                              value 008388608
                                    global pic  9(9) comp-5.


      ** Bit mask values for SQL-CONVERT-FUNCTIONS                    **
      * Integer value for X'00000001'.
       01  SQL-FN-CVT-CONVERT                            VALUE 000000001
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000002'.
       01  sql-fn-cvt-cast                               value 000000002
                                    global pic  9(9) comp-5.

      ** Bit mask values for SQL-STRING-FUNCTIONS                     **
      * Integer value for X'00000001'.
       01  SQL-FN-STR-CONCAT                             VALUE 000000001
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000002'.
       01  SQL-FN-STR-INSERT                             VALUE 000000002
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000004'.
       01  SQL-FN-STR-LEFT                               VALUE 000000004
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000008'.
       01  SQL-FN-STR-LTRIM                              VALUE 000000008
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000010'.
       01  SQL-FN-STR-LENGTH                             VALUE 000000016
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000020'.
       01  SQL-FN-STR-LOCATE                             VALUE 000000032
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000040'.
       01  SQL-FN-STR-LCASE                              VALUE 000000064
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000080'.
       01  SQL-FN-STR-REPEAT                             VALUE 000000128
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000100'.
       01  SQL-FN-STR-REPLACE                            VALUE 000000256
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000200'.
       01  SQL-FN-STR-RIGHT                              VALUE 000000512
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000400'.
       01  SQL-FN-STR-RTRIM                              VALUE 000001024
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000800'.
       01  SQL-FN-STR-SUBSTRING                          VALUE 000002048
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00001000'.
       01  SQL-FN-STR-UCASE                              VALUE 000004096
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00002000'.
       01  SQL-FN-STR-ASCII                              VALUE 000008192
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00004000'.
       01  SQL-FN-STR-CHAR                               VALUE 000016384
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00008000'.
       01  SQL-FN-STR-DIFFERENCE                         VALUE 000032768
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00010000'.
       01  SQL-FN-STR-LOCATE-2                           VALUE 000065536
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00020000'.
       01  SQL-FN-STR-SOUNDEX                            VALUE 000131072
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00040000'.
       01  SQL-FN-STR-SPACE                              VALUE 000262144
                                    GLOBAL PIC  9(9) COMP-5.

      * (ODBC Ver >= 3.0)
      * Integer value for X'00080000'.
       01  sql-fn-str-bit-length                         value 000524288
                                    global pic  9(9) comp-5.
      * Integer value for X'00100000'.
       01  sql-fn-str-char-length                        value 001048576
                                    global pic  9(9) comp-5.
      * Integer value for X'00200000'.
       01  sql-fn-str-character-length                   value 002097152
                                    global pic  9(9) comp-5.
      * Integer value for X'00400000'.
       01  sql-fn-str-octet-length                       value 004194304
                                    global pic  9(9) comp-5.
      * Integer value for X'00800000'.
       01  sql-fn-str-position                           value 008388608
                                    global pic  9(9) comp-5.

      ** Bit mask values for sql-sql92-string-functions               **
      **                                             (ODBC Ver >= 3.0 **
      * Integer value for X'00000001'.
       01  sql-ssf-convert                               value 000000001
                                    global pic  9(9) comp-5.
      * Integer value for X'00000002'.
       01  sql-ssf-lower                                 value 000000002
                                    global pic  9(9) comp-5.
      * Integer value for X'00000004'.
       01  sql-ssf-upper                                 value 000000004
                                    global pic  9(9) comp-5.
      * Integer value for X'00000008'.
       01  sql-ssf-substring                             value 000000008
                                    global pic  9(9) comp-5.
      * Integer value for X'00000010'.
       01  sql-ssf-translate                             value 000000016
                                    global pic  9(9) comp-5.
      * Integer value for X'00000020'.
       01  sql-ssf-trim-both                             value 000000032
                                    global pic  9(9) comp-5.
      * Integer value for X'00000040'.
       01  sql-ssf-trim-leading                          value 000000064
                                    global pic  9(9) comp-5.
      * Integer value for X'00000080'.
       01  sql-ssf-trim-trailing                         value 000000128
                                    global pic  9(9) comp-5.

      ** Bit mask values for SQL-NUMERIC-FUNCTIONS                    **
      * Integer value for X'00000001'.
       01  SQL-FN-NUM-ABS                                VALUE 000000001
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000002'.
       01  SQL-FN-NUM-ACOS                               VALUE 000000002
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000004'.
       01  SQL-FN-NUM-ASIN                               VALUE 000000004
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000008'.
       01  SQL-FN-NUM-ATAN                               VALUE 000000008
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000010'.
       01  SQL-FN-NUM-ATAN2                              VALUE 000000016
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000020'.
       01  SQL-FN-NUM-CEILING                            VALUE 000000032
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000040'.
       01  SQL-FN-NUM-COS                                VALUE 000000064
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000080'.
       01  SQL-FN-NUM-COT                                VALUE 000000128
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000100'.
       01  SQL-FN-NUM-EXP                                VALUE 000000256
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000200'.
       01  SQL-FN-NUM-FLOOR                              VALUE 000000512
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000400'.
       01  SQL-FN-NUM-LOG                                VALUE 000001024
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000800'.
       01  SQL-FN-NUM-MOD                                VALUE 000002048
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00001000'.
       01  SQL-FN-NUM-SIGN                               VALUE 000004096
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00002000'.
       01  SQL-FN-NUM-SIN                                VALUE 000008192
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00004000'.
       01  SQL-FN-NUM-SQRT                               VALUE 000016384
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00008000'.
       01  SQL-FN-NUM-TAN                                VALUE 000032768
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00010000'.
       01  SQL-FN-NUM-PI                                 VALUE 000065536
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00020000'.
       01  SQL-FN-NUM-RAND                               VALUE 000131072
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00040000'.
       01  SQL-FN-NUM-DEGREES                            VALUE 000262144
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00080000'.
       01  SQL-FN-NUM-LOG10                              VALUE 000524288
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00100000'.
       01  SQL-FN-NUM-POWER                              VALUE 001048576
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00200000'.
       01  SQL-FN-NUM-RADIANS                            VALUE 002097152
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00400000'.
       01  SQL-FN-NUM-ROUND                              VALUE 004194304
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00800000'.
       01  SQL-FN-NUM-TRUNCATE                           VALUE 008388608
                                    GLOBAL PIC  9(9) COMP-5.

      ** Bit mask values for sql-sql92-numeric-value-functions        **
      **                                             (ODBC Ver >= 3.0 **
      * Integer value for X'00000001'.
       01  sql-snvf-bit-length                           value 000000001
                                    global pic  9(9) comp-5.
      * Integer value for X'00000002'.
       01  sql-snvf-char-length                          value 000000002
                                    global pic  9(9) comp-5.
      * Integer value for X'00000004'.
       01  sql-snvf-character-length                     value 000000004
                                    global pic  9(9) comp-5.
      * Integer value for X'00000008'.
       01  sql-snvf-extract                              value 000000008
                                    global pic  9(9) comp-5.
      * Integer value for X'00000010'.
       01  sql-snvf-octet-length                         value 000000016
                                    global pic  9(9) comp-5.
      * Integer value for X'00000020'.
       01  sql-snvf-position                             value 000000032
                                    global pic  9(9) comp-5.

      ** Bit mask values for SQL-TIMEDATE-FUNCTIONS                   **
      * Integer value for X'00000001'.
       01  SQL-FN-TD-NOW                                 VALUE 000000001
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000002'.
       01  SQL-FN-TD-CURDATE                             VALUE 000000002
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000004'.
       01  SQL-FN-TD-DAYOFMONTH                          VALUE 000000004
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000008'.
       01  SQL-FN-TD-DAYOFWEEK                           VALUE 000000008
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000010'.
       01  SQL-FN-TD-DAYOFYEAR                           VALUE 000000016
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000020'.
       01  SQL-FN-TD-MONTH                               VALUE 000000032
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000040'.
       01  SQL-FN-TD-QUARTER                             VALUE 000000064
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000080'.
       01  SQL-FN-TD-WEEK                                VALUE 000000128
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000100'.
       01  SQL-FN-TD-YEAR                                VALUE 000000256
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000200'.
       01  SQL-FN-TD-CURTIME                             VALUE 000000512
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000400'.
       01  SQL-FN-TD-HOUR                                VALUE 000001024
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000800'.
       01  SQL-FN-TD-MINUTE                              VALUE 000002048
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00001000'.
       01  SQL-FN-TD-SECOND                              VALUE 000004096
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00002000'.
       01  SQL-FN-TD-TIMESTAMPADD                        VALUE 000008192
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00004000'.
       01  SQL-FN-TD-TIMESTAMPDIFF                       VALUE 000016384
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00008000'.
       01  SQL-FN-TD-DAYNAME                             VALUE 000032768
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00010000'.
       01  SQL-FN-TD-MONTHNAME                           VALUE 000065536
                                    GLOBAL PIC  9(9) COMP-5.

      * (ODBC Ver >= 3.0)
      * Integer value for X'00020000'.
       01  sql-fn-td-current-date                        value 000131072
                                    global pic  9(9) comp-5.
      * Integer value for X'00040000'.
       01  sql-fn-td-current-time                        value 000262144
                                    global PIC  9(9) comp-5.
      * Integer value for X'00080000'.
       01  sql-fn-td-current-timestamp                   value 000524288
                                    global PIC  9(9) comp-5.
      * Integer value for X'00100000'.
       01  sql-fn-td-extract                             value 001048576
                                    global PIC  9(9) comp-5.

      ** Bit mask values for sql-sql92-datetime-functions             **
      **                                             (ODBC Ver >= 3.0 **
      * Integer value for X'00000001'.
       01  sql-sdf-current-date                          value 000000001
                                    global pic  9(9) comp-5.
      * Integer value for X'00000002'.
       01  sql-sdf-current-time                          value 000000002
                                    global pic  9(9) comp-5.
      * Integer value for X'00000004'.
       01  sql-sdf-current-timestamp                     value 000000004
                                    global pic  9(9) comp-5.

      ** Bit mask values for SQL-SYSTEM-FUNCTIONS                     **
      * Integer value for X'00000001'.
       01  SQL-FN-SYS-USERNAME                           VALUE 000000001
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000002'.
       01  SQL-FN-SYS-DBNAME                             VALUE 000000002
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000004'.
       01  SQL-FN-SYS-IFNULL                             VALUE 000000004
                                    GLOBAL PIC  9(9) COMP-5.

      ** Bit mask values for SQL-TIMEDATE-ADD-INTERVALS               **
      **                  or SQL-TIMEDATE-DIFF-INTERVALS              **
      * Integer value for X'00000001'.
       01  SQL-FN-TSI-FRAC-SECOND                        VALUE 000000001
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000002'.
       01  SQL-FN-TSI-SECOND                             VALUE 000000002
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000004'.
       01  SQL-FN-TSI-MINUTE                             VALUE 000000004
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000008'.
       01  SQL-FN-TSI-HOUR                               VALUE 000000008
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000010'.
       01  SQL-FN-TSI-DAY                                VALUE 000000016
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000020'.
       01  SQL-FN-TSI-WEEK                               VALUE 000000032
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000040'.
       01  SQL-FN-TSI-MONTH                              VALUE 000000064
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000080'.
       01  SQL-FN-TSI-QUARTER                            VALUE 000000128
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000100'.
       01  SQL-FN-TSI-YEAR                               VALUE 000000256
                                    GLOBAL PIC  9(9) COMP-5.

      ** Bit mask values for SQL-ODBC-API-CONFORMANCE            **
      * Integer value for X'0000'.
       01  SQL-OAC-NONE                                  VALUE 0000
                                    GLOBAL PIC  9(4) COMP-5.
      * Integer value for X'0001'.
       01  SQL-OAC-LEVEL1                                VALUE 0001
                                    GLOBAL PIC  9(4) COMP-5.
      * Integer value for X'0002'.
       01  SQL-OAC-LEVEL2                                VALUE 0002
                                    GLOBAL PIC  9(4) COMP-5.

      ** Bit mask values for SQL-ODBC-SAG-CLI-CONFORMANCE        **
      * Integer value for X'0000'.
       01  SQL-OSCC-NOT-COMPLIANT                        VALUE 0000
                                    GLOBAL PIC  9(4) COMP-5.
      * Integer value for X'0001'.
       01  SQL-OSCC-COMPLIANT                            VALUE 0001
                                    GLOBAL PIC  9(4) COMP-5.

      ** Bit mask values for SQL-ODBC-SQL-CONFORMANCE            **
      * Integer value for X'0000'.
       01  SQL-OSC-MINIMUM                               VALUE 0000
                                    GLOBAL PIC  9(4) COMP-5.
      * Integer value for X'0001'.
       01  SQL-OSC-CORE                                  VALUE 0001
                                    GLOBAL PIC  9(4) COMP-5.
      * Integer value for X'0002'.
       01  SQL-OSC-EXTENDED                              VALUE 0002
                                    GLOBAL PIC  9(4) COMP-5.

      ** Bit mask values for SQL-CONCAT-NULL-BEHAVIOR            **
      * Integer value for X'0000'.
       01  SQL-CB-NULL                                   VALUE 0000
                                    GLOBAL PIC  9(4) COMP-5.
      * Integer value for X'0001'.
       01  SQL-CB-NON-NULL                               VALUE 0001
                                    GLOBAL PIC  9(4) COMP-5.

      ** Bit mask values for SQL-CURSOR-COMMIT-BEHAVIOR          **
      **                  or SQL-CURSOR-ROLLBACK-BEHAVIOR        **
      * Integer value for X'0000'.
       01  Sql-CB-DELETE                                 VALUE 0000
                                    GLOBAL PIC  9(4) COMP-5.
        01 sql-cc-delete  redefines Sql-CB-DELETE
                                    global pic  9(4) comp-5.
        01 sql-cr-delete  redefines Sql-CB-DELETE
                                    global pic  9(4) comp-5.
      * Integer value for X'0001'.
       01  Sql-CB-CLOSE                                  VALUE 0001
                                    GLOBAL PIC  9(4) COMP-5.
        01 sql-cc-close   redefines Sql-CB-CLOSE
                                    global pic  9(4) comp-5.
        01 sql-cr-close   redefines Sql-CB-CLOSE
                                    global pic  9(4) comp-5.
      * Integer value for X'0002'.
       01  Sql-CB-PRESERVE                               VALUE 0002
                                    GLOBAL PIC  9(4) COMP-5.
        01 sql-cc-preserve redefines Sql-CB-PRESERVE
                                    global pic  9(4) comp-5.
        01 sql-cr-preserve redefines Sql-CB-PRESERVE
                                    global pic  9(4) comp-5.

      ** Bit mask values for SQL-IDENTIFIER-CASE                 **
      * Integer value for X'0001'.
       01  SQL-IC-UPPER                                  VALUE 0001
                                    GLOBAL PIC  9(4) COMP-5.
      * Integer value for X'0002'.
       01  SQL-IC-LOWER                                  VALUE 0002
                                    GLOBAL PIC  9(4) COMP-5.
      * Integer value for X'0003'.
       01  SQL-IC-SENSITIVE                              VALUE 0003
                                    GLOBAL PIC  9(4) COMP-5.
      * Integer value for X'0004'.
       01  SQL-IC-MIXED                                  VALUE 0004
                                    GLOBAL PIC  9(4) COMP-5.

      ** Bit mask values for SQL-TXN-CAPABLE                     **
      * Integer value for X'0000'.
       01  SQL-TC-NONE                                   VALUE 0000
                                    GLOBAL PIC  9(4) COMP-5.
      * Integer value for X'0001'.
       01  SQL-TC-DML                                    VALUE 0001
                                    GLOBAL PIC  9(4) COMP-5.
      * Integer value for X'0002'.
       01  SQL-TC-ALL                                    VALUE 0002
                                    GLOBAL PIC  9(4) COMP-5.
      * Integer value for X'0003'.
       01  SQL-TC-DDL-COMMIT                             VALUE 0003
                                    GLOBAL PIC  9(4) COMP-5.
      * Integer value for X'0004'.
       01  SQL-TC-DDL-IGNORE                             VALUE 0004
                                    GLOBAL PIC  9(4) COMP-5.

      ** Bit mask values for SQL-SCROLL-OPTIONS                       **
      * Integer value for X'00000001'.
       01  SQL-SO-FORWARD-ONLY                           VALUE 000000001
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000002'.
       01  SQL-SO-KEYSET-DRIVEN                          VALUE 000000002
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000004'.
       01  SQL-SO-DYNAMIC                                VALUE 000000004
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000008'.
       01  SQL-SO-MIXED                                  VALUE 000000008
                                    GLOBAL PIC  9(9) COMP-5.
      * ODBC >= 2.0 *
      * Integer value for X'00000010'.
       01  SQL-SO-STATIC                                 VALUE 000000016
                                    GLOBAL PIC  9(9) COMP-5.

      ** Bit mask values for SQL-SCROLL-CONCURRENCY                   **
      * Integer value for X'00000001'.
       01  SQL-SCCO-READ-ONLY                            VALUE 000000001
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000002'.
       01  SQL-SCCO-LOCK                                 VALUE 000000002
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000004'.
       01  Sql-SCCO-OPT-ROWVER                           VALUE 000000004
                                    GLOBAL PIC  9(9) COMP-5.
        01 sql-scco-opt-timestamp  redefines  Sql-SCCO-OPT-ROWVER
                                    global pic  9(9) comp-5.
      * Integer value for X'00000008'.
       01  SQL-SCCO-OPT-VALUES                           VALUE 000000008
                                    GLOBAL PIC  9(9) COMP-5.

      ** Bit mask values for SQL-FETCH-DIRECTION                      **
      * Integer value for X'00000001'.
       01  SQL-FD-FETCH-NEXT                             VALUE 000000001
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000002'.
       01  SQL-FD-FETCH-FIRST                            VALUE 000000002
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000004'.
       01  SQL-FD-FETCH-LAST                             VALUE 000000004
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000008'.
       01  Sql-FD-FETCH-PRIOR                            VALUE 000000008
                                    GLOBAL PIC  9(9) COMP-5.
        01 sql-fd-fetch-prev  redefines Sql-FD-FETCH-PRIOR
                                    global pic  9(9) comp-5.
      * Integer value for X'00000010'.
       01  SQL-FD-FETCH-ABSOLUTE                         VALUE 000000016
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000020'.
       01  SQL-FD-FETCH-RELATIVE                         VALUE 000000032
                                    GLOBAL PIC  9(9) COMP-5.

      * (ODBC Ver < 3.0 only)
      * Integer value for X'00000040'.
       01  Sql-FD-FETCH-RESUME                           VALUE 000000064
                                    GLOBAL PIC  9(9) COMP-5.

      * Integer value for X'00000080'.
       01  SQL-FD-FETCH-BOOKMARK                         VALUE 000000128
                                    GLOBAL PIC  9(9) COMP-5.

      ** Bit mask values for SQL-TXN-ISOLATION-OPTION                 **
      * Integer value for X'00000001'.
       01  SQL-TXN-READ-UNCOMMITTED                      VALUE 000000001
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000002'.
       01  SQL-TXN-READ-COMMITTED                        VALUE 000000002
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000004'.
       01  SQL-TXN-REPEATABLE-READ                       VALUE 000000004
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000008'.
       01  SQL-TXN-SERIALIZABLE                          VALUE 000000008
                                    GLOBAL PIC  9(9) COMP-5.

      * (ODBC Ver < 3.0 only)                                      )
      * Integer value for X'00000010'.
       01  Sql-TXN-VERSIONING                            VALUE 000000016
                                    GLOBAL PIC  9(9) COMP-5.

      ** Character string returned for SQL-DRIVER-ODBC-VER
      *   (constants set for ODBC Version 02.50: i.e. Z'02.50')
      *01  SQL-SPEC-STRING          GLOBAL.
      *    02  SQL-SPEC-MAJOR              PIC XX        VALUE '02'.
      *    02                filler        PIC X         VALUE '.'.
      *    02  SQL-SPEC-MINOR              PIC XX        VALUE '50'.
      *    02                filler        PIC X         VALUE null.

      ** Bit mask values for SQL-CORRELATION-NAME                **
      * Integer value for X'0000'.
       01  SQL-CN-NONE                                   VALUE 0000
                                    GLOBAL PIC  9(4) COMP-5.
      * Integer value for X'0001'.
       01  SQL-CN-DIFFERENT                              VALUE 0001
                                    GLOBAL PIC  9(4) COMP-5.
      * Integer value for X'0002'.
       01  SQL-CN-ANY                                    VALUE 0002
                                    GLOBAL PIC  9(4) COMP-5.

      ** Bit mask values for SQL-NON-NULLABLE-COLUMN             **
      * Integer value for X'0000'.
       01  SQL-NNC-NULL                                  VALUE 0000
                                    GLOBAL PIC  9(4) COMP-5.
      * Integer value for X'0001'.
       01  SQL-NNC-NON-NULL                              VALUE 0001
                                    GLOBAL PIC  9(4) COMP-5.

      ** Bit mask values for SQL-NULL-COLLATION                  **
      * Integer value for X'0000'.
       01  SQL-NC-HIGH                                   VALUE 0000
                                    GLOBAL PIC  9(4) COMP-5.
      * Integer value for X'0001'.
       01  SQL-NC-LOW                                    VALUE 0001
                                    GLOBAL PIC  9(4) COMP-5.
      * Integer value for X'0002'.
       01  SQL-NC-START                                  VALUE 0002
                                    GLOBAL PIC  9(4) COMP-5.
      * Integer value for X'0004'.
       01  SQL-NC-END                                    VALUE 0004
                                    GLOBAL PIC  9(4) COMP-5.

      ** Bit mask values for SQL-FILE-USAGE                      **
      * Integer value for X'0000'.
       01  SQL-FILE-NOT-SUPPORTED                        VALUE 0000
                                    GLOBAL PIC  9(4) COMP-5.
      * Integer value for X'0001'.
       01  SQL-FILE-TABLE                                VALUE 0001
                                    GLOBAL PIC  9(4) COMP-5.
      * Integer value for X'0002'.
       01  SQL-FILE-QUALIFIER                            VALUE 0002
                                    GLOBAL PIC  9(4) COMP-5.

      ** Bit mask values for SQL-GETDATA-EXTENSION                    **
      * Integer value for X'00000001'.
       01  SQL-GD-ANY-COLUMN                             VALUE 000000001
                                     GLOBAL PIC 9(9) COMP-5.
      * Integer value for X'00000002'.
       01  SQL-GD-ANY-ORDER                              VALUE 000000002
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000004'.
       01  SQL-GD-BLOCK                                  VALUE 000000004
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000008'.
       01  SQL-GD-BOUND                                  VALUE 000000008
                                    GLOBAL PIC  9(9) COMP-5.

      ** Bit mask values for SQL-ALTER-TABLE                          **
      * Integer value for X'00000001'.
       01  SQL-AT-ADD-COLUMN                             VALUE 000000001
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000002'.
       01  SQL-AT-DROP-COLUMN                            VALUE 000000002
                                    GLOBAL PIC  9(9) COMP-5.

      * (ODBC Ver >= 3.0)
      * Integer value for X'00000008'.
       01  sql-at-add-constraint                         value 000000008
                                    global pic  9(9) comp-5.

      * Integer value for X'00000020'.
       01  sql-at-add-column-single                      value 000000032
                                    global pic  9(9) comp-5.
      * Integer value for X'00000040'.
       01  sql-at-add-column-default                     value 000000064
                                    global pic  9(9) comp-5.
      * Integer value for X'00000080'.
       01  sql-at-add-column-collation                   value 000000128
                                    global pic  9(9) comp-5.
      * Integer value for X'00000100'.
       01  sql-at-set-column-default                     value 000000256
                                    global pic  9(9) comp-5.
      * Integer value for X'00000200'.
       01  sql-at-drop-column-default                    value 000000512
                                    global pic  9(9) comp-5.
      * Integer value for X'00000400'.
       01  sql-at-drop-column-cascade                    value 000001024
                                    global pic  9(9) comp-5.
      * Integer value for X'00000800'.
       01  sql-at-drop-column-restrict                   value 000002048
                                    global pic  9(9) comp-5.
      * Integer value for X'00001000'.
       01  sql-at-add-table-constraint                   value 000004096
                                    global pic  9(9) comp-5.
      * Integer value for X'00002000'  "
      * (truncated from SQL_AT_DROP_TABLE_CONSTRAINT_CASCADE)
       01  sql-at-drop-table-constraint-c                value 000008192
                                    global pic  9(9) comp-5.
      * Integer value for X'00004000'  "
      * (truncated from SQL_AT_DROP_TABLE_CONSTRAINT_RESTRICT)
       01  sql-at-drop-table-constraint-r                value 000016384
                                    global pic  9(9) comp-5.
      * Integer value for X'00008000'  "
      * (truncated from SQL_AT_CONSTRAINT_NAME_DEFINITION)
       01  sql-at-constraint-name-definit                value 000032768
                                    global pic  9(9) comp-5.
      * Integer value for X'00010000'  "
      * (truncated from SQL_AT_CONSTRAINT_INITIALLY_DEFERRED)
       01  sql-at-constraint-initially-de                value 000065536
                                    global pic  9(9) comp-5.
      * Integer value for X'00020000'  "
      * (truncated from SQL_AT_CONSTRAINT_INITIALLY_IMMEDIATE)
       01  sql-at-constraint-initially-im                value 000131072
                                    global pic  9(9) comp-5.
      * Integer value for X'00040000'  "
       01  sql-at-constraint-deferrable                  value 000262144
                                    global pic  9(9) comp-5.
      * Integer value for X'00080000'  "
      * (truncated from SQL_AT_CONSTRAINT_NON_DEFERRABLE)
       01  sql-at-constraint-non-deferrab                value 000524288
                                    global pic  9(9) comp-5.


      ** Bit mask values for SQL-POSITIONED-STATEMENTS                **
      * Integer value for X'00000001'.
       01  SQL-PS-POSITIONED-DELETE                      VALUE 000000001
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000002'.
       01  SQL-PS-POSITIONED-UPDATE                      VALUE 000000002
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000004'.
       01  SQL-PS-SELECT-FOR-UPDATE                      VALUE 000000004
                                    GLOBAL PIC  9(9) COMP-5.

      ** Bit mask values for SQL-GROUP-BY                        **
      * Integer value for X'0000'.
       01  SQL-GB-NOT-SUPPORTED                          VALUE 0000
                                    GLOBAL PIC  9(4) COMP-5.
      * Integer value for X'0001'.
       01  SQL-GB-GROUP-BY-EQUALS-SELECT                 VALUE 0001
                                    GLOBAL PIC  9(4) COMP-5.
      * Integer value for X'0002'.
      *    (truncated from SQL-GB-GROUP-BY-CONTAINS-SELECT)
       01  SQL-GB-GROUP-BY-CONTAINS-SELEC                VALUE 0002
                                    GLOBAL PIC  9(4) COMP-5.
      * Integer value for X'0003'.
       01  SQL-GB-NO-RELATION                            VALUE 0003
                                    GLOBAL PIC  9(4) COMP-5.
      * (ODBC Ver >= 3.0)
      * Integer value for x'0004'
       01  sql-gb-collate                                value 0004
                                    global pic  9(4) comp-5.

      ** Bit mask values for sql-schema-usage or SQL-OWNER-USAGE      **
      * Integer value for X'00000001'.
       01  SQL-OU-DML-STATEMENTS                         VALUE 000000001
                                    GLOBAL PIC  9(9) COMP-5.
        01 sql-su-dml-statements  redefines SQL-OU-DML-STATEMENTS
                                    global pic  9(9) comp-5.
      * Integer value for X'00000002'.
       01  SQL-OU-PROCEDURE-INVOCATION                   VALUE 000000002
                                    GLOBAL PIC  9(9) COMP-5.
        01 sql-su-procedure-invocation redefines
             SQL-OU-PROCEDURE-INVOCATION
                                    global pic  9(9) comp-5.
      * Integer value for X'00000004'.
       01  SQL-OU-TABLE-DEFINITION                       VALUE 000000004
                                    GLOBAL PIC  9(9) COMP-5.
        01 sql-su-table-definition redefines SQL-OU-TABLE-DEFINITION
                                    global pic  9(9) comp-5.
      * Integer value for X'00000008'.
       01  SQL-OU-INDEX-DEFINITION                       VALUE 000000008
                                    GLOBAL PIC  9(9) COMP-5.
        01 sql-su-index-definition redefines SQL-OU-INDEX-DEFINITION
                                    global pic  9(9) comp-5.
      * Integer value for X'00000010'.
       01  SQL-OU-PRIVILEGE-DEFINITION                   VALUE 000000016
                                    GLOBAL PIC  9(9) COMP-5.
        01 sql-su-privilege-definition redefines
             SQL-OU-PRIVILEGE-DEFINITION
                                    global pic  9(9) comp-5.

      ** Bit mask values for sql-catalog-usage or SQL-QUALIFIER-USAGE **
      * Integer value for X'00000001'.
       01  SQL-QU-DML-STATEMENTS                         VALUE 000000001
                                    GLOBAL PIC  9(9) COMP-5.
        01 sql-cu-dml-statements redefines SQL-QU-DML-STATEMENTS
                                    global pic  9(9) comp-5.
      * Integer value for X'00000002'.
       01  SQL-QU-PROCEDURE-INVOCATION                   VALUE 000000002
                                    GLOBAL PIC  9(9) COMP-5.
        01 sql-cu-procedure-invocation redefines
             SQL-QU-PROCEDURE-INVOCATION
                                    global pic  9(9) comp-5.
      * Integer value for X'00000004'.
       01  SQL-QU-TABLE-DEFINITION                       VALUE 000000004
                                    GLOBAL PIC  9(9) COMP-5.
        01 sql-cu-table-definition redefines SQL-QU-TABLE-DEFINITION
                                    global pic  9(9) comp-5.
      * Integer value for X'00000008'.
       01  SQL-QU-INDEX-DEFINITION                       VALUE 000000008
                                    GLOBAL PIC  9(9) COMP-5.
        01 sql-cu-index-definition redefines SQL-QU-INDEX-DEFINITION
                                    global pic  9(9) comp-5.
      * Integer value for X'00000010'.
       01  SQL-QU-PRIVILEGE-DEFINITION                   VALUE 000000016
                                    GLOBAL PIC  9(9) COMP-5.
        01 sql-cu-privilege-definition redefines
             SQL-QU-PRIVILEGE-DEFINITION
                                    global pic  9(9) comp-5.

      ** Bit mask values for SQL-SUBQUERIES                           **
      * Integer value for X'00000001'.
       01  SQL-SQ-COMPARISON                             VALUE 000000001
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000002'.
       01  SQL-SQ-EXISTS                                 VALUE 000000002
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000004'.
       01  SQL-SQ-IN                                     VALUE 000000004
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000008'.
       01  SQL-SQ-QUANTIFIED                             VALUE 000000008
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000010'.
       01  SQL-SQ-CORRELATED-SUBQUERIES                  VALUE 000000016
                                    GLOBAL PIC  9(9) COMP-5.

      ** Bit mask values for SQL-UNION or sql-union-statement         **
      * Integer value for X'00000001'.
       01  SQL-U-UNION                                   VALUE 000000001
                                    GLOBAL PIC  9(9) COMP-5.
        01 sql-us-union  redefines  SQL-U-UNION
                                    global pic  9(9) comp-5.
      * Integer value for X'00000002'.
       01  SQL-U-UNION-ALL                               VALUE 000000002
                                    GLOBAL PIC  9(9) COMP-5.
        01 sql-us-union-all  redefines  SQL-U-UNION-ALL
                                    global pic  9(9) comp-5.

      ** Bit mask values for SQL-BOOKMARK-PERSISTENCE                 **
      * Integer value for X'00000001'.
       01  SQL-BP-CLOSE                                  VALUE 000000001
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000002'.
       01  SQL-BP-DELETE                                 VALUE 000000002
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000004'.
       01  SQL-BP-DROP                                   VALUE 000000004
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000008'.
       01  SQL-BP-TRANSACTION                            VALUE 000000008
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000010'.
       01  SQL-BP-UPDATE                                 VALUE 000000016
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000020'.
       01  SQL-BP-OTHER-HSTMT                            VALUE 000000032
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000040'.
       01  SQL-BP-SCROLL                                 VALUE 000000064
                                    GLOBAL PIC  9(9) COMP-5.

      ** Bit mask values for SQL-STATIC-SENSITIVITY                   **
      * Integer value for X'00000001'.
       01  SQL-SS-ADDITIONS                              VALUE 000000001
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000002'.
       01  SQL-SS-DELETIONS                              VALUE 000000002
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000004'.
       01  SQL-SS-UPDATES                                VALUE 000000004
                                    GLOBAL PIC  9(9) COMP-5.

      ** Bit mask values for SQL-LOCK-TYPESL                          **
      * Integer value for X'00000001'.
       01  SQL-LCK-NO-CHANGE                             VALUE 000000001
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000002'.
       01  SQL-LCK-EXCLUSIVE                             VALUE 000000002
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000004'.
       01  SQL-LCK-UNLOCK                                VALUE 000000004
                                    GLOBAL PIC  9(9) COMP-5.

      ** Bit mask values for SQL-POS-OPERATIONS                       **
      * Integer value for X'00000001'.
       01  SQL-POS-POSITION                              VALUE 000000001
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000002'.
       01  SQL-POS-REFRESH                               VALUE 000000002
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000004'.
       01  SQL-POS-UPDATE                                VALUE 000000004
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000008'.
       01  SQL-POS-DELETE                                VALUE 000000008
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000010'.
       01  SQL-POS-ADD                                   VALUE 000000016
                                    GLOBAL PIC  9(9) COMP-5.

      ** Bit mask values for sql-catalog-location   (ODBC Ver >= 3.0) **
      **                 or  Sql-QUALIFIER-LOCATION (ODBC Ver < 3.0)  **
      * Integer value for X'00000001'.
       01  Sql-QL-START                                  VALUE 000000001
                                    GLOBAL PIC  9(9) COMP-5.
        01 sql-cl-start redefines Sql-QL-START
                                    global pic  9(9) comp-5.
      * Integer value for X'00000002'.
       01  SQL-QL-END                                    VALUE 000000002
                                    GLOBAL PIC  9(9) COMP-5.
        01 sql-cl-end redefines Sql-QL-END
                                    global pic  9(9) comp-5.

      ** Bit mask values for SQL-OJ-CAPABILITIES                      **
      * Integer value for X'00000001'.
       01  SQL-OJ-LEFT                                   VALUE 000000001
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000002'.
       01  SQL-OJ-RIGHT                                  VALUE 000000002
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000004'.
       01  SQL-OJ-FULL                                   VALUE 000000004
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000008'.
       01  SQL-OJ-NESTED                                 VALUE 000000008
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000010'.
       01  SQL-OJ-NOT-ORDERED                            VALUE 000000016
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000020'.
       01  SQL-OJ-INNER                                  VALUE 000000032
                                    GLOBAL PIC  9(9) COMP-5.
      * Integer value for X'00000040'.
       01  SQL-OJ-ALL-COMPARISON-OPS                     VALUE 000000064
                                    GLOBAL PIC  9(9) COMP-5.

      ** bit mask values for sql-dynamic-cursor-attributes1,          **
      **                     sql-forward-only-cursor-attributes1,     **
      **                     sql-keyset-cursor-attributes1,           **
      **                 and sql-static-cursor-attributes1            **
      **                                            (ODBC Ver >= 3.0) **

      * supported SQLFetchScroll FetchOrientation's                    *
      * integer value for x'00000001'
       01  sql-ca1-next             global pic 9(9) comp-5 value      1.
      * integer value for x'00000002'
       01  sql-ca1-absolute         global pic 9(9) comp-5 value      2.
      * integer value for x'00000004'
       01  sql-ca1-relative         global pic 9(9) comp-5 value      4.
      * integer value for x'00000008'
       01  sql-ca1-bookmark         global pic 9(9) comp-5 value      8.

      * supported SQLSetPos LockType's                                 *
      * integer value for x'00000040'
       01  sql-ca1-lock-no-change   global pic 9(9) comp-5 value     64.
      * integer value for x'00000080'
       01  sql-ca1-lock-exclusive   global pic 9(9) comp-5 value    128.
      * integer value for x'00000100'
       01  sql-ca1-lock-unlock      global pic 9(9) comp-5 value    256.

      * supported SQLSetPos Operations                                 *
      * integer value for x'00000200'
       01  sql-ca1-pos-position     global pic 9(9) comp-5 value    512.
      * integer value for x'00000400'
       01  sql-ca1-pos-update       global pic 9(9) comp-5 value   1024.
      * integer value for x'00000800'
       01  sql-ca1-pos-delete       global pic 9(9) comp-5 value   2048.
      * integer value for x'00001008'
       01  sql-ca1-pos-refresh      global pic 9(9) comp-5 value   4096.

      * positioned updates and deletes                                 *
      * integer value for x'00002000'
       01  sql-ca1-positioned-update
                                    global pic 9(9) comp-5 value   8192.
      * integer value for x'00004000'
       01  sql-ca1-positioned-delete
                                    global pic 9(9) comp-5 value  16384.
      * integer value for x'00008000'
       01  sql-ca1-select-for-update
                                    global pic 9(9) comp-5 value  32768.

      * supported SQLBulkOperations operations                         *
      * integer value for x'00010000'
       01  sql-ca1-bulk-add         global pic 9(9) comp-5 value  65536.
      * integer value for x'00020000'
      * (truncated from sql-ca1-bulk-update-by-bookmark)
       01  sql-ca1-bulk-update-by-bookmar
                                    global pic 9(9) comp-5 value 131072.
      * integer value for x'00040000'
      * (truncated from sql-ca1-bulk-delete-by-bookmark)
       01  sql-ca1-bulk-delete-by-bookmar
                                    global pic 9(9) comp-5 value 262144.
      * integer value for x'00080000'
      * (truncated from sql-ca1-bulk-delete-by-bookmark)
       01  sql-ca1-bulk-fetch-by-bookmark
                                    global pic 9(9) comp-5 value 524280.

      ** bit mask values for sql-dynamic-cursor-attributes2,          **
      **                     sql-forward-only-cursor-attributes2,     **
      **                     sql-keyset-cursor-attributes2,           **
      **                 and sql-static-cursor-attributes2            **
      **                                            (ODBC Ver >= 3.0) **

      * supported values for sql-attr-scroll-concurrency               *
      * integer value for x'00000001'
       01  sql-ca2-read-only-concurrency
                                    global pic 9(9) comp-5 value      1.
      * integer value for x'00000002'
       01  sql-ca2-lock-concurrency global pic 9(9) comp-5 value      2.
      * integer value for x'00000004'
       01  sql-ca2-opt-rowver-concurrency
                                    global pic 9(9) comp-5 value      4.
      * integer value for x'00000008'
       01  sql-ca2-opt-values-concurrency
                                    global pic 9(9) comp-5 value      8.

      * sensitivity of cursor to its own inserts, deletes and updates  *
      * integer value for x'00000010'
       01  sql-ca2-sensitivity-additions
                                    global pic 9(9) comp-5 value     16.
      * integer value for x'00000020'
       01  sql-ca2-sensitivity-deletions
                                    global pic 9(9) comp-5 value     32.
      * integer value for x'00000040'
       01  sql-ca2-sensitivity-updates
                                    global pic 9(9) comp-5 value     64.

      * semantics of sql-attr-max-rows                                 *
      * integer value for x'00000080'
       01  sql-ca2-max-rows-select  global pic 9(9) comp-5 value    128.
      * integer value for x'00000100'
       01  sql-ca2-max-rows-insert  global pic 9(9) comp-5 value    256.
      * integer value for x'00000200'
       01  sql-ca2-max-rows-delete  global pic 9(9) comp-5 value    512.
      * integer value for x'00000400'
       01  sql-ca2-max-rows-update  global pic 9(9) comp-5 value   1024.
      * integer value for x'00000800'
       01  sql-ca2-max-rows-catalog global pic 9(9) comp-5 value   2048.
      * sql-ca2-max-rows-affects-all
      *  = sql-ca2-max-rows-select + sql-ca2-max-rows-insert +
      *    sql-ca2-max-rows-delete + sql-ca2-max-rows-update +
      *    sql-ca2-max-rows-catalog
       01  sql-ca2-max-rows-affects-all
                                    global pic 9(9) comp-5 value   3968.

      * semantics of sql-diag-cursor-row-count                         *
      * integer value for x'00001000'
       01  sql-ca2-crc-exact        global pic 9(9) comp-5 value  40962.
      * integer value for x'00002000'
       01  sql-ca2-crc-approximate  global pic 9(9) comp-5 value  81924.

      * kinds of positioned statements that can be simulated           *
      * integer value for x'00004000'
       01  sql-ca2-simulate-non-unique
                                    global pic 9(9) comp-5 value  16384.
      * integer value for x'00008000'
       01  sql-ca2-simulate-try-unique
                                    global pic 9(9) comp-5 value  32768.
      * integer value for x'00010000'
       01  sql-ca2-simulate-unique  global pic 9(9) comp-5 value  65336.


      *** bit masks for information types added for SQLGetINfo       ***
      *** in ODBC Ver 3.0.                          (ODBC Ver > 3.0) ***

      ** bit mask values returned for sql-aggregate-function          **
      * integer value for x'00000001'
       01  sql-af-avg               global pic 9(9) comp-5 value      1.
      * integer value for x'00000002'
       01  sql-af-count             global pic 9(9) comp-5 value      2.
      * integer value for x'00000004'
       01  sql-af-max               global pic 9(9) comp-5 value      4.
      * integer value for x'00000008'
       01  sql-af-min               global pic 9(9) comp-5 value      8.
      * integer value for x'00000010'
       01  sql-af-sum               global pic 9(9) comp-5 value     16.
      * integer value for x'00000020
       01  sql-af-distinct          global pic 9(9) comp-5 value     32.
      * sql-af-avg | sql-af-count | sql-af-max | sql-sf-min
      * | sql-af-sum | sql-af-distinct
       01  sql-af-all               global pic 9(9) comp-5 value     63.

      ** bit mask values returned for sql-sql-conformance             **
      * integer value for x'00000001'
       01  sql-sc-sql92-entry       global pic 9(9) comp-5 value      1.
      * integer value for x'00000002'
       01  sql-sc-fips127-2-transitional
                                    global pic 9(9) comp-5 value      2.
      * integer value for x'00000004'
       01  sql-sc-sql92-intermediate
                                    global pic 9(9) comp-5 value      4.
      * integer value for x'00000008'
       01  sql-sc-sql92-full        global pic 9(9) comp-5 value      8.

      ** bit mask values returned for sql-datetime-literals           **
      * integer value for x'00000001'
       01  sql-dl-sql92-date        global pic 9(9) comp-5 value      1.
      * integer value for x'00000002'
       01  sql-dl-sql92-time        global pic 9(9) comp-5 value      2.
      * integer value for x'00000004'
       01  sql-dl-sql92-timestamp   global pic 9(9) comp-5 value      4.
      * integer value for x'00000008'
       01  sql-dl-sql92-interval-year
                                    global pic 9(9) comp-5 value      8.
      * integer value for x'00000010'
       01  sql-dl-sql92-interval-month
                                    global pic 9(9) comp-5 value     16.
      * integer value for x'00000020
       01  sql-dl-sql92-interval-day
                                    global pic 9(9) comp-5 value     32.
      * integer value for x'00000040'
       01  sql-dl-sql92-interval-hour
                                    global pic 9(9) comp-5 value     64.
      * integer value for x'00000080'
       01  sql-dl-sql92-interval-minute
                                    global pic 9(9) comp-5 value    128.
      * integer value for x'00000100
       01  sql-dl-sql92-interval-second
                                    global pic 9(9) comp-5 value    256.
      * integer value for x'00000200
      *    (truncated from sql-dl-sql92-interval-year-to-month)
       01  sql-dl-sql92-interval-yr-to-mo
                                    global pic 9(9) comp-5 value    512.
      * integer value for x'00000400'
      *    (truncated from sql-dl-sql92-interval-day-to-hour)
       01  sql-dl-sql92-interval-day-to-h
                                    global pic 9(9) comp-5 value   1024.
      * integer value for x'00000800'
      *    (truncated from sql-dl-sql92-interval-day-to-minute)
       01  sql-dl-sql92-interval-day-to-m
                                    global pic 9(9) comp-5 value   2048.
      * integer value for x'00001000'
      *    (truncated from sql-dl-sql92-interval-day-to-second)
       01  sql-dl-sql92-interval-day-to-s
                                    global pic 9(9) comp-5 value   4096.
      * integer value for x'00002000'
      *    (truncated from sql-dl-sql92-interval-hour-to-minute)
       01  sql-dl-sql92-interval-hr-to-m
                                    global pic 9(9) comp-5 value   8192.
      * integer value for x'00004000'
      *    (truncated from sql-dl-sql92-interval-hour-to-second)
       01  sql-dl-sql92-interval-hr-to-s
                                    global pic 9(9) comp-5 value  16384.
      * integer value for x'00008000'
      *    (truncated from sql-dl-sql92-interval-minute-to-second)
       01  sql-dl-sql92-interval-min-to-s
                                    global pic 9(9) comp-5 value  32768.

      ** bit mask values returned for sql-batch-row-count             **
      * integer value for x'00000001'
       01  sql-brc-procedures       global pic 9(9) comp-5 value      1.
      * integer value for x'00000002'
       01  sql-brc-explicite        global pic 9(9) comp-5 value      2.
      * integer value for x'00000004'
       01  sql-brc-rolled-up        global pic 9(9) comp-5 value      4.

      ** bit mask values returned for sql-batch-support               **
      * integer value for x'00000001'
       01  sql-bs-select-explicit   global pic 9(9) comp-5 value      1.
      * integer value for x'00000002'
       01  sql-bs-row-count-explicit
                                    global pic 9(9) comp-5 value      2.
      * integer value for x'00000004'
       01  sql-bs-select-proc       global pic 9(9) comp-5 value      4.
      * integer value for x'00000008'
       01  sql-bs-row-count-proc
                                    global pic 9(9) comp-5 value      8.

      ** values returned for sql-param-array-row-count                **
       01  sql-parc-batch           global pic 9(9) comp-5 value      1.
       01  sql-parc-no-batch        global pic 9(9) comp-5 value      2.

      ** values returned for sql-param-array-select-batch             **
       01  sql-pas-batch            global pic 9(9) comp-5 value      1.
       01  sql-pas-no-batch         global pic 9(9) comp-5 value      2.
       01  sql-pas-no-select        global pic 9(9) comp-5 value      3.

      ** bit mask values returned for sql-index-keywords              **
      * integer value for x'00000000'
       01  sql-ik-none              global pic 9(9) comp-5 value      0.
      * integer value for x'00000001'
       01  sql-ik-asc               global pic 9(9) comp-5 value      1.
      * integer value for x'00000002'
       01  sql-ik-desc              global pic 9(9) comp-5 value      2.
      * sql-ik-all = sql-ik-asc | sql-ik-desc
       01  sql-ik-all               global pic 9(9) comp-5 value      3.

      ** bit mask values returned for sql-info-schema-views           **
      * integer value for x'00000001'
       01  sql-isv-assertions       global pic 9(9) comp-5 value      1.
      * integer value for x'00000002'
       01  sql-isv-character-sets   global pic 9(9) comp-5 value      2.
      * integer value for x'00000004'
       01  sql-isv-check-constraints
                                    global pic 9(9) comp-5 value      4.
      * integer value for x'00000008'
       01  sql-isv-collations       global pic 9(9) comp-5 value      8.
      * integer value for x'00000010'
       01  sql-isv-column-domain-usage
                                    global pic 9(9) comp-5 value     16.
      * integer value for x'00000020
       01  sql-isv-column-privileges
                                    global pic 9(9) comp-5 value     32.
      * integer value for x'00000040'
       01  sql-isv-columns          global pic 9(9) comp-5 value     64.
      * integer value for x'00000080'
      *    (truncated from sql-isv-constraint-column-usage)
       01  sql-isv-constraint-column-usag
                                    global pic 9(9) comp-5 value    128.
      * integer value for x'00000100
       01  sql-isv-constraint-table-usage
                                    global pic 9(9) comp-5 value    256.
      * integer value for x'00000200
       01  sql-isv-domain-constraints
                                    global pic 9(9) comp-5 value    512.
      * integer value for x'00000400'
       01  sql-isv-domains          global pic 9(9) comp-5 value   1024.
      * integer value for x'00000800'
       01  sql-isv-key-column-usage
                                    global pic 9(9) comp-5 value   2048.
      * integer value for x'00001000'
      *    (truncated from sql-isv-referential-constraints)
       01  sql-isv-referential-constraint
                                    global pic 9(9) comp-5 value   4096.
      * integer value for x'00002000'
       01  sql-isv-schemata         global pic 9(9) comp-5 value   8192.
      * integer value for x'00004000'
       01  sql-isv-sql-languages    global pic 9(9) comp-5 value  16384.
      * integer value for x'00008000'
       01  sql-isv-table-constraints
                                    global pic 9(9) comp-5 value  32768.
      * integer value for x'00010000
       01  sql-isv-table-privileges
                                    global pic 9(9) comp-5 value  65536.
      * integer value for x'00020000'
       01  sql-isv-tables           global pic 9(9) comp-5 value 131072.
      * integer value for x'00040000'
       01  sql-isv-translations     global pic 9(9) comp-5 value 262144.
      * integer value for x'00080000'
       01  sql-isv-usage-privileges global pic 9(9) comp-5 value 524288.
      * integer value for x'00100000'
       01  sql-isv-view-column-usage
                                    global pic 9(9) comp-5 value
                                                                1048576.
      * integer value for x'00200000'
       01  sql-isv-view-table-usage global pic 9(9) comp-5 value
                                                                2097152.
      * integer value for x'00400000'
       01  sql-isv-views            global pic 9(9) comp-5 value
                                                                4194304.

      ** values returned for sql-async-mode                           **
       01  sql-am-none              global pic 9(9) comp-5 value      0.
       01  sql-am-connection        global pic 9(9) comp-5 value      1.
       01  sql-am-statement         global pic 9(9) comp-5 value      2.

      ** bit mask values returned for sql-alter-domain                **
      * integer value for x'00000001'
      *    (truncated from sql-ad-constraint-name-definition)
       01  sql-ad-constraint-name-def
                                    global pic 9(9) comp-5 value      1.
      * integer value for x'00000002'
       01  sql-ad-add-domain-constraint
                                    global pic 9(9) comp-5 value      2.
      * integer value for x'00000004'
       01  sql-ad-drop-domain-constraint
                                    global pic 9(9) comp-5 value      4.
      * integer value for x'00000008'
       01  sql-ad-add-domain-default
                                    global pic 9(9) comp-5 value      8.
      * integer value for x'00000010'
       01  sql-ad-drop-domain-default
                                    global pic 9(9) comp-5 value     16.
      * integer value for x'00000020
      *    (truncated from sql-ad-add-constraint-initially-deferred)
       01  sql-ad-add-constraint-init-def
                                    global pic 9(9) comp-5 value     32.
      * integer value for x'00000040'
      *    (truncated from sql-ad-add-constraint-initially-immediate)
       01  sql-ad-add-constraint-init-imm
                                    global pic 9(9) comp-5 value     64.
      * integer value for x'00000080'
      *    (truncated from sql-ad-add-constraint-deferrable)
       01  sql-ad-add-constraint-defer
                                    global pic 9(9) comp-5 value    128.
      * integer value for x'00000100
      *    (truncated from sql-ad-add-constraint-non-deferrable)
       01  sql-ad-add-constraint-non-defe
                                    global pic 9(9) comp-5 value    256.

      ** bit mask values returned for sql-create-schema               **
      * integer value for x'00000001'
       01  sql-cs-create-schema     global pic 9(9) comp-5 value      1.
      * integer value for x'00000002'
       01  sql-cs-authorization     global pic 9(9) comp-5 value      2.
      * integer value for x'00000004'
       01  sql-cs-default-character-set
                                    global pic 9(9) comp-5 value      4.

      ** bit mask values returned for sql-create-translation          **
      * integer value for x'00000001'
       01  sql-ctr-create-translation
                                    global pic 9(9) comp-5 value      1.

      ** bit mask values returned for sql-create-assertion            **
      * integer value for x'00000001'
       01  sql-ca-create-assertion
                                    global pic 9(9) comp-5 value      1.
      * integer value for x'00000010'
      *    (truncated from sql-ca-constraint-initially-deferred)
       01  sql-ca-constraint-init-defer
                                    global pic 9(9) comp-5 value     16.
      * integer value for x'00000020'
      *    (truncated from sql-ca-constraint-initially-immediate)
       01  sql-ca-constraint-init-immed
                                    global pic 9(9) comp-5 value     32.
      * integer value for x'00000040'
       01  sql-ca-constraint-deferrable
                                    global pic 9(9) comp-5 value     64.
      * integer value for x'00000080'
      *    (truncated from sql-ca-constraint-non-deferrable)
       01  sql-ca-constraint-non-deferrab
                                    global pic 9(9) comp-5 value    128.

      ** bit mask values returned for sql-create-character-set        **
      * integer value for x'00000001'
       01  sql-ccs-create-character-set
                                    global pic 9(9) comp-5 value      1.
      * integer value for x'00000002'
       01  sql-ccs-collate-clause   global pic 9(9) comp-5 value      2.
      * integer value for x'00000004'
       01  sql-ccs-linited-collation
                                    global pic 9(9) comp-5 value      4.

      ** bit mask values returned for sql-create-collation            **
      * integer value for x'00000001'
       01  sql-ccol-create-collation
                                    global pic 9(9) comp-5 value      1.

      ** bit mask values returned for sql-create-domain               **
      * integer value for x'00000001'
       01  sql-cdo-create-domain    global pic 9(9) comp-5 value      1.
      * integer value for x'00000002'
       01  sql-cdo-default          global pic 9(9) comp-5 value      2.
      * integer value for x'00000004'
       01  sql-cdo-constraint       global pic 9(9) comp-5 value      4.
      * integer value for x'00000008'
       01  sql-cdo-collation        global pic 9(9) comp-5 value      8.
      * integer value for x'00000010'
      *    (truncated from sql-cdo-constraint-name-definition)
       01  sql-cdo-constraint-name-defini
                                    global pic 9(9) comp-5 value     16.
      * integer value for x'00000020'
      *    (truncated from sql-cdo-constraint-initially-deferred)
       01  sql-cdo-constraint-initially-d
                                    global pic 9(9) comp-5 value     32.
      * integer value for x'00000040'
      *    (truncated from sql-cdo-constraint-initially-immediate)
       01  sql-cdo-constraint-initially-i
                                    global pic 9(9) comp-5 value     64.
      * integer value for x'00000080'
      *    (truncated from sql-ad-add-constraint-deferrable)
       01  sql-cdo-constraint-deferrable
                                    global pic 9(9) comp-5 value    128.
      * integer value for x'00000100
      *    (truncated from sql-cdo-constrait-non-deferrable)
       01  sql-cdo-constraint-non-deferra
                                    global pic 9(9) comp-5 value    256.

      ** bit mask values returned for sql-create-table                **
      * integer value for x'00000001'
       01  sql-ct-create-table      global pic 9(9) comp-5 value      1.
      * integer value for x'00000002'
       01  sql-ct-commit-preserve   global pic 9(9) comp-5 value      2.
      * integer value for x'00000004'
       01  sql-ct-commit-delete     global pic 9(9) comp-5 value      4.
      * integer value for x'00000008'
       01  sql-ct-global-temporary  global pic 9(9) comp-5 value      8.
      * integer value for x'00000010'
       01  sql-ct-global-local      global pic 9(9) comp-5 value     16.
      * integer value for x'00000020
      *    (truncated from sql-ct-constraint-initially-deferrred)
       01  sql-ct-constraint-initially-de
                                    global pic 9(9) comp-5 value     32.
      * integer value for x'00000040'
      *    (truncated from sql-ct-constraint-initially-immediate)
       01  sql-ct-constraint-initially-im
                                    global pic 9(9) comp-5 value     64.
      * integer value for x'00000080'
       01  sql-ct-constraint-deferrable
                                    global pic 9(9) comp-5 value    128.
      * integer value for x'00000100
      *    (truncated from sql-ct-constraint-non-deferrable)
       01  sql-ct-constraint-non-deferrab
                                    global pic 9(9) comp-5 value    256.
      * integer value for x'00000200
       01  sql-ct-column-constraint global pic 9(9) comp-5 value    512.
      * integer value for x'00000400'
       01  sql-ct-column-default    global pic 9(9) comp-5 value   1024.
      * integer value for x'00000800'
       01  sql-ct-column-collation  global pic 9(9) comp-5 value   2048.
      * integer value for x'00001000'
       01  sql-ct-table-constraint  global pic 9(9) comp-5 value   4096.
      * integer value for x'00002000'
      *    (truncated from sql-ct-constraint-name-definition)
       01  sql-ct-constraint-name-definit
                                    global pic 9(9) comp-5 value   8192.

      ** bit mask values returned for sql-ddl-index                   **
      * integer value for x'00000001'
       01  sql-di-create-index      global pic 9(9) comp-5 value      1.
      * integer value for x'00000002'
       01  sql-di-drop-index        global pic 9(9) comp-5 value      2.


      ** bit mask values returned for sql-drop-collation              **
      * integer value for x'00000001'
       01  sql-dc-drop-collation    global pic 9(9) comp-5 value      1.

      ** bit mask values returned for sql-drop-domain                 **
      * integer value for x'00000001'
       01  sql-dd-drop-domain       global pic 9(9) comp-5 value      1.
      * integer value for x'00000002'
       01  sql-dd-restrict          global pic 9(9) comp-5 value      2.
      * integer value for x'00000004'
       01  sql-dd-cascade           global pic 9(9) comp-5 value      4.

      ** bit mask values returned for sql-drop-schema                 **
      * integer value for x'00000001'
       01  sql-ds-drop-schema       global pic 9(9) comp-5 value      1.
      * integer value for x'00000002'
       01  sql-ds-restrict          global pic 9(9) comp-5 value      2.
      * integer value for x'00000004'
       01  sql-ds-cascade           global pic 9(9) comp-5 value      4.

      ** bit mask values returned for sql-drop-character-set          **
      * integer value for x'00000001'
       01  sql-dcs-drop-character-set
                                    global pic 9(9) comp-5 value      1.

      ** bit mask values returned for sql-drop-assertion              **
      * integer value for x'00000001'
       01  sql-da-drop-assertion    global pic 9(9) comp-5 value      1.

      ** bit mask values returned for sql-drop-table                  **
      * integer value for x'00000001'
       01  sql-dt-drop-table        global pic 9(9) comp-5 value      1.
      * integer value for x'00000002'
       01  sql-dt-restrict          global pic 9(9) comp-5 value      2.
      * integer value for x'00000004'
       01  sql-dt-cascade           global pic 9(9) comp-5 value      4.

      ** bit mask values returned for sql-drop-translation            **
      * integer value for x'00000001'
       01  sql-dtr-drop-translation global pic 9(9) comp-5 value      1.

      ** bit mask values returned for sql-drop-view                   **
      * integer value for x'00000001'
       01  sql-dv-drop-view         global pic 9(9) comp-5 value      1.
      * integer value for x'00000002'
       01  sql-dv-restrict          global pic 9(9) comp-5 value      2.
      * integer value for x'00000004'
       01  sql-dv-cascade           global pic 9(9) comp-5 value      4.

      ** bit mask values returned for sql-insert-statement            **
      * integer value for x'00000001'
       01  sql-is-insert-literals   global pic 9(9) comp-5 value      1.
      * integer value for x'00000002'
       01  sql-is-insert-searched   global pic 9(9) comp-5 value      2.
      * integer value for x'00000004'
       01  sql-is-select-into       global pic 9(9) comp-5 value      4.

      ** values returned for sql-odbc-interface-conformance           **
       01  sql-oic-core             global pic 9(9) comp-5 value      1.
       01  sql-oic-level1           global pic 9(9) comp-5 value      2.
       01  sql-oic-level2           global pic 9(9) comp-5 value      3.

      ** bit mask values returned for sql-sql92-foreign-key-delete-rule*
      * integer value for x'00000001'
       01  sql-sfkd-cascade         global pic 9(9) comp-5 value      1.
      * integer value for x'00000002'
       01  sql-sfkd-no-action       global pic 9(9) comp-5 value      2.
      * integer value for x'00000004'
       01  sql-sfkd-set-default     global pic 9(9) comp-5 value      4.
      * integer value for x'00000008'
       01  sql-sfkd-set-null        global pic 9(9) comp-5 value      8.

      ** bit mask values returned for sql-sql92-foreign-key-update-rule*
      * integer value for x'00000001'
       01  sql-sfku-cascade         global pic 9(9) comp-5 value      1.
      * integer value for x'00000002'
       01  sql-sfku-no-action       global pic 9(9) comp-5 value      2.
      * integer value for x'00000004'
       01  sql-sfku-set-default     global pic 9(9) comp-5 value      4.
      * integer value for x'00000008'
       01  sql-sfku-set-null        global pic 9(9) comp-5 value      8.

      ** bit mask values returned for sql-sql92-grant                 **
      * integer value for x'00000001'
       01  sql-sg-usage-on-domain   global pic 9(9) comp-5 value      1.
      * integer value for x'00000002'
       01  sql-sg-usage-on-character-set
                                    global pic 9(9) comp-5 value      2.
      * integer value for x'00000004'
       01  sql-sg-usage-on-collation
                                    global pic 9(9) comp-5 value      4.
      * integer value for x'00000008'
       01  sql-sg-usage-on-translation
                                    global pic 9(9) comp-5 value      8.
      * integer value for x'00000010'
       01  sql-sg-with-grant-option global pic 9(9) comp-5 value     16.
      * integer value for x'00000020
       01  sql-sg-delete-table      global pic 9(9) comp-5 value     32.
      * integer value for x'00000040'
       01  sql-sg-insert-table      global pic 9(9) comp-5 value     64.
      * integer value for x'00000080'
       01  sql-sg-insert-column     global pic 9(9) comp-5 value    128.
      * integer value for x'00000100
       01  sql-sg-references-table  global pic 9(9) comp-5 value    256.
      * integer value for x'00000200
       01  sql-sg-references-column global pic 9(9) comp-5 value    512.
      * integer value for x'00000400'
       01  sql-sg-select-table      global pic 9(9) comp-5 value   1024.
      * integer value for x'00000800'
       01  sql-sg-update-table      global pic 9(9) comp-5 value   2048.
      * integer value for x'00001000'
       01  sql-sg-update-column     global pic 9(9) comp-5 value   4096.

      ** bit mask values returned for sql-sql92-grant                 **
      * integer value for x'00000001'
       01  sql-sp-exists            global pic 9(9) comp-5 value      1.
      * integer value for x'00000002'
       01  sql-sp-isnotnull         global pic 9(9) comp-5 value      2.
      * integer value for x'00000004'
       01  sql-sp-isnull            global pic 9(9) comp-5 value      4.
      * integer value for x'00000008'
       01  sql-sp-match-full        global pic 9(9) comp-5 value      8.
      * integer value for x'00000010'
       01  sql-sp-match-partial     global pic 9(9) comp-5 value     16.
      * integer value for x'00000020
       01  sql-sp-match-unique-full global pic 9(9) comp-5 value     32.
      * integer value for x'00000040'
       01  sql-sp-match-unique-partial
                                    global pic 9(9) comp-5 value     64.
      * integer value for x'00000080'
       01  sql-sp-overlaps          global pic 9(9) comp-5 value    128.
      * integer value for x'00000100
       01  sql-sp-unique            global pic 9(9) comp-5 value    256.
      * integer value for x'00000200
       01  sql-sp-like              global pic 9(9) comp-5 value    512.
      * integer value for x'00000400'
       01  sql-sp-in                global pic 9(9) comp-5 value   1024.
      * integer value for x'00000800'
       01  sql-sp-between           global pic 9(9) comp-5 value   2048.
      * integer value for x'00001000'
       01  sql-sp-comparison        global pic 9(9) comp-5 value   4096.
      * integer value for x'00002000'
       01  sql-sp-quantified-comparison
                                    global pic 9(9) comp-5 value   8192.

      ** bit mask values returned for                                 **
      **   sqll-sql92-relational-join-operations                      **
      * integer value for x'00000001'
       01  sql-srjo-corresponding-clause
                                    global pic 9(9) comp-5 value      1.
      * integer value for x'00000002'
       01  sql-srjo-cross-join      global pic 9(9) comp-5 value      2.
      * integer value for x'00000004'
       01  sql-srjo-except-join     global pic 9(9) comp-5 value      4.
      * integer value for x'00000008'
       01  sql-srjo-full-outer-join global pic 9(9) comp-5 value      8.
      * integer value for x'00000010
       01  sql-srjo-inner-join      global pic 9(9) comp-5 value     16.
      * integer value for x'00000020'
       01  sql-srjo-intersect-join  global pic 9(9) comp-5 value     32.
      * integer value for x'00000040'
       01  sql-srjo-left-outer-join global pic 9(9) comp-5 value     64.
      * integer value for x'00000080
       01  sql-srjo-natural-join    global pic 9(9) comp-5 value    128.
      * integer value for x'00000100
       01  sql-srjo-right-outer-join
                                    global pic 9(9) comp-5 value    256.
      * integer value for x'00000280
       01  sql-srjo-union-join      global pic 9(9) comp-5 value    512.

      ** bit mask values returned for sql-sql92-revoke                **
      * integer value for x'00000001'
       01  sql-sr-usage-on-domain   global pic 9(9) comp-5 value      1.
      * integer value for x'00000002'
       01  sql-sr-usage-on-character-set
                                    global pic 9(9) comp-5 value      2.
      * integer value for x'00000004'
       01  sql-sr-usage-on-collation
                                    global pic 9(9) comp-5 value      4.
      * integer value for x'00000008'
       01  sql-sr-usage-on-translation
                                    global pic 9(9) comp-5 value      8.
      * integer value for x'00000010'
       01  sql-sr-usage-on-option-for
                                    global pic 9(9) comp-5 value     16.
      * integer value for x'00000020
       01  sql-sr-cascade           global pic 9(9) comp-5 value     32.
      * integer value for x'00000040'
       01  sql-sr-restrict          global pic 9(9) comp-5 value     64.
      * integer value for x'00000080'
       01  sql-sr-delete-table      global pic 9(9) comp-5 value    128.
      * integer value for x'00000100
       01  sql-sr-insert-table      global pic 9(9) comp-5 value    256.
      * integer value for x'00000200
       01  sql-sr-insert-column     global pic 9(9) comp-5 value    512.
      * integer value for x'00000400'
       01  sql-sr-references-table  global pic 9(9) comp-5 value   1024.
      * integer value for x'00000800'
       01  sql-sr-references-column global pic 9(9) comp-5 value   2048.
      * integer value for x'00001000'
       01  sql-sr-select-table      global pic 9(9) comp-5 value   4096.
      * integer value for x'00002000'
       01  sql-sr-update-table      global pic 9(9) comp-5 value   8192.
      * integer value for x'00004000'
       01  sql-sr-update-column     global pic 9(9) comp-5 value  16384.

      ** bit mask values returned for sql-sql92-row-value-constructor **
      * integer value for x'00000001'
       01  sql-srvc-value-expression
                                    global pic 9(9) comp-5 value      1.
      * integer value for x'00000002'
       01  sql-srvc-null            global pic 9(9) comp-5 value      2.
      * integer value for x'00000004'
       01  sql-srvc-default         global pic 9(9) comp-5 value      4.
      * integer value for x'00000008'
       01  sql-srvc-row-subquery    global pic 9(9) comp-5 value      8.

      ** bit mask values returned for sql-sql92-value-expressions     **
      * integer value for x'00000001'
       01  sql-sve-case             global pic 9(9) comp-5 value      1.
      * integer value for x'00000002'
       01  sql-sve-castl            global pic 9(9) comp-5 value      2.
      * integer value for x'00000004'
       01  sql-sve-coalesce         global pic 9(9) comp-5 value      4.
      * integer value for x'00000008'
       01  sql-sve-nullif           global pic 9(9) comp-5 value      8.

      ** bit mask values returned for sql-standard-cli-conformance    **
      * integer value for x'00000001'
       01  sql-scc-xopen-cli-version1
                                    global pic 9(9) comp-5 value      1.
      * integer value for x'00000002'
       01  sql-scc-iso92-cli        global pic 9(9) comp-5 value      2.
      *** end of defines for SQLGetInfo                              ***

      ******************************************************************
      * SQLGetStmtAttr, SQLSetStmtAttr               (ODBC Ver >= 3.0) *
      *                                                                *
      * SQLGetStmtOption, SQLSetStmtOption           (Deprecated)      *
      ******************************************************************
      ***  Option to Retrieve or Set

       01  SQL-QUERY-TIMEOUT         GLOBAL PIC  9(4) COMP-5 VALUE  0.
        01 sql-attr-query-timeout redefines SQL-QUERY-TIMEOUT
                                     global pic  9(9) comp-5.

      * (ODBC Ver < 3.0)
       01  Sql-STMT-OPT-MIN REDEFINES SQL-QUERY-TIMEOUT
                                     GLOBAL PIC  9(4) COMP-5.
      *

       01  SQL-MAX-ROWS              GLOBAL PIC  9(4) COMP-5 VALUE  1.
        01 sql-attr-max-rows redefines SQL-MAX-ROWS
                                     global pic  9(9) comp-5.
       01  SQL-NOSCAN                GLOBAL PIC  9(4) COMP-5 VALUE  2.
        01 sql-attr-noscan redefines SQL-NOSCAN
                                     global pic  9(9) comp-5.
       01  SQL-MAX-LENGTH            GLOBAL PIC  9(4) COMP-5 VALUE  3.
        01 sql-attr-max-length redefines SQL-MAX-LENGTH
                                     global pic  9(9) comp-5.
       01  SQL-ASYNC-ENABLE          GLOBAL PIC  9(4) COMP-5 VALUE  4.
        01 sql-attr-async-enable redefines SQL-ASYNC-ENABLE
                                     global pic  9(9) comp-5.
       01  SQL-BIND-TYPE             GLOBAL PIC  9(4) COMP-5 VALUE  5.
        01 sql-attr-row-bind-type redefines SQL-BIND-TYPE
                                     global pic  9(9) comp-5.
       01  SQL-CURSOR-TYPE           GLOBAL PIC  9(4) COMP-5 VALUE  6.
        01 sql-attr-cursor-type redefines SQL-CURSOR-TYPE
                                     global pic  9(9) comp-5.
       01  SQL-CONCURRENCY           GLOBAL PIC  9(4) COMP-5 VALUE  7.
        01 sql-attr-concurrency redefines SQL-CONCURRENCY
                                     global pic  9(9) comp-5.
       01  SQL-KEYSET-SIZE           GLOBAL PIC  9(4) COMP-5 VALUE  8.
        01 sql-attr-keyset-size redefines SQL-KEYSET-SIZE
                                     global pic  9(9) comp-5.
       01  SQL-ROWSET-SIZE           GLOBAL PIC  9(4) COMP-5 VALUE  9.
       01  SQL-SIMULATE-CURSOR       GLOBAL PIC  9(4) COMP-5 VALUE 10.
        01 sql-attr-simulate-cursor redefines SQL-SIMULATE-CURSOR
                                     global pic  9(9) comp-5.
       01  SQL-RETRIEVE-DATA         GLOBAL PIC  9(4) COMP-5 VALUE 11.
        01 sql-attr-retrieve-data redefines SQL-RETRIEVE-DATA
                                     global pic  9(9) comp-5.
       01  SQL-USE-BOOKMARKS         GLOBAL PIC  9(4) COMP-5 VALUE 12.
        01 sql-attr-use-bookmarks redefines SQL-USE-BOOKMARKS
                                     global pic  9(9) comp-5.

      * GetStmtOption Only *
       01  SQL-GET-BOOKMARK          GLOBAL PIC  9(4) COMP-5 VALUE 13.
       01  SQL-ROW-NUMBER            GLOBAL PIC  9(4) COMP-5 VALUE 14.
        01 sql-attr-row-number redefines SQL-ROW-NUMBER
                                     global pic  9(9) comp-5.

      * (ODBC Ver < 3.0)
       01  Sql-STMT-OPT-MAX REDEFINES SQL-ROW-NUMBER
                                     GLOBAL PIC  9(4) COMP-5.
      * (ODBC Ver >= 3.0)
       01  sql-attr-enable-auto-ipd  global pic  9(9) comp-5 value 15.
       01  sql-attr-fetch-bookmark-ptr
                                     global pic  9(9) comp-5 value 16.
       01  sql-attr-param-bind-offset-ptr
                                     global pic  9(9) comp-5 value 17.
       01  sql-attr-param-bind-type  global pic  9(9) comp-5 value 18.
       01  sql-attr-param-operation-ptr
                                     global pic  9(9) comp-5 value 19.
       01  sql-attr-param-statusn-ptr
                                     global pic  9(9) comp-5 value 20.
       01  sql-attr-params-processed-ptr
                                     global pic  9(9) comp-5 value 21.
       01  sql-attr-paramset-size    global pic  9(9) comp-5 value 22.
       01  sql-attr-row-bind-offset-ptr
                                     global pic  9(9) comp-5 value 23.
       01  sql-attr-row-operation-ptr
                                     global pic  9(9) comp-5 value 24.
       01  sql-attr-row-status-ptr   global pic  9(9) comp-5 value 25.
       01  sql-attr-rows-fetched-ptr global pic  9(9) comp-5 value 26.
       01  sql-attr-row-array-size   global pic  9(9) comp-5 value 27.


      *** ValuePtr contents
      ** ValuPtr contents with Attribute = SQL-QUERY-TIMEOUT  **
       01  SQL-QUERY-TIMEOUT-DEFAULT GLOBAL PIC  9(9) COMP-5 VALUE  0.

      ** ValuePtr contents with Attribute = SQL-MAX-ROWS **
       01  SQL-MAX-ROWS-DEFAULT      GLOBAL PIC  9(9) COMP-5 VALUE  0.

      ** ValuePtr contents with Attribute = SQL-NOSCAN **
       01  SQL-NOSCAN-OFF            GLOBAL PIC  9(9) COMP-5 VALUE  0.
       01  SQL-NOSCAN-DEFAULT REDEFINES SQL-NOSCAN-OFF
                                     GLOBAL PIC  9(9) COMP-5.
       01  SQL-NOSCAN-ON             GLOBAL PIC  9(9) COMP-5 VALUE  1.

      ** ValuePtr contents with Attribute = SQL-MAX-LENGTH **
       01  SQL-MAX-LENGTH-DEFAULT    GLOBAL PIC  9(9) COMP-5 VALUE  0.

      ** ValuePtr contents with Attribute = SQL-ASYNC-ENABLE **
       01  SQL-ASYNC-ENABLE-OFF      GLOBAL PIC  9(9) COMP-5 VALUE  0.
       01  SQL-ASYNC-ENABLE-DEFAULT REDEFINES SQL-ASYNC-ENABLE-OFF
                                     GLOBAL PIC  9(9) COMP-5.
       01  SQL-ASYNC-ENABLE-ON       GLOBAL PIC  9(9) COMP-5 VALUE  1.

      ** ValuePtr contents with Attribute = SQL-BIND-TYPE **
       01  SQL-BIND-BY-COLUMN        GLOBAL PIC  9(9) COMP-5 VALUE  0.
       01  SQL-BIND-TYPE-DEFAULT REDEFINES SQL-BIND-BY-COLUMN
                                     GLOBAL PIC  9(9) COMP-5.

      ** ValuePtr contents with Attribute = SQL-CONCURRENCY **
       01  SQL-CONCUR-READ-ONLY      GLOBAL PIC 9(4) COMP-5 VALUE   1.
       01  SQL-CONCUR-DEFAULT REDEFINES SQL-CONCUR-READ-ONLY
                                     GLOBAL PIC 9(4) COMP-5.
       01  SQL-CONCUR-LOCK           GLOBAL PIC 9(4) COMP-5 VALUE   2.
       01  Sql-CONCUR-ROWVER         GLOBAL PIC 9(4) COMP-5 VALUE   3.
        01 sql-concur-timestamp  redefines Sql-CONCUR-ROWVER
                                     global pic 9(4) comp-5.
       01  SQL-CONCUR-VALUES         GLOBAL PIC 9(4) COMP-5 VALUE   4.

      ** ValuePtr contents with Attribute = SQL-CURSOR-TYPE **
       01  Sql-CURSOR-FORWARD-ONLY   GLOBAL PIC  9(9) COMP-5 VALUE   0.
       01  SQL-CURSOR-TYPE-DEFAULT REDEFINES Sql-CURSOR-FORWARD-ONLY
                                     GLOBAL PIC  9(9) COMP-5.
        01 sql-scroll-forward-only redefines Sql-CURSOR-FORWARD-ONLY
                                     global pic  9(9) comp-5.
      * note: replacement symbols have negative values of the         *
      *        corresponding deprecated symbols      (ODBC Ver >= 3.0)*
       01  Sql-CURSOR-KEYSET-DRIVEN  GLOBAL PIC  9(9) COMP-5 VALUE   1.
       01  sql-scroll-keyset-driven  global pic s9(9) comp-5 value  -1.
       01  SQL-CURSOR-DYNAMIC        GLOBAL PIC  9(9) COMP-5 VALUE   2.
       01  sql-scroll-dynamic        global pic s9(9) comp-5 value  -2.
       01  SQL-CURSOR-STATIC         GLOBAL PIC  9(9) COMP-5 VALUE   3.
       01  sql-scroll-satic          global pic s9(9) comp-5 value  -3.

      ** ValuePtr contents with Attribute = SQL-ROWSET-SIZE **
       01  SQL-ROWSET-SIZE-DEFAULT   GLOBAL PIC  9(9) COMP-5 VALUE   1.

      ** ValuePtr contents with Attribute = SQL-KEYSET-SIZE **
       01  SQL-KEYSET-SIZE-DEFAULT   GLOBAL PIC  9(9) COMP-5 VALUE   0.

      ** ValuePtr contents with Attribute = SQL-SIMULATE-CURSOR **
       01  SQL-SC-NON-UNIQUE         GLOBAL PIC  9(9) COMP-5 VALUE  0.
       01  SQL-SC-TRY-UNIQUE         GLOBAL PIC  9(9) COMP-5 VALUE  1.
       01  SQL-SC-UNIQUE             GLOBAL PIC  9(9) COMP-5 VALUE  2.

      ** ValuePtr contents with Attribute = SQL-RETRIEVE-DATA **
       01  SQL-RD-OFF                GLOBAL PIC  9(9) COMP-5 VALUE  0.
       01  SQL-RD-ON                 GLOBAL PIC  9(9) COMP-5 VALUE  1.
       01  SQL-RD-DEFAULT REDEFINES SQL-RD-ON
                                     GLOBAL PIC  9(9) COMP-5.

      ** ValuePtr contents with Attribute = SQL-USE-BOOKMARKS **
       01  SQL-UB-OFF                GLOBAL PIC  9(9) COMP-5 VALUE  0.
       01  SQL-UB-DEFAULT REDEFINES SQL-UB-OFF
                                     GLOBAL PIC  9(9) COMP-5.
       01  SQL-UB-ON                 GLOBAL PIC  9(9) COMP-5 VALUE  1.
        01 sql-ub-fixed   redefines SQL-UB-ON
                                     global pic  9(9) comp-5.
       01  sql-ub-variable           global pic  9(9) comp-5 value  2.

       01  sql-attr-app-row-desc    global pic  9(4) comp-5 value 10010.
       01  sql-attr-app-param-desc  global pic  9(4) comp-5 value 10011.
       01  sql-attr-imp-row-desc    global pic  9(4) comp-5 value 10012.
       01  sql-attr-imp-param-desc  global pic  9(4) comp-5 value 10013.
       01  sql-attr-cursor-scrollable
                                    global pic s9(4) comp-5 value    -1.
       01  sql-attr-cursor-sensitivity
                                    global pic s9(4) comp-5 value    -2.

      * sql-attr-cursor-scrollable values
       01  sql-nonscrollable        global pic  9(4) comp-5 value     0.
       01  sql-scrollable           global pic  9(4) comp-5 value     1.

      * statement attribute values for sql-attr-cursor-sensitivity
       01  sql-unspecified           global pic  9(4) comp-5 value    0.
       01  sql-insensitive           global pic  9(4) comp-5 value    1.
       01  sql-sensitive             global pic  9(4) comp-5 value    2.

      ******************************************************************
      * SQLGetTypeInfo                                                 *
      ******************************************************************
      * information about all data types should be returned
       01  SQL-ALL-TYPES            GLOBAL PIC S9(4) COMP-5 VALUE   0.

      * values of SEARCHABLE column
       01  sql-pred-none             global pic  9(4) comp-5 value    0.
       01  sql-pred-char             global pic  9(4) comp-5 value    1.
       01  sql-pred-basic            global pic  9(4) comp-5 value    2.

      * Values of NULLABLE column           or
       01  SQL-NO-NULLS              GLOBAL PIC  9(4) COMP-5 VALUE    0.
       01  SQL-NULLABLE              GLOBAL PIC  9(4) COMP-5 VALUE    1.
       01  SQL-NULLABLE-UNKNOWN      GLOBAL PIC  9(4) COMP-5 VALUE    2.

      ******************************************************************
      * SQLProcedures                                                  *
      ******************************************************************
      ** Procedure type (returned in result set) **
       01  SQL-PT-UNKNOWN            GLOBAL PIC  9(4) COMP-5 VALUE  0.
       01  SQL-PT-PROCEDURE          GLOBAL PIC  9(4) COMP-5 VALUE  1.
       01  SQL-PT-FUNCTION           GLOBAL PIC  9(4) COMP-5 VALUE  2.

      ******************************************************************
      * SQLSetDescField                              (ODBC Ver >= 3.0) *
      ******************************************************************
      * values of SQL_DESC_ALLOC_TYPE field
       01  sql-desc-alloc-auto       global pic  9(4) comp-5 value    1.
       01  sql-desc-alloc-user       global pic  9(4) comp-5 value    2.

      ******************************************************************
      * SQLSetEnvAttr                                (ODBC Ver >= 3.0) *
      ******************************************************************
      ** environment attributes
       01  sql-attr-odbc-version    global pic  9(4) comp-5 value   200.
       01  sql-attr-connection-pooling
                                    global pic  9(4) comp-5 value   201.
       01  sql-attr-cp-match        global pic  9(4) comp-5 value   202.

       01  sql-attr-output-nts      global pic  9(4) comp-5 value 10001.

      * values when sql-attr-connection-pooling
       01  sql-cp-off               global pic  9(9) comp-5 value     0.
        01 sql-cp-default redefines sql-cp-off
                                    global pic  9(9) comp-5.
       01  sql-cp-one-per-driver    global pic  9(9) comp-5 value     1.
       01  sql-cp-one-per-henv      global pic  9(9) comp-5 value     2.

      * values when sql-attr-cp-match
       01  sql-cp-strict-match      global pic  9(9) comp-5 value     0.

        01 sql-cp-match-default redefines sql-cp-strict-match
                                    global pic  9(9) comp-5.
       01  sql-cp-relaxed-match     global pic  9(9) comp-5 value     1.

      * values when sql-attr-odbc-version
       01  sql-ov-odbc2             global pic  9(9) comp-5 value     2.
       01  sql-ov-odbc3             global pic  9(9) comp-5 value     3.

      ******************************************************************
      * SQLSetPos                                                      *
      ******************************************************************
      ** Operation applies to every row in rowset (input) **
       01  SQL-ENTIRE-ROWSET         GLOBAL PIC  9(4) COMP-5 VALUE  0.

      ** Operation to perform - fOption (input) **
       01  SQL-POSITION              GLOBAL PIC  9(4) COMP-5 VALUE  0.
       01  SQL-REFRESH               GLOBAL PIC  9(4) COMP-5 VALUE  1.
       01  SQL-UPDATE                GLOBAL PIC  9(4) COMP-5 VALUE  2.
       01  SQL-DELETE                GLOBAL PIC  9(4) COMP-5 VALUE  3.
      *01  SQL-ADD                   GLOBAL PIC  9(4) COMP-5 VALUE  4.
      *    (SQL-ADD operation was deprecated in ODBC Ver 3.0 and
      *      replaced with SQLBulkOperations with SQL-ADD operation)

      ** How to lock the row after the operation                 **
       01  SQL-LOCK-NO-CHANGE        GLOBAL PIC  9(4) COMP-5 VALUE  0.
       01  SQL-LOCK-EXCLUSIVE        GLOBAL PIC  9(4) COMP-5 VALUE  1.
       01  SQL-LOCK-UNLOCK           GLOBAL PIC  9(4) COMP-5 VALUE  2.
        01 sql-setpos-max-lock-value redefines SQL-LOCK-UNLOCK
                                     global pic  9(4) comp-5.

      ******************************************************************
      * SQLSpecialColumns                                              *
      ******************************************************************
      ** Column type return
       01  SQL-BEST-ROWID            GLOBAL PIC  9(4) COMP-5 VALUE  1.
       01  SQL-ROWVER                GLOBAL PIC  9(4) COMP-5 VALUE  2.

      ** Scope of rowid
       01  SQL-SCOPE-CURROW          GLOBAL PIC  9(4) COMP-5 VALUE  0.
       01  SQL-SCOPE-TRANSACTION     GLOBAL PIC  9(4) COMP-5 VALUE  1.
       01  SQL-SCOPE-SESSION         GLOBAL PIC  9(4) COMP-5 VALUE  2.

      ** Pseudo column indicator (returned in the result set)
       01  SQL-PC-UNKNOWN            GLOBAL PIC  9(4) COMP-5 VALUE  0.
       01  sql-pc-non-pseudo         global pic  9(4) comp-5 value  1.
       01  sql-pc-not-pseudo         global pic  9(4) comp-5 value  1.
       01  SQL-PC-PSEUDO             GLOBAL PIC  9(4) COMP-5 VALUE  2.

      ** reserved value for IdentifierType argument (ODBC Ver >= 3.0)
       01  sql-row-identifier        global pic  9(4) comp-5 value  1.

      ******************************************************************
      * SQLStatistics                                                  *
      ******************************************************************
      ** Type of index
       01  SQL-INDEX-UNIQUE          GLOBAL PIC  9(4) COMP-5 VALUE  0.
       01  SQL-INDEX-ALL             GLOBAL PIC  9(4) COMP-5 VALUE  1.

      ** Importance of CARDINALITY and PAGES **
       01  SQL-QUICK                 GLOBAL PIC  9(4) COMP-5 VALUE  0.
       01  SQL-ENSURE                GLOBAL PIC  9(4) COMP-5 VALUE  1.

      ** TYPE of information being returned in the result set **
      *01  SQL-TABLE-STAT            GLOBAL PIC  9(4) COMP-5 VALUE  0.
       01  SQL-INDEX-CLUSTERED       GLOBAL PIC  9(4) COMP-5 VALUE  1.
       01  SQL-INDEX-HASHED          GLOBAL PIC  9(4) COMP-5 VALUE  2.
       01  SQL-INDEX-OTHER           GLOBAL PIC  9(4) COMP-5 VALUE  3.

      ******************************************************************
      * SQLTables                                                      *
      ******************************************************************
      * catalog name
       01  sql-all-catalogs         global pic xx           value z'%'.
      * schema name
       01  sql-all-schemas          global pic xx           value z'%'.
      * table types
       01  sql-all-table-types      global pic xx           value z'%'.

      ******************************************************************
      * Length values                                                  *
      ******************************************************************
       01  SQL-NULL-DATA             GLOBAL PIC S9(4) COMP-5 VALUE   -1.
       01  SQL-DATA-AT-EXEC          GLOBAL PIC S9(4) COMP-5 VALUE   -2.
       01  SQL-NTS                   GLOBAL PIC S9(4) COMP-5 VALUE   -3.

      ** BufferLength values for SQLGetDescField & SQLSetDescField   **
      *                                             (ODBC Ver >= 3.0) *
       01  sql-is-pointer            global pic s9(4) comp-5 value   -4.
       01  sql-is-uinteger           global pic s9(4) comp-5 value   -5.
       01  sql-is-integer            global pic s9(4) comp-5 value   -6.
       01  sql-is-usmallint          global pic s9(4) comp-5 value   -7.
       01  sql-is-smallint           global pic s9(4) comp-5 value   -8.

      ******************************************************************
      * CLI option true/false values                 (ODBC Ver >= 3.0) *
      ******************************************************************
       01  sql-false                 global pic  9(4) comp-5 value    0.
       01  sql-true                  global pic  9(4) comp-5 value    1.

      ******************************************************************
      * Used by Driver Manager when mapping SQLSetParam to             *
      * SQLBindParameter                                               *
      ******************************************************************
       01  SQL-PARAM-TYPE-DEFAULT    GLOBAL PIC  9(4) COMP-5 VALUE  2.
      *     = SQL-PARAM-INPUT-OUTPUT

       01  SQL-SETPARAM-VALUE-MAX    GLOBAL PIC S9(9) COMP-5 VALUE -1.

      ******************************************************************
      * Length constants                                               *
      ******************************************************************
       01  SQL-SQLSTATE-SIZE         GLOBAL PIC 9(4) COMP-5 VALUE   5.
       01  SQL-MAX-MESSAGE-LENGTH    GLOBAL PIC 9(4) COMP-5 VALUE 512.
       01  SQL-MAX-DSN-LENGTH        GLOBAL PIC 9(4) COMP-5 VALUE  32.
       01  SQL-MAX-OPTION-STRING-LENGTH
                                     GLOBAL PIC 9(4) COMP-5 VALUE 256.

       01  sql-sqlstate-sizenew      global pic 9(4) comp-5 value  10.

      * date/time length constants (>= ODBC Ver 3.0)
       01  sql-date-len              global pic 9(4) comp-5 value  10.
       01  sql-time-len              global pic 9(4) comp-5 value   8.
       01  sql-timestamp-len         global pic 9(4) comp-5 value  19.

      ******************************************************************
      ******************************************************************
      * Data Types                                                     *
      ******************************************************************
      ******************************************************************

      *** SQL Data Types ***
       01  SQL-UNKNOWN-TYPE         GLOBAL PIC S9(4) COMP-5 VALUE     0.

       01  SQL-CHAR                 GLOBAL PIC S9(4) COMP-5 VALUE     1.
       01  SQL-NUMERIC              GLOBAL PIC S9(4) COMP-5 VALUE     2.
       01  SQL-DECIMAL              GLOBAL PIC S9(4) COMP-5 VALUE     3.
       01  SQL-INTEGER              GLOBAL PIC S9(4) COMP-5 VALUE     4.
       01  SQL-SMALLINT             GLOBAL PIC S9(4) COMP-5 VALUE     5.
       01  SQL-FLOAT                GLOBAL PIC S9(4) COMP-5 VALUE     6.
       01  SQL-REAL                 GLOBAL PIC S9(4) COMP-5 VALUE     7.
       01  SQL-DOUBLE               GLOBAL PIC S9(4) COMP-5 VALUE     8.
       01  sql-datetime             global pic s9(4) comp-5 value     9.
       01  SQL-VARCHAR              GLOBAL PIC S9(4) COMP-5 VALUE    12.
      *      (ODBC Ver < 3.0 )
       01  Sql-TYPE-MAX  REDEFINES SQL-VARCHAR
                                    GLOBAL PIC S9(4) COMP-5.

      **    SQL extended data types   **
       01  SQL-DATE                 GLOBAL PIC S9(4) COMP-5 VALUE     9.
       01  SQL-TIME                 GLOBAL PIC S9(4) COMP-5 VALUE    10.
       01  sql-interval             global pic s9(4) comp-5 value    10.
       01  SQL-TIMESTAMP            GLOBAL PIC S9(4) COMP-5 VALUE    11.

       01  SQL-LONGVARCHAR          GLOBAL PIC S9(4) COMP-5 VALUE    -1.
       01  SQL-BINARY               GLOBAL PIC S9(4) COMP-5 VALUE    -2.
       01  SQL-VARBINARY            GLOBAL PIC S9(4) COMP-5 VALUE    -3.
       01  SQL-LONGVARBINARY        GLOBAL PIC S9(4) COMP-5 VALUE    -4.
       01  SQL-BIGINT               GLOBAL PIC S9(4) COMP-5 VALUE    -5.
       01  SQL-TINYINT              GLOBAL PIC S9(4) COMP-5 VALUE    -6.
       01  SQL-BIT                  GLOBAL PIC S9(4) COMP-5 VALUE    -7.
      * (ODBC Ver < 3.0)
        01 Sql-TYPE-MIN  REDEFINES SQL-BIT
                                    GLOBAL PIC S9(4) COMP-5.
      * (from sqlucode.h)
       01  sql-wchar                global pic s9(4) comp-5 value    -8.
        01 sql-c-wchar redefines sql-wchar
                                    global pic s9(4) comp-5.
       01  sql-wvarchar             global pic s9(4) comp-5 value    -9.
       01  sql-wlongvarchar         global pic s9(4) comp-5 value   -10.

      **   one-parameter shortcuts for date/time data types (>= 3.0)
       01  sql-type-date            global pic s9(4) comp-5 value    91.
       01  sql-type-time            global pic s9(4) comp-5 value    92.
       01  sql-type-timestamp       global pic s9(4) comp-5 value    93.

      **   sql date/time type subcode                (ODBC Ver >= 3.0)
       01  sql-code-date            global pic  9(4) comp-5 value     1.
       01  sql-code-time            global pic  9(4) comp-5 value     2.
       01  sql-code-timestamp       global pic  9(4) comp-5 value     3.

      * (ODBC Ver < 3.0 )
      * 01 SQL-TYPE-MIN REDEFINES SQL-BIT
      *                             GLOBAL PIC S9(4) COMP-5.

      **   Other SQL data types   **
      * interval code
      * (ODBC Ver >= 3.0)
       01  sql-code-year              global pic s9(4) comp-5 value   1.
       01  sql-code-month             global pic s9(4) comp-5 value   2.
       01  sql-code-day               global pic s9(4) comp-5 value   3.
       01  sql-code-hour              global pic s9(4) comp-5 value   4.
       01  sql-code-minute            global pic s9(4) comp-5 value   5.
       01  sql-code-second            global pic s9(4) comp-5 value   6.
       01  sql-code-year-to-month     global pic s9(4) comp-5 value   7.
       01  sql-code-day-to-hour       global pic s9(4) comp-5 value   8.
       01  sql-code-day-to-minute     global pic s9(4) comp-5 value   8.
       01  sql-code-day-to-second     global pic s9(4) comp-5 value  10.
       01  sql-code-hour-to-minute    global pic s9(4) comp-5 value  11.
       01  sql-code-hour-to-second    global pic s9(4) comp-5 value  12.
       01  sql-code-minute-to-second  global pic s9(4) comp-5 value  13.

      * (the following 13 names are "redefinitions" of the above 13 and
      *  are used to support SQLAllocHandle to conform to X/Open std.
       01  sql-year                   global pic s9(4) comp-5 value   1.
       01  sql-month                  global pic s9(4) comp-5 value   2.
       01  sql-day                    global pic s9(4) comp-5 value   3.
       01  sql-hour                   global pic s9(4) comp-5 value   4.
       01  sql-minute                 global pic s9(4) comp-5 value   5.
       01  sql-second                 global pic s9(4) comp-5 value   6.
       01  sql-year-to-month          global pic s9(4) comp-5 value   7.
       01  sql-day-to-hour            global pic s9(4) comp-5 value   8.
       01  sql-day-to-minute          global pic s9(4) comp-5 value   8.
       01  sql-day-to-second          global pic s9(4) comp-5 value  10.
       01  sql-hour-to-minute         global pic s9(4) comp-5 value  11.
       01  sql-hour-to-second         global pic s9(4) comp-5 value  12.
       01  sql-minute-to-second       global pic s9(4) comp-5 value  13.

       01  sql-interval-year          global pic s9(4) comp-5 value 101.
       01  sql-interval-month         global pic s9(4) comp-5 value 102.
       01  sql-interval-day           global pic s9(4) comp-5 value 103.
       01  sql-interval-hour          global pic s9(4) comp-5 value 104.
       01  sql-interval-minute        global pic s9(4) comp-5 value 105.
       01  sql-interval-second        global pic s9(4) comp-5 value 106.
       01  sql-interval-year-to-month global pic s9(4) comp-5 value 107.
       01  sql-interval-day-to-hour   global pic s9(4) comp-5 value 108.
       01  sql-interval-day-to-minute global pic s9(4) comp-5 value 109.
       01  sql-interval-day-to-second global pic s9(4) comp-5 value 110.
       01  sql-interval-hour-to-minute
                                      global pic s9(4) comp-5 value 111.
       01  sql-interval-hour-to-second
                                      global pic s9(4) comp-5 value 112.
       01  sql-interval-minute-to-second
                                      global pic s9(4) comp-5 value 113.

      ** ODBC Ver < 3.0 (Conflicts with ODBC Ver >= 3.0 definitions)****
      *                                                                *
      *01  Sql-INTERVAL-YEAR          GLOBAL PIC S9(4) COMP-5 VALUE -80.
      * 01  Sql-TYPE-DRIVER-START REDEFINES Sql-INTERVAL-YEAR
      *                               GLOBAL PIC S9(4) COMP-5.
      *01  Sql-INTERVAL-MONTH         GLOBAL PIC S9(4) COMP-5 VALUE -81.
      *01  Sql-INTERVAL-YEAR-TO-MONTH GLOBAL PIC S9(4) COMP-5 VALUE -82.
      *01  Sql-INTERVAL-DAY           GLOBAL PIC S9(4) COMP-5 VALUE -83.
      *01  Sql-INTERVAL-HOUR          GLOBAL PIC S9(4) COMP-5 VALUE -84.
      *01  Sql-INTERVAL-MINUTE        GLOBAL PIC S9(4) COMP-5 VALUE -85.
      *01  Sql-INTERVAL-SECOND        GLOBAL PIC S9(4) COMP-5 VALUE -86.
      *01  Sql-INTERVAL-DAY-TO-HOUR   GLOBAL PIC S9(4) COMP-5 VALUE -87.
      *01  Sql-INTERVAL-DAY-TO-MINUTE GLOBAL PIC S9(4) COMP-5 VALUE -88.
      *01  Sql-INTERVAL-DAY-TO-SECOND GLOBAL PIC S9(4) COMP-5 VALUE -89.
      *01  Sql-INTERVAL-HOUR-TO-MINUTE
      *                               GLOBAL PIC S9(4) COMP-5 VALUE -90.
      *01  Sql-INTERVAL-HOUR-TO-SECOND
      *                               GLOBAL PIC S9(4) COMP-5 VALUE -91.
      *01  Sql-INTERVAL-MINUTE-TO-SECOND
      *                               GLOBAL PIC S9(4) COMP-5 VALUE -92.
      *                                                                *
      ******************************************************************

       01  SQL-UNICODE                GLOBAL PIC S9(4) COMP-5 VALUE -95.
       01  SQL-UNICODE-CHAR      REDEFINES SQL-UNICODE
                                      GLOBAL PIC S9(4) COMP-5.
       01  SQL-UNICODE-VARCHAR        GLOBAL PIC S9(4) COMP-5 VALUE -96.
       01  SQL-UNICODE-LONGVARCHAR    GLOBAL PIC S9(4) COMP-5 VALUE -97.
      * (ODBC Ver < 3.0)
       01  Sql-TYPE-DRIVER-END   REDEFINES SQL-UNICODE-LONGVARCHAR
                                      GLOBAL PIC S9(5) COMP-5.

      *** C Data Types ***
       01  SQL-TYPE-NULL              GLOBAL PIC S9(4) COMP-5 VALUE   0.
       01  SQL-C-CHAR                 GLOBAL PIC S9(4) COMP-5 VALUE   1.
      *      = SQL-CHAR
       01  sql-c-numeric              global pic s9(4) comp-5 value   2.
      *      = SQL-NUMERIC
       01  SQL-C-LONG                 GLOBAL PIC S9(4) COMP-5 VALUE   4.
      *      = SQL-INTEGER
       01  SQL-C-SHORT                GLOBAL PIC S9(4) COMP-5 VALUE   5.
      *      = SQL-SHORT
       01  SQL-C-DOUBLE               GLOBAL PIC S9(4) COMP-5 VALUE   8.
      *      = SQL-DOUBLE
       01  SQL-C-FLOAT                GLOBAL PIC S9(4) COMP-5 VALUE   7.
      *      = SQL-REAL
       01  SQL-C-DATE                 GLOBAL PIC S9(4) COMP-5 VALUE   9.
      *      = SQL-DATE
       01  SQL-C-TIME                 GLOBAL PIC S9(4) COMP-5 VALUE  10.
      *      = SQL-TIME
       01  SQL-C-TIMESTAMP            GLOBAL PIC S9(4) COMP-5 VALUE  11.
      *      = SQL-TIMESTAMP

       01  sql-c-type-date            global pic s9(4) comp-5 value  91.
      *      = sql-type-date
       01  sql-c-type-time            global pic s9(4) comp-5 value  92.
      *      = sql-type-time
       01  sql-c-type-timestamp       global pic s9(4) comp-5 value  93.
      *      = sql-type-timestamp

       01  SQL-C-DEFAULT              GLOBAL PIC S9(4) COMP-5 VALUE  99.

       01  sql-c-interval-year        global pic s9(4) comp-5 value 101.
      *      = sql-interval-year
       01  sql-c-interval-month       global pic s9(4) comp-5 value 102.
      *      = sql-interval-month
       01  sql-c-interval-day         global pic s9(4) comp-5 value 103.
      *      = sql-interval-day
       01  sql-c-interval-hour        global pic s9(4) comp-5 value 104.
      *      = sql-interval-hour
       01  sql-c-interval-minute      global pic s9(4) comp-5 value 105.
      *      = sql-interval-minute
       01  sql-c-interval-second      global pic s9(4) comp-5 value 106.
      *      = sql-interval-second
       01  sql-c-interval-year-to-month
                                      global pic s9(4) comp-5 value 107.
      *      = sql-interval-year-to-month
       01  sql-c-interval-day-to-hour global pic s9(4) comp-5 value 108.
      *      = sql-interval-day-to-hour
       01  sql-c-interval-day-to-minute
                                      global pic s9(4) comp-5 value 109.
      *      = sql-interval-day-to-minute
       01  sql-c-interval-day-to-second
                                      global pic s9(4) comp-5 value 110.
      *      = sql-interval-day-to-second
       01  sql-c-interval-hour-to-minute
                                      global pic s9(4) comp-5 value 111.
      *      = sql-interval-hour-to-minute
       01  sql-c-interval-hour-to-second
                                      global pic s9(4) comp-5 value 112.
      *      = sql-interval-hour-to-second

      *    (name truncated from sql-c-interval-minute-to-second)
       01  sql-c-interval-minute-to-secon
                                      global pic s9(4) comp-5 value 113.
      *      = sql-interval-minute-to-second

       01  SQL-C-BINARY               GLOBAL PIC S9(4) COMP-5 VALUE  -2.
      *      = SQL-BINARY
        01 sql-c-varbookmark  redefines SQL-C-BINARY
                                      global pic s9(4) comp-5.
       01  SQL-C-TINYINT              GLOBAL PIC S9(4) COMP-5 VALUE  -6.
      *      = SQL-TINYINT
       01  SQL-C-BIT                  GLOBAL PIC S9(4) COMP-5 VALUE  -7.
      *      = SQL-BIT

       01  SQL-C-SSHORT               GLOBAL PIC S9(4) COMP-5 VALUE -15.
      *      = SQL-C-SHORT + SQL-SIGNED-OFFSET
       01  SQL-C-SLONG                GLOBAL PIC S9(4) COMP-5 VALUE -16.
      *      = SQL-C-LONG + SQL-SIGNED-OFFSET
       01  SQL-C-ULONG                GLOBAL PIC S9(4) COMP-5 VALUE -18.
      *      = SQL-C-LONG + SQL-UNSIGNED-OFFSET
       01  SQL-C-USHORT               GLOBAL PIC S9(4) COMP-5 VALUE -17.
      *      = SQL-C-SHORT + SQL-UNSIGNED-OFFSET
       01  SQL-C-BOOKMARK             GLOBAL PIC S9(4) COMP-5 VALUE -18.
      *      = SQL-C-BOOKMARK = SQL-C-ULONG

       01  SQL-SIGNED-OFFSET          GLOBAL PIC S9(4) COMP-5 VALUE -20.
       01  SQL-UNSIGNED-OFFSET        GLOBAL PIC S9(4) COMP-5 VALUE -22.

       01  sql-c-sbigint              global pic s9(4) comp-5 value -25.
      *      = SQL-BIGINT + SQL-SIGNED-OFFSET
       01  SQL-C-STINYINT             GLOBAL PIC S9(4) COMP-5 VALUE -26.
      *      = TINYINT
       01  sql-c-ubigint              global pic s9(4) comp-5 value -27.
      *      = SQL-BIGINT + SQL-UNSIGNED-OFFSET
       01  SQL-C-UTINYINT             GLOBAL PIC S9(4) COMP-5 VALUE -28.


      ******************************************************************
      * End of ODBC3.CPY                                               *
      ******************************************************************

