/**INTERNAL_ONLY**/
/*
 *  Change History:
 *
 *     Post ISO/CMVC Revision history: (f = feature d = defect)                *
 *  Flag Change Fixer Date    Tester Date    Review Date    Release  Describe  *
 *  ---- ------ ----- ------- ------ ------- ------ ------- -------  --------  *
 *  @f00 f2359  MBB   93Nov10
 *   Add Net32 entry points & internal-use structs; make all 'char' UCHAR
 *       D06991 MBB   94Apr09
 *   Declare all 32-bit functions as API32_FUNCTION
 *  @f01 F05438  MBB  94Aug08                                LS 4.0
 *   Make LS 4.0 header files compatible with C++
 */
/**END_INTERNAL**/

/********************************************************************/
/**                        IBM LAN Server                          **/
/** Copyright (c) International Business Machines Corp., 1987-1993 **/
/** Copyright (c) Microsoft Corp., 1987-1990                       **/
/********************************************************************/


/********************************************************************
 *
 *  About this file ...  ALERT.H
 *
 *  This file contains information about the NetAlert APIs.
 *
 *      Function prototypes.
 *
 *      Data structure templates.
 *
 *      Definition of special values.
 *
 *
 *  NOTE:  You must include NETCONS.H before this file, since this
 *         file depends on values defined in NETCONS.H.
 *
 *  NOTE:  ALERT.H includes ALERTMSG.H, which defines the alert message
 *         numbers.
 *
 ********************************************************************/

/**INTERNAL_ONLY**/
/*
 *
 *    IMPORTANT!  IMPORTANT! IMPORTANT! IMPORTANT! IMPORTANT! IMPORTANT!
 *    READ THIS FIRST BEFORE MAKING ANY CHANGES
 *
 *    This file was modified to provide support for 32-bit code.
 *
 *    Any 32-bit module that includes this header file must define
 *    the constant INCL_32.
 *
 *    It is assumed that "netcons.h" is included before this file.
 *
 *    The following contants are defined in netcons.h as shown below:
 *
 *    #ifdef INCL_32    ( defined by 32-bit apps )
 *        #define LSFAR
 *        #define LSPAS
 *        #define LSPTR  _Seg16
 *        #define LSINT  short
 *    #else                 ( for 16-bit apps )
 *        #define LSFAR  far
 *        #define LSPAS  pascal
 *        #define LSPTR
 *        #define LSINT  int
 *    #endif
 *
 *    Do not add any keywords like far, pascal, etc. which are not recognized
 *    by the 32-bit compiler. The constants defined in netcons.h (LSFAR, LSPAS)
 *    must be used to replace these keywords.
 *
 */
/**END_INTERNAL**/

/*NOINC*/
#ifndef NETALERT_INCLUDED

#define NETALERT_INCLUDED

#ifdef  ANY_32_BIT
#pragma pack(1)
#endif
/*INC*/

#include "alertmsg.h"

/****************************************************************
 *                                                              *
 *              Function prototypes                             *
 *                                                              *
 ****************************************************************/

extern API_FUNCTION
  NetAlertRaise ( const unsigned char LSFAR * pszEvent,
                  const unsigned char LSFAR * pbBuffer,
                  unsigned short              usBuffer,
                  unsigned long               ulTimeout );

extern API_FUNCTION
  NetAlertStart ( const unsigned char LSFAR * pszEvent,
                  const unsigned char LSFAR * pszRecipient,
                  unsigned short              usMaxData );

extern API_FUNCTION
  NetAlertStop ( const unsigned char LSFAR * pszEvent,
                 const unsigned char LSFAR * pszRecipient );



/****************************************************************
 *                                                              *
 *              Data structure templates                        *
 *                                                              *
 ****************************************************************/


/***   Standard alert structure
 */

struct std_alert
{
        long            alrt_timestamp;
        unsigned char   alrt_eventname[EVLEN+1];
        unsigned char   alrt_pad1;
        unsigned char   alrt_servicename[SNLEN+1];
};

/*
 *      The following macro gives a pointer to the other_info data.
 *      It takes a "struct std_alert *" and returns a "unsigned char *".
 */

#define ALERT_OTHER_INFO(x)    ((unsigned char *)(x)     + sizeof(struct std_alert))
#define ALERT_OTHER_INFO_F(x)  ((unsigned char LSFAR *)(x) + sizeof(struct std_alert))

/*
 *      The following macro gives a pointer to the variable-length data.
 *      It takes a pointer to one of the other-info structs and
 *      returns a "unsigned char *".
 */

#define ALERT_VAR_DATA(p)      ((unsigned char *)(p)     + sizeof(*p))
#define ALERT_VAR_DATA_F(p)    ((unsigned char LSFAR *)(p) + sizeof(*p))


/***   Print alert other-info structure
 */

struct print_other_info {
        short   alrtpr_jobid;       /* Job ID for job */
        short   alrtpr_status;      /* Status word from job info struct */
                                    /* bit 15 == 1 means job deleted */
        long    alrtpr_submitted;   /* When submitted */
        long    alrtpr_size;        /* Bytes in job */
};

/*      Followed by (consecutive ASCIIZ strings) ...
 *
 *              computername
 *              username
 *              queuename
 *              destination
 *              status string
 */

/***   Error log alert other-info structure
 */

struct errlog_other_info {
        short   alrter_errcode;
        long    alrter_offset;
};

/***   Admin alert other-info structure
 */

struct admin_other_info {
        short   alrtad_errcode;         /* code for message in net error message file */
        short   alrtad_numstrings;      /* the number of merge strings 0-9 */
};

/*      Followed by merge strings (consecutive ASCIIZ strings, count
 *      is in alrtad_numstrings field).
 */


/***   User alert other-info structure
 */

struct user_other_info {
        short   alrtus_errcode; /* code for message in net error message file */
        short   alrtus_numstrings;       /* the number of merge strings 0-9 */
};

/*      Followed by merge strings (consecutive ASCIIZ strings, count
 *      is in alrtus_numstrings field).
 *
 *      Further followed by (consecutive ASCIIZ strings) ...
 *
 *              username
 *              computername
 */


/**INTERNAL_ONLY**/
/***  Release memory alert other info.
 *      Used to request memory from the server.
 *      Mot supported in this version.
 */
struct releasemem_other_info {
        unsigned short memneeded;
        unsigned short waittime;
};
/**END_INTERNAL**/


/***    Time set alert other-info structure.
 *
 *      Provides detailed information about a change in the system clock.
 */

struct timeset_other_info {
        unsigned long   alrtts_old_time;
        unsigned long   alrtts_new_time;
        unsigned long   alrtts_old_msec;
        unsigned long   alrtts_new_msec;
        unsigned char   alrtts_old_hsec;
        unsigned char   alrtts_new_hsec;
        unsigned short  alrtts_old_tz;
        unsigned short  alrtts_new_tz;
};


/**INTERNAL_ONLY**/
#ifdef IBMTHUNK      /* Define PURE_32 temporarily */
#define PURE_32
#endif
/**END_INTERNAL**/

#ifdef PURE_32
/****************************************************************
 *                                                              *
 *              Function prototypes                             *
 *                                                              *
 ****************************************************************/

extern API32_FUNCTION
  Net32AlertRaise ( const unsigned char    * pszEvent,
                    const unsigned char    * pbBuffer,
                    unsigned long            ulBuffer,
                    unsigned long            ulTimeout );

extern API32_FUNCTION
  Net32AlertStart ( const unsigned char    * pszEvent,
                    const unsigned char    * pszRecipient,
                    unsigned long            ulMaxData );

extern API32_FUNCTION
  Net32AlertStop ( const unsigned char * pszEvent,
                   const unsigned char * pszRecipient );
#endif /* PURE_32 */

/**INTERNAL_ONLY**/
#ifdef IBMTHUNK      /* Undefine PURE_32; no data structure to pick up */
#undef PURE_32
#endif /* IBMTHUNK */
/**END_INTERNAL**/

/****************************************************************
 *                                                              *
 *              Special values and constants                    *
 *                                                              *
 ****************************************************************/

/*
 *      Names of standard Microsoft-defined alert events.
 */

#define ALERT_PRINT_EVENT       "PRINTING"
#define ALERT_MESSAGE_EVENT     "MESSAGE"
#define ALERT_ERRORLOG_EVENT    "ERRORLOG"
#define ALERT_ADMIN_EVENT       "ADMIN"
#define ALERT_USER_EVENT        "USER"
/**INTERNAL_ONLY**/
/* The following two alerts are not supported in LM 2.0 */
#define ALERT_RELEASE_MEMORY    "RELEASEMEMORY"
#define ALERT_TIME_SET          "TIMESET"
/**END_INTERNAL**/

/*
 *      Three suggested timeouts (in milliseconds) for NetAlertRaise.
 */

#define ALERT_SHORT_WAIT        100L
#define ALERT_MED_WAIT          1000L
#define ALERT_LONG_WAIT         10000L


/**INTERNAL_ONLY**/
#define ALERT_MAX_DISPLAYED_MSG_SIZE    4096
#define ALERT_MIN_STD_SIZE              sizeof(struct std_alert)
#define ALERT_ADMIN_INFO_SIZE           (sizeof(struct admin_other_info))
#define ALERT_NAME_UPDATE       -2
#define ALERT_SEM_WAIT          50000L
/**END_INTERNAL**/

/*NOINC*/
#ifdef ANY_32_BIT
#pragma pack()
#endif

#endif /* NETALERT_INCLUDED */
/*INC*/
