/**INTERNAL_ONLY**/
/*
 *
 *     Post ISO/CMVC Revision history: (f = feature d = defect)                *
 *  Flag Change Fixer Date    Tester Date    Review Date    Release  Describe  *
 *  ---- ------ ----- ------- ------ ------- ------ ------- -------  --------  *
 *  @f00 F02633 TRK   93Oct21 TRK    93Nov05 SAW    93Nov11  LS 4.0
 *   Create UUID_LEN
 *  @f02 F02359 MBB   93Aug25                                LS 4.0
 *   Create 32-bit entry points for 16-bit APIs
 *  @f03 F02861 MBB   93Oct30                                LS 4.0
 *   Make the NetService APIs fully 32-bit
 *  @d00 D04871 TRK   93Dec03                                LS 4.0
 *   Remove UUID_LEN
 *  @d01 D06125 CKC   94Mar11                                LS 4.0
 *   Change RIPLREMLEN defined as 40 to MAXCOMMENTSZ
 *  @d02 D06298 MBB   94Mar15                                LS 4.0
 *   Insert definitions of FARPASCAL, FARCDECL, FARSTAR, API32_FUNCTION,
 *   API16_FUNCTION; all to fit CSet/2 conventions.
 *  @d03 D07278 MBB   94Apr20 MBB    94Apr20                 LS 4.0
 *   Change definition of API_FUNCTION to use FARPASCAL for compatibility with
 *   CSet++, and force use of the definition regardless
 *  @D04 D10127 jc    94Jul08                                LS 4.0
 *   Put #include <nettrace.h> line inside NOINC/INC lines per Ghassan
 *  @D05 d10355 jc    94Jul11                                LS 4.0
 *   Okay, now <nettrace.h> isn't sanitized out! Try again...
 *  @D06 d11116 MBB   94Jul29                                LS 4.0
 *   Change linkage for Net32 APIs to _System
 *  @f07 F05438 MBB   94Aug08                                LS 4.0
 *   Make .h files compatible with C++
 *  @D08 d19701 jc    95Jun22                                LS 4.0
 *   include os2def.h if PURE_32 is defined; change #define for
 *   API32_FUNCTION (Borland compiler considerations)
 * @d09 d20027  jc    95Sep01                                LS 5.0
 *   externalize WRKHEUR_COUNT (it's mentioned in the PGR)
 */
/**END_INTERNAL**/
/********************************************************************/
/**                        IBM LAN Server                          **/
/** Copyright (c) International Business Machines Corp., 1987-1994 **/
/********************************************************************/

/********************************************************************
 *                                                                  *
 *  About this file ...  NETCONS.H                                  *
 *                                                                  *
 *  This file contains constants used throughout the LAN Server     *
 *  API header files.  It should be included in any source file     *
 *  that is going to include other LAN Server API header files or   *
 *  call a LAN Server API.                                          *
 *                                                                  *
 ********************************************************************/

/**INTERNAL_ONLY**/
/*    Revised as part of Feature 2359
 *
 *    IMPORTANT!  IMPORTANT! IMPORTANT! IMPORTANT! IMPORTANT! IMPORTANT!
 *    READ THIS FIRST BEFORE MAKING ANY CHANGES
 *
 *    This file was modified to provide support for 32-bit code.
 *    New modifications  make it suitable for both mixed-model and
 *    "pure" 32-bit.
 *
 *    Mixed-model: Any module that includes this header file must define
 *    the constant INCL_32 or MIXED_32.  (MIXED_32 is preferred.)
 *    Pure 32-bit: Any module that includes this header file must define
 *    the constant PURE_32.
 *
 *    This file must be included  before any other LAN API header file.
 *
 *    The following constants which are defined here are used in all the
 *    other LAN API header files (access.h, server.h, etc.)
 *
 *
 *    #ifdef INCL_32
 *        #define MIXED_32
 *    #endif
 *    #ifdef PURE_32            Defined by pure 32-bit apps
 *        #define LSFAR
 *        #define LSPAS
 *        #define LSPTR
 *        #define LSINT  short
 *        #define ANY_32_BIT    For declarations used by pure and mixed
 *    #elif  MIXED_32           Defined by mixed-model 32-bit apps
 *        #define LSFAR
 *        #define LSPAS
 *        #define LSPTR  _Seg16
 *        #define LSINT  short
 *        #define ANY_32_BIT    For declarations used by pure and mixed
 *    #else                     For 16-bit apps
 *        #define LSFAR  far
 *        #define LSPAS  pascal
 *        #define LSPTR
 *        #define LSINT  int
 *        #undef  ANY_32_BIT     Omit 32-bit declarations
 *    #endif
 *
 *    Do not add any keywords like far, pascal, etc. which are not recognized
 *    by the 32-bit compiler. The constants defined here (LSFAR, LSPAS) must
 *    be used to replace these keywords.
 *
 */
/**END_INTERNAL**/

/*
 *      NOTE:  Lengths of ASCIIZ strings are given as the maximum
 *      strlen() value.  This does not include space for the
 *      terminating 0-byte.  When allocating space for such an item,
 *      use the form:
 *
 *              char username[UNLEN+1];
 *
 *      An exception to this is the PATHLEN manifest, which does
 *      include space for the terminating 0-byte.
 */

/*NOINC*/
/**INTERNAL_ONLY**/
#include <nettrace.h>
#ifdef IBMTHUNK      /* Define MIXED_32 */
#define MIXED_32
BOOL  _Optlink CheckBuffer (PVOID, ULONG);
ULONG _Optlink Net32PackString (PSZ *, PSZ, PSZ *);
#endif
/**END_INTERNAL**/

#if defined(PURE_32)   /* Defined by pure 32-bit apps */
#include <os2def.h>
#undef MIXED_32
#undef INCL_32
#define LSFAR
#define LSPAS
#define LSPTR
#define LSINT  short
#define FARPASCAL
#define FARCDECL
#define FARSTAR    *
#define ANY_32_BIT     /* For declarations used by pure 32 and mixed-model */
#endif
#ifdef INCL_32
#define MIXED_32
#endif
#ifdef MIXED_32   /* Defined by mixed-model 32-bit apps */
#undef PURE_32
#define LSFAR
#define LSPAS
#define LSPTR  _Seg16
#define LSINT  short
#define FARPASCAL _Far16 _Pascal
#define FARCDECL  _Far16 _Cdecl
#define FARSTAR   * _Seg16
#define SELTOFLAT(ptr) (void *)(((((ULONG)(ptr))>>19)<<16)|(0xFFFF&((ULONG)(ptr))))
#define ANY_32_BIT    /* For declarations used by pure 32 and mixed-model */
#endif
#if !defined(ANY_32_BIT) /* Must be 16-bit app */
#define LSFAR  far
#define LSPAS  pascal
#define LSPTR
#define LSINT  int
#define FARPASCAL far pascal
#define FARCDECL  far cdecl
#define FARSTAR   far *
#endif
/**INTERNAL_ONLY**/
/* --------------------  End  f02 (f2359) --------------- */
/**END_INTERNAL**/

#ifndef NETCONS_INCLUDED

#define NETCONS_INCLUDED
/*INC*/

#define CNLEN           15                  /* Computer name length     */
#define UNCLEN          (CNLEN+2)           /* UNC computer name length */
#define NNLEN           12                  /* 8.3 Net name length      */
#define RMLEN           (UNCLEN+1+NNLEN)    /* Maximum remote name length */

#define SNLEN           15                  /* Service name length      */
#define STXTLEN         63                  /* Service text length      */

/**INTERNAL_ONLY**/
#ifdef DOS3
#define PATHLEN         128
#else  /* DOS3 */

#define PATHLEN1_1      128
#define COMPLEN1_1      (8 + 1 + 3)     /* 8.3 */

/* Determine if the CCHMAXPATH manifest is defined (and use it).
 * If it isn't, then the source file in question isn't using OS2.H,
 * and we display a warning message.
 */
#ifdef CCHMAXPATH
#define PATHLEN         CCHMAXPATH
#else  /* CCHMAXPATH */
/*NOINC*/
#ifndef ANY_32_BIT    /* was INCL_32 */
#pragma message("WARNING: This file doesn't include OS2.H before NETCONS.H.")
#endif
/*INC*/

/**END_INTERNAL**/
#define PATHLEN         260
/**INTERNAL_ONLY**/
#endif /* CCHMAXPATH */
#endif /* DOS3 */

/* BUG20.7067 - We define MAXPATHLEN to be equivalent to PATHLEN.  This
 *          should be removed.
 */
#ifndef MAXPATHLEN
#define MAXPATHLEN      PATHLEN
#endif /* not MAXPATHLEN */
/**END_INTERNAL**/

#define DEVLEN           8                  /* Device name length       */
#define APP_LEN          8                  /* Application name length  */
#define ALIAS_LEN        8                  /* Alias name length        */

/**INTERNAL_ONLY**/
/* WARNING:  DNLEN must be the same as CNLEN.  We have a sanity check
 *           below which verifies this.
 */
/**END_INTERNAL**/
#define DNLEN           CNLEN               /* Maximum domain name length */
#define EVLEN           16                  /* event name length        */
#define JOBSTLEN        80                  /* status length in print job */
#define AFLEN           64                  /* Maximum length of alert  */
                                            /* names field              */
#define UNLEN           20                  /* Maximum user name length */
#define GNLEN           UNLEN               /* Group name               */
#define PWLEN           14                  /* Maximum password length  */
#define SHPWLEN          8                  /* Share password length    */
#define CLTYPE_LEN      12                  /* Length of client type string */


#define MAXCOMMENTSZ    48                  /* server & share comment length */

#define QNLEN           12                  /* Queue name maximum length     */
/**INTERNAL_ONLY**/
/*NOINC*/
#if (QNLEN != NNLEN)
# error QNLEN and NNLEN are not equal
#endif
/*INC*/
/**END_INTERNAL**/
#define PDLEN            8                  /* Print destination length      */
#define DTLEN            9                  /* Spool file data type          */
                                            /* e.g. IBMQSTD,IBMQESC,IBMQRAW  */
#define ALERTSZ         128                 /* size of alert string in server */
#define MAXDEVENTRIES   (sizeof (LSINT)*8)    /* Max number of device entries   */
                                            /* We use int bitmap to represent */

#define HOURS_IN_WEEK           24*7        /* for struct user_info_2 in UAS */
#define MAXWORKSTATIONS         8           /* for struct user_info_2 in UAS */

#define NETBIOS_NAME_LEN        16          /* NetBIOS net name */

#define DOSIMGLEN     8  /* maximum length for DOS RIPL image name           */
                         /* maximum length for RIPL machine remarks          */
#define RIPLREMLEN  MAXCOMMENTSZ
#define SRVRECLEN   250  /* maximum length for RIPL machine server record ID */

#define WRKHEUR_COUNT           54

/**INTERNAL_ONLY**/
#ifdef  USHRT_MAX
#define MAX_API_BUFFER_SIZE     USHRT_MAX
#else
#define MAX_API_BUFFER_SIZE     0xffff
#endif


#define WORKBUFSIZE             4096

#define SMBANDXPAD              212         /* Added to each rdr & srv wrkbuf */
#define SMB_HDR_SZ              48          /* Added to each rdr & srv wrkbuf */

                                            /* WARNING: The following two    */
                                            /*  defines are dependent upon   */
                                            /*  rdr data structures!!!       */
#define RDR_SMB_LINK_SZ         8           /* Additional amount rdr adds to */
                                            /*  to each work buf             */
#define RDR_SMB_SEG_HD_SZ       20          /* Amount of rdr overhd per each */
                                            /*  workbuf segment              */

#define MAXSRVWRKSEGS           80          /* 64K segs for srv work bufs */
#define MAXRDRWRKSEGS           1           /* 64K segs for rdr work bufs */
#define MAXRDRBIGBUFSEGS        10          /* rdr 64K big buf segs */
/**END_INTERNAL**/

/*
 *      Constants used with encryption
 */

#define CRYPT_KEY_LEN   7
#define CRYPT_TXT_LEN   8
#define ENCRYPTED_PWLEN 16
#define SESSION_PWLEN   24
#define SESSION_CRYPT_KLEN 21

/*
 *  Value to be used with SetInfo calls to allow setting of all
 *  settable parameters (parmnum zero option)
*/
#ifndef  PARMNUM_ALL
#define         PARMNUM_ALL             0
#endif

/*
 *      Message File Names
 */

#define MESSAGE_FILE            "NETPROG\\NET.MSG"
#define MESSAGE_FILENAME        "NET.MSG"
#define OS2MSG_FILE             "NETPROG\\OSO001.MSG"
#define OS2MSG_FILENAME         "OSO001.MSG"
#define HELP_MSG_FILE           "NETPROG\\NETH.MSG"
#define HELP_MSG_FILENAME       "NETH.MSG"
#define NMP_MSG_FILE            "NETPROG\\NMP.MSG"
#define NMP_MSG_FILENAME        "NMP.MSG"

#define MESSAGE_FILE_BASE       "NETPROG\\NET00000"
#define MESSAGE_FILE_EXT        ".MSG"

/**INTERNAL_ONLY**/

/* The backup message file named here is a duplicate of net.msg. It
 * is not shipped with the product, but is used at buildtime to
 * msgbind certain messages to netapi.dll and some of the services.
 * This allows for OEMs to modify the message text in net.msg and
 * have those changes show up.  Only in case there is an error in
 * retrieving the messages from net.msg do we then get the bound
 * messages out of bak.msg (really out of the message segment).
 */

#define BACKUP_MSG_FILENAME     "BAK.MSG"

/**END_INTERNAL**/


#define NMP_LOW_END             230
#define NMP_HIGH_END            240

#ifndef NULL
#define  NULL    0
#endif


/*NOINC*/
#define PUNAVAIL NULL
#ifdef ANY_32_BIT                       /* was INCL_32 */
#define API_RET_TYPE unsigned short
#else
#define API_RET_TYPE unsigned
#endif
#if defined(API_FUNCTION)
#undef API_FUNCTION
#endif
#define API_FUNCTION   API_RET_TYPE FARPASCAL
#define API16_FUNCTION API_RET_TYPE FARPASCAL
#define API32_FUNCTION API_RET_TYPE APIENTRY
/*INC*/


/**INTERNAL_ONLY**/
/*NOINC*/
/* Sanity check to verify that CNLEN == DNLEN */
#if (CNLEN != DNLEN)
#error CNLEN and DNLEN are not equal
#endif
/*INC*/
/**END_INTERNAL**/


/**INTERNAL_ONLY**/
/*NOINC*/

/* The following are Sys-Hungarian and related definitions that are not
 * in the standard OS/2 header file suite.  Since they are used in
 * various parts of the LM source tree, we have moved them here to
 * NETCONS.H.  In a future version, we should put these in a separate
 * header file (NETDEFS.H), possibly to be included by NETCONS.H.
 *
 * -- DannyGl, 27 Mar 90
 */

typedef const unsigned char LSFAR * CPSZ ;

/* The following are stolen from OS2DEF.H and should be removed when
 * all references to the obsolete DOSCALLS.H are removed.
 */
#if !defined(OS2_INCLUDED) && !defined(ANY_32_BIT)    /* was INCL_32 */
#define PASCAL  pascal
#define FAR     far
#define INT     int
typedef unsigned char BYTE;
typedef unsigned char UCHAR;
typedef unsigned short USHORT;
typedef unsigned long ULONG;
typedef unsigned char far  *PSZ;
typedef USHORT FAR *PUSHORT;
typedef ULONG  FAR *PULONG;
typedef unsigned short SEL;
#endif


/*INC*/
/**END_INTERNAL**/


/**INTERNAL_ONLY**/

/********************************************************************
 *
 *      There are (at present) six (6) files which are processed
 *      by the mapmsg utility to create an input file for the os
 *      utility mkmsgf.  Each of these files has a non-overlapping
 *      range of MESSAGE numbers assigned to it.  In addtion, the
 *      file neterr.h has a range of ERROR numbers.  The error
 *      numbers do not overlap with the error numbers assigned to
 *      other os components.
 *
 *      The ERROR number range in neterr.h is 2100 to 2999.  The
 *      range 2750 - 2799 has been reserved for IBM.  The range
 *      2900 - 2999 has been reserved for other Microsoft OEMs.
 *
 *      The MESSAGE number range is as follow:
 *
 *      neterr.h:       the same as the error range, 2100-2999, with some
 *                      reserved for IBM, and some reserved for other
 *                      Microsoft OEMs.
 *      alertmsg.h:     3000 - 3049
 *      service.h:      3050 - 3099
 *      errlog.h:       3100 - 3299
 *      msgtext.h:      3300 - 3499
 *      apperr.h:       3500 - (where ever it chooses to stop)
 *
 *     WARNING *** WARNING *** WARNING
 *
 *   The redirector has hardcoded in its
 *   makefile some message numbers used
 *   at startup.  If you change MTXT_BASE
 *   or any of the redirs message numbers
 *   you must also fix the redir makefile
 *   where it generates netwksta.pro
 *
 ********************************************************************/

/**END_INTERNAL**/

/*NOINC*/
#endif /* NETCONS_INCLUDED */
/*INC*/

