/**INTERNAL_ONLY**/
/*
 *  Change History:
 *
 *     Post ISO/CMVC Revision history: (f = feature d = defect)                *
 *  Flag Change Fixer Date    Tester Date    Review Date    Release  Describe  *
 *  ---- ------ ----- ------- ------ ------- ------ ------- -------  --------  *
 *  @f01 f02359 MBB   93Nov11
 *   Add Net32 prototypes and internal-only structs; make all 'char' UCHAR
 *       D06991 MBB   94Apr09
 *   Declare all 32-bit functions as API32_FUNCTION
 *  @f01 F05438 MBB   94Aug08                                LS 4.0
 *   Make .h files compatible with C++
 */
/**END_INTERNAL**/

/********************************************************************/
/**                        IBM LAN Server                          **/
/** Copyright (c) International Business Machines Corp., 1987-1993 **/
/** Copyright (c) Microsoft Corp., 1987-1990                       **/
/********************************************************************/

/********************************************************************
 *                                                                  *
 *  About this file ...  NETSTATS.H                                 *
 *                                                                  *
 *  This file contains information about the NetStatistics APIs.    *
 *                                                                  *
 *      Function prototypes.                                        *
 *                                                                  *
 *      Data structure templates.                                   *
 *                                                                  *
 *      Definition of special values.                               *
 *                                                                  *
 *                                                                  *
 *  NOTE:  You must include NETCONS.H before this file, since this  *
 *         file depends on values defined in NETCONS.H.             *
 *                                                                  *
 ********************************************************************/

/**INTERNAL_ONLY**/
/*
 *
 *    IMPORTANT!  IMPORTANT! IMPORTANT! IMPORTANT! IMPORTANT! IMPORTANT!
 *    READ THIS FIRST BEFORE MAKING ANY CHANGES
 *
 *    This file was modified to provide support for 32-bit code.
 *
 *    Any 32-bit module that includes this header file must define
 *    the constant INCL_32.
 *
 *    It is assumed that "netcons.h" is included before this file.
 *
 *    The following contants are defined in netcons.h as shown below:
 *
 *    #ifdef INCL_32    ( defined by 32-bit apps )
 *        #define LSFAR
 *        #define LSPAS
 *        #define LSPTR  _Seg16
 *        #define LSINT  short
 *    #else                 ( for 16-bit apps )
 *        #define LSFAR  far
 *        #define LSPAS  pascal
 *        #define LSPTR
 *        #define LSINT  int
 *    #endif
 *
 *    Do not add any keywords like far, pascal, etc. which are not recognized
 *    by the 32-bit compiler. The constants defined in netcons.h (LSFAR, LSPAS)
 *    must be used to replace these keywords.
 *
 */
/**END_INTERNAL**/

/**INTERNAL_ONLY**/
/*  NOTE: This file must be HtoINCable                              */
/**END_INTERNAL**/

/*NOINC*/
#ifndef NETSTATS_INCLUDED

#define NETSTATS_INCLUDED
#define NETSTATS_INC

#ifdef  ANY_32_BIT
#pragma pack(1)
#endif
/*INC*/


/****************************************************************
 *                                                              *
 *              Function prototypes                             *
 *                                                              *
 ****************************************************************/

extern API_FUNCTION
  NetStatisticsClear ( const unsigned char LSFAR * pszServer );

extern API_FUNCTION
  NetStatisticsGet ( const unsigned char LSFAR *     pszServer,
                     unsigned char LSFAR *           pbBuffer,
                     unsigned short         cbBuffer,
                     unsigned short LSFAR * pcbReturned,
                     unsigned short LSFAR * pcbTotalAvail );

extern API_FUNCTION
  NetStatisticsGet2 ( const unsigned char LSFAR *     pszServer,
                      const unsigned char LSFAR *     pszService,
                      unsigned long          ulReserved,
                      short                  sLevel,
                      unsigned long          flOptions,
                      unsigned char LSFAR *           pbBuffer,
                      unsigned short         cbBuffer,
                      unsigned short LSFAR * pcbTotalAvail );

/**INTERNAL_ONLY**/
#ifdef IBMTHUNK  /* Define PURE_32 temporarily */
#define PURE_32
#endif
/**END_INTERNAL**/

#ifdef PURE_32
/****************************************************************
 *                                                              *
 *                Function prototypes                           *
 *           For "pure" 32-bit applications                     *
 *                                                              *
 ****************************************************************/

extern API32_FUNCTION
  Net32StatisticsGet2 ( const unsigned char * pszServer,
                        const unsigned char * pszService,
                        unsigned long         ulReserved,
                        unsigned long         ulLevel,      /*was signed short*/
                        unsigned long         flOptions,
                        unsigned char       * pbBuffer,
                        unsigned long         ulBuffer,        /*was USHORT*/
                        unsigned long       * pulTotalAvail ); /*was PUSHORT*/
#endif /* PURE_32 */

/**INTERNAL_ONLY**/
#ifdef  IBMTHUNK  /* Undefine PURE_32 and pick up data structures */
#undef  PURE_32
#endif
/**END_INTERNAL**/

/****************************************************************
 *                                                              *
 *              Special values and constants                    *
 *                                                              *
 ****************************************************************/


#define STATSOPT_CLR    1
/*NOINC*/
#define STATS_NO_VALUE  ((unsigned long) -1L)
#define STATS_OVERFLOW  ((unsigned long) -2L)
/*INC*/


/****************************************************************
 *                                                              *
 *              Data structure templates                        *
 *                                                              *
 ****************************************************************/



/**INTERNAL_ONLY**/

/*
 *      NOTE: struct statistics_info is defined in rdrioctl.h also, so it
 *      is defined conditionally here.
 */

/* #ifndef STATISTICS_INFO_DEFINED */

/**END_INTERNAL**/



struct statistics_info_0 {
    unsigned long   st0_start;        /* time statistics collection started   */
    unsigned long   st0_wknumNCBs;    /* # workstation NCBs issued            */
    unsigned long   st0_wkfiNCBs;     /* # workstation NCBs failed issue      */
    unsigned long   st0_wkfcNCBs;     /* # workstation NCBs failed completion */
    unsigned long   st0_wksesstart;   /* # workstation sessions started       */
    unsigned long   st0_wksessfail;   /* # workstation session failures       */
    unsigned long   st0_wkuses;       /* # workstation uses                   */
    unsigned long   st0_wkusefail;    /* # workstation use failures           */
    unsigned long   st0_wkautorec;    /* # workstation auto-reconnects        */
    unsigned long   st0_rdrnumNCBs;   /* # redir NCBs issued                  */
    unsigned long   st0_srvnumNCBs;   /* # NCBs issued for the server         */
    unsigned long   st0_usrnumNCBs;   /* # user NCBs issued                   */
    unsigned long   st0_reserved4;    /* reserved for future use              */
    unsigned long   st0_reserved5;    /* reserved for future use              */
    unsigned long   st0_reserved6;    /* reserved for future use              */
    unsigned long   st0_reserved7;    /* reserved for future use              */
    unsigned long   st0_reserved8;    /* reserved for future use              */
    unsigned long   st0_svfopens;     /* # of server file opens               */
    unsigned long   st0_svdevopens;   /* # of server device opens             */
    unsigned long   st0_svjobsqueued; /* # of server print jobs spooled       */
    unsigned long   st0_svsopens;     /* # of server session starts           */
    unsigned long   st0_svstimedout;  /* # of server session auto-disconnects */
    unsigned long   st0_svserrorout;  /* # of server sessions errored out     */
    unsigned long   st0_svpwerrors;   /* # of server password violations      */
    unsigned long   st0_svpermerrors; /* # of server access permission errors */
    unsigned long   st0_svsyserrors;  /* # of server system errors            */
    unsigned long   st0_svbytessent;  /* # of server bytes sent to net        */
    unsigned long   st0_svbytesrcvd;  /* # of server bytes received from net  */
    unsigned long   st0_svavresponse; /* average server response time in msec */
}; /* statistics_info_0 */

/**INTERNAL_ONLY**/
/*NOINC*/
/*
#define STATISTICS_INFO_DEFINED
#endif
*/
/*INC*/

#define WKSTA_STATS_LEN         (12 * sizeof (unsigned long))
#define RES_STATS_LEN           (5 * sizeof (unsigned long))

/**END_INTERNAL**/


struct stat_workstation_0  {
        unsigned long  stw0_start;
        unsigned long  stw0_numNCB_r;
        unsigned long  stw0_numNCB_s;
        unsigned long  stw0_numNCB_a;
        unsigned long  stw0_fiNCB_r;
        unsigned long  stw0_fiNCB_s;
        unsigned long  stw0_fiNCB_a;
        unsigned long  stw0_fcNCB_r;
        unsigned long  stw0_fcNCB_s;
        unsigned long  stw0_fcNCB_a;
        unsigned long  stw0_sesstart;
        unsigned long  stw0_sessfailcon;
        unsigned long  stw0_sessbroke;
        unsigned long  stw0_uses;
        unsigned long  stw0_usefail;
        unsigned long  stw0_autorec;
        unsigned long  stw0_bytessent_r_lo;
        unsigned long  stw0_bytessent_r_hi;
        unsigned long  stw0_bytesrcvd_r_lo;
        unsigned long  stw0_bytesrcvd_r_hi;
        unsigned long  stw0_bytessent_s_lo;
        unsigned long  stw0_bytessent_s_hi;
        unsigned long  stw0_bytesrcvd_s_lo;
        unsigned long  stw0_bytesrcvd_s_hi;
        unsigned long  stw0_bytessent_a_lo;
        unsigned long  stw0_bytessent_a_hi;
        unsigned long  stw0_bytesrcvd_a_lo;
        unsigned long  stw0_bytesrcvd_a_hi;
        unsigned long  stw0_reqbufneed;
        unsigned long  stw0_bigbufneed;
}; /* stat_workstation_0 */


struct stat_server_0  {
        unsigned long  sts0_start;
        unsigned long  sts0_fopens;
        unsigned long  sts0_devopens;
        unsigned long  sts0_jobsqueued;
        unsigned long  sts0_sopens;
        unsigned long  sts0_stimedout;
        unsigned long  sts0_serrorout;
        unsigned long  sts0_pwerrors;
        unsigned long  sts0_permerrors;
        unsigned long  sts0_syserrors;
        unsigned long  sts0_bytessent_low;
        unsigned long  sts0_bytessent_high;
        unsigned long  sts0_bytesrcvd_low;
        unsigned long  sts0_bytesrcvd_high;
        unsigned long  sts0_avresponse;
        unsigned long  sts0_reqbufneed;
        unsigned long  sts0_bigbufneed;
}; /* stat_server_0 */


/*NOINC*/
#ifdef  ANY_32_BIT
#pragma pack()
#endif

#endif /* NETSTATS_INCLUDED */
/*INC*/
