/*
 * COMPONENT_NAME:
 *
 * FUNCTIONS: ULS API prototypes and typedefs - public
 *
 * (C) COPYRIGHT International Business Machines Corp. 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */

#ifndef _ULS_UNIDEF
#define _ULS_UNIDEF

#ifdef __cplusplus
   extern "C" {
#endif

/* compiler dependent include files */
#include <stddef.h>             /* define size_t and wchar_t types */
#include <time.h>               /* define tm struct */

/* ULS include files */
#include <ulserrno.h>           /* uls return code defs */
#include <errcmpat.h>
#include <ulsitem.h>            /* define LocaleItem type */
#include <callconv.h>

/*
 * ulsBool Type
 */
typedef int ulsBool;


/* LSA added TRUE/FALSE */
#ifndef TRUE
   #define TRUE      1
#endif
#ifndef FALSE
   #define FALSE     0
#endif

/*
 * UniChar Type
 */
#ifndef _ULS_UNICHAR_DEFINED
    typedef unsigned  short  UniChar ;
    #define _ULS_UNICHAR_DEFINED
#endif

/*
 * LocaleObject Type
 */
typedef void  *LocaleObject;

/*
 * LocaleToken Type
 */
typedef unsigned int LocaleToken;

/*
 * AttrObject Type
 */
typedef void *AttrObject;

/*
 * XformObject type
 */
typedef void *XformObject;

/*
 * LocaleSpecType Values
 */
#define UNI_TOKEN_POINTER       1
#define UNI_MBS_STRING_POINTER  2
#define UNI_UCS_STRING_POINTER  3


/*
 * Categories
 */
#undef LANG
#undef LC_ALL
#undef LC_COLLATE
#undef LC_CTYPE
#undef LC_NUMERIC
#undef LC_MONETARY
#undef LC_TIME
#undef LC_MESSAGES

#define LANG         (-2)
#define LC_ALL       (-1)
#define LC_COLLATE    0
#define LC_CTYPE      1
#define LC_NUMERIC    2
#define LC_MONETARY   3
#define LC_TIME       4
#define LC_MESSAGES   5

/*
 * UniLconv locale conventions structure
 */
struct UniLconv {
   UniChar *decimal_point;      /* non-monetary decimal point           */
   UniChar *thousands_sep;      /* non-monetary thousands separator     */
   short   *grouping;           /* non-monetary size of grouping        */
   UniChar *int_curr_symbol;    /* int'l currency symbol and separator  */
   UniChar *currency_symbol;    /* local  currency symbol               */
   UniChar *mon_decimal_point;  /* monetary decimal point               */
   UniChar *mon_thousands_sep;  /* monetary thousands separator         */
   short   *mon_grouping;       /* monetary size of grouping            */
   UniChar *positive_sign;      /* non-negative values sign             */
   UniChar *negative_sign;      /* negative values sign                 */
   short   int_frac_digits;     /* no of fractional digits int currency */
   short   frac_digits;         /* no of fractional digits loc currency */
   short   p_cs_precedes;       /* nonneg curr sym 1-precedes,0-succeeds*/
   short   p_sep_by_space;      /* nonneg curr sym 1-space,0-no space   */
   short   n_cs_precedes;       /* neg curr sym 1-precedes,0-succeeds   */
   short   n_sep_by_space;      /* neg curr sym 1-space 0-no space      */
   short   p_sign_posn;         /* positioning of nonneg monetary sign  */
   short   n_sign_posn;         /* positioning of negative monetary sign*/
   short   os2_mondecpt;        /* os2 curr sym positioning             */
   UniChar *debit_sign;         /* non-neg-valued monetary sym - "DB"   */
   UniChar *credit_sign;        /* negative-valued monetary sym - "CR"  */
   UniChar *left_parenthesis;   /* negative-valued monetary sym - "("   */
   UniChar *right_parenthesis;  /* negative-valued monetary sym - ")"   */
};

/*
 * Locale Management Function Prototypes
 */
int     CALLCONV UniCreateLocaleObject ( int locale_spec_type, const void *locale_spec,
                            LocaleObject *locale_object_ptr );
int     CALLCONV UniQueryLocaleObject  ( const LocaleObject locale_object, int category,
                            int locale_spec_type, void **locale_spec_ptr );
int     CALLCONV UniFreeLocaleObject   ( LocaleObject locale_object );
int     CALLCONV UniFreeMem            ( void *memory_ptr );
int     CALLCONV UniLocaleStrToToken   ( int locale_string_type, const void *locale_string,
                            LocaleToken *locale_token_ptr );
int     CALLCONV UniLocaleTokenToStr   ( const LocaleToken locale_token,
                            int locale_string_type, void **locale_string_ptr );

/*
 * Locale Information Function Prototypes
 */
int     CALLCONV UniQueryLocaleInfo ( const LocaleObject locale_object,
                         struct UniLconv **unilconv_addr_ptr );
int     CALLCONV UniFreeLocaleInfo  ( struct UniLconv *unilconv_addr );
int     CALLCONV UniQueryLocaleItem ( const LocaleObject locale_object,
                         LocaleItem item,
                         UniChar **info_item_addr_ptr );

/*
 * Date and Time Function Prototypes
 */
size_t       CALLCONV UniStrftime ( const LocaleObject locale_object,
                       UniChar *ucs, size_t maxsize,
                       const UniChar *format, const struct tm *time_ptr );
UniChar    * CALLCONV UniStrptime ( const LocaleObject locale_object,
                       const UniChar *buf, const UniChar *format,
                       struct tm *time_ptr );

/*
 * Monetary Formatting Function Prototype
 */
int          CALLCONV UniStrfmon  ( const LocaleObject locale_object,
                       UniChar *ucs, size_t maxsize,
                       const UniChar *format, ... );

/*
 * String/Character Function Prototypes
 */
UniChar    * CALLCONV UniStrcat  ( UniChar *ucs1, const UniChar *ucs2 );
UniChar    * CALLCONV UniStrchr  ( const UniChar *ucs, UniChar uc );
int          CALLCONV UniStrcmp  ( const UniChar *ucs1, const UniChar *ucs2 );
UniChar    * CALLCONV UniStrcpy  ( UniChar *ucs1, const UniChar *ucs2 );
size_t       CALLCONV UniStrcspn ( const UniChar *ucs1, const UniChar *ucs2 );
size_t       CALLCONV UniStrlen  ( const UniChar *ucs1 );
UniChar    * CALLCONV UniStrncat ( UniChar *ucs1, const UniChar *ucs2, size_t n );
int          CALLCONV UniStrncmp ( const UniChar *ucs1, const UniChar *ucs2, size_t n );
UniChar    * CALLCONV UniStrncpy ( UniChar *ucs1, const UniChar *ucs2, size_t n );
UniChar    * CALLCONV UniStrpbrk ( const UniChar *ucs1, const UniChar *ucs2 );
UniChar    * CALLCONV UniStrrchr ( const UniChar *ucs, UniChar uc );
size_t       CALLCONV UniStrspn  ( const UniChar *ucs1, const UniChar *ucs2 );
UniChar    * CALLCONV UniStrstr  ( const UniChar *ucs1, const UniChar *ucs2 );
UniChar    * CALLCONV UniStrtok  ( UniChar *ucs1, const UniChar *ucs2 );


/*
 * Character Attribute Function Prototypes
 */
int   CALLCONV UniCreateAttrObject ( const LocaleObject locale_object,
                           const UniChar *attr_name,
                           AttrObject *attr_object_ptr );
int   CALLCONV UniQueryCharAttr    ( AttrObject attr_object, UniChar uc );
int   CALLCONV UniScanForAttr      ( AttrObject attr_object, const UniChar *ucs,
                           size_t num_elems, ulsBool inverse_op,
                           size_t *offset_ptr );
int   CALLCONV UniFreeAttrObject   ( AttrObject attr_object );
int   CALLCONV UniQueryAlnum       ( const LocaleObject locale_object, UniChar uc );
int   CALLCONV UniQueryAlpha       ( const LocaleObject locale_object, UniChar uc );
int   CALLCONV UniQueryBlank       ( const LocaleObject locale_object, UniChar uc );
int   CALLCONV UniQueryCntrl       ( const LocaleObject locale_object, UniChar uc );
int   CALLCONV UniQueryDigit       ( const LocaleObject locale_object, UniChar uc );
int   CALLCONV UniQueryGraph       ( const LocaleObject locale_object, UniChar uc );
int   CALLCONV UniQueryLower       ( const LocaleObject locale_object, UniChar uc );
int   CALLCONV UniQueryPrint       ( const LocaleObject locale_object, UniChar uc );
int   CALLCONV UniQueryPunct       ( const LocaleObject locale_object, UniChar uc );
int   CALLCONV UniQuerySpace       ( const LocaleObject locale_object, UniChar uc );
int   CALLCONV UniQueryUpper       ( const LocaleObject locale_object, UniChar uc );
int   CALLCONV UniQueryXdigit      ( const LocaleObject locale_object, UniChar uc );

/*
 * String Transformation Function Prototypes
 */
int   CALLCONV UniCreateTransformObject ( const LocaleObject locale_object,
                                const UniChar *xtype,
                                XformObject *xform_object_ptr );
int   CALLCONV UniTransformStr          ( XformObject xform_object,
                                const UniChar *inp_buf, int *inp_size,
                                UniChar *out_buf, int *out_size );
int   CALLCONV UniFreeTransformObject   ( XformObject xform_object );
UniChar   CALLCONV UniTransLower        ( const LocaleObject locale_object, UniChar uc );
UniChar   CALLCONV UniTransUpper        ( const LocaleObject locale_object, UniChar uc );

/*
 * String Conversion Function Prototypes
 */
int   CALLCONV UniStrtod  ( const LocaleObject locale_object, const UniChar *ucs,
                  UniChar **end_ptr, double *result_ptr );
int   CALLCONV UniStrtol  ( const LocaleObject locale_object, const UniChar *ucs,
                  UniChar **end_ptr, int base, long int *result_ptr );
int   CALLCONV UniStrtoul ( const LocaleObject locale_object, const UniChar *ucs,
                  UniChar **end_ptr, int base, unsigned long int *result_ptr );

/*
 * String Comparison Function Prototypes
 */
int      CALLCONV UniStrcoll  ( const LocaleObject locale_object,
                     const UniChar *ucs1, const UniChar *ucs2 );
size_t   CALLCONV UniStrxfrm  ( const LocaleObject locale_object,
                     UniChar *ucs1, const UniChar *ucs2, size_t n );
int      CALLCONV UniStrcmpi  ( const LocaleObject locale_object,
                     const UniChar *ucs1, const UniChar *ucs2 );
int      CALLCONV UniStrncmpi ( const LocaleObject locale_object,
                     const UniChar *ucs1, const UniChar *ucs2, const size_t n );

/*
 * Unicode Case Mapping Function Prototypes
 */
UniChar   CALLCONV UniToupper ( UniChar uc );
UniChar   CALLCONV UniTolower ( UniChar uc );
UniChar * CALLCONV UniStrupr  ( UniChar * ucs );
UniChar * CALLCONV UniStrlwr  ( UniChar * ucs );


int CALLCONV UniMapCtryToLocale( unsigned long Country,
                                 UniChar *LocaleName,
                                 size_t n
                               );
#ifdef __cplusplus
   }
#endif

#endif
