000100 IDENTIFICATION DIVISION.                                         ANA00010
000200 PROGRAM-ID. ANASAMP.                                             ANA00020
000300 AUTHOR. JOHN C. SMITH                                            ANA00030
000400                                                                  ANA00040
000500******************************************************************ANA00050
000600*     THIS PROGRAM DOES THE MONTH END CALCULATIONS FOR EACH TYPE *ANA00060
000700*     OF CHECKING ACCOUNT CARRIED BY THE UNIVERSAL BANK.  IT     *ANA00070
000800*     HANDLES THE FOLLOWING TYPES OF ACCOUNTS.                   *ANA00080
000900*         CHECKING WITH INTEREST                                 *ANA00090
001000*         CHECKING WITH NO INTEREST                              *ANA00100
001100*         MONEY MARKET ACCOUNT (MMA)                             *ANA00110
001200*         SAVINGS ACCOUNT                                        *ANA00120
001300*     IT ALSO UPDATES THE ACCOUNT BALANCE, BRANCH BALANCE AND    *ANA00130
001400*     BANK BALANCE.                                              *ANA00140
001500******************************************************************ANA00150
001600                                                                  ANA00160
001700 ENVIRONMENT DIVISION.                                            ANA00170
001800 CONFIGURATION SECTION.                                           ANA00180
001900 SOURCE-COMPUTER. IBM-370.                                        ANA00190
002000 OBJECT-COMPUTER. IBM-370.                                        ANA00200
002100 INPUT-OUTPUT SECTION.                                            ANA00210
002200                                                                  ANA00220
002300 FILE-CONTROL.                                                    ANA00230
002400     SELECT ACCT-FILE           ASSIGN TO ACCT                    ANA00240
002500            ORGANIZATION IS INDEXED                               ANA00250
002600            ACCESS IS RANDOM                                      ANA00260
002700            RECORD KEY IS ACCT-KEY.                               ANA00270
002800     SELECT EXCEPTION-FILE      ASSIGN TO UT-S-EXCEPTS.           ANA00280
002900     SELECT TRAN-FILE           ASSIGN TO UT-S-TRAN.              ANA00290
003000     SELECT ACTION-FILE         ASSIGN TO UT-S-ACTIONS.           ANA00300
003010     SELECT ACCT-DATA           ASSIGN TO UT-S-ACCTDATA.          ANA00310
003100                                                                  ANA00320
003200 DATA DIVISION.                                                   ANA00330
003300                                                                  ANA00340
003400 FILE SECTION.                                                    ANA00350
003410 FD  ACCT-DATA                                                    ANA00360
003420     RECORDING MODE IS F                                          ANA00370
003430     BLOCK CONTAINS 0 RECORDS                                     ANA00380
003440     LABEL RECORDS ARE STANDARD.                                  ANA00390
003450 01  ACCT-DATA-REC                     PIC X(80).                 ANA00400
003460                                                                  ANA00410
003500 FD  ACCT-FILE                                                    ANA00420
003600     LABEL RECORDS ARE STANDARD.                                  ANA00430
003700                                                                  ANA00440
003800 01  ACCT-RECORD.                                                 ANA00450
003900     05  ACCT-CONTROL-CODE             PIC 9(6).                  ANA00460
004000     05  ACCT-KEY.                                                ANA00470
004100         10  ACCT-NUM                  PIC 9(9).                  ANA00480
004200         10  ACCT-TYPE                 PIC X(3).                  ANA00490
004300     05  ACCT-STATUS-CODE              PIC 9(2).                  ANA00500
004400     05  ACCT-BALANCE                  PIC S9(6)V99.              ANA00510
004500     05  ACCT-MIN-BALANCE              PIC S9(6)V99.              ANA00520
004600     05  ACCT-AVG-BALANCE              PIC S9(6)V99.              ANA00530
004700     05  ACCT-MULTI-ACCT               PIC X(3).                  ANA00540
004800     05  ACCT-BRANCH-CODE              PIC 9(3).                  ANA00550
004900     05  ACCT-INTEREST                 PIC S9(6)V99.              ANA00560
005000     05  ACCT-INT-YTD                  PIC S9(6)V99.              ANA00570
005100     05  ACCT-SERVICE-CHARGE           PIC S9(6)V99.              ANA00580
005200     05  ACCT-LAST-UPDATE              PIC 9(6).                  ANA00590
005300                                                                  ANA00600
005400 FD  EXCEPTION-FILE                                               ANA00610
005500     RECORDING MODE IS F                                          ANA00620
005600     BLOCK CONTAINS 0 RECORDS                                     ANA00630
005700     LABEL RECORDS ARE STANDARD.                                  ANA00640
005800 01  EXCEPT-BUF.                                                  ANA00650
005900     05  FILLER                          PIC X(133).              ANA00660
006000                                                                  ANA00670
006100 FD  TRAN-FILE                                                    ANA00680
006200     RECORDING MODE IS F                                          ANA00690
006300     BLOCK CONTAINS 0 RECORDS                                     ANA00700
006400     LABEL RECORDS ARE STANDARD.                                  ANA00710
006500 01  TRAN-RECORD                       PIC X(80).                 ANA00720
006510 01  TRAN-REC1.                                                   ANA00730
006600     05  TRAN-CONTROL-CODE             PIC 9(6).                  ANA00740
006700     05  TRAN-ACCT-KEY.                                           ANA00750
006800         10  TRAN-ACCT-NUM             PIC 9(9).                  ANA00760
006900         10  TRAN-ACCT-TYPE            PIC X(3).                  ANA00770
007000     05  TRAN-ADJ-VALUE                PIC S9(6)V99.              ANA00780
007100     05  TRAN-TIMESTAMP                PIC 9(15).                 ANA00790
007200     05  TRAN-LOCATION-CODE            PIC 9(3).                  ANA00800
007210     05  FILLER                        PIC X(36).                 ANA00810
007300                                                                  ANA00820
007400 FD  ACTION-FILE                                                  ANA00830
007500     RECORDING MODE IS F                                          ANA00840
007600     BLOCK CONTAINS 0 RECORDS                                     ANA00850
007700     LABEL RECORDS ARE STANDARD.                                  ANA00860
007800 01  ACTION-RECORD.                                               ANA00870
007900     05  ACT-CONTROL-CODE              PIC 9(6).                  ANA00880
008000     05  ACT-REASON-CODE               PIC 9(4).                  ANA00890
008100     05  ACT-ACCT-KEY.                                            ANA00900
008200         10  ACCT-NUM                  PIC 9(18).                 ANA00910
008300         10  ACCT-TYPE                 PIC X(3).                  ANA00920
008400     05  ACT-STATUS-CODE               PIC 9(2).                  ANA00930
008500     05  ACT-ORIGIN-CODE               PIC 9(18).                 ANA00940
008600     05  ACT-TIMESTAMP                 PIC 9(15).                 ANA00950
008700     05  ACT-CUR-BALANCE               PIC S9(11)V9(4) COMP-3.    ANA00960
008800     05  ACT-SIGNATURE                 PIC X(4).                  ANA00970
008900                                                                  ANA00980
009000 WORKING-STORAGE SECTION.                                         ANA00990
009100                                                                  ANA01000
009200 77  PGM-SIGNATURE                     PIC X(4) VALUE 'BANK'.     ANA01010
009300 77  TRAN-FILE-FLAG                    PIC X    VALUE ' '.        ANA01020
009400     88  TRAN-FILE-ENDS                VALUE 'X'.                 ANA01030
009500                                                                  ANA01040
009600 77  CHK-INTEREST-RATE                 PIC S9(4)V9(4) COMP-3      ANA01050
009700                                       VALUE +5.0.                ANA01060
009710 77  ACCT-FILE-KEY-ERROR               PIC S9(4)V9(4) COMP-3.     ANA01070
009720                                                                  ANA01080
009800 77  CHK-MULTI-ACCT-RATE               PIC S9(4)V9(4) COMP-3      ANA01090
009900                                       VALUE +0.5.                ANA01100
010000 77  SERVICE-INTEREST-RATE             PIC S9(4)V9(4) COMP-3      ANA01110
010100                                       VALUE +0.5.                ANA01120
010200 77  MMA-INTEREST-RATE                 PIC S9(4)V9(4) COMP-3      ANA01130
010300                                       VALUE +7.0.                ANA01140
010400 77  SAV-INTEREST-RATE                 PIC S9(4)V9(4) COMP-3      ANA01150
010500                                       VALUE +5.0.                ANA01160
010600 77  SERVICE-CHARGE                    PIC S9(4)V9(4) COMP-3      ANA01170
010700                                       VALUE +5.00.               ANA01180
010800 77  WK-INTEREST                       PIC S9(4)V9(4) COMP-3.     ANA01190
010900 77  INTEREST-RATE                     PIC S9(4)V9(4) COMP-3.     ANA01200
011000 77  DAYS-IN-PERIOD                    PIC S9(9) COMP-3.          ANA01210
011100 77  DAYS-IN-YEAR                      PIC S9(9) COMP-3.          ANA01220
011200 77  WORK-ACTION-REASON                PIC 9(4).                  ANA01230
011300     88  NO-ACTIONS                    VALUE 0000.                ANA01240
011400     88  NEGATIVE-BALANCE              VALUE 0042.                ANA01250
011500     88  BELOW-MINIMUM                 VALUE 0056.                ANA01260
011600     88  MULTI-ACCT                    VALUE 0099.                ANA01270
011700     88  MISSING-ACCT                  VALUE 2099.                ANA01280
011800                                                                  ANA01290
011900 77  ACCT-EOF                          PIC X.                     ANA01300
011910 77  ACCT-IO-CNT                       PIC 9(4) VALUE 0.          ANA01310
012000 77  TRAN-CNT                          PIC 9(4) VALUE 0.          ANA01320
012100 77  EX-RPT-LINE-CNT                   PIC 9(4) VALUE 0.          ANA01330
012200 77  EX-RPT-PAGE-CNT                   PIC 9(4) VALUE 0.          ANA01340
012300 77  ACTION-CNT                        PIC 9(4) VALUE 0.          ANA01350
012400 77  WORK-CNT                          PIC 9(4).                  ANA01360
012500 77  WORK-RETURN-CODE                  PIC S9(4) COMP.            ANA01370
012510 77  WORK-DAYS-INDEX                   PIC 9(4) VALUE 0.          ANA01380
012520 77  WORK-ACCT-INDEX                   PIC 9(4) VALUE 0.          ANA01390
012600                                                                  ANA01400
012700 01  MONTH-TABLE-INIT.                                            ANA01410
012800     05  JAN-DAYS                      PIC 9(02) VALUE 31.        ANA01420
012900     05  FEB-DAYS                      PIC 9(02) VALUE 28.        ANA01430
013000     05  MAR-DAYS                      PIC 9(02) VALUE 31.        ANA01440
013100     05  APR-DAYS                      PIC 9(02) VALUE 30.        ANA01450
013200     05  MAY-DAYS                      PIC 9(02) VALUE 31.        ANA01460
013300     05  JUN-DAYS                      PIC 9(02) VALUE 30.        ANA01470
013400     05  JUL-DAYS                      PIC 9(02) VALUE 31.        ANA01480
013500     05  AUG-DAYS                      PIC 9(02) VALUE 31.        ANA01490
013600     05  SEP-DAYS                      PIC 9(02) VALUE 30.        ANA01500
013700     05  OCT-DAYS                      PIC 9(02) VALUE 31.        ANA01510
013800     05  NOV-DAYS                      PIC 9(02) VALUE 30.        ANA01520
013900     05  DEC-DAYS                      PIC 9(02) VALUE 31.        ANA01530
014000                                                                  ANA01540
014100 01  MONTH-TABLE REDEFINES MONTH-TABLE-INIT.                      ANA01550
014200     05  MONTH     OCCURS 12 TIMES  PIC 9(02).                    ANA01560
014300                                                                  ANA01570
014310 01  PRINT-DAY-LINE.                                              ANA01580
014320     05  PRINT-DAY PIC 9(02)  OCCURS 12 INDEXED BY PRINT-INDEX.   ANA01590
014330                                                                  ANA01600
014400 01  TODAY-DATE.                                                  ANA01610
014500     05  TODAY-YY                      PIC 9(02).                 ANA01620
014600     05  TODAY-MM                      PIC 9(02).                 ANA01630
014700     05  TODAY-DD                      PIC 9(02).                 ANA01640
014800                                                                  ANA01650
014900 01  PGM-LITERALS.                                                ANA01660
015000     05  YES-LITERAL                   PIC X    VALUE 'Y'.        ANA01670
015100     05  NO-LITERAL                    PIC X    VALUE 'N'.        ANA01680
015200     05  EOF-LITERAL                   PIC X    VALUE 'X'.        ANA01690
015300                                                                  ANA01700
015400 01  ACTION-REASON-CODES.                                         ANA01710
015500     05  ACTION-NEG-BALANCE            PIC 9(4) VALUE 0042.       ANA01720
015600     05  ACTION-BELOW-MIN              PIC 9(4) VALUE 0056.       ANA01730
015700     05  ACTION-MULTI-ACCT             PIC 9(4) VALUE 0099.       ANA01740
015800     05  ACTION-MISSING-ACCT           PIC 9(4) VALUE 2099.       ANA01750
015900                                                                  ANA01760
016000*    COPY BANKCPY1.                                               ANA01770
016100     COPY BANKCPY1.                                               ANA01780
016200                                                                  ANA01790
016300 01  EXCEPT-HEAD-LINE2.                                           ANA01800
016400     05  EX-HDG2                         PIC X(1).                ANA01810
016500     05  EXCEPT1-REPORT-DATE             PIC X(8).                ANA01820
016600     05  FILLER                          PIC X(49)                ANA01830
016700         VALUE SPACES.                                            ANA01840
016800     05  FILLER                          PIC X(30)                ANA01850
016900         VALUE 'SERVICE CHARGE EXCEPTIONS'.                       ANA01860
017000     05  FILLER                          PIC X(49)                ANA01870
017100         VALUE SPACES.                                            ANA01880
017200     05  FILLER                          PIC X(5)                 ANA01890
017300         VALUE 'PAGE '.                                           ANA01900
017400     05  EXCEP2-REPORT-PAGE-CNT          PIC 9(4).                ANA01910
017500                                                                  ANA01920
017600 01  EXCEPT-DETAIL-LINE2.                                         ANA01930
017700     05  EX-CC                           PIC X  VALUE ' '.        ANA01940
017800     05  FILLER                          PIC X(17)                ANA01950
017900         VALUE 'ACCOUNT-NUMBER:  '.                               ANA01960
018000     05  EX-NUM                          PIC 9(12).               ANA01970
018100     05  FILLER                          PIC X(40) VALUE SPACES.  ANA01980
018200     05  FILLER                          PIC X(16)                ANA01990
018300         VALUE 'YTD INTEREST:   '.                                ANA02000
018400     05  EX-YTD-INTEREST                 PIC S9(12)V99.           ANA02010
018500     05  FILLER                          PIC X(2).                ANA02020
018600     05  FILLER                          PIC X(17)                ANA02030
018700         VALUE 'SERVICE CHARGE:  '.                               ANA02040
018800     05  EX-SERVICE                      PIC 999999.              ANA02050
018900     05  FILLER                          PIC X(10) VALUE SPACES.  ANA02060
019000 LINKAGE SECTION.                                                 ANA02070
019100                                                                  ANA02080
019200 01  CONTROL-PARAMETERS.                                          ANA02090
019300     05  FREE-SERVICE-MIN              PIC S9(6)V99.              ANA02100
019400     05  CD-REVIEW-MIN                 PIC S9(6)V99.              ANA02110
019500     05  BRANCH-BALANCE                PIC S9(6)V99.              ANA02120
019600     05  BANK-BALANCE                  PIC S9(6)V99.              ANA02130
019700                                                                  ANA02140
019800 PROCEDURE DIVISION USING CONTROL-PARAMETERS.                     ANA02150
020000                                                                  ANA02160
020100     OPEN OUTPUT EXCEPTION-FILE.                                  ANA02170
020200                                                                  ANA02180
020300     PERFORM INITIALIZE-PGM.                                      ANA02190
020400                                                                  ANA02200
020500     PERFORM ACCT-MAINTENANCE                                     ANA02210
020600        THRU ACCT-MAINTENANCE-EXIT                                ANA02220
020700       UNTIL TRAN-FILE-ENDS.                                      ANA02230
020800                                                                  ANA02240
020900     PERFORM REPORT-FINAL-CNTRS.                                  ANA02250
021000                                                                  ANA02260
021100     PERFORM CLOSE-PGM.                                           ANA02270
021200                                                                  ANA02280
021300     GOBACK.                                                      ANA02290
021400                                                                  ANA02300
021500                                                                  ANA02310
021600 ACCT-MAINTENANCE.                                                ANA02320
021700                                                                  ANA02330
021800     READ TRAN-FILE                                               ANA02340
021900         AT END                                                   ANA02350
022000             MOVE EOF-LITERAL  TO TRAN-FILE-FLAG.                 ANA02360
022001                                                                  ANA02370
022010     IF TRAN-FILE-FLAG EQUAL EOF-LITERAL                          ANA02380
022100        GO TO ACCT-MAINTENANCE-EXIT.                              ANA02390
022200                                                                  ANA02400
022300     ADD  +1    TO TRAN-CNT.                                      ANA02410
022400                                                                  ANA02420
022500     MOVE TRAN-ACCT-KEY TO ACCT-KEY.                              ANA02430
022510     DISPLAY 'ACCT-FILE READ KEY: ' ACCT-KEY.                     ANA02440
022600                                                                  ANA02450
022710     READ ACCT-FILE   KEY IS ACCT-KEY                             ANA02460
022800         INVALID KEY                                              ANA02470
022810             DISPLAY 'INVALID ACCT-FILE READ'                     ANA02480
022900             MOVE ACTION-MISSING-ACCT TO WORK-ACTION-REASON       ANA02490
023000             MOVE SPACES              TO ACCT-RECORD              ANA02500
023100             PERFORM INITIATE-ACTION THRU INITIATE-ACTION-EXIT    ANA02510
023110             MOVE 77 TO ACCT-FILE-KEY-ERROR                       ANA02520
023300             GO TO INITIATE-ACTION-1.                             ANA02530
023500                                                                  ANA02540
023510     DISPLAY 'ACCT-FILE-READ'.                                    ANA02550
023600     ADD  +1    TO ACCT-IO-CNT.                                   ANA02560
023700     PERFORM UPDATE-ACCT THRU UPDATE-ACCT-EXIT.                   ANA02570
023710     DISPLAY 'RETURN #1     '.                                    ANA02580
023800                                                                  ANA02590
023900     IF ACCT-MIN-BALANCE IS LESS THAN ACCT-BALANCE                ANA02600
024000        PERFORM EXCEPTION-REPORT-1 THRU EXCEPTION-REPORT-EXIT.    ANA02610
024100                                                                  ANA02620
024200 ACCT-MAINTENANCE-EXIT.                                           ANA02630
024300     EXIT.                                                        ANA02640
024400                                                                  ANA02650
024500                                                                  ANA02660
024600 UPDATE-ACCT.                                                     ANA02670
024700                                                                  ANA02680
024710     DISPLAY 'UPDATE-ACCT ENTER'.                                 ANA02690
024800     PERFORM INIT-ACTION-RECORD.                                  ANA02700
024900                                                                  ANA02710
025000     IF ACCT-TYPE OF ACCT-RECORD = 'INT'                          ANA02720
025100         MOVE CHK-INTEREST-RATE TO INTEREST-RATE                  ANA02730
025200     ELSE IF ACCT-TYPE OF ACCT-RECORD = 'CHK'                     ANA02740
025300         MOVE ZERO TO INTEREST-RATE                               ANA02750
025400     ELSE IF ACCT-TYPE OF ACCT-RECORD = 'MMA'                     ANA02760
025500         MOVE MMA-INTEREST-RATE TO INTEREST-RATE                  ANA02770
025600     ELSE IF ACCT-TYPE OF ACCT-RECORD = 'SAV'                     ANA02780
025700         MOVE SAV-INTEREST-RATE TO INTEREST-RATE.                 ANA02790
025800                                                                  ANA02800
025810     DISPLAY 'UPDATE-ACCT: INTEREST-RATE: ' INTEREST-RATE.        ANA02810
025820                                                                  ANA02820
025900     IF ACCT-MULTI-ACCT = 'YES'                                   ANA02830
025910        DISPLAY 'UPDATE-ACCT: MULTI=YES'                          ANA02840
025920        DISPLAY 'UPDATE-ACCT: MULTI-RATE' CHK-MULTI-ACCT-RATE     ANA02850
026000        ADD CHK-MULTI-ACCT-RATE TO INTEREST-RATE                  ANA02860
026100        MOVE ACTION-MULTI-ACCT TO WORK-ACTION-REASON              ANA02870
026110        PERFORM INITIATE-ACTION THRU INITIATE-ACTION-EXIT.        ANA02880
026300                                                                  ANA02890
026400     IF ACCT-MIN-BALANCE < FREE-SERVICE-MIN                       ANA02900
026410        DISPLAY 'UPDATE-ACCT: ACCT-MIN < FREE'                    ANA02910
026420        DISPLAY 'UPDATE-ACCT: SERVICE-CHARGE' SERVICE-CHARGE      ANA02920
026500        MOVE SERVICE-INTEREST-RATE TO INTEREST-RATE               ANA02930
026600        COMPUTE ACCT-SERVICE-CHARGE = SERVICE-CHARGE              ANA02940
026700        MOVE ACTION-BELOW-MIN TO WORK-ACTION-REASON               ANA02950
026710        PERFORM INITIATE-ACTION THRU INITIATE-ACTION-EXIT         ANA02960
026900     ELSE                                                         ANA02970
027000        MOVE ZEROS TO ACCT-SERVICE-CHARGE.                        ANA02980
027100                                                                  ANA02990
027200     IF ACCT-MIN-BALANCE < 0                                      ANA03000
027300        MOVE ACTION-NEG-BALANCE TO WORK-ACTION-REASON             ANA03010
027310        PERFORM INITIATE-ACTION THRU INITIATE-ACTION-EXIT.        ANA03020
027500                                                                  ANA03030
027510     DISPLAY 'ACCT-AVG-BALANCE: ' ACCT-AVG-BALANCE.               ANA03040
027520     DISPLAY 'DAYS-IN-YEAR: ' DAYS-IN-YEAR.                       ANA03050
027530     DISPLAY 'DAYS-IN-PERIOD: ' DAYS-IN-PERIOD.                   ANA03060
027600     COMPUTE WK-INTEREST =                                        ANA03070
027700           (ACCT-AVG-BALANCE / DAYS-IN-YEAR) *                    ANA03080
027800           DAYS-IN-PERIOD * (INTEREST-RATE / 100).                ANA03090
027900                                                                  ANA03100
028000     MOVE WK-INTEREST TO ACCT-INTEREST.                           ANA03110
028100     ADD ACCT-INTEREST TO ACCT-BALANCE.                           ANA03120
028200     ADD ACCT-INTEREST TO ACCT-INT-YTD.                           ANA03130
028300                                                                  ANA03140
028400     SUBTRACT SERVICE-CHARGE FROM ACCT-BALANCE.                   ANA03150
028500     SUBTRACT ACCT-INTEREST FROM BRANCH-BALANCE.                  ANA03160
028600     SUBTRACT ACCT-INTEREST FROM BANK-BALANCE.                    ANA03170
028700                                                                  ANA03180
028800     ADD SERVICE-CHARGE TO BRANCH-BALANCE.                        ANA03190
028900     ADD SERVICE-CHARGE TO BANK-BALANCE.                          ANA03200
029000                                                                  ANA03210
029010     PERFORM INITIATE-ACTION THRU INITIATE-ACTION-EXIT.           ANA03220
029200                                                                  ANA03230
029300     MOVE TODAY-DATE  TO ACCT-LAST-UPDATE.                        ANA03240
029400                                                                  ANA03250
029500     REWRITE ACCT-RECORD.                                         ANA03260
029510     DISPLAY 'UPDATE-ACCT EXIT'.                                  ANA03270
029600                                                                  ANA03280
029700 UPDATE-ACCT-EXIT.                                                ANA03290
029800     EXIT.                                                        ANA03300
029900                                                                  ANA03310
030000 EXCEPTION-REPORT-1.                                              ANA03320
030100*                                                                 ANA03330
030200*   EXCEPTION REPORT 1 LIST ALL ACCOUNTS WITH A MINIMUM BALANCE   ANA03340
030300*   THAT IS LESS THAN THE CURRENT BALANCE.                        ANA03350
030400*                                                                 ANA03360
030500     IF EX-RPT-LINE-CNT IS GREATER THAN 60                        ANA03370
030600        GO TO EXCEPTION-REPORT-2                                  ANA03380
031100     ADD  +1  TO  EX-RPT-LINE-CNT.                                ANA03390
031200     MOVE ACCT-BALANCE TO EX-CUR-BAL.                             ANA03400
031300     MOVE ACCT-MIN-BALANCE TO EX-REPORT-MIN-BAL.                  ANA03410
031400     WRITE EXCEPT-BUF FROM EXCEPT-DETAIL-LINE1.                   ANA03420
031500     WRITE EXCEPT-BUF FROM EXCEPT-DETAIL-LINE2.                   ANA03430
031510     GO TO EXCEPTION-REPORT-EXIT.                                 ANA03440
031600                                                                  ANA03450
031611 EXCEPTION-REPORT-2.                                              ANA03460
031612     ADD +1 TO EX-RPT-PAGE-CNT.                                   ANA03470
031613     MOVE EX-RPT-PAGE-CNT TO EXCEP1-REPORT-PAGE-CNT.              ANA03480
031614     WRITE EXCEPT-BUF FROM EXCEPT-HEAD-LINE1.                     ANA03490
031615     WRITE EXCEPT-BUF FROM EXCEPT-HEAD-LINE2.                     ANA03500
031616     MOVE 0 TO EX-RPT-LINE-CNT.                                   ANA03510
031617                                                                  ANA03520
031618 EXCEPTION-REPORT-EXIT.                                           ANA03530
031619     EXIT.                                                        ANA03540
031620                                                                  ANA03550
031700 INITIATE-ACTION.                                                 ANA03560
031900     MOVE WORK-ACTION-REASON   TO  ACT-REASON-CODE.               ANA03570
032000     MOVE TRAN-CONTROL-CODE    TO  ACT-CONTROL-CODE.              ANA03580
032100     MOVE ACCT-KEY             TO  ACT-ACCT-KEY.                  ANA03590
032101                                                                  ANA03600
032110 INITIATE-ACTION-1.                                               ANA03610
032200     MOVE ACCT-STATUS-CODE     TO  ACT-STATUS-CODE.               ANA03620
032300     MOVE TRAN-LOCATION-CODE   TO  ACT-ORIGIN-CODE.               ANA03630
032400     MOVE TRAN-TIMESTAMP       TO  ACT-TIMESTAMP.                 ANA03640
032600                                                                  ANA03650
032700     MOVE PGM-SIGNATURE        TO  ACT-SIGNATURE.                 ANA03660
032701                                                                  ANA03670
032710     IF ACCT-FILE-KEY-ERROR EQUAL 77                              ANA03680
032720             MOVE +4                  TO WORK-RETURN-CODE         ANA03690
032730             MOVE 0 TO ACCT-FILE-KEY-ERROR                        ANA03700
032740             GO TO ACCT-MAINTENANCE-EXIT.                         ANA03710
032750                                                                  ANA03720
032800     WRITE ACTION-RECORD.                                         ANA03730
032900     ADD  +1  TO  ACTION-CNT.                                     ANA03740
033000                                                                  ANA03750
033010 INITIATE-ACTION-EXIT.                                            ANA03760
033011     EXIT.                                                        ANA03770
033020                                                                  ANA03780
033100 GET-NUM-OF-DAYS.                                                 ANA03790
033200*                                                                 ANA03800
033300     ACCEPT TODAY-DATE FROM DATE.                                 ANA03810
033400                                                                  ANA03820
033500     COMPUTE DAYS-IN-PERIOD =                                     ANA03830
033600          MONTH (TODAY-MM) - TODAY-DD.                            ANA03840
033700     MOVE +0  TO  DAYS-IN-YEAR.                                   ANA03850
033800     PERFORM SUM-TOTAL-DAYS                                       ANA03860
033900             VARYING  WORK-CNT FROM 1 BY 1                        ANA03870
034000             UNTIL TODAY-DD = WORK-CNT.                           ANA03880
034010     PERFORM PRINT-DAYS THRU PRINT-DAYS-EXIT.                     ANA03890
034100*                                                                 ANA03900
034200 SUM-TOTAL-DAYS.                                                  ANA03910
034300     COMPUTE DAYS-IN-YEAR = DAYS-IN-YEAR + MONTH ( WORK-CNT ).    ANA03920
034400*                                                                 ANA03930
034410 PRINT-DAYS.                                                      ANA03940
034411     SET PRINT-INDEX TO 1.                                        ANA03950
034412     MOVE 1 TO WORK-ACCT-INDEX.                                   ANA03960
034420                                                                  ANA03970
034430 PRINT-DAYS-1.                                                    ANA03980
034431     MOVE 1 TO WORK-DAYS-INDEX.                                   ANA03990
034432     DISPLAY WORK-ACCT-INDEX.                                     ANA04000
034433                                                                  ANA04010
034434 PRINT-DAYS-2.                                                    ANA04020
034440     MOVE MONTH (WORK-DAYS-INDEX) TO PRINT-DAY (PRINT-INDEX).     ANA04030
034450     SET PRINT-INDEX UP BY 1.                                     ANA04040
034460     ADD 1 TO WORK-DAYS-INDEX.                                    ANA04050
034470     IF PRINT-INDEX IS LESS THAN 13                               ANA04060
034480        GO TO PRINT-DAYS-2.                                       ANA04070
034490                                                                  ANA04080
034491     DISPLAY PRINT-DAY-LINE.                                      ANA04090
034492     ADD 1 TO WORK-ACCT-INDEX.                                    ANA04100
034493     IF WORK-ACCT-INDEX IS LESS THAN 5                            ANA04110
034494        GO TO PRINT-DAYS-1.                                       ANA04120
034500                                                                  ANA04130
034510 PRINT-DAYS-EXIT.                                                 ANA04140
034511     EXIT.                                                        ANA04150
034520                                                                  ANA04160
034600 INITIALIZE-PGM.                                                  ANA04170
034700                                                                  ANA04180
034800     PERFORM OPEN-FILES.                                          ANA04190
034900                                                                  ANA04200
035000     MOVE  +0          TO ACCT-IO-CNT                             ANA04210
035100                          TRAN-CNT                                ANA04220
035200                          ACTION-CNT                              ANA04230
035300                          WORK-RETURN-CODE.                       ANA04240
035400                                                                  ANA04250
035410     DISPLAY 'FREE-SERVICE-MIN: ' FREE-SERVICE-MIN.               ANA04260
035500     IF  FREE-SERVICE-MIN NOT NUMERIC                             ANA04270
035600         MOVE +0       TO FREE-SERVICE-MIN.                       ANA04280
035610     DISPLAY 'CD-REVIEW-MIN: ' CD-REVIEW-MIN.                     ANA04290
035700     IF  CD-REVIEW-MIN    NOT NUMERIC                             ANA04300
035800         MOVE +0       TO CD-REVIEW-MIN.                          ANA04310
035810     DISPLAY 'BRANCH-BALANCE: ' BRANCH-BALANCE.                   ANA04320
035900     IF  BRANCH-BALANCE   NOT NUMERIC                             ANA04330
036000         MOVE +0       TO BRANCH-BALANCE.                         ANA04340
036010     DISPLAY 'BANK-BALANCE: ' BANK-BALANCE.                       ANA04350
036100     IF  BANK-BALANCE     NOT NUMERIC                             ANA04360
036200         MOVE +0       TO BANK-BALANCE.                           ANA04370
036300                                                                  ANA04380
036400     MOVE ZEROES       TO WORK-ACTION-REASON.                     ANA04390
036500                                                                  ANA04400
036600     PERFORM GET-NUM-OF-DAYS.                                     ANA04410
036700                                                                  ANA04420
036800 INIT-ACTION-RECORD.                                              ANA04430
036810     DISPLAY 'INIT-ACTION-RECORD ENTER'.                          ANA04440
036900     MOVE ACCT-CONTROL-CODE TO ACT-CONTROL-CODE.                  ANA04450
037000     MOVE ACCT-KEY TO ACT-ACCT-KEY.                               ANA04460
037100     MOVE ACCT-NUM OF ACCT-RECORD TO                              ANA04470
037200          ACCT-NUM OF ACTION-RECORD.                              ANA04480
037300     MOVE ACCT-TYPE OF ACCT-RECORD TO                             ANA04490
037400          ACCT-TYPE OF ACTION-RECORD.                             ANA04500
037500     MOVE ACCT-STATUS-CODE TO ACT-STATUS-CODE.                    ANA04510
037600     MOVE ACCT-BALANCE TO ACT-CUR-BALANCE.                        ANA04520
037610     DISPLAY 'INIT-ACTION-RECORD EXIT'.                           ANA04530
037700                                                                  ANA04540
037800                                                                  ANA04550
037900 CLOSE-PGM.                                                       ANA04560
038000                                                                  ANA04570
038100     PERFORM CLOSE-FILES.                                         ANA04580
038200                                                                  ANA04590
038300     MOVE WORK-RETURN-CODE  TO RETURN-CODE.                       ANA04600
038400                                                                  ANA04610
038500                                                                  ANA04620
038600 REPORT-FINAL-CNTRS.                                              ANA04630
038700                                                                  ANA04640
038800     DISPLAY 'TRANSACTION COUNT        =======> ' TRAN-CNT.       ANA04650
038900     DISPLAY 'ACCOUNT MASTER I/O COUNT =======> ' ACCT-IO-CNT.    ANA04660
039000     DISPLAY 'ACTION INITIATION COUNT  =======> ' ACTION-CNT.     ANA04670
039100                                                                  ANA04680
039200                                                                  ANA04690
039300 OPEN-FILES.                                                      ANA04700
039400                                                                  ANA04710
039410     OPEN  INPUT  ACCT-DATA                                       ANA04720
039420           OUTPUT ACCT-FILE.                                      ANA04730
039421                                                                  ANA04740
039423     MOVE 'N' TO ACCT-EOF.                                        ANA04750
039430     PERFORM READ-ACCT-DATA UNTIL ACCT-EOF EQUAL 'Y'.             ANA04760
039440                                                                  ANA04770
039450                                                                  ANA04780
039460     CLOSE ACCT-DATA                                              ANA04790
039470           ACCT-FILE.                                             ANA04800
039490                                                                  ANA04810
039500     OPEN  INPUT  TRAN-FILE                                       ANA04820
039600           I-O    ACCT-FILE                                       ANA04830
039700           OUTPUT ACTION-FILE.                                    ANA04840
039710     DISPLAY 'FILES OPEN #2 '.                                    ANA04850
039800                                                                  ANA04860
039810 READ-ACCT-DATA.                                                  ANA04870
039820     READ ACCT-DATA AT END MOVE 'Y' TO ACCT-EOF.                  ANA04880
039830     IF ACCT-EOF NOT EQUAL 'Y'                                    ANA04890
039831        DISPLAY 'WRITE ACCT-RECORD'                               ANA04900
039840        MOVE ACCT-DATA-REC TO ACCT-RECORD                         ANA04910
039850        WRITE ACCT-RECORD.                                        ANA04920
039900                                                                  ANA04930
040000 CLOSE-FILES.                                                     ANA04940
040100                                                                  ANA04950
040200     CLOSE EXCEPTION-FILE.                                        ANA04960
040300                                                                  ANA04970
040400     CLOSE TRAN-FILE                                              ANA04980
040500           ACCT-FILE                                              ANA04990
040600           ACTION-FILE.                                           ANA05000
040700                                                                  ANA05010
