      *************************************************************
       IDENTIFICATION DIVISION.
      * * * * * * * * * * * * * *
       Class-ID.   DBClass inherits SOMObject.
       AUTHOR.     Sample-Programmer.
      *************************************************************
      * Name:     DBClass                                       ***
      *                                                         ***
      * Language: IBM COBOL                                     ***
      *                                                         ***
      * Function: This class accesses the sample DB/2 database  ***
      *           and  returns information from the employee    ***
      *           table.                                        ***
      *                                                         ***
      *           This program could is an example of existing  ***
      *           procedural code that has been simply modified ***
      *           by making it into a class with the main       ***
      *           procedure division into a mehtod.  One        ***
      *           method was added to set the search name.      ***
      *                                                         ***
      * External subroutines: SERVC                             ***
      *                                                         ***
      * COPY members:                                           ***
      *           DBCOM: Data area for communications           ***
      *           SERVSC: Service Calculation parameters        ***
      *                                                         ***
      *************************************************************

      *************************************************************
       ENVIRONMENT DIVISION.
      * * * * * * * * * * * * * *
       CONFIGURATION SECTION.
       Repository.
           CLASS SOMObject is "SOMObject"
           CLASS DBClass is "DBClass".

      *************************************************************
       DATA DIVISION.
       Working-Storage Section.
         01 In-LastName               PIC X(15).
         01 LName.
               49 LName-Len           PIC S9(4) COMP-5.
               49 LName-Data          PIC X(15).

      *************************************************************
       PROCEDURE DIVISION.
      *************************************************************

      *************************************************************
       Identification Division.
       Method-ID. "somInit" override.
      *************************************************************
      *  This method overrides the somInit method and           ***
      *  initializes the name for the search.                   ***
      *************************************************************

       Procedure Division.
            Move High-Values to In-LastName.
            Move 0 to LName-Len.
            Move High-Values to LName-Data.
       End Method "somInit".
      *************************************************************

      *************************************************************
       Identification Division.
       Method-ID. "setSrchName".
      *************************************************************
      *  This method sets the search name.                      ***
      *************************************************************
       Data Division.
       Linkage Section.
       01 SrchName.
           03 Name-Length                PIC 9(9) COMP-5.
           03 Name-String.
           05 Name-Chars                 PIC X
                       OCCURS 1 TO 255 TIMES
                       DEPENDING ON Name-Length.

       Procedure Division Using SrchName.
            Move Name-String to In-LastName.
       End Method "setSrchName".
      *************************************************************

      *************************************************************
       Identification Division.
       Method-ID. "doSearch".
      *************************************************************
      *  This method performs the actual database access; it    ***
      *  checks whether the serach name is set to decide how    ***
      *  to get the data from the database.                     ***
      *************************************************************
       Data Division.
       Working-Storage Section.
      *****************************************************
      *    DECLARE host variables                         *
      *****************************************************
           EXEC SQL BEGIN DECLARE SECTION END-EXEC.
           EXEC SQL INCLUDE 'DBCOM.CPY' END-EXEC.
           EXEC SQL END DECLARE SECTION END-EXEC.

      **************************************************
      *    Declare Cursors for Employee Database       *
      **************************************************
           EXEC SQL
           DECLARE CSR1 CURSOR FOR
             SELECT WORKDEPT, FIRSTNME,
                   HIREDATE, LASTNAME,
                   MIDINIT, PHONENO
             FROM EMPLOYEE
             ORDER BY LASTNAME
           END-EXEC.

      *************************************************************
      ***  Declare Cursor 2 here                                 **
      *************************************************************
           EXEC SQL
           DECLARE CSR2 CURSOR FOR
             SELECT WORKDEPT, FIRSTNME,
                   HIREDATE, LASTNAME,
                   MIDINIT, PHONENO
             FROM EMPLOYEE
                WHERE LASTNAME LIKE :LNAME
             ORDER BY LASTNAME
           END-EXEC.

      *************************************************************
      *  Internal variables                                       *
      *************************************************************
       01  ARRAY-MAX-ENTRIES.
           05  EMP-ARRAY-MAX              PIC 9(2)  VALUE 50.
           05  RESULT-DATA-MAX            PIC 9(2)  VALUE 0.

       01  PROGRAM-WORK-FIELDS.
           05  EMP-PTR                    PIC 9(2).
           05  BLANK-COUNT                PIC 9(2).
           05  LASTNAME-LENGTH            PIC 9(2).
           05  DEPT-LENGTH                PIC 9(2).
           05  CHARPTR                    PIC 9(2).

       01  Workingfields.
           10  EMP-ENTRY                  OCCURS 50 TIMES.
               15  EMP-LAST-NAME          PIC X(15).
               15  EMP-FIRST-NAME         PIC X(10).
               15  EMP-MIDDLE-INITIAL     PIC X.
               15  EMP-DEPT               PIC X(3).
               15  EMP-PHONE              PIC X(12).
               15  EMP-HIRE-DATE          PIC 9(6).
       01 CS-Request                      PIC X.
            88  CS-Display-All                      VALUE "D".
            88  CS-Partial-Match                    VALUE "P".

       01  Display-Emp.
           05 DISPLAY-EMP-DATA            PIC x(65) OCCURS 50 TIMES.
       77  DISPLAY-FILLER                 PIC X(2)  VALUE HIGH-VALUE.
       01  DISPLAY-INDEX                  PIC 9(2).

       01  GS-FULLNAME                    PIC X(30).
       77  UPPER-ALPHA                    PIC X(26)   VALUE
              "ABCDEFGHIJKLMNOPQRSTUVWXYZ".
       77  LOWER-ALPHA                    PIC X(26)   VALUE
              "abcdefghijklmnopqrstuvwxyz".

       01  LINE-COUNT                     PIC 9(2).
       01  TOTAL-COUNT                    PIC 9(2).
       01  THE-COUNT                      PIC 9(2) VALUE ZERO.
       01  FIX-FIELDS.
           05  LJUST-FIELD-1.
               10  LJUST-LASTNAME-1       PIC X(15).
           05  LJUST-FIELD-2.
               10  LJUST-LASTNAME-2       PIC X(15).

           COPY SQLCA.
           COPY SQL.

      * - - - - - SQL Values
       01  NOT-FOUND                     PIC S9(4) COMP-4 VALUE 100.
       01  FOUND                         PIC S9(4)  COMP-4  VALUE 0.

       01  SC-COMMAREA.
           COPY SERVSC.

       Linkage Section.
      * - - - - - DataArea (for communications)
       01 DataArea.
           COPY DATAAREA.

      *************************************************************
       Procedure Division Returning DataArea.
      *************************************************************
      * 1000-MAIN: Main Processing
      *
      *   Return code is set if matches were found or not found.
      *************************************************************
        1000-MAIN.
            EXEC SQL
              CONNECT TO SAMPLE
            END-EXEC.
      * Initialize stuff
            INITIALIZE CS-RESULT-DATA.
            MOVE 0 TO RESULT-DATA-MAX.
            MOVE 0 to CS-Return-Code.

      * Check whether the search name is set and process routines
            If In-LastName = High-Value
               Move "D" to CS-Request
            Else
               Perform 1600-FIX-NAME
               Move "P" to CS-Request.

            EVALUATE TRUE
              WHEN CS-DISPLAY-ALL
                PERFORM 1100-DISPLAY-ALL THRU
                   1100-DISPLAY-ALL-EXIT
                subtract 1 from Results-Knt
              WHEN CS-PARTIAL-MATCH
                PERFORM 1200-DISPLAY-MATCH THRU
                   1200-DISPLAY-MATCH-EXIT
              WHEN OTHER
                MOVE 3 TO CS-RETURN-CODE
            END-EVALUATE.
            GOBACK.

      *************************************************************
      * 1100-DISPLAY-ALL:
      *   Return all of the entries in EMP-ARRAY.
      *   Calls FETCH-ALL to do the actual getting of the data.
      *************************************************************
        1100-DISPLAY-ALL.

      * Initialize retun code
            MOVE 0 TO CS-SQL-CODE.
      * Initialize subscripts
            MOVE 1 TO Results-Knt.
            MOVE 1 TO EMP-PTR.

      * Data Assistant generated code.  Do Not Modify.
           EXEC SQL
             OPEN CSR1
           END-EXEC

      * If database error occurred, set DB error return code
           IF SQLCODE NOT = 0
             MOVE 2 TO CS-RETURN-CODE
             MOVE SQLCODE TO CS-SQL-CODE
           END-IF.

           PERFORM 1130-FETCH-ALL THRU 1130-FETCH-ALL-EXIT
                   WITH TEST BEFORE UNTIL SQLCODE NOT = FOUND
                          OR Results-Knt > EMP-ARRAY-MAX
                          OR CS-RETURN-CODE NOT = 0.
           MOVE SQLCODE TO CS-SQL-CODE.

      *  Close Cursor1
             EXEC SQL
               CLOSE CSR1
             END-EXEC.

      * Indicate number of entries processed
            MOVE EMP-ARRAY-MAX TO RESULT-DATA-MAX.

         1100-DISPLAY-ALL-EXIT. EXIT.

      *************************************************************
      * 1130-FETCH-ALL:
      *   Executes the SQL search
      *   Move all of the entries from EMP-DATA to CS-RESULT-DATA.
      *************************************************************
         1130-FETCH-ALL.

           INITIALIZE SOLO.
           EXEC SQL
             FETCH CSR1
             INTO  :WORKDEPT, :FIRSTNME,
                   :HIREDATE, :LASTNAME,
                   :MIDINIT, :PHONENO
           END-EXEC.

           IF SQLCODE = FOUND and Results-Knt <= EMP-ARRAY-MAX
             MOVE LASTNAME  TO CS-EMP-LASTNAME(Results-Knt)
             MOVE FIRSTNME  TO CS-EMP-FIRSTNAME(Results-Knt)
             MOVE MIDINIT   TO CS-EMP-INITIAL(Results-Knt)
             MOVE WORKDEPT  TO CS-EMP-DEPT(Results-Knt)
             MOVE PHONENO   TO CS-EMP-PHONE(Results-Knt)
             MOVE HIREDATE  TO CS-EMP-HIRE-DATE(Results-Knt)
      *******************************************
      *      Call Service Routine               *
      *******************************************
             MOVE CS-EMP-HIRE-DATE(Results-Knt) TO SC-HIRE-DATE
             MOVE 4 TO SC-RETURN-CODE

             CALL "SERVC" USING SC-COMMAREA

             IF SC-RETURN-CODE NOT = 0
                MOVE 4 TO CS-RETURN-CODE
             END-IF
             MOVE SC-SERVICE-LENGTH TO CS-SERVICE-LENGTH(Results-Knt)

             ADD 1 TO Results-Knt

           ELSE
      *      If database error occurred, set DB error return code
             IF SQLCODE NOT = NOT-FOUND and SQLCODE NOT = FOUND
               MOVE 2 TO CS-RETURN-CODE
               MOVE SQLCODE TO CS-SQL-CODE
             END-IF
           END-IF.

         1130-FETCH-ALL-EXIT.   EXIT.

      *************************************************************
      * 1200-DISPLAY-MATCH
      *   Return all of the entries in EMP-ARRAY.
      *   Move all of the entries from EMP-DATA to CS-RESULT-DATA.
      *************************************************************
        1200-DISPLAY-MATCH.

      *   Determine the lengths of the client's inputs: IN-LASTNAME
      *   and build the search target, LNAME.
           PERFORM 1210-FIND-LENGTHS THRU 1210-FIND-LENGTHS-EXIT.
           STRING
              IN-LASTNAME
              "%"
                DELIMITED BY SPACE
                INTO LNAME-DATA.

      * Initialize retun code
           MOVE 0 TO CS-SQL-CODE.

      * Initialize subscripts
           MOVE 0 TO Results-Knt.
           MOVE 0 TO EMP-PTR.

      * Data Assistant generated code.  Do Not Modify.
           EXEC SQL
             OPEN CSR2
           END-EXEC

      * If database error occured, set db error return code
           IF SQLCODE NOT = 0
             MOVE 2 TO CS-RETURN-CODE
             MOVE SQLCODE TO CS-SQL-CODE
           END-IF.

           PERFORM 1230-FETCH-MATCH THRU 1230-FETCH-MATCH-EXIT
                   WITH TEST BEFORE UNTIL SQLCODE NOT = FOUND
                                    OR Results-Knt > EMP-ARRAY-MAX
                                    OR CS-RETURN-CODE NOT = 0.
           MOVE SQLCODE TO CS-SQL-CODE.
      *  Close Cursor2
           EXEC SQL
               CLOSE CSR2
           END-EXEC.

      * Indicate number of entries processed and set return
      * code if nothing's found
           MOVE Results-Knt TO RESULT-DATA-MAX.
           IF Results-Knt = 0  AND CS-RETURN-CODE = 0
               MOVE 1 TO CS-RETURN-CODE
           END-IF.
      * Reset the search name
           Move High-Values to In-LastName.
           Move 0 to LName-Len.
           Move High-Values to LName-Data.

         1200-DISPLAY-MATCH-EXIT. EXIT.

      *************************************************************
      * 1210-FIND-LENGTHS: Determine length of what the user
      *   entered, add 1 and set that as the length of the host
      *   variable.
      *************************************************************
        1210-FIND-LENGTHS.
            IF IN-LASTNAME = SPACES
      * Lastname is blank
               MOVE 0 TO LNAME-LEN
            ELSE
      * Lastname is not blank; determine its length
               INITIALIZE BLANK-COUNT
      * Determine the number of trailing blanks in last name
      * input characters using intrinsic function REVERSE
               INSPECT FUNCTION REVERSE(IN-LASTNAME)
                   TALLYING BLANK-COUNT FOR LEADING SPACES
      * Calculate field length (field size minus trailing blanks)
               COMPUTE LNAME-LEN = 16 - BLANK-COUNT
            END-IF.

        1210-FIND-LENGTHS-EXIT. EXIT.

      *************************************************************
      * 1230-FETCH-MATCH
      *   This rountine gets cursor 2 and gets the results if
      *   a match is found.  It then calls the calcyear routine
      *   to calculate the years of service.
      *************************************************************
         1230-FETCH-MATCH.

           INITIALIZE SOLO.

           EXEC SQL
             FETCH CSR2
             INTO  :WORKDEPT, :FIRSTNME,
                   :HIREDATE, :LASTNAME,
                   :MIDINIT, :PHONENO
           END-EXEC.

           IF SQLCODE = FOUND and Results-Knt <= EMP-ARRAY-MAX
              ADD 1 TO Results-Knt
              MOVE LASTNAME  TO CS-EMP-LASTNAME(Results-Knt)
              MOVE FIRSTNME  TO CS-EMP-FIRSTNAME(Results-Knt)
              MOVE MIDINIT   TO CS-EMP-INITIAL(Results-Knt)
              MOVE WORKDEPT  TO CS-EMP-DEPT(Results-Knt)
              MOVE PHONENO   TO CS-EMP-PHONE(Results-Knt)
              MOVE HIREDATE  TO CS-EMP-HIRE-DATE(Results-Knt)
      *******************************************
      *      Call Calcyear Routine              *
      *******************************************
              MOVE CS-EMP-HIRE-DATE(Results-Knt) TO SC-HIRE-DATE
              MOVE 4  to SC-RETURN-CODE

              CALL "SERVC" USING SC-COMMAREA

              IF SC-RETURN-CODE NOT = 0
                 MOVE 4 TO CS-RETURN-CODE
              END-if
              MOVE SC-SERVICE-LENGTH TO CS-SERVICE-LENGTH(Results-Knt)

           ELSE
      * ---- If database error occured, set DB error return code
              IF SQLCODE NOT = NOT-FOUND and SQLCODE NOT = FOUND
                 MOVE 2 TO CS-RETURN-CODE
                 MOVE SQLCODE TO CS-SQL-CODE
              END-IF
           END-IF.

         1230-FETCH-MATCH-EXIT.   EXIT.

      ***************************************************************
      *  1600-FIX-NAME.                                             *
      *  This routine sets up the search name for use in the        *
      *  SQL call.  It converts to upper case and removes the       *
      *  leading blanks, then set the search name actually used.    *
      ***************************************************************

        1600-FIX-NAME.
      ***************************************************************
      *  This routine strips out the leading blanks from the entry. *
      ***************************************************************
           INITIALIZE LJUST-FIELD-1, LJUST-FIELD-2
           INSPECT IN-LASTNAME
               CONVERTING LOWER-ALPHA TO UPPER-ALPHA.

      * --- Left-justify the Last Name input
           IF IN-LASTNAME NOT = SPACES
              INSPECT IN-LASTNAME REPLACING LEADING SPACES BY
                      HIGH-VALUES
              UNSTRING IN-LASTNAME DELIMITED BY ALL HIGH-VALUES
                      INTO LJUST-FIELD-1, LJUST-FIELD-2
              IF LJUST-FIELD-1 = SPACES
                 MOVE LJUST-LASTNAME-2 TO IN-LASTNAME
              END-IF
           END-IF.
      ***************************************************************

       End Method "doSearch".

      ***************************************************************

       END CLASS DBClass.


