; ****************************************************************************
; *      Copyright (c) IBM Corporation 1993  -  All Rights Reserved          *
; *                                                                          *
; * DFM/2 (program no. 5648-020)                                             *
; * Version: 1.0                                                             *
; * Release: 1.0                                                             *
; * Level:   0.0                                                             *
; *                                                                          *
; ****************************************************************************
; *                                                                          *
; *             IBM Distributed FileManager (DFM/2) for OS/2                 *
; *             ============================================                 *
; *                                                                          *
; *                     SAMPLE CONFIGURATION FILE                            *
; *                                                                          *

; Definition of an MVS/ESA system as target:
       DFM_TARGET (
             remote_lu(ST11APPC)
             description(The MVS/ESA System)
             conversation(HOLD)
             max_send_limit(4096)
             userid (tsouserid)
;            password (XXXXXXX)
;             dcinclude(%ehndir%\cachinex\dcincl2.dci)
             )

; ****************************************************************************
; * Define the local LU alias as defined for the OS/2 ES Communications Mgr. *
; ****************************************************************************
       LOCAL_LU (STB5761I)

; ****************************************************************************
; * Define the Mode Name                                                     *
; ****************************************************************************
       MODE_NAME (QPCSUPP)

; ****************************************************************************
; * Define the Default DFM Target System                                     *
; ****************************************************************************
       DEFAULT_DFM_TARGET(ST11APPC)

; ****************************************************************************
; * Define the default CCSID (Coded-Character-Set-Id, up to 5 decimal digits)*
; * for all accessed targets:                                                *
; * Some examples for CCSIDs (code pages)                                    *
; * (CEPC means EBCDIC format, PC Data means ASCII format):                  *
; * 500 = CEPC: International Latin-1, B, CH, Can(AS/400)                    *
; *             (default if no specification given)                          *
; * 437 = PC Data: USA                                                       *
; * 850 = PC Data: Latin Alphabet Number 1, Latin-1 Countries                *
; ****************************************************************************
       DEFAULT_CCSID(00500)

; ****************************************************************************
; * Define the shared memory size to be available for DFM/2 tracing.         *
; * Trace buffer memory to be specified in kilobytes:                        *
; *  Minimum value:   10 KB                                                  *
; *  Maximum value: 1000 KB                                                  *
; ****************************************************************************
;       TRACE_BUFFER(64)

; ****************************************************************************
; * Define space available for DFM/2 caching.                                *
; * The size (maximum space used) is specified in kilobytes,                 *
; * default value is 2000 KB.                                                *
; * The default directory is %ehndir%\cache.                                 *
; * Make sure the directory specified exists and does not contain any files  *
; * you want to keep, as DFM/2 may delete all files in that directory.       *
; ****************************************************************************
;       DFM_CACHE (
;             cache_disk_size(1000)
;             cache_directory(%ehndir%\cache)
;             )

; ***** end of file **********************************************************
