PROCESS CHAR(EBCDIC) FLOAT(HEX) BINARY(S390)
       IDENTIFICATION DIVISION.
      *
       PROGRAM-ID. HOSTDATA.
      *
      * Employee VSAM file utility program
      * - Read   FILE2 using file name from EMPLIST environment variable
      * - Write  FILE1 with a list of employee names using EMPVSAM
      * - Update FILE1 record with key supplied by user
      * - Delete FILE1 record with key supplied by user
      *
       ENVIRONMENT DIVISION.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           SELECT FILE1 ASSIGN TO EMPVSAM
                  ORGANIZATION IS INDEXED
                  ACCESS MODE IS DYNAMIC
                  RECORD KEY IS EMP-NAME
                  FILE STATUS IS FILE1-STATUS
                         FILE8-STAT.
           SELECT FILE2 ASSIGN TO EMPLIST
                  ORGANIZATION IS LINE SEQUENTIAL
      *           ORGANIZATION IS SEQUENTIAL
      *  on MVS switch from "LINE SEQUENTIAL" to "SEQUENTIAL"
                  ACCESS MODE IS SEQUENTIAL
                  FILE STATUS IS SYSIN-STATUS.

       DATA DIVISION.
       FILE SECTION.
       FD  FILE1.
      *    RECORD CONTAINS 81 CHARACTERS.
       01  FILE1-R1.
           05 EMP-NAME.
              10 EMP-LAST-NAME      PIC X(15).
              10 EMP-FIRST-NAME     PIC X(10).
              10 EMP-MIDDLE-INITIAL PIC X(1).
           05  EMP-DEPT             PIC X(3).
           05  EMP-PHONE            PIC X(12).
           05  EMP-HIRE             PIC X(6).
      * Binary types
           05  B1                   PIC 99 COMP.
           05  B2                   PIC 99V99 BINARY.
           05  B3                   PIC 9(5)V9(5) COMP-4.
      * Floating point types
           05  F1                   COMP-1.
           05  F2                   COMP-2.
      * Packed Decimal types
           05  PD1                  PIC 99 COMP-3.
           05  PD2                  PIC 99V99 COMP-3.
           05  PD3                  PIC S9(8)V9(5) PACKED-DECIMAL.

       FD  FILE2
           RECORDING MODE IS F
           RECORD CONTAINS 47 CHARACTERS.
       01  SYSIN-R1.
           05  EMPL-NAME            PIC X(26) USAGE DISPLAY NATIVE.
           05  EMPL-DEPT            PIC X(3)  USAGE DISPLAY NATIVE.
           05  EMPL-PHONE           PIC X(12) USAGE DISPLAY NATIVE.
           05  EMPL-HIRE            PIC X(6)  USAGE DISPLAY NATIVE.

       WORKING-STORAGE SECTION.
       01  FILE1-STATUS.
           05  FILE1-STATUS-A       PIC X.
           05  FILE1-STATUS-B       PIC X.
       01  FILE8-STAT.
           05 VSAM-RC        COMP   PIC S9(4).
           05 VSAM-FUNC      COMP   PIC S9(4).
           05 VSAM-FEED      COMP   PIC S9(4).
       01  SYSIN-STATUS.
           05  SYSIN-STATUS-A       PIC X.
           05  SYSIN-STATUS-B       PIC X.
       01  GOOD-STATUS              PIC X(2).
       01  END-OF-FILE              PIC X(2).
       01  ACCEPT-AREA              PIC X.
       01  PADAREA                  PIC X(7).
       01  LOOP-NBR          COMP   PIC 99.
      *
      * Output file buffer
      *
       01  FILE1-OUT.
           05  EMP-KEY-O            PIC X(26).
           05  FILLER               PIC X(1).
           05  EMP-DEPT-O           PIC X(3).
           05  FILLER               PIC X(2).
           05  EMP-PHONE-O          PIC X(12).
           05  FILLER               PIC X(1).
           05  EMP-HIRE-DATE-O      PIC X(6).
      * Binary types
           05  emp-b1               PIC 99 COMP.
           05  emp-b2               PIC 99V99 BINARY.
           05  emp-b3               PIC 9(5)V9(5) COMP-4.
      * Floating point types
           05  emp-f1               COMP-1.
           05  emp-f2               COMP-2.
      * Packed Decimal types
           05  emp-PD1              PIC 99 COMP-3.
           05  emp-PD2              PIC 99V99 COMP-3.
           05  emp-PD3              PIC S9(8)V9(5) PACKED-DECIMAL.

       PROCEDURE DIVISION.
           MOVE 00 TO GOOD-STATUS.
           MOVE 10 TO END-OF-FILE.
           Display " "
           Display "Create or Maintain a VSAM employee file."
           Display " "
           Display "Enter a choice:"
           Display " 1 to Create"
           Display " 2 to Report"
           Display " 3 to Update a single record"
           Display " 4 to Delete a single record"
           Display " "
           Accept accept-area
           Evaluate accept-area
             when "1"
               Perform Hostdata-create thru Hostdata-create-exit
             when "2"
               Perform hostdata-read thru Hostdata-read-exit
             when "3"
               Perform hostdata-update thru Hostdata-update-exit
             when "4"
               Perform hostdata-delete thru Hostdata-delete-exit
             when other
               Display "Invalid choice."
           End-evaluate.

           Display " "
           Display "Press enter to exit"
           accept accept-area
           GOBACK.
      *
      * Create the file
      *
       Hostdata-create.
           Display "Opening for CREATE"
           Display " "
           Display "Starting VSAM file loader..."
           Display "Using EMPVSAM variable for name of output file"
           Display "..... EMPLIST for name of input file."

           OPEN INPUT FILE2.
           IF SYSIN-STATUS NOT EQUAL TO GOOD-STATUS THEN
                DISPLAY "Error opening INPUT file. Status code = ",
                        SYSIN-STATUS
                GO TO Hostdata-create-exit
           END-IF.
           Display "SYSIN file opened OK using EMPLIST variable"
           OPEN OUTPUT FILE1.
           IF FILE1-STATUS NOT EQUAL TO GOOD-STATUS THEN
                DISPLAY "Error opening OUTPUT file. Status code = ",
                        FILE1-STATUS
                Display "Verify your environment variable points ",
                        "to a valid remote drive."
                GO TO Hostdata-create-exit
           END-IF.
           Display "OUTPUT file opened OK using EMPVSAM variable"
           READ FILE2 NEXT RECORD END-READ.
           Initialize B1.
           PERFORM
                   UNTIL SYSIN-STATUS NOT EQUAL TO GOOD-STATUS
                         OR file1-status NOT EQUAL TO good-status
               MOVE EMPL-NAME TO EMP-NAME
               MOVE EMPL-PHONE TO EMP-PHONE
               MOVE EMPL-HIRE TO EMP-HIRE
               MOVE EMPL-DEPT  TO EMP-DEPT

               COMPUTE B1 = 1 + B1
               COMPUTE B2 = 1.23 + B1
               COMPUTE B3 = 12345.4321 + B1
               COMPUTE F1 = 3.14 + B1
               COMPUTE F2 = 3.14567 + B1
               COMPUTE PD1 = B1
               COMPUTE PD2 = 9.87 + B1
               COMPUTE PD3 = 12345678.54321 + B1

               WRITE FILE1-R1
               IF FILE1-STATUS NOT EQUAL TO GOOD-STATUS THEN
                 DISPLAY "Error writing to OUTPUT file, Status code = ",
                          FILE1-STATUS
                 GO TO Hostdata-create-exit
               END-IF

               DISPLAY "Loading...." EMP-NAME EMP-DEPT " " B1 " " B3

               READ FILE2 NEXT RECORD END-READ
           END-PERFORM.

           IF sysin-status NOT EQUAL TO good-status
              AND sysin-status NOT EQUAL TO END-OF-FILE
           THEN
                DISPLAY "Error reading input. Status code = ",
                        SYSIN-STATUS
           END-IF.
           IF FILE1-STATUS NOT EQUAL TO GOOD-STATUS THEN
                DISPLAY "Error Writing output. Status code = ",
                        FILE1-STATUS
           END-IF.
           CLOSE FILE2.
           CLOSE FILE1.

           DISPLAY "  "
           DISPLAY "After close of OUTPUT file:"
           DISPLAY "Status: " FILE1-STATUS,
                   " VSAM-RC=" VSAM-RC,
                   " VSAM-FUNC=" VSAM-FUNC,
                   " VSAM-FEED=" VSAM-FEED
           MOVE 00 TO GOOD-STATUS.
           MOVE 10 TO END-OF-FILE.

           Display " "
           Display "Reopen the OUTPUT file to verify its usable"
           Display " "
           OPEN I-O    FILE1.
           IF FILE1-STATUS NOT EQUAL TO GOOD-STATUS THEN
                DISPLAY "Error opening OUTPUT file:"
                DISPLAY "Status: " FILE1-STATUS,
                        " VSAM-RC=" VSAM-RC,
                        " VSAM-FUNC=" VSAM-FUNC,
                        " VSAM-FEED=" VSAM-FEED
           ELSE
                DISPLAY "OUTPUT file is ok, file open status =" ,
                        file1-status

           END-IF.

           READ  FILE1 NEXT RECORD END-READ.
           Display "First record=" emp-last-name
           .
       Hostdata-create-exit.
           CLOSE FILE1.
           Exit.
      *
      * Read the existing file
      *
       Hostdata-read.
           MOVE 00 TO GOOD-STATUS.
           MOVE 10 TO END-OF-FILE.
           Display " "
           Display "Using EMPVSAM variable...for name of employee file."
           Display "Opening for REPORT"
           OPEN Input FILE1.
           IF FILE1-STATUS NOT EQUAL TO GOOD-STATUS THEN
                DISPLAY "Error opening FILE1. Status code = ",
                        FILE1-STATUS
                Display "Verify your environment variable points ",
                        "to an existing remote VSAM file."
                CLOSE FILE1
                GO TO Hostdata-read-exit
           END-IF.

           DISPLAY "  "
           DISPLAY "Employee-Name              Dept Phone        Hired "
           DISPLAY "-------------------------- ---  ------------ ------"

           Initialize file1-r1
           Initialize padarea
           Read FILE1 NEXT RECORD End-read.
           PERFORM
                   UNTIL FILE1-STATUS NOT EQUAL TO GOOD-STATUS
               Move spaces to file1-out
               Move emp-name to emp-key-o
               Move emp-dept to emp-dept-o
               Move emp-phone to emp-phone-o
               Move emp-hire to emp-hire-date-o
               Move B1 to emp-b1
               Move B2 to emp-b2
               Move B3 to emp-b3
               Move F1 to emp-f1
               Move F2 to emp-f2
               Move PD1 to emp-pd1
               Move PD2 to emp-pd2
               Move PD3 to emp-pd3
               Display emp-key-o " " emp-dept-o "  " emp-phone-o " ",
                       emp-hire-date-o " "
               Display padarea " " emp-b1 " " emp-b2 " " emp-b3
               Display padarea " " emp-f1
               Display padarea " " emp-f2
               Display padarea " " emp-pd1 " " emp-pd2 " " emp-pd3
               Move spaces to emp-name
               Move spaces to file1-r1
               READ FILE1 NEXT RECORD
           END-PERFORM.

           DISPLAY "  "
           DISPLAY "Reading done -- last read status code=" FILE1-STATUS
           IF FILE1-status NOT EQUAL TO good-status
              AND FILE1-status NOT EQUAL TO END-OF-FILE
           THEN
                DISPLAY "Error subsequent records. Status code = ",
                        FILE1-STATUS
           END-IF.

           Display " "
           .
       Hostdata-read-exit.
           CLOSE FILE1.
           Exit.
      *
      * Update a record in the existing file
      *
       Hostdata-update.
           MOVE 00 TO GOOD-STATUS.
           MOVE 10 TO END-OF-FILE.
           Display " "
           Display "Using EMPVSAM variable...for name of employee file."
           Display "Opening for UPDATE"
           OPEN I-O FILE1.
           IF FILE1-STATUS NOT EQUAL TO GOOD-STATUS THEN
                DISPLAY "Error opening VSAM file. Status code = ",
                        FILE1-STATUS
                CLOSE FILE1
                GO TO Hostdata-update-exit
           END-IF.

           Initialize file1-r1
           Display " "
           Display "Enter employee name to update in three parts."
           Display " "
           Display "Enter LAST NAME:"
           Display " "
           Accept emp-last-name
           Display " "
           Display "FIRST NAME:"
           Display " "
           Accept emp-first-name
           Display " "
           Display "Middle Initial:"
           Display " "
           Accept emp-middle-initial
           Display " "

           READ FILE1 KEY IS emp-name END-READ.
           Evaluate file1-status
             When Good-status
               Display "Status code=00 - Record found"
               Display "Updating...." EMP-NAME
             When "23"
               Display "Status code=23 - Record not found"
               Display "Adding..." EMP-NAME
             When Other
               Display "Status code=" file1-status "is unexpected."
               Display "Bailing out..."
               GO TO Hostdata-update-exit
           End-evaluate.

           Display " "
           Display "Enter fields you wish to add or change."
           Display " "
           Display "Dept?"
           Accept emp-dept
           Display " "
           Display "Hire Date?"
           Accept emp-hire
           Display " "
           Display "Phone?"
           Accept emp-phone
           Display " "

           If file1-status = good-status
             ReWRITE FILE1-R1
           Else
             WRITE FILE1-R1.
           Evaluate file1-status
             When good-status
               Display "Status code=00 - update complete."
             When "22"
               Display "Status code=22 - record is a duplicate"
             When Other
               Display "Status code=" file1-status " is unexpected."
               Display "Error updating VSAM file."
               Display "Bailing out..."
           End-evaluate.

       Hostdata-update-exit.
           Close FILE1.
           Exit.
      *
      * Delete a record in the existing file
      *
       Hostdata-delete.
           MOVE 00 TO GOOD-STATUS.
           MOVE 10 TO END-OF-FILE.
           Display " "
           Display "Using EMPVSAM variable...for name of employee file."
           Display "Opening for DELETE"
           OPEN I-O FILE1.
           IF FILE1-STATUS NOT EQUAL TO GOOD-STATUS THEN
                DISPLAY "Error opening VSAM file. Status code = ",
                        FILE1-STATUS
                CLOSE FILE1
                GO TO Hostdata-delete-exit
           END-IF.

           Initialize file1-r1
           Display " "
           Display "Enter employee name to delete in three parts."
           Display " "
           Display "Enter LAST NAME:"
           Display " "
           Accept emp-last-name
           Display " "
           Display "Enter FIRST NAME:"
           Display " "
           Accept emp-first-name
           Display " "
           Display "Enter Middle Initial:"
           Display " "
           Accept emp-middle-initial
           Display " "

           READ FILE1 KEY IS emp-name END-READ.
           Evaluate file1-status
             When Good-status
               Display "Status code=00 - Record found"
               Display "Deleting..." EMP-NAME
             When "23"
               Display "Status code=23 - Record not found"
               GO TO Hostdata-delete-exit
             When Other
               Display "Status code=" file1-status "is unexpected."
               Display "Bailing out..."
               GO TO Hostdata-delete-exit
           End-evaluate.

           Delete FILE1
           Evaluate file1-status
             When good-status
               Display "Status code=00 - Record deleted"
               Continue
             When Other
               Display "Status code=" file1-status " is unexpected."
               Display "Error deleting VSAM file record."
               Display "Bailing out..."
               GO TO Hostdata-delete-exit
           End-evaluate.

       Hostdata-delete-exit.
           Close FILE1.
           Exit.

       END PROGRAM HOSTDATA.


