########################################################################
#                                                                      #
#    Licensed Materials - Property of IBM                              #
#                                                                      #
#    5622-793  (C) Copyright IBM Corp., 1996                           #
#    All rights reserved                                               #
#                                                                      #
#    US Government Users Restricted Rights - Use,                      #
#    duplication, or disclosure restricted by GSA ADP                  #
#    Schedule Contract with IBM Corp.                                  #
#                                                                      #
########################################################################
# DynDLLs.MAK
########################################################################
# This is a special Make file to create multiple Dynamic Call DLLs
# To use:
#    Inherit from the COBOL master project
#    Turn Projects Smarts off (If VisualAge C++ is installed)
#    Change the project-settings-makefile to DYNDLLS.MAK
#    Set the following build-normal options
#       MAKE
#          Do NOT generate a make file
#          Make command: iwzvMake "%p" "%d" /INPUT *.CBL /nologo /r /f %m
#       PROJECT
#          Do NOT use setting from parent project
#
#    Set the following Rebuild-all options
#       MAKE
#          Do NOT generate a make file
#          Make command: iwzvMake "%p" "%d" /INPUT *.CBL /nologo /r /a /f %m
#       PROJECT
#          Do NOT use setting from parent project
#
#    To Build selected files, set up a file-scoped action that calls iwzvMake.exe
#    with the following options:  %p %d /INPUT %a %z /nologo /r /f %m
#
########################################################################
#
#  This make file is updated by VisualAge COBOL do not make changes
#
########################################################################
# COBOL_WF_OPTIONS File #@# C++ Compiler
CBLCompileOptions= \
-q"EXIT(ADEXIT(IWZRMGUX)) NOADATA" -B"/NODEBUG"
CBLSource=\
DYNDLL1.CBL \
DYNDLL2.CBL \
DYNDLL3.CBL
CBLMakeFileName= \
DynDLLs.mak
CBLMAKEDepend= \
$(CBLMakeFileName)
CBLProjectName= \
%REPLACEDIR%\samples\mtexe\mtdll
CBLWorkingDir=\
%REPLACEDIR%\samples\mtexe\mtdll
# COBOL_END_OPTIONS do not delete this line
########################################################################

.SUFFIXES:

TARGETDLL=$(CBLSource:.CBL=.DLL)
TARGETDEF=$(CBLSource:.CBL=.DEF)

.all: PREP         \
      $(TARGETDLL)

PREP:
    @echo -----------------------------------------------------
    @echo ----- Running MAKE file:  $(CBLMakeFileName)
    @echo ----- Project File Name:  $(CBLProjectName)
    @echo ----- Working Directory:  $(CBLWorkingDir)
    @cd $(CBLWorkingDir)
    @echo -----------------------------------------------------

$(TARGETDLL): $$(@B).cbl $$(@B).def $(CBLMAKEDepend)
    @echo -----------------------------------------------------
    @echo ----- Compile COBOL Dynamic DLLs
    ! -4 iwzvcomp.cmd $(CBLCompileOptions) $*.CBL $*.def
    @echo -----------------------------------------------------

$(TARGETDEF):
    @echo -----------------------------------------------------
    @echo ----- Create file: $@
    !iwzvgdef.cmd $@
    @echo -----------------------------------------------------

