#********************************************************copyrite.xic******/
#                                                                          /
#   Licensed Materials - Property of IBM                                   /
#   IBM TCP/IP for OS/2                                                    /
#   (C) Copyright IBM Corporation. 1996.                                   /
#                                                                          /
#   All rights reserved.                                                   /
#                                                                          /
#   US Government Users Restricted Rights -                                /
#   Use, duplication or disclosure restricted by GSA ADP Schedule          /
#   Contract with IBM Corp.                                                /
#                                                                          /
#--------------------------------------------------------------------------/
#                                                                          /
#  DISCLAIMER OF WARRANTIES.  The following [enclosed] code is             /
#  sample code created by IBM Corporation. This sample code is not         /
#  part of any standard or IBM product and is provided to you solely       /
#  for  the purpose of assisting you in the development of your            /
#  applications.  The code is provided "AS IS", without                    /
#  warranty of any kind.  IBM shall not be liable for any damages          /
#  arising out of your use of the sample code, even if they have been      /
#  advised of the possibility of such damages.                             /
#--------------------------------------------------------------------------/

.AUTODEPEND

#=============================================================
#		Translator Definitions
#=============================================================
CC = bcc +socket.CFG
TASM = tasm.exe
TLIB = tlib.exe
TLINK = tlink
RC = brcc.exe
RB = rc.exe
LIBPATH = D:\BCOS2\LIB;C:\TOOLKIT\LIB
INCLUDEPATH = D:\BCOS2\INCLUDE;C:\TOOLKIT\H


#=============================================================
#		Implicit Rules
#=============================================================
.c.obj:
  $(CC) -c {$< }

.cpp.obj:
  $(CC) -c {$< }

.asm.obj:
  $(TASM) -Mx $*.asm,$*.obj

.rc.res:
  $(RC) -r $*.rc

#=============================================================
#		List Macros
#=============================================================


UDPS_DEPENDENCIES =  \
 c:\toolkit\lib\tcp32dll.lib \
 c:\toolkit\lib\so32dll.lib \
 udps.obj

UDPC_DEPENDENCIES =  \
 c:\toolkit\lib\tcp32dll.lib \
 c:\toolkit\lib\so32dll.lib \
 udpc.obj

MSGS_DEPENDENCIES =  \
 c:\toolkit\lib\tcp32dll.lib \
 c:\toolkit\lib\so32dll.lib \
 msgs.obj

MSGC_DEPENDENCIES =  \
 c:\toolkit\lib\tcp32dll.lib \
 c:\toolkit\lib\so32dll.lib \
 msgc.obj

TCPS_DEPENDENCIES =  \
 c:\toolkit\lib\tcp32dll.lib \
 c:\toolkit\lib\so32dll.lib \
 tcps.obj

TCPC_DEPENDENCIES =  \
 c:\toolkit\lib\tcp32dll.lib \
 c:\toolkit\lib\so32dll.lib \
 tcpc.obj

SELECTS_DEPENDENCIES =  \
 c:\toolkit\lib\tcp32dll.lib \
 c:\toolkit\lib\so32dll.lib \
 selects.obj

#=============================================================
#		Explicit Rules
#=============================================================

ALL : udps.exe udpc.exe tcps.exe tcpc.exe selects.exe msgs.exe msgc.exe

#----------------------- udps --------------------------------

udps.exe: socket.cfg $(UDPS_DEPENDENCIES)
  $(TLINK) /v /B:0x10000 /Toe /ap /L$(LIBPATH) @&&|
D:\BCOS2\LIB\C02.OBJ+
udps.obj
udps,udps
c:\toolkit\lib\tcp32dll.lib+
c:\toolkit\lib\so32dll.lib+
D:\BCOS2\LIB\C2MTI.LIB+
D:\BCOS2\LIB\OS2.LIB

|

#----------------------- udpc --------------------------------

udpc.exe: socket.cfg $(UDPC_DEPENDENCIES)
  $(TLINK) /v /B:0x10000 /Toe /ap /L$(LIBPATH) @&&|
D:\BCOS2\LIB\C02.OBJ+
udpc.obj
udpc,udpc
c:\toolkit\lib\tcp32dll.lib+
c:\toolkit\lib\so32dll.lib+
D:\BCOS2\LIB\C2MTI.LIB+
D:\BCOS2\LIB\OS2.LIB

|

#----------------------- msgs --------------------------------

msgs.exe: socket.cfg $(MSGS_DEPENDENCIES)
  $(TLINK) /v /B:0x10000 /Toe /ap /L$(LIBPATH) @&&|
D:\BCOS2\LIB\C02.OBJ+
msgs.obj
msgs,msgs
c:\toolkit\lib\tcp32dll.lib+
c:\toolkit\lib\so32dll.lib+
D:\BCOS2\LIB\C2MTI.LIB+
D:\BCOS2\LIB\OS2.LIB

|

#----------------------- msgc --------------------------------

msgc.exe: socket.cfg $(MSGC_DEPENDENCIES)
  $(TLINK) /v /B:0x10000 /Toe /ap /L$(LIBPATH) @&&|
D:\BCOS2\LIB\C02.OBJ+
msgc.obj
msgc,msgc
c:\toolkit\lib\tcp32dll.lib+
c:\toolkit\lib\so32dll.lib+
D:\BCOS2\LIB\C2MTI.LIB+
D:\BCOS2\LIB\OS2.LIB

|

#----------------------- tcps --------------------------------

tcps.exe: socket.cfg $(TCPS_DEPENDENCIES)
  $(TLINK) /v /B:0x10000 /Toe /ap /L$(LIBPATH) @&&|
D:\BCOS2\LIB\C02.OBJ+
tcps.obj
tcps,tcps
c:\toolkit\lib\tcp32dll.lib+
c:\toolkit\lib\so32dll.lib+
D:\BCOS2\LIB\C2MTI.LIB+
D:\BCOS2\LIB\OS2.LIB

|

#----------------------- tcpc --------------------------------

tcpc.exe: socket.cfg $(TCPC_DEPENDENCIES)
  $(TLINK) /v /B:0x10000 /Toe /ap /L$(LIBPATH) @&&|
D:\BCOS2\LIB\C02.OBJ+
tcpc.obj
tcpc,tcpc
c:\toolkit\lib\tcp32dll.lib+
c:\toolkit\lib\so32dll.lib+
D:\BCOS2\LIB\C2MTI.LIB+
D:\BCOS2\LIB\OS2.LIB

|

#---------------------- selects --------------------------------

selects.exe: socket.cfg $(SELECTS_DEPENDENCIES)
  $(TLINK) /v /B:0x10000 /Toe /ap /L$(LIBPATH) @&&|
D:\BCOS2\LIB\C02.OBJ+
selects.obj
selects,selects
c:\toolkit\lib\tcp32dll.lib+
c:\toolkit\lib\so32dll.lib+
D:\BCOS2\LIB\C2MTI.LIB+
D:\BCOS2\LIB\OS2.LIB

|


#=============================================================
#		Individual File Dependencies
#=============================================================
udps.obj: socket.cfg udps.c
	$(CC) -c udps.c

udpc.obj: socket.cfg udpc.c
	$(CC) -c udpc.c

msgs.obj: socket.cfg msgs.c
	$(CC) -c msgs.c

msgc.obj: socket.cfg msgc.c
	$(CC) -c msgc.c

tcps.obj: socket.cfg tcps.c
	$(CC) -c tcps.c

tcpc.obj: socket.cfg tcpc.c
	$(CC) -c tcpc.c

selects.obj: socket.cfg selects.c
	$(CC) -c selects.c


#=============================================================
#		Compiler Configuration File
#=============================================================
socket.cfg: borland.mak
  copy &&|
-R
-L$(LIBPATH)
-I$(INCLUDEPATH)
-vi-
-sm
-v
-DOS2
| socket.cfg


#===================================================
# CLEAN
#=================================================

clean:
	-del *.obj
	-del *.exe
