      * --------------------------------------------- *
      *  FILERW.CBL
      *     File I/O program for the Wine Store sample.
      *     Version 2
      * --------------------------------------------- *

       IDENTIFICATION DIVISION.
       CLASS-ID. "FileRW" Inherits SOMObject.

       ENVIRONMENT DIVISION.
       Configuration Section.
       Repository.
            CLASS SOMObject is "SOMObject"
            CLASS TheOrder is "WineOrder".

       DATA DIVISION.
       Working-Storage Section.

       PROCEDURE DIVISION.

      * ========================================
      * ========================================
       Identification Division.
       Method-Id. "XternOrder".
       ENVIRONMENT DIVISION.
       Input-Output Section.
       File-Control.
             Select OPTIONAL Orders Assign to Orders
                File Status is WS-Status-Flag
                Organization is Line Sequential.
       DATA DIVISION.
       File Section.
       FD Orders External
           Record contains 255.
       01 Order-Record                 PIC X(255).
       Working-Storage Section.
       01 WS-Status-Flag               PIC X(2).
       01 WS-Ev            Usage Pointer.
       01 WS-Order-Record.
           05 WS-Order-Number          PIC X(5).
           05 WS-Order-Date            PIC X(10).
           05 Filler                   PIC X(3).
           05 WS-Items.
              10 WS-Order-Count        PIC S9(4).
              10 WS-Order-Item     Occurs 1 to 64
                                   Depending on WS-Order-Count
                                   Indexed by WS-Index.
                 15 WSO-Type           PIC X(20).
                 15 WSO-Cost           PIC 9(3)V99.

       Linkage Section.
       01  orderObj         Usage Object Reference TheOrder.

       PROCEDURE DIVISION
                   Using orderObj.
           Move spaces to WS-Order-Record.
           Move zero to WS-Status-Flag.
      * ---------------------- Open the file
           Open Extend Orders.
      * ---------------------- Check file status
           If (WS-Status-Flag = "00") Or
                       (WS-Status-Flag = "05")
              Invoke orderObj "GetOrderNumber"
                     Returning WS-Order-Number
              Invoke orderObj "GetOrderDate" Returning WS-Order-Date
              Invoke orderObj "DescribeOrder" Returning WS-Items
      * ---------------------- Write the record.
              Write Order-Record from WS-Order-Record
           End-if.
      * ---------------------- Display a message if file I/0 failed
           If WS-Status-Flag Is Not = 00
              Display "   ---> File Error; code: "
                      WS-Status-Flag
           End-if.
      * ---------------------- Close the file.
           Close Orders.
           Exit Method.
       End Method "XternOrder".

       END CLASS "FileRW".

