      * --------------------------------------------- *
      *  USERINT.CBL
      *     User interface class for the wine store sample.
      *     Version 2
      * --------------------------------------------- *

       IDENTIFICATION Division.
       CLASS-ID. "UserInterface" inherits SOMObject.

       ENVIRONMENT DIVISION.
       Configuration Section.
       Repository.
            CLASS SOMObject is "SOMObject".

       DATA DIVISION.
       Working-Storage Section.
       01   User-Action                PIC X(10).
           88  UA-Add                      Value "ADD".
           88  UA-Delete                   Value "DELETE".
           88  UA-End                      Value "END".

       PROCEDURE DIVISION.

      * ========================================
      * ========================================
       IDENTIFICATION DIVISION.
       Method-Id. "WriteWelcome".
       DATA DIVISION.
       Working-Storage Section.

       PROCEDURE DIVISION.
           Display "===========================================".
           Display "===                        o            ===".
           Display "===                 o                   ===".
           Display "===             o      o  o             ===".
           Display "===         -----o----o-----            ===".
           Display "===          \ o    o  o  /             ===".
           Display "===            \~~~~~~~~/               ===".
           Display "===              \    /                 ===".
           Display "===                \/                   ===".
           Display "===                ||                   ===".
           Display "===                ||                   ===".
           Display "===             ___||___                ===".
           Display "===                                     ===".
           Display "===           Welcome to                ===".
           Display "===     Jim n'Bob's Wine Shoppe         ===".
           Display "===         --------------              ===".
           Display "===                                     ===".
           Display "===   We appreciate your busness.       ===".
           Display "===   Please fill out your order.       ===".
           Display "===                                     ===".
           Display "===========================================".
           Display " ".
           Exit Method.
       End Method "WriteWelcome".

      * ========================================
      * ========================================
       IDENTIFICATION DIVISION.
       Method-Id. "ReadAction".
       DATA DIVISION.
       Working-Storage Section.
       01  WS-Edit-Flag                PIC X.
       01  Answer                      PIC 9.
       Linkage Section.
       01  LS-Action                   PIC X(10).

       PROCEDURE DIVISION
                   Returning LS-Action.
           Move Low-Value to WS-Edit-Flag.
           Perform Until WS-Edit-Flag Not = Low-Value
              Move 0 to Answer
              Display "      ============================="
              Display "      |       Order Menu          |"
              Display "      |                           | "
              Display "      |   1. Add a bottle         | "
              Display "      |   2. Delete a bottle      | "
              Display "      |   9. End                  | "
              Display "      ============================= "
              Display " Enter an action.... "
              Accept Answer from SYSIN
              Evaluate Answer
                 When 1
                    Set UA-Add to TRUE
                    Move High-Value to WS-Edit-Flag
                 When 2
                    Set UA-Delete to TRUE
                    Move High-Value to WS-Edit-Flag
                 When 9
                    Set UA-End to TRUE
                    Move High-Value to WS-Edit-Flag
              End-Evaluate
              Move User-Action to LS-Action
           End-perform.
           Exit Method.
       End Method "ReadAction".

      * ========================================
      * ========================================
       IDENTIFICATION DIVISION.
       Method-Id. "ReadType".
       DATA DIVISION.
       Working-Storage Section.
       01  WS-Type                     PIC X(80).
       Linkage Section.
       01  LS-Type                     PIC X(20).

       PROCEDURE DIVISION
                   Returning LS-Type.
           Initialize WS-Type.
           Display " ".
           Display "  ====================================".
           Display " ".
           Display "   Enter the type of wine: ".
           Accept WS-Type from SYSIN.
           Move WS-Type(1:20) to LS-Type.
           Exit Method.
       End Method "ReadType".

      * ========================================
      * ========================================
       IDENTIFICATION DIVISION.
       Method-Id. "ReadCost".
       DATA DIVISION.
       Working-Storage Section.
       01  WS-Cost                     PIC X(6).
       Linkage Section.
       01  LS-Cost                     PIC 9(3)V99.

       PROCEDURE DIVISION
                   Returning LS-Cost.
           Initialize WS-Cost.
           Display " ".
           Display "   Enter the cost: ".
           Accept WS-Cost from SYSIN.
           Compute LS-Cost = Function Numval-c(WS-Cost).
           Exit Method.
       End Method "ReadCost".

      * ========================================
      * ========================================
       IDENTIFICATION DIVISION.
       Method-Id. "WriteMessage".
       DATA DIVISION.
       Linkage Section.
       01  LS-Flag                     PIC X.

       PROCEDURE DIVISION
                   Using LS-Flag.
           If LS-Flag = 0
              Display  "     "
                   User-Action " successfully completed "
           Else
              Display  "     "
                   User-Action " not successful, too bad... "
           End-If.
           Display " ".
           Exit Method.
       End Method "WriteMessage".


      * ========================================
      * ========================================
       IDENTIFICATION DIVISION.
       Method-Id. "WriteOutput".
       DATA DIVISION.
       Working-Storage Section.
       01  Formatted-Cost              PIC $Z,ZZZ,ZZ9.99.
       Linkage Section.
       01  Total-Cost                  PIC 9(7)V99.
       01  Order-Number                PIC 9(5).
       01  Order-Date                  PIC X(10).

       PROCEDURE DIVISION
                   Using Total-Cost Order-Number Order-Date.
           Move Total-Cost to Formatted-Cost.
           Display " ".
           Display "     Thank you for your order.... ".
           Display " ".
           Display "  ====================================".
           Display "         Order Information ".
           Display " ".
           Display "   Your order number: " Order-Number.
           Display "   Date: " Order-Date.
           Display " ".
           Display "   Total cost: " Formatted-Cost.
           Display "   Contents: ".
           Exit Method.
       End Method "WriteOutput".

      * ========================================
      * ========================================
       IDENTIFICATION DIVISION.
       Method-Id. "WriteBottle".
       DATA DIVISION.
       Working-Storage Section.
       01  WS-Formatted-Cost           PIC ZZ9.99.
       01  WS-Index                    PIC 9(2).
       01  WS-Formatted-Index          PIC Z9.
       Linkage Section.
       01  LS-Items.
           05 LS-Count                 PIC 9(4).
           05 LS-Item    Occurs 1 to 64 times
                         Depending on LS-Count
                         Indexed by LS-Index.
              10 LS-Type               PIC X(20).
              10 LS-Cost               PIC 9(3)V99.

       PROCEDURE DIVISION
                   Using LS-Items.
           Move 0 to WS-Index.
           Display "   ------------------------------------------   ".
           Perform Varying LS-Index from 1 by 1
                     Until LS-Index > LS-Count
              Move LS-Cost(LS-Index) to WS-Formatted-Cost
              Add 1 to WS-Index
              Move WS-Index to WS-Formatted-Index
              Display "    "  WS-Formatted-Index ". "
                      LS-Type(LS-Index) " at " WS-Formatted-Cost
           End-Perform
           Display "   ------------------------------------------   ".
           Exit Method.
       End Method "WriteBottle".

      *---------------------------------
       END CLASS "UserInterface".


