      * --------------------------------------------- *
      *  WINESTR.CBL
      *     Main program for the Wine Store sample.
      *     Version 2
      * --------------------------------------------- *

       IDENTIFICATION DIVISION.
       PROGRAM-ID. "Winestr".

       ENVIRONMENT DIVISION.
       Configuration Section.
       Repository.
            CLASS SOMObject is "SOMObject"
            CLASS TheOrder is "WineOrder"
            CLASS Bottle is "Bottle"
            CLASS FileRW is "FileRW"
            CLASS UserInterface is "UserInterface".

       DATA DIVISION.
       Working-Storage Section.
      * ------------------------- Objects
       01  orderObj       Usage Object Reference TheOrder.
       01  userObj        Usage Object Reference UserInterface.
       01  bottleObj      Usage Object Reference Bottle.
       01  fileObj        Usage Object Reference FileRW.
      * ------------------------- Data Items
       01  Max-Items                   PIC 9(4)  COMP Value 64.
       01  Seed                        PIC 9(2).
       01  Order-Number                PIC 9(5).
       01  Order-Date                  PIC X(10) Value "00/00/0000".
       77  Item-Type                   PIC X(20).
       77  Item-Cost                   PIC 9(3)V99.
       77  Total-Cost                  PIC 9(7)V99.
       77  Action                      PIC X(10).
       77  Flag                        PIC X(4).
       77  Today                       PIC X(21).
       01  WS-Random-Val               PIC 9V9(5).
       01  WS-Items.
           05 WS-Count                 PIC 9(4).
           05 WS-Item   Occurs 1 to 64 times
                        Depending on WS-Count
                        Indexed by WS-Index.
              10 WS-Type               PIC X(20).
              10 WS-Cost               PIC 9(3)V99.
       01  WS-Parms.
           05 Item-Count               PIC S9(8)  COMP.
           05 WS-Flag                  PIC X.
              88 Successful                      Value "0".
              88 Failure                         Value "1".

       PROCEDURE DIVISION.
      * --------------------------------------
      *   Instantiate the UserInterface class
      *     somNew is inherited from SOMObject
      * --------------------------------------
           Invoke UserInterface "somNew" Returning userObj.
      * --------------------------------------
      *   Get the current date and generate a
      *     random number for the order
      * --------------------------------------
           Move Function Current-date to Today.
           Move Today(1:4) to Order-Date (7:4).
           Move Today(5:2) to Order-Date (1:2).
           Move Today(7:2) to Order-Date (4:2).
           Move Today(13:2) to Seed.
           Compute WS-Random-Val = Function Random(Seed).
           Compute Order-Number = WS-Random-Val * 10000.
           Move Zero to Item-Count.

           Invoke TheOrder "somNew" Returning orderObj.
           Invoke orderObj "SetOrderNumber" Using Order-Number.
           Invoke orderObj "SetOrderDate" Using Order-Date.

           Invoke userObj "WriteWelcome".
           Invoke userObj "readAction" Returning Action.

           Perform until Action = "END"
                        or Item-Count >= Max-Items
              Evaluate Action(1:3)
                When "ADD"
                  Invoke userObj "ReadType" Returning Item-Type
                  Invoke userObj "ReadCost" Returning Item-Cost
                  Invoke orderObj "addBottle"
                                  Using Item-Type Item-Cost
                                  Returning WS-Parms
                  If WS-Flag = "1"
                     Display " ====> Problem adding to the order"
                  End-If
                  Invoke userObj "WriteMessage" using WS-Flag
                When "DEL"
                 If Item-Count > 0
                    Invoke userObj "ReadType" Returning Item-Type
                    Invoke userObj "ReadCost" Returning Item-Cost
                    Invoke orderObj "DeleteBottle"
                                  Using Item-Type Item-Cost WS-Parms
                 Else
                    Display "  Sorry, nothing to delete "
                 End-if
               When Other
                 Continue
              End-Evaluate
              Invoke UserObj "ReadAction" Returning Action
           End-Perform.

           If Item-Count = 0
              Then Goback.

           If Action(1:3) is not = "End"
              Invoke orderObj "CalculateCost" Returning Total-Cost
              Invoke orderObj "GetOrderNumber" Returning Order-Number
              Invoke orderObj "GetOrderDate" Returning Order-Date
              Invoke userObj "WriteOutput"
                              Using Total-Cost Order-Number Order-Date
              Invoke orderObj "DescribeOrder" Returning WS-Items
              Invoke userObj "WriteBottle" Using WS-Items
              Invoke FileRW "somNew" Returning fileObj
              Invoke fileObj "XternOrder" Using orderObj
           End-If.
           Display "  ...... Thank you for your support".
           Invoke fileObj "somFree".
           Invoke orderObj "somFree".
           Invoke userObj "somFree".

           Goback.

       END PROGRAM "Winestr".


