#ifndef _KDATA_
  #define _KDATA_
/*-----------------------------------------------------------------------
                      Copyright (C) 1993, 1994
                               by
                           KASEWORKS, Inc.

 All rights reserved.  No part of this material may be reproduced, 
 stored in a retrieval system, or transmitted, in any form or by 
 any means, electronic, mechanical, photocopying, recording, or
 otherwise, without the prior written permission of KASEWORKS, Inc.
-----------------------------------------------------------------------*/

#ifndef _IVBASE_
  #include <ivbase.hpp>
#endif

#ifndef _ISTRING_
  #include <istring.hpp>
#endif

/*-----------------------------------------------------------------------
  Name: KData
 
  Implementation File: N/A

  Purpose: This class serves as an abstract base class for data objects
           generated by KASE:VIP.

  Base Class: IVBase

  Notes:

-----------------------------------------------------------------------*/
class _Export KData : virtual public IVBase
{
   public:
      virtual ~KData() {}
   protected:
      KData() {}
};

/*-----------------------------------------------------------------------
  Name: KDataFactory
 
  Implementation File: N/A

  Purpose: Exists as a "factory" class; its purpose is to create and 
           identify data objects for the KDobManager class. 

  Base Class: IVBase

  Notes:   KDataFactory is an abstract class.  

-----------------------------------------------------------------------*/
class _Export KDataFactory : public IVBase
{
   public:
      virtual ~KDataFactory() {}
      virtual KData *makeDataObject() const = 0;
      virtual KData *cloneDataObject(KData *) const = 0;
      IString const &name() const { return className; }

   protected: 
      KDataFactory(IString const &name) : className(name) {}

   private:
      const IString className;
};
#endif
