#define INCL_BASE
#include <os2.h>
#include <iwindow.hpp>
#include <kdirlst.hpp>
#include <itextctl.hpp>
#include <ictlevt.hpp>
#include <kwconst.hpp>

Boolean KDirListBox::fill()
{
   FILEFINDBUF3 findBuf;
   unsigned long ulSearchCount;
   HDIR hDir;
   APIRET rc;

   // use the system-default search-directory handle
   hDir = HDIR_SYSTEM;

   // initialize the search count to 1, to only find 1 file at a time
   ulSearchCount = 1;

   // clear current items
   removeAll();

   // initiate the search
   rc = DosFindFirst(spec, 
                     &hDir, FILE_DIRECTORY,
                     &findBuf, sizeof(findBuf),
                     &ulSearchCount, FIL_STANDARD);
   if (rc)
      return false;
   else
   {
      while (rc != ERROR_NO_MORE_FILES)
      {
         // if this is a directory and it isn't the current directory,
         // add it to the list box
         IString name = findBuf.achName;
         if ((findBuf.attrFile & FILE_DIRECTORY) &&  name != ".")
            addAsLast(findBuf.achName);

         // get the next file
         rc = DosFindNext(hDir, 
                          &findBuf, sizeof(findBuf),
                          &ulSearchCount);
      }

      // terminate the search
      DosFindClose(hDir);
   }

   // add drive letters to the list box following all directories
   unsigned long ulDriveNum,
                 ulDriveMap;

   // first retrieve the drive map from the system
   rc = DosQueryCurrentDisk(&ulDriveNum, &ulDriveMap);
   if (rc)
      return false;

   // loop through each bit of the drive map, each of the lower 26 bits
   // represents a drive letter
   for (char cDrive = 0; cDrive < 26; cDrive++)
   {
      if (ulDriveMap & (1 << cDrive))
      {
         // construct a string for the drive name
         IString drive((char)(cDrive + 'A'));
         IString label = "[" + drive + ":]";

         // and add it to the list box
         addAsLast(label);
      }
   }

   // set the target entry field to point to the current drive/directory
   if (target)
   {
      // query the current directory name
      unsigned long ulPathLen = 256;
      IString currentDir(0, ulPathLen);
      DosQueryCurrentDir(ulDriveNum, currentDir, &ulPathLen);

      // construct a full path name string consisting of drive:\directory
      IString currentStr((char)('@' + ulDriveNum));
      currentStr += ":\\" + currentDir;

      // and add it to the list box
      target->setText(currentStr);
   }
   
   return true;
}

static IBase::Boolean _Optlink DriveTest(int c)
{
   return (c >= 'A' && c <= 'Z');
}

Boolean KDirListBox::enter(IControlEvent &event)
{
   IString selected = itemText(selection());

   // check to see if the new selection is a drive or a directory
   if (selected.isLike("[?:]"))
   {
     // save current drive in case of error
     unsigned long ulCurDisk, ulDriveMap;
     DosQueryCurrentDisk(&ulCurDisk, &ulDriveMap);

     // change to the new drive. On error (e.g. the drive doesn't exist),
     // restore to the previous drive

     IStringTest test(DriveTest);
     char drive = selected[selected.indexOf(test)];
     if (DosSetDefaultDisk(drive - '@') != 0)
       DosSetDefaultDisk(ulCurDisk);

     // refill the list box, checking for an error again...
     // if the drive isn't ready (e.g., floppy or CD), fill returns an error
     if (!fill())
     {
       DosSetDefaultDisk(ulCurDisk);
       fill();
     }

   }
   else
   {
      DosSetCurrentDir(selected);
      // refill the list box
      fill();

   }

   // inform all file list/combo boxes descended from my owner that 
   // the current drive/directory has changed so they can refill themselves...

   // postEvents throws an exception, so simulate it here
   //   owner()->handle().postEvents(KW_FILL);

   IWindow::ChildCursor cursor(*owner());
   for(cursor.setToFirst(); cursor.isValid(); cursor.setToNext())
      childAt(cursor).sendEvent(KW_FILL);
   return false;
}

