#define INCL_BASE
#include <os2.h>
#include <kfillst.hpp>
#include <kwconst.hpp>
#include <itextctl.hpp>

Boolean KFileListHandler::dispatchHandlerEvent(IEvent &event)
{
  if (event.eventId() == KW_FILL)
     return fillList(event);
  else
     return false;
}


Boolean KFileListBox::fill()
{
   FILEFINDBUF3 findBuf;
   unsigned long ulSearchCount;
   HDIR hDir;
   APIRET rc;

   // use the system-default search-directory handle
   hDir = HDIR_SYSTEM;

   // initialize the search count to 1, to only find 1 file at a time
   ulSearchCount = 1;

   // clear current items
   removeAll();

   // initiate the search
   rc = DosFindFirst(spec, 
                     &hDir, FILE_NORMAL,
                     &findBuf, sizeof(findBuf),
                     &ulSearchCount, FIL_STANDARD);
   if (rc && rc != ERROR_NO_MORE_FILES)        
      return false;
   if (!rc)
   {
      while (rc != ERROR_NO_MORE_FILES)
      {
         // add the file name to the list box
         addAsLast(findBuf.achName);

         // get the next file
         rc = DosFindNext(hDir, 
                          &findBuf, sizeof(findBuf),
                          &ulSearchCount);
      }

      // terminate the search
      DosFindClose(hDir);
   }
   return true;
}

Boolean KFileListBox::fillList(IEvent &event)
{
  fill();
  if (target)
     target->setText("");
  return true;
}
