#ifndef _KLIBRARY_
  #define _KLIBRARY_

#ifndef _IBASE_
  #include <ibase.hpp>
#endif

#ifndef _IRESLIB_
  #include <ireslib.hpp>
#endif

#ifndef _IAPP_
  #include <iapp.hpp>
#endif

/*---------------------------------------------------------------
 * Name: KLibrary
 * 
 * Implementation File: N/A
 * 
 * Purpose: This class exists to simplify setting and restoring
 *          the user resource library for an application.  It 
 *          allows User Interface Class Library objects to reside
 *          in, and obtain resources from, a DLL.
 *
 * Base Classes: KLibrary is derived from IBase.
 *
 * Notes:   
 *-------------------------------------------------------------*/
class KLibrary : public IBase
{
   public:
      KLibrary(IResourceLibrary &library)
        : _saved(IApplication::current().userResourceLibrary())
      {
         IApplication::current().setUserResourceLibrary(library);
      }

      ~KLibrary()
      {
         IApplication::current().setUserResourceLibrary(_saved);
      }

   private:
      IResourceLibrary& _saved;
};

#endif
