#define INCL_PM
#include <os2.h>
#include <ievent.hpp>
#include <ictlevt.hpp>
#include <kmlehdr.hpp>

Boolean KMleHandler::dispatchHandlerEvent(IEvent& event)
{
   Boolean filtered = false;
   if (event.eventId() == WM_CONTROL)
   {                                   // Control event
      IControlEvent ctlEvent(event);
      unsigned long ulMsg = ctlEvent.parameter1().number2();
      switch(ulMsg)
      {
         case MLN_TEXTOVERFLOW:
            filtered = textOverflow(ctlEvent);
            break;

         case MLN_PIXHORZOVERFLOW:
            filtered = pixHorzOverflow(ctlEvent);
            break;

         case MLN_PIXVERTOVERFLOW:
            filtered = pixVertOverflow(ctlEvent);
            break;

         case MLN_OVERFLOW:
            filtered = overflow(ctlEvent);
            break;

         case MLN_HSCROLL:
            filtered = hScroll(ctlEvent);
            break;

         case MLN_VSCROLL:
            filtered = vScroll(ctlEvent);
            break;

         case MLN_UNDOOVERFLOW:
            filtered = undoOverflow(ctlEvent);
            break;

         case MLN_CLPBDFAIL:
            filtered = clipboardFail(ctlEvent);
            break;

         case MLN_MEMERROR:
            filtered = memError(ctlEvent);
            break;

         case MLN_MARGIN:
            filtered = margin(ctlEvent);
            break;

         case MLN_SEARCHPAUSE:
            filtered = searchPause(ctlEvent);
            break;

         default:
            filtered = false;
            break;
      }
      if (filtered)
        event.setResult(ctlEvent.result());
   }
   return filtered;
}
